/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.fastner.FastRule;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NERSpan
extends Span
implements Comparable<Span> {
    public static Logger logger = IOUtil.getLogger(FastRule.class);
    public static final String scoreOnly = "score";
    public static final String scorewidth = "scorewidth";
    public static final String widthscore = "widthscore";
    public static final String widthOnly = "width";
    public static final String byStrWidth = "strWidth";
    public static final String byRuleLength = "ruleLength";
    private String method = "scorewidth";
    private String widthCompareMethod = "ruleLength";
    public int ruleLength;

    public NERSpan(int begin, int end) {
        super(begin, end);
    }

    public NERSpan(int begin, int end, String text) {
        super(begin, end, text);
    }

    public NERSpan(int begin, int end, int ruleId) {
        super(begin, end, ruleId);
    }

    public NERSpan(int begin, int end, int ruleId, double score) {
        super(begin, end, ruleId, score);
    }

    public NERSpan(int begin, int end, int ruleId, double score, String text) {
        super(begin, end, ruleId, score, text);
    }

    public NERSpan(int begin, int end, int ruleId, int ruleLength, double score, String text) {
        super(begin, end, ruleId, score, text);
        this.ruleLength = ruleLength;
    }

    @Override
    public int compareTo(NERSpan o) {
        switch (this.method) {
            case "score": {
                return this.compareScoreOnly(o);
            }
            case "scorewidth": {
                return this.compareScorePrior(o);
            }
            case "widthscore": {
                return this.compareWidthPrior(o);
            }
        }
        return this.compareWidthOnly(o);
    }

    public void setCompareMethod(String method) {
        this.method = method;
    }

    public void setWidthCompareMethod(String widthCompareMethod) {
        this.widthCompareMethod = widthCompareMethod;
    }

    protected int compareScoreOnly(Span o) {
        return (int)Math.signum(this.score - o.score);
    }

    protected int compareWidthOnly(Span o) {
        if (this.widthCompareMethod.equals(byStrWidth)) {
            return Integer.signum(this.width - o.width);
        }
        if (o instanceof NERSpan) {
            return Integer.signum(this.ruleLength - ((NERSpan)o).ruleLength);
        }
        System.err.println("Cannot compare NERSpan against Span using matched rule lengths. Return equal as default.");
        return 0;
    }

    protected int compareScorePrior(Span o) {
        int scoreResult;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\t\tcurrent " + this.ruleId + " score: " + this.score + "\t---\toverlapped " + o.ruleId + " score: " + o.score);
        }
        if ((scoreResult = this.compareScoreOnly(o)) == 0) {
            return this.compareWidthOnly(o);
        }
        return scoreResult;
    }

    protected int compareWidthPrior(Span o) {
        int widthResult = this.compareWidthOnly(o);
        if (widthResult == 0) {
            return this.compareScoreOnly(o);
        }
        return widthResult;
    }

    @Override
    public String toString() {
        return String.format("(%s-%s):%s", this.begin, this.end, this.ruleId);
    }
}

