/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

import edu.utah.bmi.nlp.core.Setting;
import edu.utah.bmi.nlp.core.SettingAb;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NLPTask {
    protected Map<String, SettingAb> paras;
    protected final Map<String, SettingAb> map = new LinkedHashMap<String, SettingAb>();
    protected final Map<String, SettingAb> executes = new LinkedHashMap<String, SettingAb>();
    protected String taskName;
    protected final String generalTask = "General";

    public NLPTask() {
        this.init("General");
    }

    public NLPTask(String taskName) {
        this.init(taskName);
    }

    public List<Map.Entry<String, SettingAb>> getSettings() {
        return new ArrayList<Map.Entry<String, SettingAb>>(this.paras.entrySet());
    }

    public void init(String taskName) {
        this.taskName = taskName;
        this.paras = this.map;
    }

    public String getValue(String key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key).getSettingValue();
        }
        return "";
    }

    public String getValue(String key, String defaultValue) {
        if (this.map.containsKey(key)) {
            return this.map.get(key).getSettingValue();
        }
        return defaultValue;
    }

    public String getDesc(String key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key).getSettingDesc();
        }
        return "";
    }

    public String getName(String key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key).getSettingName();
        }
        return "";
    }

    public void setValue(String key, String value, String desc, String doubleClick) {
        this.setValue(key, value, desc, doubleClick, "");
    }

    public void setValue(String key, String value, String desc, String doubleClick, String openClick) {
        if (desc == null) {
            desc = "";
        }
        this.paras.put(key, new Setting(key, value, desc, doubleClick, openClick));
        this.map.put(key, new Setting(key, value, desc, doubleClick, openClick));
    }

    public void setValue(String key, String value) {
        this.setValue(key, value, "", "");
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void addExecute(String label, String className, String memo) {
        this.executes.put(label, new Setting(label, className, memo, ""));
    }

    public List<Map.Entry<String, SettingAb>> getExecutes() {
        return new ArrayList<Map.Entry<String, SettingAb>>(this.executes.entrySet());
    }

    public String getExecuteValue(String key) {
        if (this.executes.containsKey(key)) {
            return this.executes.get(key).getSettingValue();
        }
        return "";
    }

    public String getExecuteDesc(String key) {
        if (this.executes.containsKey(key)) {
            return this.executes.get(key).getSettingDesc();
        }
        return "";
    }

    public LinkedHashMap<String, SettingAb> getChildSettings(String parentKey) {
        LinkedHashMap<String, SettingAb> child = new LinkedHashMap<String, SettingAb>();
        int parentKeyLength = parentKey.length() + 1;
        for (Map.Entry<String, SettingAb> entry : this.map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(parentKey) || key.length() <= parentKeyLength) continue;
            child.put(key.substring(parentKeyLength), entry.getValue());
        }
        return child;
    }
}

