/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

public class Span
implements Comparable<Span> {
    public int begin;
    public int end;
    public int width;
    public int ruleId;
    public String text;
    public double score = 0.0;

    public Span() {
    }

    public Span(int begin, int end) {
        this.begin = begin;
        this.end = end;
        this.width = end - begin + 1;
    }

    public Span(int begin, int end, String text) {
        this.begin = begin;
        this.end = end;
        this.width = end - begin + 1;
        this.text = text;
    }

    public Span(int begin, int end, int ruleId) {
        this.begin = begin;
        this.end = end;
        this.ruleId = ruleId;
    }

    public Span(int begin, int end, int ruleId, double score) {
        this.begin = begin;
        this.end = end;
        this.ruleId = ruleId;
        this.score = score;
    }

    public Span(int begin, int end, int ruleId, double score, String text) {
        this.begin = begin;
        this.end = end;
        this.ruleId = ruleId;
        this.score = score;
        this.text = text;
    }

    @Override
    public int compareTo(Span o) {
        if (o == null) {
            return -1;
        }
        if (this.begin != o.begin) {
            return this.begin - o.begin;
        }
        return this.end - o.end;
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        String text = this.getText();
        if (text == null) {
            return String.format("Span(%s-%s)", this.getBegin(), this.getEnd());
        }
        return String.format("Span(%s-%s): '%s'", this.getBegin(), this.getEnd(), text);
    }

    public String serialize() {
        return "(Rule" + this.ruleId + ": " + this.getBegin() + "-" + this.getEnd() + ":" + this.score + "):" + this.getText();
    }

    public static Span deserialize(String serialzied) {
        String[] items = serialzied.trim().split("(:\\s*|\\):|-)");
        if (items.length < 5) {
            System.err.println("Format error to deserialize string to Span:\n" + serialzied);
            return null;
        }
        int ruleId = Integer.parseInt(items[0].substring(5));
        int begin = Integer.parseInt(items[1]);
        int end = Integer.parseInt(items[2]);
        double score = Double.parseDouble(items[3]);
        String text = items[4];
        return new Span(begin, end, ruleId, score, text);
    }
}

