/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class TypeDefinition
implements Comparable<TypeDefinition>,
Cloneable {
    public String shortTypeName;
    public String shortSuperTypeName;
    public String fullSuperTypeName;
    public String fullTypeName;
    public LinkedHashMap<String, String> featureTypes = new LinkedHashMap();
    public LinkedHashMap<String, String> featureDefaultValues = new LinkedHashMap();

    public TypeDefinition(String typeName, String superTypeName) {
        this.init(typeName, superTypeName, null);
    }

    public TypeDefinition(String typeName, String superTypeName, List<String> newFeatureNames) {
        this.init(typeName, superTypeName, newFeatureNames);
    }

    public TypeDefinition(String typeName, String superTypeName, Set<String> newFeatureNames) {
        this.init(typeName, superTypeName, newFeatureNames);
    }

    public TypeDefinition(List<String> definition) {
        if (definition.size() > 2) {
            this.init(definition.get(0), definition.get(1), definition.subList(2, definition.size()));
        } else {
            this.init(definition.get(0), definition.get(1), null);
        }
    }

    public TypeDefinition(String typeName, String superTypeName, LinkedHashMap<String, String> newFeatureNames) {
        this.initWFeaturValuePairs(typeName, superTypeName, newFeatureNames);
    }

    public void initWFeaturValuePairs(String typeName, String superTypeName, LinkedHashMap<String, String> newFeatureDefaultValues) {
        this.init(typeName, superTypeName, null);
        this.setFeatureDefaultValues(newFeatureDefaultValues);
    }

    public void init(String typeName, String superTypeName, Collection<String> newFeatureNames) {
        this.fullTypeName = DeterminantValueSet.checkNameSpace(typeName);
        this.shortTypeName = DeterminantValueSet.getShortName(typeName);
        if (superTypeName.trim().length() == 0 || superTypeName == null) {
            this.fullSuperTypeName = DeterminantValueSet.defaultNameSpace + "Concept";
            this.shortSuperTypeName = "Concept";
        } else {
            this.fullSuperTypeName = DeterminantValueSet.checkNameSpace(superTypeName);
            this.shortSuperTypeName = DeterminantValueSet.getShortName(superTypeName);
        }
        this.setNewFeatureNames(newFeatureNames);
    }

    public String getFullSuperTypeName() {
        return this.fullSuperTypeName;
    }

    public String getFullTypeName() {
        return this.fullTypeName;
    }

    public String getShortTypeName() {
        return this.shortTypeName;
    }

    public String getShortSuperTypeName() {
        return this.shortSuperTypeName;
    }

    public Set<String> getNewFeatureNames() {
        return this.featureDefaultValues.keySet();
    }

    public LinkedHashMap<String, String> getFeatureValuePairs() {
        return this.featureDefaultValues;
    }

    public void setFeatureDefaultValues(LinkedHashMap<String, String> featureDefaultValues) {
        this.featureDefaultValues = featureDefaultValues;
    }

    public void setNewFeatureNames(Collection<String> newFeatureNames) {
        if (newFeatureNames == null) {
            return;
        }
        for (String featureName : newFeatureNames) {
            this.featureDefaultValues.put(featureName, "");
        }
    }

    public void addFeatureName(String featureName) {
        this.featureDefaultValues.put(featureName, "");
    }

    public void addFeatureDefaultValue(String featureName, String defaultValue) {
        this.featureDefaultValues.put(featureName, defaultValue);
    }

    public void setFeatureType(String featureName, String typeName) {
        this.featureTypes.put(featureName, typeName);
    }

    public String getFeatureType(String featureName) {
        if (this.featureTypes.containsKey(featureName)) {
            return this.featureTypes.get(featureName);
        }
        return "";
    }

    @Override
    public int compareTo(TypeDefinition o) {
        if (!this.fullTypeName.equals(o.fullTypeName)) {
            return 1;
        }
        if (!this.fullSuperTypeName.equals(o.fullSuperTypeName)) {
            return 1;
        }
        Set<String> thisKeys = this.featureDefaultValues.keySet();
        thisKeys.removeAll(o.featureDefaultValues.keySet());
        if (thisKeys.size() > 0) {
            return 1;
        }
        return 0;
    }

    public TypeDefinition clone() {
        return new TypeDefinition(this.fullTypeName, this.fullSuperTypeName, (LinkedHashMap)this.featureDefaultValues.clone());
    }

    public String toString() {
        ArrayList<String> featureNames = new ArrayList<String>();
        featureNames.addAll(this.getNewFeatureNames());
        return this.getFullTypeName() + " <" + this.getFullSuperTypeName() + ">:\t" + featureNames;
    }
}

