/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastcner;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.core.WildCardChecker;
import edu.utah.bmi.nlp.fastner.FastRuleWG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class FastCRule
extends FastRuleWG {
    protected HashMap<Integer, Double> scores = new HashMap();
    protected final DeterminantValueSet.Determinants END = DeterminantValueSet.Determinants.END;
    protected int maxRepeatLength = 30;
    protected boolean supportReplications = false;
    protected boolean scSupport = false;
    protected String method = "width";
    protected int offset = 0;
    protected HashMap<String, IntervalST> overlapCheckers = new HashMap();

    protected FastCRule() {
    }

    public FastCRule(String ruleStr) {
        super(ruleStr);
    }

    public FastCRule(HashMap<Integer, Rule> ruleStore) {
        this.initiate(ruleStore);
    }

    @Override
    protected boolean addRule(Rule rule) {
        int i;
        char[] crule = rule.rule.toCharArray();
        String determinant = rule.ruleName;
        HashMap rule1 = this.rulesMap;
        HashMap<Object, Object> rule2 = new HashMap<Object, Object>();
        HashMap rulet = new HashMap();
        int length = crule.length;
        for (i = 0; i < length && rule1 != null && rule1.containsKey(Character.valueOf(crule[i])); rule1 = (HashMap)rule1.get(Character.valueOf(crule[i])), ++i) {
        }
        if (i == length && rule1.containsKey((Object)this.END) && rule1.get((Object)this.END) == determinant) {
            logger.info("This rule has been included");
            return false;
        }
        if (i == length) {
            if (rule1.containsKey((Object)this.END)) {
                ((HashMap)rule1.get((Object)this.END)).put(determinant, rule.id);
            } else {
                rule2.put(determinant, rule.id);
                rule1.put(this.END, rule2.clone());
            }
            this.setScore(rule.id, rule.score);
            return true;
        }
        rule2.put(determinant, rule.id);
        rule2.put((Object)this.END, rule2.clone());
        rule2.remove(determinant);
        for (int j = length - 1; j > i; --j) {
            rulet = (HashMap)rule2.clone();
            rule2.clear();
            rule2.put(Character.valueOf(crule[j]), rulet);
        }
        this.setScore(rule.id, rule.score);
        rule1.put(Character.valueOf(crule[i]), rule2.clone());
        return true;
    }

    @Override
    public HashMap<String, ArrayList<Span>> processTokens(ArrayList<String> contextTokens) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("This method is not used in character-based ruleStore");
        }
        return null;
    }

    @Override
    public HashMap<String, ArrayList<Span>> processSpans(ArrayList<Span> contextTokens) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("This method is not used in character-based ruleStore");
        }
        return null;
    }

    @Override
    public HashMap<String, ArrayList<Span>> processString(String text) {
        this.offset = 0;
        return this.processRules(text);
    }

    public HashMap<String, ArrayList<Span>> processString(String text, int offset) {
        this.offset = offset;
        return this.processRules(text);
    }

    public HashMap<String, ArrayList<Span>> processSpan(Span span) {
        return this.processString(span.text, span.begin);
    }

    public HashMap<String, ArrayList<Span>> processRules(String text) {
        HashMap<String, ArrayList<Span>> matches = new HashMap<String, ArrayList<Span>>();
        char[] textChars = text.toCharArray();
        for (int i = 0; i < textChars.length; ++i) {
            char previousChar = i > 0 ? textChars[i - 1] : (char)' ';
            this.processRules(text, textChars, this.rulesMap, i, -1, i, matches, previousChar, false, ' ');
        }
        if (this.removePseudo) {
            this.removePseudoMatches(matches);
        }
        return matches;
    }

    protected void processRules(String text, char[] textChars, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches, char previousChar, boolean wildcard, char previousKey) {
        if (currentPosition < textChars.length) {
            char thisChar = textChars[currentPosition];
            if (rule.containsKey(Character.valueOf('\\'))) {
                this.processWildCards(text, textChars, (HashMap)rule.get(Character.valueOf('\\')), matchBegin, matchEnd, currentPosition, matches, previousChar, true, '\\');
            }
            if (rule.containsKey(Character.valueOf('(')) && previousKey != '\\') {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('(')), currentPosition, matchEnd, currentPosition, matches, previousChar, false, '(');
            }
            if (rule.containsKey(Character.valueOf(')')) && previousKey != '\\') {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf(')')), matchBegin, currentPosition, currentPosition, matches, previousChar, false, ')');
            }
            if (rule.containsKey((Object)this.END)) {
                this.addDeterminants(text, rule, matches, matchBegin, matchEnd, currentPosition);
            }
            if (rule.containsKey(Character.valueOf(thisChar)) && thisChar != ')' && thisChar != '(') {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf(thisChar)), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, false, thisChar);
            }
            if (this.supportReplications && rule.containsKey(Character.valueOf('+'))) {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('+')), matchBegin, matchEnd, currentPosition, matches, thisChar, false, '+');
                this.processReplicants(text, textChars, (HashMap)rule.get(Character.valueOf('+')), matchBegin, matchEnd, currentPosition, matches, thisChar, wildcard, previousKey);
            }
        } else if (currentPosition == textChars.length && rule.containsKey((Object)this.END)) {
            if (matchEnd == -1) {
                this.addDeterminants(text, rule, matches, matchBegin, currentPosition, currentPosition);
            } else {
                this.addDeterminants(text, rule, matches, matchBegin, matchEnd, currentPosition);
            }
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf('\\')) && ((HashMap)rule.get(Character.valueOf('\\'))).containsKey(Character.valueOf('e'))) {
            HashMap deterRule = (HashMap)((HashMap)rule.get(Character.valueOf('\\'))).get(Character.valueOf('e'));
            if (matchEnd == -1) {
                this.addDeterminants(text, deterRule, matches, matchBegin, currentPosition, currentPosition);
            } else {
                this.addDeterminants(text, deterRule, matches, matchBegin, matchEnd, currentPosition);
            }
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf(')'))) {
            HashMap deterRule = (HashMap)rule.get(Character.valueOf(')'));
            if (deterRule.containsKey((Object)this.END)) {
                this.addDeterminants(text, deterRule, matches, matchBegin, currentPosition, currentPosition);
            } else if (deterRule.containsKey(Character.valueOf('\\')) && ((HashMap)deterRule.get(Character.valueOf('\\'))).containsKey(Character.valueOf('e'))) {
                this.processRules(text, textChars, (HashMap)((HashMap)deterRule.get(Character.valueOf('\\'))).get(Character.valueOf('e')), matchBegin, matchEnd, currentPosition, matches, previousChar, false, ' ');
            }
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf('+'))) {
            HashMap deterRule = (HashMap)rule.get(Character.valueOf('+'));
            this.processRules(text, textChars, deterRule, matchBegin, matchEnd, currentPosition, matches, previousChar, wildcard, previousKey);
        }
    }

    protected boolean iss(char thisChar) {
        return thisChar == ' ' || thisChar == '\t' || thisChar == '\u00a0';
    }

    protected boolean isd(char thisChar) {
        return Character.isDigit(thisChar);
    }

    protected boolean isC(char thisChar) {
        return Character.isUpperCase(thisChar);
    }

    protected boolean isc(char thisChar) {
        return Character.isLowerCase(thisChar);
    }

    protected boolean isp(char thisChar) {
        return WildCardChecker.isPunctuation(thisChar);
    }

    protected boolean isu(char thisChar) {
        return WildCardChecker.isSpecialChar(thisChar);
    }

    protected boolean isw(char thisChar) {
        return Character.isWhitespace(thisChar) || thisChar == '\u00a0' || WildCardChecker.isSpecialChar(thisChar);
    }

    protected boolean isa(char thisChar) {
        return !Character.isWhitespace(thisChar) && thisChar != '\u00a0';
    }

    protected void processWildCards(String text, char[] textChars, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches, char previousChar, boolean wildcard, char previousKey) {
        char thisChar = textChars[currentPosition];
        for (Object rulechar : rule.keySet()) {
            char thisRuleChar = ((Character)rulechar).charValue();
            switch (thisRuleChar) {
                case 's': {
                    if (!this.iss(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('s')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 's');
                    break;
                }
                case 'n': {
                    if (thisChar != '\n' && thisChar != '\r') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('n')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'n');
                    break;
                }
                case '(': {
                    if (thisChar != '(') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('(')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, '(');
                    break;
                }
                case ')': {
                    if (thisChar != ')') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf(')')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, ')');
                    break;
                }
                case 'd': {
                    if (!this.isd(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('d')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'd');
                    break;
                }
                case 'C': {
                    if (!this.isC(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('C')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'C');
                    break;
                }
                case 'c': {
                    if (!this.isc(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('c')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'c');
                    break;
                }
                case 'p': {
                    if (!this.isp(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('p')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'p');
                    break;
                }
                case '+': {
                    if (thisChar != '+') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('+')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, '+');
                    break;
                }
                case '\\': {
                    if (thisChar != '\\') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('\\')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, false, '\\');
                    break;
                }
                case 'b': {
                    if (currentPosition != 0) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('b')), matchBegin, matchEnd, currentPosition, matches, previousChar, false, 'b');
                    break;
                }
                case 'a': {
                    if (!this.isa(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('a')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'a');
                    break;
                }
                case 'u': {
                    if (!this.isu(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('u')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'u');
                    break;
                }
                case 'w': {
                    if (!this.isw(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('w')), matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'w');
                }
            }
        }
    }

    protected void processReplicants(String text, char[] textChars, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches, char previousChar, boolean wildcard, char previousKey) {
        int currentRepeats;
        char thisChar = textChars[currentPosition];
        if (wildcard) {
            block0 : switch (previousKey) {
                case 's': {
                    if (!this.iss(thisChar)) break;
                    for (currentRepeats = 0; this.iss(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length; ++currentRepeats) {
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'n': {
                    if (thisChar != '\n' && thisChar != '\r') break;
                    while ((thisChar == '\n' || thisChar == '\r') && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'd': {
                    if (!this.isd(thisChar)) break;
                    while (this.isd(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'C': {
                    if (!this.isC(thisChar)) break;
                    while (this.isC(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'c': {
                    if (!this.isc(thisChar)) break;
                    while (this.isc(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'p': {
                    if (!this.isp(thisChar)) break;
                    while (this.isp(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'a': {
                    if (!this.isa(thisChar)) break;
                    while (this.isa(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'u': {
                    if (!this.isu(thisChar)) break;
                    while (this.isu(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'w': {
                    if (!this.isw(thisChar)) break;
                    while (this.isw(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
            }
            this.processRules(text, textChars, rule, matchBegin, matchEnd, currentPosition, matches, previousChar, false, '+');
        } else if (thisChar == previousKey) {
            while (thisChar == previousKey && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                ++currentRepeats;
                if (++currentPosition == textChars.length) break;
                thisChar = textChars[currentPosition];
            }
            this.processRules(text, textChars, rule, matchBegin, matchEnd, currentPosition, matches, previousChar, false, '+');
        }
    }

    protected void addDeterminants(String text, HashMap rule, HashMap<String, ArrayList<Span>> matches, int matchBegin, int matchEnd, int currentPosition) {
        int end;
        HashMap deterRule = (HashMap)rule.get((Object)this.END);
        int n = end = matchEnd == -1 ? currentPosition : matchEnd;
        if (matchBegin > end) {
            StringBuilder sb = new StringBuilder();
            for (Object key : deterRule.keySet()) {
                int rulePos = (Integer)deterRule.get(key);
                sb.append(this.getRule(rulePos).toString());
                sb.append("\n");
            }
            logger.warning("Rule definition error ----matched begin > matched end\ncheck the following rules: \n" + sb.toString());
            int snippetBegin = matchBegin - 100;
            snippetBegin = snippetBegin < 0 ? 0 : snippetBegin;
            int snippetEnd = end + 100;
            snippetEnd = snippetEnd > text.length() ? text.length() : snippetEnd;
            logger.warning("try to match span: " + text.substring(snippetBegin, end) + "<*>" + text.substring(end, matchBegin) + "<*>" + text.substring(matchBegin, snippetEnd));
            return;
        }
        Span currentSpan = new Span(matchBegin + this.offset, end + this.offset, text.substring(matchBegin, end));
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Try to addDeterminants: " + currentSpan.begin + ", " + currentSpan.end + "\t" + currentSpan.text);
        }
        for (Object key : deterRule.keySet()) {
            IntervalST<Integer> overlapChecker;
            ArrayList<Object> currentSpanList = new ArrayList<Span>();
            int rulePos = (Integer)deterRule.get(key);
            double score = this.getScore(rulePos);
            currentSpan.ruleId = rulePos;
            currentSpan.score = score;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\t\tRule Id: " + rulePos + "\t" + key + "\t" + (Object)((Object)this.getRule((int)rulePos).type) + "\t" + this.getRuleString(rulePos));
            }
            if (matches.containsKey(key)) {
                currentSpanList = matches.get(key);
                overlapChecker = this.overlapCheckers.get(key);
                Object overlappedPos = overlapChecker.get(new Interval1D(currentSpan.begin, currentSpan.end - 1));
                if (overlappedPos != null) {
                    int pos = (Integer)overlappedPos;
                    Span overlappedSpan = (Span)currentSpanList.get(pos);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("\t\tOverlapped with: " + overlappedSpan.begin + ", " + overlappedSpan.end + "\t" + text.substring(overlappedSpan.begin - this.offset, overlappedSpan.end - this.offset));
                    }
                    if (!this.compareSpan(currentSpan, overlappedSpan)) {
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest("\t\tSkip this span ...");
                        continue;
                    }
                    currentSpanList.set(pos, currentSpan);
                    overlapChecker.remove(new Interval1D(overlappedSpan.begin, overlappedSpan.end - 1));
                    overlapChecker.put(new Interval1D(currentSpan.begin, currentSpan.end - 1), pos);
                    continue;
                }
                overlapChecker.put(new Interval1D(currentSpan.begin, currentSpan.end - 1), currentSpanList.size());
                currentSpanList.add(currentSpan);
                continue;
            }
            currentSpanList.add(currentSpan);
            matches.put((String)key, currentSpanList);
            overlapChecker = new IntervalST<Integer>();
            overlapChecker.put(new Interval1D(currentSpan.begin, currentSpan.end - 1), 0);
            this.overlapCheckers.put((String)key, overlapChecker);
        }
    }

    public double getScore(Span span) {
        return this.scores.get(span.ruleId);
    }

    public double getScore(int ruleId) {
        return this.scores.get(ruleId);
    }

    public void setScore(int ruleId, double score) {
        this.scores.put(ruleId, score);
    }

    public void setReplicationSupport(boolean support) {
        this.supportReplications = support;
    }

    @Override
    public void setCompareMethod(String method) {
        this.method = method;
    }

    protected boolean compareScoreOnly(Span a, Span b) {
        if (this.getScore(a) < 0.0) {
            return true;
        }
        if (this.getScore(b) < 0.0) {
            return false;
        }
        return this.getScore(a) > this.getScore(b);
    }

    protected boolean compareWidthOnly(Span a, Span b) {
        return a.width > b.width;
    }

    protected boolean compareScorePrior(Span a, Span b) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\t\tcurrent " + a.ruleId + " score: " + this.getScore(a.ruleId) + "\t---\toverlapped " + b.ruleId + " score: " + this.getScore(b.ruleId));
        }
        if (this.getScore(a) < 0.0) {
            return true;
        }
        if (this.getScore(b) < 0.0) {
            return false;
        }
        if (this.getScore(a) > this.getScore(b)) {
            return true;
        }
        return this.getScore(a) >= this.getScore(b) && a.width > b.width;
    }

    protected boolean compareWidthPrior(Span a, Span b) {
        if (a.width > b.width) {
            return true;
        }
        return a.width == b.width && this.getScore(a) > this.getScore(b);
    }

    protected boolean compareSpan(Span a, Span b) {
        switch (this.method) {
            case "score": {
                return this.compareScoreOnly(a, b);
            }
            case "scorewidth": {
                return this.compareScorePrior(a, b);
            }
            case "widthscore": {
                return this.compareWidthPrior(a, b);
            }
        }
        return this.compareWidthOnly(a, b);
    }

    public void setSpecialCharacterSupport(Boolean scSupport) {
        this.scSupport = scSupport;
    }

    public void setMaxRepeatLength(int maxRepeatLength) {
        this.maxRepeatLength = maxRepeatLength;
    }
}

