/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastcner;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.fastcner.FastRuSHRule_H;
import edu.utah.bmi.nlp.fastcner.FastRuSHRule_HCN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FastRuSHFactory {
    public static FastRuSHRule_H createFastRuSHRule(String ruleStr) {
        FastRuSHRule_H frr;
        Object[] output = FastRuSHFactory.buildRuleStore(ruleStr);
        HashMap ruleStore = (HashMap)output[0];
        String type = (String)output[1];
        boolean tokenRuleEnabled = (Boolean)output[2];
        switch (type) {
            case "cn": {
                frr = new FastRuSHRule_HCN(ruleStore);
                break;
            }
            default: {
                frr = new FastRuSHRule_H(ruleStore);
            }
        }
        frr.tokenRuleEnabled = tokenRuleEnabled;
        return frr;
    }

    public static Object[] buildRuleStore(String ruleStr) {
        HashMap<Integer, Rule> ruleStore = new HashMap<Integer, Rule>();
        IOUtil ioUtil = new IOUtil(ruleStr);
        String type = "en";
        if (ioUtil.settings.containsKey("cn")) {
            type = "cn";
        } else if (!ioUtil.settings.containsKey("en")) {
            FastRuSHRule_H.logger.warning("RuSH rule type is not specified. Assume it is 'en'.");
        }
        boolean tokenRuleEnabled = false;
        boolean oldformat = true;
        for (ArrayList<String> arrayList : ioUtil.getRuleCells()) {
            int id = Integer.parseInt(arrayList.get(0));
            String rule = arrayList.get(1);
            double score = 0.0;
            DeterminantValueSet.Determinants determinant = null;
            score = Double.parseDouble(arrayList.get(2));
            String ruleName = arrayList.get(3).trim();
            if (!tokenRuleEnabled && ruleName.equals("tobegin")) {
                tokenRuleEnabled = true;
            }
            if (arrayList.size() > 4) {
                determinant = DeterminantValueSet.Determinants.valueOf(arrayList.get(4));
                oldformat = false;
            }
            ruleStore.put(id, new Rule(id, rule, ruleName, score, determinant));
        }
        if (oldformat) {
            for (Map.Entry entry : ruleStore.entrySet()) {
                Rule rule = (Rule)entry.getValue();
                if (rule.type != null) continue;
                rule.type = rule.score % 2.0 == 0.0 ? DeterminantValueSet.Determinants.ACTUAL : DeterminantValueSet.Determinants.PSEUDO;
            }
        } else {
            for (Map.Entry entry : ruleStore.entrySet()) {
                Rule rule = (Rule)entry.getValue();
                if (rule.type != null) continue;
                rule.type = DeterminantValueSet.Determinants.ACTUAL;
            }
        }
        return new Object[]{ruleStore, type, tokenRuleEnabled};
    }
}

