/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastcner;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.WildCardChecker;
import edu.utah.bmi.nlp.fastcner.FastCRuleSB;
import edu.utah.bmi.nlp.fastcner.FastRuSHFactory;
import edu.utah.bmi.nlp.fastcner.FastRuSHRule;
import edu.utah.bmi.nlp.fastner.FastRule;
import edu.utah.bmi.nlp.rush.core.Marker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FastRuSHRule_H
extends FastCRuleSB
implements FastRuSHRule {
    protected HashMap<String, String> typeMergeMap = new HashMap();
    public static Logger logger = IOUtil.getLogger(FastRule.class);
    public boolean tokenRuleEnabled = false;

    public FastRuSHRule_H(String ruleStr) {
        Object[] output = FastRuSHFactory.buildRuleStore(ruleStr);
        HashMap ruleStore = (HashMap)output[0];
        this.tokenRuleEnabled = (Boolean)output[2];
        this.initiate(ruleStore);
    }

    public FastRuSHRule_H(HashMap<Integer, Rule> ruleStore) {
        super(ruleStore);
    }

    @Override
    public HashMap<String, ArrayList<Marker>> processText(String text) {
        HashMap<String, HashMap<Float, Marker>> matches = new HashMap<String, HashMap<Float, Marker>>();
        char[] textChars = text.toCharArray();
        for (int i = 0; i < textChars.length; ++i) {
            char previousChar = i > 0 ? textChars[i - 1] : (char)' ';
            this.processRules(text, textChars, this.rulesMap, i, i, 0, i, matches, previousChar, false, ' ');
        }
        HashMap<String, ArrayList<Marker>> res = new HashMap<String, ArrayList<Marker>>();
        for (String type : matches.keySet()) {
            HashMap<Float, Marker> spans = matches.get(type);
            ArrayList<Marker> list = new ArrayList<Marker>();
            for (Marker marker : spans.values()) {
                if (this.removePseudo && ((Rule)this.ruleStore.get((Object)Integer.valueOf((int)marker.ruleId))).type == DeterminantValueSet.Determinants.PSEUDO) continue;
                list.add(marker);
            }
            Collections.sort(list);
            res.put(type, list);
        }
        return res;
    }

    protected void processRules(String text, char[] textChars, HashMap rule, int ruleStartPosition, int matchBegin, int matchEnd, int currentPosition, Map<String, HashMap<Float, Marker>> matches, char previousChar, boolean wildcard, char previousKey) {
        if (currentPosition < textChars.length) {
            char thisChar = textChars[currentPosition];
            if (rule.containsKey(Character.valueOf('\\'))) {
                this.processWildCards(text, textChars, (HashMap)rule.get(Character.valueOf('\\')), ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, previousChar, true, '\\');
            }
            if (rule.containsKey(Character.valueOf('(')) && previousKey != '\\') {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('(')), ruleStartPosition, currentPosition, matchEnd, currentPosition, matches, previousChar, false, '(');
            }
            if (rule.containsKey(Character.valueOf(')')) && previousKey != '\\') {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf(')')), ruleStartPosition, matchBegin, currentPosition, currentPosition, matches, previousChar, false, ')');
            }
            if (rule.containsKey((Object)this.END)) {
                if (matchEnd == 0) {
                    matchEnd = currentPosition;
                }
                this.addDeterminants(text, rule, matches, ruleStartPosition, matchBegin, matchEnd, currentPosition);
            }
            if (rule.containsKey(Character.valueOf(thisChar)) && thisChar != ')' && thisChar != '(') {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf(thisChar)), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, false, thisChar);
            }
            if (rule.containsKey(Character.valueOf('+'))) {
                this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('+')), ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, thisChar, false, '+');
                this.processReplicants(text, textChars, (HashMap)rule.get(Character.valueOf('+')), ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, thisChar, wildcard, previousKey);
            }
        } else if (currentPosition == textChars.length && rule.containsKey((Object)this.END)) {
            if (matchEnd == 0) {
                matchEnd = currentPosition;
            }
            this.addDeterminants(text, rule, matches, ruleStartPosition, matchBegin, matchEnd, currentPosition);
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf('\\')) && ((HashMap)rule.get(Character.valueOf('\\'))).containsKey(Character.valueOf('e'))) {
            HashMap deterRule = (HashMap)((HashMap)rule.get(Character.valueOf('\\'))).get(Character.valueOf('e'));
            if (matchEnd == 0) {
                matchEnd = currentPosition;
            }
            this.addDeterminants(text, deterRule, matches, ruleStartPosition, matchBegin, matchEnd, currentPosition);
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf(')'))) {
            HashMap deterRule = (HashMap)rule.get(Character.valueOf(')'));
            if (deterRule.containsKey((Object)this.END)) {
                this.addDeterminants(text, deterRule, matches, ruleStartPosition, matchBegin, currentPosition, currentPosition);
            } else if (deterRule.containsKey(Character.valueOf('\\')) && ((HashMap)deterRule.get(Character.valueOf('\\'))).containsKey(Character.valueOf('e'))) {
                this.processRules(text, textChars, (HashMap)((HashMap)deterRule.get(Character.valueOf('\\'))).get(Character.valueOf('e')), ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, previousChar, false, ' ');
            }
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf('+'))) {
            HashMap deterRule = (HashMap)rule.get(Character.valueOf('+'));
            this.processRules(text, textChars, deterRule, ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, previousChar, wildcard, previousKey);
        }
    }

    @Override
    protected boolean iss(char thisChar) {
        return thisChar == ' ' || thisChar == '\t' || thisChar == '\u00a0';
    }

    @Override
    protected boolean isd(char thisChar) {
        return Character.isDigit(thisChar);
    }

    @Override
    protected boolean isC(char thisChar) {
        return Character.isUpperCase(thisChar);
    }

    @Override
    protected boolean isc(char thisChar) {
        return Character.isLowerCase(thisChar);
    }

    @Override
    protected boolean isp(char thisChar) {
        return WildCardChecker.isPunctuation(thisChar);
    }

    @Override
    protected boolean isu(char thisChar) {
        return WildCardChecker.isSpecialChar(thisChar);
    }

    @Override
    protected boolean isw(char thisChar) {
        return Character.isWhitespace(thisChar) || thisChar == '\u00a0' || WildCardChecker.isSpecialChar(thisChar);
    }

    @Override
    protected boolean isa(char thisChar) {
        return !Character.isWhitespace(thisChar) && thisChar != '\u00a0';
    }

    protected void processReplicants(String text, char[] textChars, HashMap rule, int ruleStartPosition, int matchBegin, int matchEnd, int currentPosition, Map<String, HashMap<Float, Marker>> matches, char previousChar, boolean wildcard, char previousKey) {
        int currentRepeats;
        char thisChar = textChars[currentPosition];
        if (wildcard) {
            block0 : switch (previousKey) {
                case 's': {
                    if (!this.iss(thisChar)) break;
                    for (currentRepeats = 0; this.iss(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length; ++currentRepeats) {
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'n': {
                    if (thisChar != '\n' && thisChar != '\r') break;
                    while ((thisChar == '\n' || thisChar == '\r') && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'd': {
                    if (!this.isd(thisChar)) break;
                    while (this.isd(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'C': {
                    if (!this.isC(thisChar)) break;
                    while (this.isC(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'c': {
                    if (!this.isc(thisChar)) break;
                    while (this.isc(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'p': {
                    if (!this.isp(thisChar)) break;
                    while (this.isp(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'a': {
                    if (!this.isa(thisChar)) break;
                    while (this.isa(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'u': {
                    if (!this.isu(thisChar)) break;
                    while (this.isu(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
                case 'w': {
                    if (!this.isw(thisChar)) break;
                    while (this.isw(thisChar) && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                        ++currentRepeats;
                        if (++currentPosition == textChars.length) break block0;
                        thisChar = textChars[currentPosition];
                    }
                    break;
                }
            }
            this.processRules(text, textChars, rule, ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, previousChar, false, '+');
        } else if (thisChar == previousKey) {
            while (thisChar == previousKey && currentRepeats < this.maxRepeatLength && currentPosition < textChars.length) {
                ++currentRepeats;
                if (++currentPosition == textChars.length) break;
                thisChar = textChars[currentPosition];
            }
            this.processRules(text, textChars, rule, ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, previousChar, false, '+');
        }
    }

    protected void processWildCards(String text, char[] textChars, HashMap rule, int ruleStartPosition, int matchBegin, int matchEnd, int currentPosition, Map<String, HashMap<Float, Marker>> matches, char previousChar, boolean wildcard, char previousKey) {
        char thisChar = textChars[currentPosition];
        for (Object rulechar : rule.keySet()) {
            char thisRuleChar = ((Character)rulechar).charValue();
            switch (thisRuleChar) {
                case 's': {
                    if (!this.iss(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('s')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 's');
                    break;
                }
                case 'n': {
                    if (thisChar != '\n' && thisChar != '\r') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('n')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'n');
                    break;
                }
                case '(': {
                    if (thisChar != '(') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('(')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, '(');
                    break;
                }
                case ')': {
                    if (thisChar != ')') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf(')')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, ')');
                    break;
                }
                case 'd': {
                    if (!this.isd(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('d')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'd');
                    break;
                }
                case 'C': {
                    if (!this.isC(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('C')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'C');
                    break;
                }
                case 'c': {
                    if (!this.isc(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('c')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'c');
                    break;
                }
                case 'p': {
                    if (!this.isp(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('p')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'p');
                    break;
                }
                case '+': {
                    if (thisChar != '+') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('+')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, '+');
                    break;
                }
                case '\\': {
                    if (thisChar != '\\') break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('\\')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, false, '\\');
                    break;
                }
                case 'b': {
                    if (currentPosition != 0) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('b')), ruleStartPosition, matchBegin, matchEnd, currentPosition, matches, previousChar, false, 'b');
                    break;
                }
                case 'a': {
                    if (!this.isa(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('a')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'a');
                    break;
                }
                case 'u': {
                    if (!this.isu(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('u')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'u');
                    break;
                }
                case 'w': {
                    if (!this.isw(thisChar)) break;
                    this.processRules(text, textChars, (HashMap)rule.get(Character.valueOf('w')), ruleStartPosition, matchBegin, matchEnd, currentPosition + 1, matches, thisChar, true, 'w');
                }
            }
        }
    }

    protected void addDeterminants(String text, HashMap rule, Map<String, HashMap<Float, Marker>> matches, int ruleStartPosition, int matchBegin, int matchEnd, int currentPosition) {
        int end;
        HashMap deterRule = (HashMap)rule.get((Object)this.END);
        int n = end = matchEnd == -1 ? currentPosition : matchEnd;
        if (matchBegin > end) {
            StringBuilder sb = new StringBuilder();
            for (Object key : deterRule.keySet()) {
                int rulePos = (Integer)deterRule.get(key);
                sb.append(this.getRule(rulePos).toString());
                sb.append("\n");
            }
            logger.warning("Rule definition error ----matched begin > matched end\ncheck the following rules: \n" + sb.toString());
            int snippetBegin = matchBegin - 100;
            snippetBegin = snippetBegin < 0 ? 0 : snippetBegin;
            int snippetEnd = end + 100;
            snippetEnd = snippetEnd > text.length() ? text.length() : snippetEnd;
            logger.warning("try to match span: " + text.substring(snippetBegin, end) + "<*>" + text.substring(end, matchBegin) + "<*>" + text.substring(matchBegin, snippetEnd));
            return;
        }
        Marker currentSpan = new Marker(matchBegin + this.offset, end + this.offset, text.substring(matchBegin, end));
        currentSpan.type = Marker.MARKERTYPE.END;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Try to addDeterminants: " + currentSpan.begin + ", " + currentSpan.end + "\t" + currentSpan.text);
        }
        for (Object key : deterRule.keySet()) {
            IntervalST<Float> overlapChecker;
            HashMap<Object, Object> currentSpanList = new HashMap<Float, Marker>();
            int rulePos = (Integer)deterRule.get(key);
            double score = this.getScore(rulePos);
            currentSpan.ruleId = rulePos;
            currentSpan.score = score;
            currentSpan.type = key.equals("stend") ? Marker.MARKERTYPE.END : Marker.MARKERTYPE.BEGIN;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\t\tRule Id: " + rulePos + "\t" + key + "\t" + (Object)((Object)this.getRule((int)rulePos).type) + "\t" + this.getRuleString(rulePos));
            }
            if (matches.containsKey(key)) {
                currentSpanList = matches.get(key);
                overlapChecker = (IntervalST<Float>)this.overlapCheckers.get(key);
                Float overlappedPos = (Float)overlapChecker.get(new Interval1D(currentSpan.begin, currentSpan.end - 1));
                if (overlappedPos != null) {
                    Marker overlappedSpan = (Marker)currentSpanList.get(overlappedPos);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("\t\tOverlapped with: " + overlappedSpan.fbegin + ", " + overlappedSpan.fend + "\t" + text.substring(overlappedSpan.getBegin() - this.offset, overlappedSpan.getEnd() - this.offset));
                    }
                    if (!this.compareSpan(currentSpan, overlappedSpan)) {
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest("\t\tSkip this span ...");
                        continue;
                    }
                    currentSpanList.put(Float.valueOf(currentSpan.fbegin), currentSpan);
                    overlapChecker.remove(new Interval1D(currentSpan.getBegin(), currentSpan.getEnd()));
                    overlapChecker.put(new Interval1D(currentSpan.getBegin(), currentSpan.getEnd()), Float.valueOf(currentSpan.fbegin));
                    continue;
                }
                overlapChecker.put(new Interval1D(currentSpan.getBegin(), currentSpan.getEnd()), Float.valueOf(currentSpan.fbegin));
                currentSpanList.put(Float.valueOf(currentSpan.fbegin), currentSpan);
                continue;
            }
            currentSpanList.put(Float.valueOf(currentSpan.fbegin), currentSpan);
            matches.put((String)key, currentSpanList);
            overlapChecker = new IntervalST<Float>();
            overlapChecker.put(new Interval1D(currentSpan.getBegin(), currentSpan.getEnd()), Float.valueOf(currentSpan.fbegin));
            this.overlapCheckers.put((String)key, overlapChecker);
        }
    }
}

