/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastcner;

import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.fastcner.FastRuSHRule_H;
import edu.utah.bmi.nlp.fastcner.UnicodeChecker;
import java.util.HashMap;

public class FastRuSHRule_HCN
extends FastRuSHRule_H {
    public FastRuSHRule_HCN(String ruleStr) {
        super(ruleStr);
    }

    public FastRuSHRule_HCN(HashMap<Integer, Rule> ruleStore) {
        super(ruleStore);
    }

    @Override
    protected boolean iss(char thisChar) {
        return thisChar == ' ' || thisChar == '\t' || thisChar == '\u00a0';
    }

    @Override
    protected boolean isd(char thisChar) {
        return UnicodeChecker.isDigit(thisChar);
    }

    @Override
    protected boolean isC(char thisChar) {
        return UnicodeChecker.isChinese(thisChar);
    }

    @Override
    protected boolean isc(char thisChar) {
        return UnicodeChecker.isAlphabetic(thisChar);
    }

    @Override
    protected boolean isp(char thisChar) {
        return UnicodeChecker.isPunctuation(thisChar);
    }

    @Override
    protected boolean isu(char thisChar) {
        return UnicodeChecker.isSpecialChar(thisChar);
    }

    @Override
    protected boolean isw(char thisChar) {
        return Character.isWhitespace(thisChar) || thisChar == '\u00a0' || UnicodeChecker.isSpecialChar(thisChar) || thisChar == '\u3000';
    }

    @Override
    protected boolean isa(char thisChar) {
        return !Character.isWhitespace(thisChar) && thisChar != '\u00a0' && thisChar != '\u3000';
    }
}

