/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastcner;

import org.apache.commons.lang3.StringUtils;

public class UnicodeChecker {
    public static boolean isSpecialChar(char c) {
        char d = c;
        return d > '~' && d != '\u00a0' && d < '\u2e80';
    }

    public static boolean isChinese(char c) {
        char d = c;
        return d > '\u4dff' && d < '\u9fcc';
    }

    public static boolean isPunctuation(char c) {
        return c == '\uff01' || c == '\u3001' || c == '\u3002' || c == '\uff03' || c == '\uff05' || c == '\uff06' || c == '\uff08' || c == '\uff09' || c == '\u300a' || c == '\uff0b' || c == '\u300b' || c == '\uff0c' || c == '\u300c' || c == '\uff0d' || c == '\u300d' || c == '\uff0f' || c == '\u2014' || c == '\u2018' || c == '\u2019' || c == '\uff1a' || c == '\uff1b' || c == '\u201c' || c == '\u201d' || c == '\uff1d' || c == '\uff1f' || c == '\uff20' || c == '!' || c == '\"' || c == '#' || c == '$' || c == '%' || c == '&' || c == '\u2026' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == '-' || c == '.' || c == '/' || c == '\u00b7' || c == ':' || c == ';' || c == '<' || c == '=' || c == '>' || c == '?' || c == '@' || c == '\uff40' || c == '\u00d7' || c == '[' || c == '\uff5b' || c == '\\' || c == '\uff5c' || c == ']' || c == '\uff5d' || c == '^' || c == '\uff5e' || c == '_' || c == '`' || c == '\uffe5' || c == '{';
    }

    public static boolean isDigit(char c) {
        char d = c;
        return Character.isDigit(c) || d > '\uff10' && d < '\uff11';
    }

    public static boolean isAlphabetic(char c) {
        return (6 >> Character.getType(c) & 1) != 0;
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0') {
            if (chars[start + 1] == 'x' || chars[start + 1] == 'X') {
                int i2 = start + 2;
                if (i2 == sz) {
                    return false;
                }
                while (i2 < chars.length) {
                    if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            if (Character.isDigit(chars[start + 1])) {
                for (int i3 = start + 1; i3 < chars.length; ++i3) {
                    if (chars[i3] >= '0' && chars[i3] <= '9') continue;
                    return false;
                }
                return true;
            }
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }
}

