/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastcner.uima;

import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.SimpleParser;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.fastcner.FastCNER;
import edu.utah.bmi.nlp.fastner.uima.FastNER_AE_General;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class FastCNER_AE_General
extends FastNER_AE_General {
    public static final String PARAM_REPLICATION_SUPPORT = "ReplicationSupport";
    protected boolean replicationSupport;
    public static final String PARAM_MAXREPEATLENGTH = "MaxRepeatLength";
    protected int maxRepeatLength;

    @Override
    public void initialize(UimaContext cont) {
        super.initialize(cont);
    }

    @Override
    protected LinkedHashMap<String, TypeDefinition> initFastNER(UimaContext cont, String ruleStr) {
        Object obj = cont.getConfigParameterValue(PARAM_REPLICATION_SUPPORT);
        this.replicationSupport = obj == null ? true : (Boolean)obj;
        obj = cont.getConfigParameterValue(PARAM_MAXREPEATLENGTH);
        this.maxRepeatLength = obj == null ? 50 : (Integer)obj;
        this.fastNER = new FastCNER(ruleStr);
        ((FastCNER)this.fastNER).setReplicationSupport(this.replicationSupport);
        ((FastCNER)this.fastNER).setMaxRepeatLength(this.maxRepeatLength);
        if (this.markPseudo) {
            this.fastNER.setRemovePseudo(false);
        }
        return this.fastNER.getTypeDefinitions();
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        IntervalST<String> sectionTree = new IntervalST<String>();
        int totalSections = 0;
        if (this.assignSection || this.forceAssignSections) {
            totalSections = this.indexSections(jcas, sectionTree);
        }
        LinkedHashMap sentences = new LinkedHashMap();
        AnnotationIndex annoIndex = jcas.getAnnotationIndex(this.SentenceType);
        FSIterator annoIter = annoIndex.iterator();
        int totalSentences = 0;
        while (annoIter.hasNext()) {
            Annotation sentence = (Annotation)annoIter.next();
            ++totalSentences;
            String sectionName = sectionTree.get(new Interval1D(sentence.getBegin(), sentence.getEnd()));
            if (sectionName == null) {
                if (totalSections != 0) continue;
                sectionName = SourceDocumentInformation.class.getSimpleName();
            }
            if (!sentences.containsKey(sectionName)) {
                sentences.put(sectionName, new ArrayList());
            }
            ((ArrayList)sentences.get(sectionName)).add(sentence);
        }
        if (totalSentences > 0) {
            for (String sectionName : sentences.keySet()) {
                boolean outsiders = true;
                if (this.includeSections.size() == 0 && this.excludeSections.size() > 0 && !this.excludeSections.contains(sectionName) || this.includeSections.size() > 0 && this.includeSections.contains(sectionName) || this.includeSections.size() == 0 && this.excludeSections.size() == 0) {
                    outsiders = false;
                }
                for (Annotation sentence : (ArrayList)sentences.get(sectionName)) {
                    HashMap<String, ArrayList<Span>> concepts = ((FastCNER)this.fastNER).processAnnotation(sentence);
                    if (concepts.size() <= 0) continue;
                    if (outsiders) {
                        this.saveOutsideScopeConcepts(jcas, concepts, sectionName);
                        continue;
                    }
                    this.saveConcepts(jcas, concepts, sectionName);
                }
            }
        } else {
            Collection<SourceDocumentInformation> docAnnotation = JCasUtil.select(jcas, SourceDocumentInformation.class);
            if (docAnnotation != null && docAnnotation.size() > 0) {
                logger.info("Document: " + docAnnotation.iterator().next().getUri() + " has not been properly sentence segmented. Use simple segmenter instead.");
            }
            String text = jcas.getDocumentText();
            ArrayList<ArrayList<Span>> simpleSentences = SimpleParser.tokenizeDecimalSmartWSentences(text, true);
            for (ArrayList<Span> sentence : simpleSentences) {
                Span sentenceSpan = new Span(sentence.get((int)0).begin, sentence.get((int)(sentence.size() - 1)).end);
                sentenceSpan.text = text.substring(sentenceSpan.begin, sentenceSpan.end);
                this.saveConcept(jcas, "Sentence", sentenceSpan.begin, sentenceSpan.end, null);
                for (Span token : sentence) {
                    this.saveConcept(jcas, "Token", token.begin, token.end, null);
                }
                HashMap<String, ArrayList<Span>> concepts = ((FastCNER)this.fastNER).processSpan(sentenceSpan);
                if (concepts.size() <= 0) continue;
                this.saveConcepts(jcas, concepts, null);
            }
        }
    }
}

