/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.fastner.FastRule;
import edu.utah.bmi.nlp.fastner.FastRuleFactory;
import edu.utah.bmi.nlp.fastner.FastRuleWOG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.uima.jcas.tcas.Annotation;

public class FastNER {
    public FastRule fastRule;
    protected boolean caseSenstive = false;
    protected LinkedHashMap<String, TypeDefinition> typeDefinition = new LinkedHashMap();

    protected FastNER() {
    }

    public FastNER(String ruleFile) {
        this.initiate(ruleFile, this.caseSenstive);
    }

    public FastNER(String ruleFile, boolean caseSenstive) {
        this.caseSenstive = caseSenstive;
        this.initiate(ruleFile, caseSenstive, true);
    }

    public FastNER(String ruleFile, boolean caseSenstive, boolean constructRuleMap) {
        this.caseSenstive = caseSenstive;
        this.initiate(ruleFile, caseSenstive, constructRuleMap);
    }

    public void setCompareMethod(String method) {
        if (this.fastRule instanceof FastRuleWOG) {
            ((FastRuleWOG)this.fastRule).setCompareMethod(method);
        }
    }

    public void setWidthCompareMethod(String widthCompareMethod) {
        if (this.fastRule instanceof FastRuleWOG) {
            ((FastRuleWOG)this.fastRule).setWidthCompareMethod(widthCompareMethod);
        }
    }

    protected void initiate(String ruleStr, boolean caseSenstive) {
        this.initiate(ruleStr, caseSenstive, true);
    }

    protected void initiate(String ruleStr, boolean caseSenstive, boolean constructRuleMap) {
        this.typeDefinition = new LinkedHashMap();
        this.fastRule = FastRuleFactory.createFastRule(ruleStr, this.typeDefinition, caseSenstive, constructRuleMap);
    }

    public HashMap<String, ArrayList<Span>> processStringList(ArrayList<String> tokens) {
        return this.fastRule.processTokens(tokens);
    }

    public HashMap<String, ArrayList<Span>> processSpanList(ArrayList<Span> tokens) {
        return this.fastRule.processSpans(tokens);
    }

    public HashMap<String, ArrayList<Span>> processAnnotationList(ArrayList<Annotation> tokens) {
        ArrayList<Span> spans = new ArrayList<Span>();
        for (Annotation token : tokens) {
            if (this.caseSenstive) {
                spans.add(new Span(token.getBegin(), token.getEnd(), token.getCoveredText()));
                continue;
            }
            spans.add(new Span(token.getBegin(), token.getEnd(), token.getCoveredText().toLowerCase()));
        }
        return this.processSpanList(spans);
    }

    public String getMatchedNEName(int ruleId) {
        return this.fastRule.ruleStore.get((Object)Integer.valueOf((int)ruleId)).ruleName;
    }

    public String getMatchedNEName(Span matchedSpan) {
        return this.getMatchedNEName(matchedSpan.ruleId);
    }

    public DeterminantValueSet.Determinants getMatchedNEType(Span matchedSpan) {
        return this.getMatchedNEType(matchedSpan.ruleId);
    }

    public DeterminantValueSet.Determinants getMatchedNEType(int ruleId) {
        return this.fastRule.ruleStore.get((Object)Integer.valueOf((int)ruleId)).type;
    }

    public LinkedHashMap<String, TypeDefinition> getTypeDefinitions() {
        return this.typeDefinition;
    }

    public String getRuleString(int ruleId) {
        return this.fastRule.ruleStore.get((Object)Integer.valueOf((int)ruleId)).rule;
    }

    public String getRuleName(int ruleId) {
        return this.fastRule.getRule((int)ruleId).ruleName;
    }

    public Rule getRule(int ruleId) {
        return this.fastRule.getRule(ruleId);
    }

    public void printRulesMap() {
        this.fastRule.printRulesMap();
    }

    public Rule getMatchedRuleString(Span matchedSpan) {
        return this.fastRule.ruleStore.get(matchedSpan.ruleId);
    }

    public void setRemovePseudo(boolean removePseudo) {
        this.fastRule.setRemovePseudo(removePseudo);
    }

    public double getRuleScore(int ruleId) {
        return this.fastRule.getRule((int)ruleId).score;
    }

    public HashMap<Integer, Rule> getRuleStore() {
        return this.fastRule.getRuleStore();
    }
}

