/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.NERRule;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.SimpleParser;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.fastner.FastRuleFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FastRule {
    public static Logger logger = IOUtil.getLogger(FastRule.class);
    protected boolean removePseudo = true;
    protected HashMap rulesMap = new HashMap();
    protected final DeterminantValueSet.Determinants END = DeterminantValueSet.Determinants.END;
    public HashMap<Integer, Rule> ruleStore = new HashMap();
    protected BiFunction<ArrayList, Integer, Integer> getSpanBegin;
    protected BiFunction<ArrayList, Integer, Integer> getSpanEnd;
    protected BiFunction<ArrayList, Integer, Integer> getBeginId;
    protected BiFunction<ArrayList, Integer, Integer> getEndId;
    protected BiFunction<ArrayList, Integer, String> getSpanText;
    protected BiFunction<ArrayList, Integer, String> getStringText;

    public FastRule() {
    }

    public FastRule(HashMap<Integer, Rule> ruleStore) {
        this.initiate(ruleStore);
    }

    public void initiate(String ruleStr, boolean caseSensitive) {
        this.ruleStore = (HashMap)FastRuleFactory.buildRuleStore(ruleStr, null, caseSensitive, true)[0];
        this.initiate(this.ruleStore);
    }

    public void initiate(HashMap<Integer, Rule> ruleStore) {
        this.rulesMap.clear();
        this.ruleStore = ruleStore;
        for (Map.Entry<Integer, Rule> ent : ruleStore.entrySet()) {
            Rule rule = ent.getValue();
            if (rule.rule.indexOf("[") != -1) {
                ArrayList<Rule> rules = this.expandSB(rule);
                for (Rule subrule : rules) {
                    this.addRule(subrule);
                }
                continue;
            }
            this.addRule(rule);
        }
        this.initiateFunctions();
    }

    public ArrayList<Rule> expandSB(Rule rule) {
        ArrayList<Rule> expandedRules = new ArrayList<Rule>();
        ArrayList<StringBuilder> ruleStringBuilders = new ArrayList<StringBuilder>();
        String ruleString = rule.rule;
        ruleStringBuilders.add(new StringBuilder());
        boolean OUT = false;
        boolean IN = true;
        boolean status = false;
        char[] ruleChars = ruleString.toCharArray();
        char preCh = ' ';
        int nextCh = 32;
        ArrayList<StringBuilder> branches = new ArrayList<StringBuilder>();
        for (int i = 0; i < ruleChars.length; ++i) {
            char ch = ruleChars[i];
            if (i > 0) {
                preCh = ruleChars[i - 1];
            }
            nextCh = i < ruleChars.length - 1 ? ruleChars[i + 1] : 32;
            if (!(status || ch == '[' && preCh != '\\')) {
                if (ch == '\\' && (nextCh == 91 || nextCh == 93)) {
                    preCh = ch;
                    continue;
                }
                for (int j = 0; j < ruleStringBuilders.size(); ++j) {
                    ((StringBuilder)ruleStringBuilders.get(j)).append(ch);
                }
                continue;
            }
            if (!status && ch == '[' && preCh != '\\') {
                status = true;
                branches = new ArrayList();
                branches.add(new StringBuilder());
                continue;
            }
            if (status && (ch != ']' || preCh == '\\')) {
                if (ch == '|') {
                    branches.add(new StringBuilder());
                    continue;
                }
                if (ch == '\\' && (nextCh == 91 || nextCh == 93)) {
                    preCh = ch;
                    continue;
                }
                ((StringBuilder)branches.get(branches.size() - 1)).append(ch);
                continue;
            }
            if (!status || ch != 93 || preCh == 92) continue;
            status = false;
            int previousSize = ruleStringBuilders.size();
            if (ch == '\\' && (nextCh == 91 || nextCh == 93)) {
                preCh = ch;
                continue;
            }
            for (int j = 0; j < previousSize; ++j) {
                StringBuilder sb = new StringBuilder((CharSequence)ruleStringBuilders.get(j));
                ((StringBuilder)ruleStringBuilders.get(j)).append((CharSequence)branches.get(0));
                for (int k = 1; k < branches.size(); ++k) {
                    ruleStringBuilders.add(new StringBuilder(sb));
                    ((StringBuilder)ruleStringBuilders.get(ruleStringBuilders.size() - 1)).append((CharSequence)branches.get(k));
                }
            }
        }
        HashSet<String> cleanSet = new HashSet<String>();
        for (StringBuilder subRule : ruleStringBuilders) {
            cleanSet.add(subRule.toString());
        }
        for (StringBuilder subRule : ruleStringBuilders) {
            logger.logp(Level.FINEST, this.getClass().getCanonicalName(), "expandSB", subRule.toString() + "\t" + rule.ruleName);
            NERRule newRule = new NERRule(rule.id, subRule.toString(), rule.ruleName, rule.score, rule.type, new String[0]);
            expandedRules.add(newRule);
        }
        return expandedRules;
    }

    protected void initiateFunctions() {
        this.getSpanEnd = (list, id) -> ((Span)list.get((int)id)).getEnd();
        this.getSpanBegin = (list, id) -> ((Span)list.get((int)id)).getBegin();
        this.getSpanText = (list, id) -> ((Span)list.get((int)id)).getText();
        this.getBeginId = (list, id) -> id;
        this.getEndId = (list, id) -> id;
        this.getStringText = (list, id) -> (String)list.get((int)id);
    }

    protected boolean addRule(Rule rule) {
        int i;
        ArrayList<HashMap> rules_tmp = new ArrayList<HashMap>();
        HashMap rule1 = this.rulesMap;
        HashMap<Object, Object> rule2 = new HashMap<Object, Object>();
        String[] ruleContent = rule.rule.split("\\s+");
        int length = ruleContent.length;
        rules_tmp.add(this.rulesMap);
        for (i = 0; i < length && rule1 != null && rule1.containsKey(ruleContent[i]); rule1 = (HashMap)rule1.get(ruleContent[i]), ++i) {
        }
        if (i > length) {
            return false;
        }
        if (i == length) {
            if (rule1.containsKey((Object)this.END)) {
                ((HashMap)rule1.get((Object)this.END)).put(rule.ruleName, rule.id);
            } else {
                rule2.put(rule.ruleName, rule.id);
                rule1.put(this.END, rule2.clone());
            }
            return true;
        }
        rule2.put(rule.ruleName, rule.id);
        rule2.put((Object)this.END, rule2.clone());
        rule2.remove(rule.ruleName);
        for (int j = length - 1; j > i; --j) {
            HashMap rule_t = (HashMap)rule2.clone();
            rule2.clear();
            rule2.put(ruleContent[j], rule_t);
        }
        rule1.put(ruleContent[i], rule2.clone());
        return true;
    }

    public HashMap<String, ArrayList<Span>> processString(String text, int begin, int end) {
        String sentence = text.substring(begin, end);
        return this.processString(sentence);
    }

    public HashMap<String, ArrayList<Span>> processString(String text) {
        ArrayList<Span> tokens = SimpleParser.tokenize2Spans(text, false);
        return this.processSpans(tokens);
    }

    protected abstract HashMap<String, ArrayList<Span>> processTokens(ArrayList<String> var1);

    protected abstract HashMap<String, ArrayList<Span>> processSpans(ArrayList<Span> var1);

    protected void removePseudoMatches(HashMap<String, ArrayList<Span>> matches) {
        for (Map.Entry<String, ArrayList<Span>> entry : matches.entrySet()) {
            Iterator<Span> spanIterator = entry.getValue().iterator();
            while (spanIterator.hasNext()) {
                Span thisSpan = spanIterator.next();
                if (this.ruleStore.get((Object)Integer.valueOf((int)thisSpan.ruleId)).type != DeterminantValueSet.Determinants.PSEUDO) continue;
                spanIterator.remove();
            }
        }
    }

    public void setRemovePseudo(boolean removePseudo) {
        this.removePseudo = removePseudo;
    }

    public String getRuleString(int ruleId) {
        return this.ruleStore.get((Object)Integer.valueOf((int)ruleId)).rule;
    }

    public Rule getRule(int pos) {
        return this.ruleStore.get(pos);
    }

    public void printRulesMap() {
        this.printEmbededMap(this.rulesMap, "");
    }

    private void printEmbededMap(HashMap<Object, Object> ruleMap, String offset) {
        for (Map.Entry<Object, Object> ent : ruleMap.entrySet()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(offset + "key: " + ent.getKey());
            }
            if (ent.getValue().getClass() == HashMap.class) {
                this.printEmbededMap((HashMap)ent.getValue(), offset + "\t");
                continue;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer(offset + "pair: " + ent.getKey() + "->" + ent.getValue());
        }
    }

    public HashMap<Integer, Rule> getRuleStore() {
        return this.ruleStore;
    }
}

