/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.NERRule;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.fastcner.FastCNER;
import edu.utah.bmi.nlp.fastcner.FastCRule;
import edu.utah.bmi.nlp.fastcner.FastCRuleCN;
import edu.utah.bmi.nlp.fastcner.FastCRuleSB;
import edu.utah.bmi.nlp.fastcner.UnicodeChecker;
import edu.utah.bmi.nlp.fastner.FastRule;
import edu.utah.bmi.nlp.fastner.FastRuleWG;
import edu.utah.bmi.nlp.fastner.FastRuleWGN;
import edu.utah.bmi.nlp.fastner.FastRuleWOG;
import edu.utah.bmi.nlp.fastner.IOUtil;
import edu.utah.bmi.nlp.fastner.OWLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Logger;

public class FastRuleFactory {
    public static Logger logger = edu.utah.bmi.nlp.core.IOUtil.getLogger(FastRuleFactory.class);

    @Deprecated
    public static FastRule createFastRule(Class fastNER, String ruleStr, LinkedHashMap<String, TypeDefinition> typeDefinition, String splitter, boolean caseSensitive) {
        return FastRuleFactory.createFastRule(fastNER, ruleStr, typeDefinition, splitter, caseSensitive);
    }

    public static Object[] buildRuleStore(String ruleStr, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean constructRuleMap) {
        String ruleType;
        String concatenated;
        Object[] output = new Object[3];
        HashMap<Integer, NERRule> rules = new HashMap<Integer, NERRule>();
        int strLength = ruleStr.trim().length();
        String testFileStr = ruleStr.trim().substring(strLength - 4).toLowerCase();
        File agnosticFile = new File(ruleStr);
        ArrayList<ArrayList<String>> allCells = new ArrayList<ArrayList<String>>();
        if (testFileStr.equals(".owl")) {
            concatenated = OWLUtil.readOwlFile(ruleStr, allCells, caseSensitive);
            ruleType = FastRuleFactory.getRuleType(concatenated);
        } else if (agnosticFile.exists() && agnosticFile.isDirectory()) {
            concatenated = OWLUtil.readOwlDirectory(ruleStr, allCells, caseSensitive);
            ruleType = FastRuleFactory.getRuleType(concatenated);
        } else {
            edu.utah.bmi.nlp.core.IOUtil ioUtil = new edu.utah.bmi.nlp.core.IOUtil(ruleStr);
            for (ArrayList<String> cells : ioUtil.getInitiations()) {
                String conceptShortName;
                String conceptName;
                if (cells.get(1).startsWith("@CONCEPT_FEATURES") || cells.get(1).startsWith("&CONCEPT_FEATURES")) {
                    conceptName = cells.get(2).trim();
                    conceptShortName = DeterminantValueSet.getShortName(conceptName);
                    if (typeDefinition == null || typeDefinition.containsKey(conceptShortName)) continue;
                    typeDefinition.put(conceptShortName, new TypeDefinition(cells.subList(2, cells.size())));
                    continue;
                }
                if (Character.isUpperCase(cells.get(1).charAt(1))) {
                    conceptName = cells.get(1).substring(1);
                    conceptShortName = DeterminantValueSet.getShortName(conceptName);
                    String superTypeName = cells.get(2);
                    if (typeDefinition == null || typeDefinition.containsKey(conceptShortName)) continue;
                    if (cells.size() > 3) {
                        typeDefinition.put(conceptShortName, new TypeDefinition(conceptName, cells.get(2), cells.subList(3, cells.size())));
                        continue;
                    }
                    typeDefinition.put(conceptShortName, new TypeDefinition(conceptName, cells.get(2), new ArrayList<String>()));
                    continue;
                }
                if (cells.size() <= 3) continue;
                System.err.println("Unrecognized rule initialization: " + cells);
            }
            allCells = ioUtil.getRuleCells();
            ruleType = FastRuleFactory.getRuleType(ioUtil);
            concatenated = ioUtil.getConcatenatedRuleStr();
        }
        for (ArrayList<String> cells : allCells) {
            String conceptName;
            ArrayList<String> featureValues = new ArrayList<String>();
            logger.finest("Add rule: " + cells);
            int id = Integer.parseInt(cells.get(0));
            String rule = cells.get(1);
            double score = 0.0;
            DeterminantValueSet.Determinants determinant = DeterminantValueSet.Determinants.ACTUAL;
            boolean scoreSet = false;
            if (cells.size() < 3) {
                logger.info("Rule format error: " + cells + ". Will skip it.");
                continue;
            }
            if (cells.size() < 4) {
                conceptName = cells.get(2).trim();
                determinant = DeterminantValueSet.Determinants.ACTUAL;
            } else {
                int featureCellBegin = 5;
                if (UnicodeChecker.isNumber(cells.get(2))) {
                    conceptName = cells.get(3).trim();
                    score = Double.parseDouble(cells.get(2));
                    scoreSet = true;
                    if (cells.size() > 4 && cells.get(4).trim().length() > 0) {
                        determinant = DeterminantValueSet.Determinants.valueOf(cells.get(4));
                    }
                } else {
                    conceptName = cells.get(2).trim();
                    if (cells.size() > 3 && cells.get(3).trim().length() > 0) {
                        determinant = DeterminantValueSet.Determinants.valueOf(cells.get(3));
                    }
                    featureCellBegin = 4;
                }
                if (cells.size() > featureCellBegin) {
                    for (String featureName : typeDefinition.get(conceptName).getFeatureValuePairs().keySet()) {
                        featureValues.add(cells.get(featureCellBegin));
                        if (++featureCellBegin < cells.size()) continue;
                        break;
                    }
                }
            }
            String conceptShortName = DeterminantValueSet.getShortName(conceptName);
            if (typeDefinition != null && !typeDefinition.containsKey(conceptName)) {
                typeDefinition.put(conceptShortName, new TypeDefinition(conceptName, DeterminantValueSet.defaultSuperTypeName, new ArrayList<String>()));
            }
            if (!scoreSet && determinant == DeterminantValueSet.Determinants.PSEUDO) {
                score = 1.0;
            }
            if (!constructRuleMap) continue;
            if (featureValues.size() > 0) {
                String[] featureValuesArray = new String[featureValues.size()];
                featureValuesArray = featureValues.toArray(featureValuesArray);
                rules.put(id, new NERRule(id, caseSensitive ? rule : rule.toLowerCase(), conceptName, score, determinant, featureValuesArray));
                continue;
            }
            rules.put(id, new NERRule(id, caseSensitive ? rule : rule.toLowerCase(), conceptName, score, determinant, new String[0]));
        }
        output[0] = rules;
        output[1] = ruleType;
        output[2] = concatenated;
        return output;
    }

    public static FastRule createFastRule(String ruleStr, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean constructRuleMap) {
        boolean supportReplication;
        FastRuleWOG fastRule = null;
        Object[] output = FastRuleFactory.buildRuleStore(ruleStr, typeDefinition, caseSensitive, constructRuleMap);
        String ruleType = (String)output[1];
        String concatenated = (String)output[2];
        boolean bl = supportReplication = concatenated.indexOf("+") != -1;
        if (constructRuleMap) {
            HashMap rules = (HashMap)output[0];
            switch (ruleType) {
                case "FastCRuleCN": {
                    fastRule = new FastCRuleCN(rules);
                    ((FastCRule)fastRule).setReplicationSupport(supportReplication);
                    break;
                }
                case "FastCRuleSB": {
                    fastRule = new FastCRuleSB(rules);
                    ((FastCRule)fastRule).setReplicationSupport(supportReplication);
                    break;
                }
                case "FastCRule": {
                    fastRule = new FastCRule(rules);
                    ((FastCRule)fastRule).setReplicationSupport(supportReplication);
                    break;
                }
                case "FastRuleWGN": {
                    fastRule = new FastRuleWGN(rules);
                    break;
                }
                case "FastRuleWG": {
                    fastRule = new FastRuleWG(rules);
                    break;
                }
                default: {
                    fastRule = new FastRuleWOG(rules);
                }
            }
        }
        return fastRule;
    }

    @Deprecated
    public static FastRule createFastRule(Class fastNER, String ruleStr, LinkedHashMap<String, TypeDefinition> typeDefinition, String splitter, boolean caseSensitive, boolean constructRuleMap) {
        FastRuleWOG fastRule = null;
        int strLength = ruleStr.trim().length();
        String testFileStr = ruleStr.trim().substring(strLength - 4).toLowerCase();
        HashMap<Integer, Rule> rules = new HashMap<Integer, Rule>();
        boolean[] thisRuleType = new boolean[]{false, false, false, false, false, false};
        thisRuleType = testFileStr.equals(".tsv") || testFileStr.equals(".csv") || testFileStr.equals("xlsx") || testFileStr.equals(".owl") ? IOUtil.readAgnosticFile(ruleStr, rules, typeDefinition, caseSensitive, thisRuleType) : IOUtil.readCSVString(ruleStr, rules, typeDefinition, splitter, caseSensitive, thisRuleType);
        if (constructRuleMap) {
            if (thisRuleType[0] || fastNER == FastCNER.class) {
                fastRule = thisRuleType[5] ? new FastCRuleCN(rules) : (thisRuleType[2] ? new FastCRuleSB(rules) : new FastCRule(rules));
                if (thisRuleType[3]) {
                    ((FastCRule)fastRule).setReplicationSupport(true);
                }
            } else {
                fastRule = thisRuleType[4] ? new FastRuleWGN(rules) : (thisRuleType[1] ? new FastRuleWG(rules) : new FastRuleWOG(rules));
            }
        }
        return fastRule;
    }

    private static String getRuleType(String concatenated) {
        String ruleType = "";
        for (char ch : concatenated.toCharArray()) {
            if (Character.UnicodeScript.of(ch) != Character.UnicodeScript.HAN) continue;
            ruleType = "FastCRuleCN";
            break;
        }
        if (ruleType.length() == 0) {
            ruleType = concatenated.indexOf("[") != -1 && concatenated.indexOf("]") != -1 ? "FastCRuleSB" : (concatenated.indexOf("\\a") != -1 || concatenated.indexOf("\\d") != -1 || concatenated.indexOf("\\s") != -1 ? "FastCRule" : (concatenated.indexOf("\\>") != -1 || concatenated.indexOf("\\<") != -1 ? "FastRuleWGN" : (concatenated.indexOf("(") != -1 || concatenated.indexOf(")") != -1 ? "FastRuleWG" : "FastRuleWOG")));
        }
        return ruleType;
    }

    private static String getRuleType(edu.utah.bmi.nlp.core.IOUtil ioUtil) {
        String ruleType = "";
        String concatenated = ioUtil.getConcatenatedRuleStr();
        ruleType = ioUtil.settings.containsKey("fastcnercn") ? "FastCRuleCN" : (ioUtil.settings.containsKey("fastcner") ? (concatenated.indexOf("[") != -1 && concatenated.indexOf("]") != -1 ? "FastCRuleSB" : "FastCRule") : (ioUtil.settings.containsKey("fastner") ? (concatenated.indexOf("\\>") != -1 || concatenated.indexOf("\\<") != -1 ? "FastRuleWGN" : (concatenated.indexOf("(") != -1 || concatenated.indexOf(")") != -1 ? "FastRuleWG" : "FastRuleWOG")) : FastRuleFactory.getRuleType(concatenated)));
        return ruleType;
    }
}

