/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner;

import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.NERSpan;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.fastcner.UnicodeChecker;
import edu.utah.bmi.nlp.fastner.FastRuleWOG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.logging.Level;

public class FastRuleWG
extends FastRuleWOG {
    protected HashMap<String, IntervalST> overlapCheckers = new HashMap();

    public FastRuleWG() {
    }

    public FastRuleWG(String ruleStr) {
        super(ruleStr);
    }

    public FastRuleWG(String ruleStr, boolean caseSensitive) {
        super(ruleStr, caseSensitive);
    }

    public FastRuleWG(HashMap<Integer, Rule> ruleStore) {
        super(ruleStore);
    }

    @Override
    protected void process(ArrayList<?> contextTokens, BiFunction<ArrayList, Integer, String> getText, BiFunction<ArrayList, Integer, Integer> getBegin, BiFunction<ArrayList, Integer, Integer> getEnd, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches) {
        if (currentPosition < contextTokens.size()) {
            String thisToken = getText.apply(contextTokens, currentPosition);
            if (rule.containsKey("\\w+")) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\w+"), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey((Object)this.END)) {
                this.addDeterminants(rule, matches, getBegin.apply(contextTokens, matchBegin), getEnd.apply(contextTokens, matchEnd == -1 ? currentPosition - 1 : matchEnd));
            }
            if (rule.containsKey(thisToken)) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get(thisToken), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey("\\d+") && UnicodeChecker.isNumber(thisToken)) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\d+"), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey("\\(")) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\("), currentPosition, matchEnd, currentPosition, matches);
            }
            if (rule.containsKey("\\)")) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\)"), matchBegin, currentPosition - 1, currentPosition, matches);
            }
        } else if (currentPosition == contextTokens.size() && rule.containsKey((Object)this.END)) {
            matchEnd = matchEnd == -1 ? currentPosition - 1 : matchEnd;
            this.addDeterminants(rule, matches, getBegin.apply(contextTokens, matchBegin), getEnd.apply(contextTokens, matchEnd));
        }
    }

    @Override
    protected void addDeterminants(HashMap rule, HashMap<String, ArrayList<Span>> matches, int matchBegin, int matchEnd) {
        HashMap deterRule = (HashMap)rule.get((Object)this.END);
        for (Object key : deterRule.keySet()) {
            IntervalST<Integer> overlapChecker;
            ArrayList<Object> currentSpanList;
            int ruleId = (Integer)deterRule.get(key);
            boolean contain = this.ruleLengths.containsKey(ruleId);
            contain = this.ruleStore.containsKey(ruleId);
            NERSpan currentSpan = new NERSpan(matchBegin, matchEnd, ruleId, (Integer)this.ruleLengths.get(ruleId), ((Rule)this.ruleStore.get((Object)Integer.valueOf((int)ruleId))).score, "");
            currentSpan.setCompareMethod(this.spanCompareMethod);
            currentSpan.setWidthCompareMethod(this.widthCompareMethod);
            logger.finest(this.getRule(currentSpan.ruleId).toString());
            if (matches.containsKey((String)key)) {
                currentSpanList = matches.get((String)key);
                overlapChecker = this.overlapCheckers.get(key);
                Object overlappedPos = overlapChecker.get(new Interval1D(currentSpan.begin, currentSpan.end - 1));
                if (overlappedPos != null) {
                    int pos = (Integer)overlappedPos;
                    Span overlappedSpan = (Span)currentSpanList.get(pos);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("\t\tOverlapped with: " + overlappedSpan.begin + ", " + overlappedSpan.end + "\t");
                    }
                    if (currentSpan.compareTo((NERSpan)overlappedSpan) <= 0) {
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest("\t\tSkip this span ...");
                        continue;
                    }
                    currentSpanList.set(pos, currentSpan);
                    overlapChecker.remove(new Interval1D(overlappedSpan.begin, overlappedSpan.end - 1));
                    overlapChecker.put(new Interval1D(currentSpan.begin, currentSpan.end - 1), pos);
                } else {
                    overlapChecker.put(new Interval1D(currentSpan.begin, currentSpan.end - 1), currentSpanList.size());
                    currentSpanList.add(currentSpan);
                }
            } else {
                currentSpanList = new ArrayList<NERSpan>();
                currentSpanList.add(currentSpan);
                overlapChecker = new IntervalST<Integer>();
                overlapChecker.put(new Interval1D(currentSpan.begin, currentSpan.end - 1), 0);
                this.overlapCheckers.put((String)key, overlapChecker);
            }
            matches.put((String)key, currentSpanList);
        }
    }
}

