/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner;

import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.fastcner.UnicodeChecker;
import edu.utah.bmi.nlp.fastner.FastRuleWG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiFunction;
import org.apache.commons.lang3.math.NumberUtils;

public class FastRuleWGN
extends FastRuleWG {
    public FastRuleWGN() {
    }

    public FastRuleWGN(String ruleStr) {
        super(ruleStr);
    }

    public FastRuleWGN(String ruleStr, boolean caseSensitive) {
        super(ruleStr, caseSensitive);
    }

    public FastRuleWGN(HashMap<Integer, Rule> ruleStore) {
        super(ruleStore);
    }

    @Override
    protected void process(ArrayList<?> contextTokens, BiFunction<ArrayList, Integer, String> getText, BiFunction<ArrayList, Integer, Integer> getBegin, BiFunction<ArrayList, Integer, Integer> getEnd, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches) {
        if (currentPosition < contextTokens.size()) {
            String thisToken = getText.apply(contextTokens, currentPosition);
            if (rule.containsKey("\\w+")) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\w+"), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey((Object)this.END)) {
                this.addDeterminants(rule, matches, getBegin.apply(contextTokens, matchBegin), getEnd.apply(contextTokens, matchEnd == -1 ? currentPosition - 1 : matchEnd));
            }
            if (rule.containsKey(thisToken)) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get(thisToken), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey("\\d+") && UnicodeChecker.isNumber(thisToken)) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\d+"), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey("\\(")) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\("), currentPosition, matchEnd, currentPosition, matches);
            }
            if (rule.containsKey("\\)")) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\)"), matchBegin, currentPosition - 1, currentPosition, matches);
            }
            if (rule.containsKey("\\>") && UnicodeChecker.isNumber(thisToken)) {
                this.processNumerics(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\>"), matchBegin, matchEnd, currentPosition, matches, thisToken, true);
            }
            if (rule.containsKey("\\<") && UnicodeChecker.isNumber(thisToken)) {
                this.processNumerics(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\<"), matchBegin, matchEnd, currentPosition, matches, thisToken, false);
            }
        } else if (currentPosition == contextTokens.size() && rule.containsKey((Object)this.END)) {
            matchEnd = matchEnd == -1 ? currentPosition - 1 : matchEnd;
            this.addDeterminants(rule, matches, getBegin.apply(contextTokens, matchBegin), getEnd.apply(contextTokens, matchEnd));
        }
    }

    protected void processNumerics(ArrayList<?> contextTokens, BiFunction<ArrayList, Integer, String> getText, BiFunction<ArrayList, Integer, Integer> getBegin, BiFunction<ArrayList, Integer, Integer> getEnd, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches, String numericToken, boolean greaterThan) {
        Double num = NumberUtils.createDouble(numericToken.trim());
        for (Object ruleValue : rule.keySet()) {
            Double ruleNumValue = NumberUtils.createDouble((String)ruleValue);
            if (greaterThan && num > ruleNumValue) {
                if (((HashMap)rule.get(ruleValue)).containsKey("\\<")) {
                    this.processNumerics(contextTokens, getText, getBegin, getEnd, (HashMap)((HashMap)rule.get(ruleValue)).get("\\<"), matchBegin, matchEnd, currentPosition, matches, numericToken, false);
                }
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get(ruleValue), matchBegin, matchEnd, currentPosition + 1, matches);
                continue;
            }
            if (greaterThan || !(num < ruleNumValue)) continue;
            if (((HashMap)rule.get(ruleValue)).containsKey("\\>")) {
                this.processNumerics(contextTokens, getText, getBegin, getEnd, (HashMap)((HashMap)rule.get(ruleValue)).get("\\>"), matchBegin, matchEnd, currentPosition, matches, numericToken, true);
            }
            this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get(ruleValue), matchBegin, matchEnd, currentPosition + 1, matches);
        }
    }
}

