/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner;

import edu.utah.bmi.nlp.core.NERSpan;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.fastcner.UnicodeChecker;
import edu.utah.bmi.nlp.fastner.FastRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiFunction;

public class FastRuleWOG
extends FastRule {
    protected HashMap<Integer, Integer> ruleLengths = new HashMap();
    protected String spanCompareMethod = "scorewidth";
    protected String widthCompareMethod = "ruleLength";

    public FastRuleWOG() {
    }

    public FastRuleWOG(String ruleStr) {
        this.initiate(ruleStr, false);
    }

    public FastRuleWOG(String ruleStr, boolean caseSensitive) {
        this.initiate(ruleStr, caseSensitive);
    }

    public FastRuleWOG(HashMap<Integer, Rule> ruleStore) {
        this.initiate(ruleStore);
    }

    public void setCompareMethod(String method) {
        this.spanCompareMethod = method;
    }

    public void setWidthCompareMethod(String widthCompareMethod) {
        this.widthCompareMethod = widthCompareMethod;
    }

    @Override
    protected boolean addRule(Rule rule) {
        int i;
        ArrayList<HashMap> rules_tmp = new ArrayList<HashMap>();
        HashMap rule1 = this.rulesMap;
        HashMap<Object, Object> rule2 = new HashMap<Object, Object>();
        String[] ruleContent = rule.rule.split("\\s+");
        this.ruleLengths.put(rule.id, ruleContent.length);
        int length = ruleContent.length;
        rules_tmp.add(this.rulesMap);
        for (i = 0; i < length && rule1 != null && rule1.containsKey(ruleContent[i]); rule1 = (HashMap)rule1.get(ruleContent[i]), ++i) {
        }
        if (i > length) {
            return false;
        }
        if (i == length) {
            if (rule1.containsKey((Object)this.END)) {
                ((HashMap)rule1.get((Object)this.END)).put(rule.ruleName, rule.id);
            } else {
                rule2.put(rule.ruleName, rule.id);
                rule1.put(this.END, rule2.clone());
            }
            return true;
        }
        rule2.put(rule.ruleName, rule.id);
        rule2.put((Object)this.END, rule2.clone());
        rule2.remove(rule.ruleName);
        for (int j = length - 1; j > i; --j) {
            HashMap rule_t = (HashMap)rule2.clone();
            rule2.clear();
            rule2.put(ruleContent[j], rule_t);
        }
        rule1.put(ruleContent[i], rule2.clone());
        return true;
    }

    @Override
    public HashMap<String, ArrayList<Span>> processTokens(ArrayList<String> contextTokens) {
        HashMap<String, ArrayList<Span>> matches = new HashMap<String, ArrayList<Span>>();
        for (int i = 0; i < contextTokens.size(); ++i) {
            this.processTokens(contextTokens, this.rulesMap, i, -1, i, matches);
        }
        if (this.removePseudo) {
            this.removePseudoMatches(matches);
        }
        return matches;
    }

    protected void processTokens(ArrayList<String> contextTokens, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches) {
        this.process(contextTokens, this.getStringText, this.getBeginId, this.getEndId, rule, matchBegin, matchEnd, currentPosition, matches);
    }

    @Override
    public HashMap<String, ArrayList<Span>> processSpans(ArrayList<Span> contextTokens) {
        HashMap<String, ArrayList<Span>> matches = new HashMap<String, ArrayList<Span>>();
        for (int i = 0; i < contextTokens.size(); ++i) {
            this.processSpans(contextTokens, this.rulesMap, i, -1, i, matches);
        }
        if (this.removePseudo) {
            this.removePseudoMatches(matches);
        }
        return matches;
    }

    protected void processSpans(ArrayList<Span> contextTokens, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches) {
        this.process(contextTokens, this.getSpanText, this.getSpanBegin, this.getSpanEnd, rule, matchBegin, matchEnd, currentPosition, matches);
    }

    protected void process(ArrayList<?> contextTokens, BiFunction<ArrayList, Integer, String> getText, BiFunction<ArrayList, Integer, Integer> getBegin, BiFunction<ArrayList, Integer, Integer> getEnd, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<String, ArrayList<Span>> matches) {
        if (currentPosition < contextTokens.size()) {
            String thisToken = getText.apply(contextTokens, currentPosition);
            if (rule.containsKey("\\w+")) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\w+"), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey((Object)this.END)) {
                this.addDeterminants(rule, matches, getBegin.apply(contextTokens, matchBegin), getEnd.apply(contextTokens, matchEnd == -1 ? currentPosition - 1 : matchEnd));
            }
            if (rule.containsKey(thisToken)) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get(thisToken), matchBegin, matchEnd, currentPosition + 1, matches);
            }
            if (rule.containsKey("\\d+") && UnicodeChecker.isNumber(thisToken)) {
                this.process(contextTokens, getText, getBegin, getEnd, (HashMap)rule.get("\\d+"), matchBegin, matchEnd, currentPosition + 1, matches);
            }
        } else if (currentPosition == contextTokens.size() && rule.containsKey((Object)this.END)) {
            matchEnd = matchEnd == -1 ? currentPosition - 1 : matchEnd;
            this.addDeterminants(rule, matches, getBegin.apply(contextTokens, matchBegin), getEnd.apply(contextTokens, matchEnd));
        }
    }

    protected void addDeterminants(HashMap rule, HashMap<String, ArrayList<Span>> matches, int matchBegin, int matchEnd) {
        HashMap deterRule = (HashMap)rule.get((Object)this.END);
        for (Object key : deterRule.keySet()) {
            ArrayList<Object> currentSpanList;
            int ruleId = (Integer)deterRule.get(key);
            boolean contain = this.ruleLengths.containsKey(ruleId);
            contain = this.ruleStore.containsKey(ruleId);
            NERSpan currentSpan = new NERSpan(matchBegin, matchEnd, ruleId, this.ruleLengths.get(ruleId), ((Rule)this.ruleStore.get((Object)Integer.valueOf((int)ruleId))).score, "");
            currentSpan.setCompareMethod(this.spanCompareMethod);
            currentSpan.setWidthCompareMethod(this.widthCompareMethod);
            logger.finest(this.getRule(currentSpan.ruleId).toString());
            if (matches.containsKey((String)key)) {
                currentSpanList = matches.get((String)key);
                Span lastSpan = (Span)currentSpanList.get(currentSpanList.size() - 1);
                if (currentSpan.end < lastSpan.end) continue;
                if (lastSpan.end > currentSpan.begin) {
                    if (currentSpan.compareTo((NERSpan)lastSpan) <= 0) continue;
                    currentSpanList.remove(currentSpanList.size() - 1);
                }
                currentSpanList.add(currentSpan);
            } else {
                currentSpanList = new ArrayList<NERSpan>();
                currentSpanList.add(currentSpan);
            }
            matches.put((String)key, currentSpanList);
        }
    }
}

