/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner;

import edu.utah.blulab.domainontology.Anchor;
import edu.utah.blulab.domainontology.DomainOntology;
import edu.utah.blulab.domainontology.LogicExpression;
import edu.utah.blulab.domainontology.Variable;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.NERRule;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.fastcner.UnicodeChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@Deprecated
public class IOUtil {
    public static Logger logger = edu.utah.bmi.nlp.core.IOUtil.getLogger(IOUtil.class);

    @Deprecated
    public static HashMap<Integer, Rule> parseRuleStr(String ruleStr, String splitter, boolean caseSensitive) {
        HashMap<Integer, Rule> rules = new HashMap<Integer, Rule>();
        int strLength = ruleStr.trim().length();
        String testFileStr = ruleStr.trim().substring(strLength - 4).toLowerCase();
        boolean[] thisRuleType = new boolean[]{false, false, false};
        LinkedHashMap<String, TypeDefinition> typeDefinition = new LinkedHashMap<String, TypeDefinition>();
        thisRuleType = testFileStr.equals(".tsv") || testFileStr.equals(".csv") || testFileStr.equals("xlsx") || testFileStr.equals(".owl") ? IOUtil.readAgnosticFile(ruleStr, rules, typeDefinition, caseSensitive) : IOUtil.readCSVString(ruleStr, rules, typeDefinition, splitter, caseSensitive, thisRuleType);
        return rules;
    }

    public static boolean[] readOwlFile(String owlFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] ruleSupports) {
        boolean ruleType = false;
        int id = 0;
        try {
            DomainOntology domain = new DomainOntology(owlFileName, true);
            ArrayList<Variable> domainVariables = domain.getAllEvents();
            for (Variable var : domainVariables) {
                ArrayList<LogicExpression<Anchor>> logicExpressions = var.getAnchor();
                for (LogicExpression<Anchor> logicExpression : logicExpressions) {
                    if (logicExpression.isSingleExpression()) {
                        for (Anchor term : logicExpression) {
                            String preferredTerm = term.getPrefTerm();
                            if (preferredTerm == null || preferredTerm.trim().length() == 0) {
                                System.err.println("Error in owl file at: " + logicExpression.toString());
                                continue;
                            }
                            String nameEntityClass = term.getSemanticType().get(0);
                            nameEntityClass = nameEntityClass.replaceAll(" +", "_").toUpperCase();
                            ruleSupports = IOUtil.addRule(rules, typeDefinition, new NERRule(++id, caseSensitive ? preferredTerm : preferredTerm.toLowerCase(), nameEntityClass, 0.0, DeterminantValueSet.Determinants.ACTUAL, new String[0]), ruleSupports);
                            if (term.getSynonym().size() > 0) {
                                for (String s2 : term.getSynonym()) {
                                    ruleSupports = IOUtil.addRule(rules, typeDefinition, new NERRule(++id, caseSensitive ? s2 : s2.toLowerCase(), nameEntityClass, 0.0, DeterminantValueSet.Determinants.ACTUAL, new String[0]), ruleSupports);
                                }
                            }
                            if (term.getAbbreviation().size() > 0) {
                                for (String s2 : term.getAbbreviation()) {
                                    ruleSupports = IOUtil.addRule(rules, typeDefinition, new NERRule(++id, caseSensitive ? s2 : s2.toLowerCase(), nameEntityClass, 0.0, DeterminantValueSet.Determinants.ACTUAL, new String[0]), ruleSupports);
                                }
                            }
                            if (term.getMisspelling().size() > 0) {
                                for (String s2 : term.getMisspelling()) {
                                    ruleSupports = IOUtil.addRule(rules, typeDefinition, new NERRule(++id, caseSensitive ? s2 : s2.toLowerCase(), nameEntityClass, 0.0, DeterminantValueSet.Determinants.ACTUAL, new String[0]), ruleSupports);
                                }
                            }
                            if (term.getPseudos().size() <= 0) continue;
                            for (String s2 : term.getMisspelling()) {
                                ruleSupports = IOUtil.addRule(rules, typeDefinition, new NERRule(++id, caseSensitive ? s2 : s2.toLowerCase(), nameEntityClass, 0.0, DeterminantValueSet.Determinants.PSEUDO, new String[0]), ruleSupports);
                            }
                        }
                        continue;
                    }
                    logger.info("Current FastRule does not support complex NER:\n\t" + logicExpression);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ruleSupports;
    }

    public static boolean[] readOwlDirectory(String owlFileDirectory, HashMap<Integer, Rule> rules, boolean caseSensitive) {
        Collection<File> files = FileUtils.listFiles(new File(owlFileDirectory), new String[]{"owl"}, true);
        LinkedHashMap<String, TypeDefinition> typeDefinition = new LinkedHashMap<String, TypeDefinition>();
        boolean[] thisRuleType = new boolean[]{false, false, false};
        for (File file : files) {
            thisRuleType = IOUtil.readOwlFile(file.getAbsolutePath(), rules, typeDefinition, caseSensitive, thisRuleType);
        }
        return thisRuleType;
    }

    public static boolean[] readAgnosticFile(String agnosticFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive) {
        boolean[] thisRuleType = new boolean[]{false, false, false, false, false, false};
        IOUtil.readAgnosticFile(agnosticFileName, rules, typeDefinition, caseSensitive, thisRuleType);
        return thisRuleType;
    }

    public static boolean[] readAgnosticFile(String agnosticFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] thisRuleType) {
        File agnosticFile = new File(agnosticFileName);
        if (agnosticFile.exists()) {
            if (agnosticFile.isDirectory()) {
                thisRuleType = IOUtil.readOwlDirectory(agnosticFileName, rules, caseSensitive);
            } else if (FilenameUtils.getExtension(agnosticFileName).equals("owl")) {
                thisRuleType = IOUtil.readOwlFile(agnosticFileName, rules, typeDefinition, caseSensitive, thisRuleType);
            } else if (FilenameUtils.getExtension(agnosticFileName).equals("xlsx")) {
                thisRuleType = IOUtil.readXLSXRuleFile(agnosticFileName, rules, typeDefinition, caseSensitive, thisRuleType);
            } else if (FilenameUtils.getExtension(agnosticFileName).equals("csv")) {
                thisRuleType = IOUtil.readCSVFile(agnosticFileName, rules, typeDefinition, CSVFormat.DEFAULT, caseSensitive, thisRuleType);
            } else if (FilenameUtils.getExtension(agnosticFileName).equals("tsv")) {
                thisRuleType = IOUtil.readCSVFile(agnosticFileName, rules, typeDefinition, CSVFormat.TDF, caseSensitive, thisRuleType);
            }
        }
        return thisRuleType;
    }

    public static boolean[] readXLSXRuleFile(String xlsxFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] ruleSupports) {
        try {
            FileInputStream inputStream = new FileInputStream(new File(xlsxFileName));
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            Sheet firstSheet = workbook.getSheetAt(0);
            Iterator iterator2 = firstSheet.iterator();
            int id = 0;
            while (iterator2.hasNext()) {
                Row nextRow = (Row)iterator2.next();
                Iterator<Cell> cellIterator = nextRow.cellIterator();
                ArrayList<String> cells = new ArrayList<String>();
                while (cellIterator.hasNext()) {
                    Cell cell = cellIterator.next();
                    cell.setCellType(CellType.STRING);
                    cells.add(cell.getStringCellValue());
                }
                if (cells.size() > 0) {
                    ruleSupports = IOUtil.parseCells(cells, id, rules, typeDefinition, caseSensitive, ruleSupports);
                }
                ++id;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ruleSupports;
    }

    public static boolean[] readCSVFile(String csvFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, CSVFormat csvFormat, boolean caseSensitive, boolean[] ruleSupports) {
        try {
            CSVParser recordsIterator = CSVParser.parse(new File(csvFileName), StandardCharsets.UTF_8, csvFormat);
            ruleSupports = IOUtil.readCSV(recordsIterator, rules, typeDefinition, caseSensitive, ruleSupports);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ruleSupports;
    }

    public static boolean[] readCSVString(String csvString, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, String splitter, boolean caseSensitive, boolean[] ruleSupports) {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        if (splitter.equals("\t")) {
            csvFormat = CSVFormat.TDF;
        }
        ruleSupports = IOUtil.readCSVString(csvString, rules, typeDefinition, csvFormat, caseSensitive, ruleSupports);
        return ruleSupports;
    }

    public static boolean[] readCSVString(String csvString, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, CSVFormat csvFormat, boolean caseSensitive, boolean[] ruleSupports) {
        try {
            CSVParser recordsIterator = CSVParser.parse(csvString, csvFormat);
            ruleSupports = IOUtil.readCSV(recordsIterator, rules, typeDefinition, caseSensitive, ruleSupports);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ruleSupports;
    }

    private static boolean[] readCSV(Iterable<CSVRecord> recordsIterator, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] ruleSupports) {
        int id = 0;
        for (CSVRecord record : recordsIterator) {
            ArrayList<String> cells = new ArrayList<String>();
            for (String cell : record) {
                cells.add(cell);
            }
            if (!(((String)cells.get(0)).startsWith("@") || ((String)cells.get(0)).startsWith("&") || cells.size() <= 1 || UnicodeChecker.isNumber(cells.get(1)))) {
                cells.add(1, "1");
            }
            ruleSupports = IOUtil.parseCells(cells, id, rules, typeDefinition, caseSensitive, ruleSupports);
            ++id;
        }
        return ruleSupports;
    }

    private static boolean[] parseCells(ArrayList<String> cells, int id, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] ruleSupports) {
        if (cells.get(0).startsWith("#") || cells.get(0).trim().length() == 0) {
            return ruleSupports;
        }
        if (cells.get(0).startsWith("@") || cells.get(0).startsWith("&")) {
            if (cells.size() == 1) {
                ruleSupports = IOUtil.checkFastCRule(cells.get(0));
            } else if (cells.size() > 1) {
                cells.set(0, cells.get(0).substring(1));
                typeDefinition.put(IOUtil.getShortName(cells.get(0)), new TypeDefinition(cells));
            }
            return ruleSupports;
        }
        if (cells.size() >= 2) {
            String rule = cells.get(0);
            if (UnicodeChecker.isNumber(cells.get(1))) {
                String conceptShortName = IOUtil.getShortName(cells.get(2).trim());
                if (!typeDefinition.containsKey(conceptShortName)) {
                    typeDefinition.put(conceptShortName, new TypeDefinition(cells.get(2).trim(), DeterminantValueSet.defaultSuperTypeName, new ArrayList<String>()));
                }
                ruleSupports = IOUtil.addRule(rules, typeDefinition, new NERRule(id, caseSensitive ? rule : rule.toLowerCase(), cells.get(2).trim(), Double.parseDouble(cells.get(1)), cells.size() > 3 ? DeterminantValueSet.Determinants.valueOf(cells.get(3)) : DeterminantValueSet.Determinants.ACTUAL, new String[0]), ruleSupports);
            } else {
                String conceptShortName = IOUtil.getShortName(cells.get(1).trim());
                if (!typeDefinition.containsKey(conceptShortName)) {
                    typeDefinition.put(conceptShortName, new TypeDefinition(cells.get(1).trim(), DeterminantValueSet.defaultSuperTypeName, new ArrayList<String>()));
                }
                ruleSupports = IOUtil.addRule(rules, typeDefinition, new NERRule(id, caseSensitive ? rule : rule.toLowerCase(), cells.get(1).trim(), 0.0, cells.size() > 2 ? DeterminantValueSet.Determinants.valueOf(cells.get(2)) : DeterminantValueSet.Determinants.ACTUAL, new String[0]), ruleSupports);
            }
        } else {
            logger.info("Definition format error: line " + id + "\t\t" + cells);
        }
        return ruleSupports;
    }

    public static HashMap<Integer, NERRule> readCRuleString(String ruleString, String splitter) {
        int id = 0;
        HashMap<Integer, NERRule> rules = new HashMap<Integer, NERRule>();
        for (String rule : ruleString.split("\n")) {
            rule = rule.trim();
            ++id;
            if (rule.length() < 1 || rule.startsWith("#")) continue;
            String[] definition = rule.split(splitter);
            DeterminantValueSet.Determinants determinant = DeterminantValueSet.Determinants.ACTUAL;
            if (definition.length > 3) {
                determinant = DeterminantValueSet.Determinants.valueOf(definition[3]);
            }
            if (definition.length > 2) {
                definition[2] = DeterminantValueSet.checkNameSpace(definition[2]);
            } else if (!rule.trim().startsWith("#")) {
                logger.info("Definition format error: line " + id + "\t\t" + rule);
                continue;
            }
            rules.put(id, new NERRule(id, definition[0], definition[2].trim(), Double.parseDouble(definition[1]), determinant, new String[0]));
        }
        return rules;
    }

    private static boolean[] addRule(HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, NERRule rule, boolean[] ruleSupports) {
        if (!ruleSupports[1] && rule.rule.indexOf("(") != -1) {
            ruleSupports[1] = true;
        }
        if (!ruleSupports[2] && rule.rule.indexOf("[") != -1) {
            ruleSupports[2] = true;
        }
        if (!ruleSupports[3] && rule.rule.indexOf("+") != -1) {
            ruleSupports[3] = true;
        }
        if (!(ruleSupports[4] || rule.rule.indexOf("\\>") == -1 && rule.rule.indexOf("\\<") == -1)) {
            ruleSupports[4] = true;
        }
        if (!ruleSupports[5] && UnicodeChecker.isChinese(rule.rule.toCharArray()[0])) {
            ruleSupports[5] = true;
        }
        rules.put(rule.id, rule);
        return ruleSupports;
    }

    private static boolean[] checkFastCRule(String ruleString) {
        int begin = ruleString.indexOf("@");
        if (begin == -1) {
            begin = ruleString.indexOf("&");
        }
        int end = ruleString.indexOf("\n", begin);
        boolean[] ruleSupports = new boolean[]{false, false, false, false, false, false};
        String definition = ruleString.substring(begin, end == -1 ? ruleString.length() : end).toLowerCase();
        if (definition.indexOf("fastcnercn") != -1) {
            ruleSupports[5] = true;
        } else if (definition.indexOf("fastcner") != -1) {
            ruleSupports[0] = true;
        }
        return ruleSupports;
    }

    private static String getShortName(String fullName) {
        int dot = fullName.lastIndexOf(".");
        if (dot != -1) {
            fullName = fullName.substring(dot + 1);
        }
        return fullName;
    }
}

