/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.fastner.uima;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.NERRule;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.SimpleParser;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.fastner.FastNER;
import edu.utah.bmi.nlp.type.system.Concept;
import edu.utah.bmi.nlp.type.system.ConceptBASE;
import edu.utah.bmi.nlp.type.system.OutsideScopeConcept;
import edu.utah.bmi.nlp.type.system.PseudoConcept;
import edu.utah.bmi.nlp.type.system.SectionBody;
import edu.utah.bmi.nlp.type.system.SectionHeader;
import edu.utah.bmi.nlp.uima.ae.RuleBasedAEInf;
import edu.utah.bmi.nlp.uima.common.AnnotationComparator;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.FSUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class FastNER_AE_General
extends JCasAnnotator_ImplBase
implements RuleBasedAEInf {
    public static Logger logger = IOUtil.getLogger(FastNER_AE_General.class);
    public static final String PARAM_INCLUDE_SECTIONS = "IncludeSections";
    public static final String PARAM_EXCLUDE_SECTIONS = "ExcludeSections";
    public static final String PARAM_ASSIGN_SECTIONS = "AssignSections";
    public static final String PARAM_RULE_STR = "RuleFileOrStr";
    public static final String PARAM_SENTENCE_TYPE_NAME = "SentenceTypeName";
    public static final String PARAM_TOKEN_TYPE_NAME = "TokenTypeName";
    public static final String PARAM_MARK_PSEUDO = "MarkPseudo";
    public static final String PARAM_LOG_RULE_INFO = "LogRuleInfo";
    @Deprecated
    public static final String PARAM_ENABLE_DEBUG = "EnableDebug";
    public static final String PARAM_CASE_SENSITIVE = "CaseSensitive";
    public static final String ADV_PARAM_SPAN_COMPARE_METHOD = "SpanCompareMethod";
    public static final String ADV_PARAM_WIDTH_COMPARE_METHOD = "WidthCompareMethod";
    protected FastNER fastNER;
    protected HashMap<String, Constructor<? extends Annotation>> ConceptTypeClasses = new HashMap();
    protected HashSet<String> includeSections = new HashSet();
    protected HashSet<Class<? extends Annotation>> includeSectionClasses = new LinkedHashSet<Class<? extends Annotation>>();
    protected HashSet<String> excludeSections = new HashSet();
    protected Class<? extends Annotation> SentenceType;
    protected Class<? extends Annotation> TokenType;
    protected Constructor<? extends Annotation> SentenceTypeConstructor;
    protected Constructor<? extends Annotation> TokenTypeConstructor;
    protected HashMap<String, Class<? extends Concept>> ConceptTypes = new HashMap();
    protected HashMap<String, Constructor<? extends Concept>> ConceptTypeConstructors = new HashMap();
    protected LinkedHashMap<String, LinkedHashMap<String, Method>> setMethods = new LinkedHashMap();
    protected boolean markPseudo = false;
    protected boolean logRuleInfo = false;
    protected boolean caseSenstive = true;
    protected boolean forceAssignSections = true;
    protected boolean assignSection = true;
    private String spanCompareMethod = "scorewidth";
    private String widthCompareMethod = "ruleLength";
    @Deprecated
    protected boolean debug = false;

    @Override
    public void initialize(UimaContext cont) {
        String ruleStr = (String)cont.getConfigParameterValue(PARAM_RULE_STR);
        Object obj = cont.getConfigParameterValue(PARAM_SENTENCE_TYPE_NAME);
        String sentenceTypeName = obj == null ? "edu.utah.bmi.nlp.type.system.Sentence" : (String)obj;
        obj = cont.getConfigParameterValue(PARAM_TOKEN_TYPE_NAME);
        String tokenTypeName = obj == null ? "edu.utah.bmi.nlp.type.system.Token" : (String)obj;
        obj = cont.getConfigParameterValue(PARAM_INCLUDE_SECTIONS);
        if (obj != null && ((String)obj).trim().length() > 0) {
            for (String sectionName : ((String)obj).split("[\\|,;]")) {
                sectionName = sectionName.trim();
                this.includeSections.add(DeterminantValueSet.checkNameSpace(sectionName));
                this.includeSectionClasses.add(AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(sectionName)));
            }
        }
        if ((obj = cont.getConfigParameterValue(PARAM_EXCLUDE_SECTIONS)) != null && ((String)obj).trim().length() > 0) {
            for (String sectionName : ((String)obj).split("[\\|,;]")) {
                sectionName = sectionName.trim();
                this.excludeSections.add(DeterminantValueSet.checkNameSpace(sectionName));
            }
        }
        if ((obj = cont.getConfigParameterValue(PARAM_MARK_PSEUDO)) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.markPseudo = true;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_LOG_RULE_INFO)) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.logRuleInfo = true;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_CASE_SENSITIVE)) != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            this.caseSenstive = false;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_ASSIGN_SECTIONS)) != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            this.forceAssignSections = false;
        }
        if ((obj = cont.getConfigParameterValue(ADV_PARAM_SPAN_COMPARE_METHOD)) != null && obj instanceof String) {
            this.spanCompareMethod = (String)obj;
        }
        if ((obj = cont.getConfigParameterValue(ADV_PARAM_WIDTH_COMPARE_METHOD)) != null && obj instanceof String) {
            this.widthCompareMethod = (String)obj;
        }
        if (this.includeSections.size() == 0 && this.excludeSections.size() == 0) {
            this.assignSection = false;
        }
        try {
            this.SentenceType = Class.forName(sentenceTypeName).asSubclass(Annotation.class);
            this.TokenType = Class.forName(tokenTypeName).asSubclass(Annotation.class);
            this.TokenTypeConstructor = this.TokenType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            this.SentenceTypeConstructor = this.SentenceType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            LinkedHashMap<String, TypeDefinition> conceptNames = this.initFastNER(cont, ruleStr);
            for (Map.Entry<String, TypeDefinition> conceptTypeDefPair : conceptNames.entrySet()) {
                String shortTypeName = conceptTypeDefPair.getKey();
                TypeDefinition typeDefinition = conceptTypeDefPair.getValue();
                String fullTypeName = typeDefinition.fullTypeName;
                Class<? extends Annotation> superClass = AnnotationOper.getTypeClass(typeDefinition.getFullSuperTypeName());
                Class<? extends Annotation> conceptTypeClass = AnnotationOper.getTypeClass(fullTypeName);
                if (superClass == null) {
                    logger.warning("Super Class " + DeterminantValueSet.getRealClassTypeName(typeDefinition.getFullSuperTypeName()) + " for class: " + fullTypeName + " has not been loaded.");
                    continue;
                }
                if (conceptTypeClass == null) {
                    logger.warning("Class " + fullTypeName + " has not been loaded.");
                    continue;
                }
                this.ConceptTypes.put(conceptTypeDefPair.getKey(), conceptTypeClass);
                this.ConceptTypeConstructors.put(shortTypeName, this.ConceptTypes.get(shortTypeName).getConstructor(JCas.class, Integer.TYPE, Integer.TYPE));
                this.setMethods.put(shortTypeName, new LinkedHashMap());
                for (String featureName : typeDefinition.getFeatureValuePairs().keySet()) {
                    Method setFeature = AnnotationOper.getDefaultSetMethod(conceptTypeClass, featureName);
                    if (setFeature == null) {
                        logger.warning("Set feature: '" + featureName + "' has not been initiated in type: '" + fullTypeName + "'");
                    }
                    this.setMethods.get(shortTypeName).put(featureName, setFeature);
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("You need to run this AE through AdaptableUIMACPERunner, which can automatically generate unknown Type classes and type descriptors.\n@see nlp-core project: edu.utah.bmi.uima.AdaptableUIMACPERunner");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    protected LinkedHashMap<String, TypeDefinition> initFastNER(UimaContext cont, String ruleStr) {
        this.fastNER = new FastNER(ruleStr, this.caseSenstive);
        if (this.markPseudo) {
            this.fastNER.setRemovePseudo(false);
        }
        this.fastNER.setCompareMethod(this.spanCompareMethod);
        this.fastNER.setWidthCompareMethod(this.widthCompareMethod);
        return this.fastNER.getTypeDefinitions();
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        IntervalST<String> sectionTree = new IntervalST<String>();
        int totalSections = 0;
        if (this.assignSection || this.forceAssignSections) {
            totalSections = this.indexSections(jcas, sectionTree);
        }
        LinkedHashMap sections = new LinkedHashMap();
        ArrayList<Annotation> tokens = new ArrayList<Annotation>();
        AnnotationIndex<? extends Annotation> annoIndex = jcas.getAnnotationIndex(this.SentenceType);
        FSIterator annoIter = annoIndex.iterator();
        int totalSentences = 0;
        while (annoIter.hasNext()) {
            Annotation sentence = (Annotation)annoIter.next();
            ++totalSentences;
            String sectionName = sectionTree.get(new Interval1D(sentence.getBegin(), sentence.getEnd()));
            if (sectionName == null) {
                if (totalSections != 0) continue;
                sectionName = SourceDocumentInformation.class.getSimpleName();
            }
            if (!sections.containsKey(sectionName)) {
                sections.put(sectionName, new ArrayList());
            }
            ((ArrayList)sections.get(sectionName)).add(sentence);
        }
        annoIndex = jcas.getAnnotationIndex(this.TokenType);
        annoIter = annoIndex.iterator();
        while (annoIter.hasNext()) {
            tokens.add((Annotation)annoIter.next());
        }
        if (totalSentences > 0) {
            for (String sectionName : sections.keySet()) {
                Collections.sort((List)sections.get(sectionName), new AnnotationComparator());
                Collections.sort(tokens, new AnnotationComparator());
                TreeMap<Integer, TreeSet<Integer>> sentence2TokenMap = new TreeMap<Integer, TreeSet<Integer>>();
                AnnotationOper.buildAnnoMap((ArrayList)sections.get(sectionName), tokens, sentence2TokenMap);
                for (Map.Entry<Integer, TreeSet<Integer>> sentence : sentence2TokenMap.entrySet()) {
                    int sentenceId = sentence.getKey();
                    TreeSet<Integer> sentenceTokenIds = sentence2TokenMap.get(sentenceId);
                    ArrayList<Annotation> tokensInThisSentence = new ArrayList<Annotation>();
                    for (int tokenId : sentenceTokenIds) {
                        tokensInThisSentence.add(tokens.get(tokenId));
                    }
                    HashMap<String, ArrayList<Span>> concepts = this.fastNER.processAnnotationList(tokensInThisSentence);
                    if (concepts.size() <= 0) continue;
                    this.saveConcepts(jcas, concepts, sectionName);
                }
            }
        } else {
            Collection<SourceDocumentInformation> docAnnotation = JCasUtil.select(jcas, SourceDocumentInformation.class);
            if (docAnnotation != null && docAnnotation.size() > 0) {
                logger.info("Document: " + docAnnotation.iterator().next().getUri() + " has not been properly sentence segmented. Use simple segmenter instead.");
            }
            String text = jcas.getDocumentText();
            ArrayList<ArrayList<Span>> simpleSentences = SimpleParser.tokenizeDecimalSmartWSentences(text, true, this.caseSenstive);
            for (ArrayList<Span> sentence : simpleSentences) {
                this.saveConcept(jcas, "Sentence", sentence.get((int)0).begin, sentence.get((int)(sentence.size() - 1)).end, null);
                logger.finest("Sentence: " + sentence.get((int)0).begin + "-" + sentence.get((int)(sentence.size() - 1)).end);
                for (Span token : sentence) {
                    this.saveConcept(jcas, "Token", token.begin, token.end, null);
                }
                HashMap<String, ArrayList<Span>> concepts = this.fastNER.processSpanList(sentence);
                if (concepts.size() <= 0) continue;
                this.saveConcepts(jcas, concepts, null);
            }
        }
    }

    protected void saveOutsideScopeConcepts(JCas jcas, HashMap<String, ArrayList<Span>> concepts, String sectionName) {
        for (ArrayList<Span> spans : concepts.values()) {
            for (Span span : spans) {
                if (this.logRuleInfo) {
                    String ruleInfor = this.getRuleInfo(span);
                    this.saveOutsideScopeConcept(jcas, span, sectionName, ruleInfor);
                    continue;
                }
                this.saveOutsideScopeConcept(jcas, span, sectionName);
            }
        }
    }

    protected int indexSections(JCas jCas, IntervalST<String> sectionTree) {
        int totalSections = 0;
        if (this.includeSections.size() > 0) {
            for (Class<? extends Annotation> sectionCls : this.includeSectionClasses) {
                for (Annotation annotation : JCasUtil.select(jCas, sectionCls)) {
                    String sectionName = annotation.getType().getName();
                    if (this.excludeSections.size() != 0 && this.excludeSections.contains(sectionName)) continue;
                    sectionTree.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), sectionName);
                    ++totalSections;
                }
            }
        } else {
            String sectionName;
            AnnotationIndex<SectionBody> annoIndex = jCas.getAnnotationIndex(SectionBody.class);
            FSIterator annoIter = annoIndex.iterator();
            for (Annotation annotation : JCasUtil.select(jCas, SectionBody.class)) {
                sectionName = annotation.getType().getName();
                if (this.forceAssignSections) {
                    sectionTree.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), sectionName);
                } else if (this.excludeSections.size() > 0 && !this.excludeSections.contains(sectionName)) {
                    sectionTree.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), sectionName);
                }
                ++totalSections;
            }
            for (Annotation annotation : JCasUtil.select(jCas, SectionHeader.class)) {
                sectionName = annotation.getType().getShortName();
                if (this.forceAssignSections) {
                    sectionTree.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), sectionName);
                } else if (this.excludeSections.size() > 0 && !this.excludeSections.contains(sectionName)) {
                    sectionTree.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), sectionName);
                }
                ++totalSections;
            }
        }
        return totalSections;
    }

    protected void saveConcepts(JCas jcas, HashMap<String, ArrayList<Span>> concepts, String sectionName) {
        for (Map.Entry<String, ArrayList<Span>> entry : concepts.entrySet()) {
            for (Span span : entry.getValue()) {
                String conceptTypeName = entry.getKey();
                Rule rule = this.fastNER.getMatchedRuleString(span);
                if (this.logRuleInfo) {
                    String ruleInfor = this.getRuleInfo(span);
                    if (this.getSpanType(span) == DeterminantValueSet.Determinants.ACTUAL) {
                        this.saveConcept(jcas, conceptTypeName, span.begin, span.end, sectionName, ruleInfor, ((NERRule)rule).attributes.toArray(new String[((NERRule)rule).attributes.size()]));
                        continue;
                    }
                    if (!this.markPseudo) continue;
                    this.savePseudoConcept(jcas, span, ruleInfor);
                    continue;
                }
                if (this.getSpanType(span) == DeterminantValueSet.Determinants.ACTUAL) {
                    this.saveConcept(jcas, conceptTypeName, span.begin, span.end, sectionName, null, ((NERRule)rule).attributes.toArray(new String[((NERRule)rule).attributes.size()]));
                    continue;
                }
                if (!this.markPseudo) continue;
                this.savePseudoConcept(jcas, span, new String[0]);
            }
        }
    }

    protected void saveOutsideScopeConcept(JCas jcas, Span span, String ... comments) {
        OutsideScopeConcept concept = new OutsideScopeConcept(jcas, span.begin, span.end);
        concept.setCategory(this.getMatchedNEName(span));
        if (comments.length > 0) {
            concept.setSection(comments[0]);
        }
        if (comments.length > 1) {
            concept.setNote(comments[1]);
        }
        concept.addToIndexes();
    }

    protected void savePseudoConcept(JCas jcas, Span span, String ... rule) {
        PseudoConcept concept = new PseudoConcept(jcas, span.begin, span.end);
        concept.setCategory(this.getMatchedNEName(span));
        if (rule.length > 0) {
            concept.setNote(rule[0]);
        }
        concept.addToIndexes();
    }

    protected String getMatchedNEName(Span span) {
        return this.fastNER.getMatchedNEName(span);
    }

    protected DeterminantValueSet.Determinants getSpanType(Span span) {
        return this.fastNER.getMatchedNEType(span);
    }

    protected String getRuleInfo(Span span) {
        return span.ruleId + ":\t" + this.fastNER.getMatchedRuleString((Span)span).rule;
    }

    protected void saveConcept(JCas jcas, String conceptTypeName, int begin, int end, String sectionName, String note, String ... featureValues) {
        Class<? extends Annotation> conceptCls = AnnotationOper.getTypeClass(conceptTypeName);
        Annotation anno = AnnotationFactory.createAnnotation(jcas, begin, end, conceptCls);
        if (anno instanceof ConceptBASE) {
            if (sectionName != null) {
                ((ConceptBASE)anno).setSection(sectionName);
            }
            if (note != null) {
                ((ConceptBASE)anno).setNote(note);
            }
            if (featureValues.length > 0 && this.setMethods.containsKey(conceptTypeName)) {
                int i = 0;
                for (String featureName : this.setMethods.get(conceptTypeName).keySet()) {
                    if (i >= featureValues.length) break;
                    FSUtil.setFeature((FeatureStructure)anno, featureName, featureValues[i]);
                    ++i;
                }
            }
        }
        anno.addToIndexes();
    }

    @Deprecated
    protected void saveConcept(JCas jcas, String conceptTypeName, Constructor<? extends Annotation> annoConstructor, int begin, int end, String sectionName, String note, String ... featureValues) {
        TOP anno;
        block8: {
            anno = null;
            try {
                anno = annoConstructor.newInstance(jcas, begin, end);
                if (!(anno instanceof ConceptBASE)) break block8;
                if (sectionName != null) {
                    ((ConceptBASE)anno).setSection(sectionName);
                }
                if (note != null) {
                    ((ConceptBASE)anno).setNote(note);
                }
                if (featureValues.length <= 0 || !this.setMethods.containsKey(conceptTypeName)) break block8;
                int i = 0;
                for (String featureName : this.setMethods.get(conceptTypeName).keySet()) {
                    if (i < featureValues.length) {
                        this.setMethods.get(conceptTypeName).get(featureName).invoke((Object)anno, featureValues[i]);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        anno.addToIndexes();
    }

    protected void saveConcept(JCas jcas, String conceptTypeName, int begin, int end, String sectionName) {
        this.saveConcept(jcas, conceptTypeName, begin, end, sectionName, null, new String[0]);
    }

    @Deprecated
    protected void saveConcept(JCas jcas, String conceptTypeName, Constructor<? extends Annotation> annoConstructor, int begin, int end, String sectionName) {
        this.saveConcept(jcas, conceptTypeName, begin, end, sectionName, null, new String[0]);
    }

    public static LinkedHashMap<String, TypeDefinition> getTypeDefinitions(String ruleFile, boolean caseSenstive) {
        return new FastNER(ruleFile, caseSenstive, false).getTypeDefinitions();
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefs(String ruleStr) {
        return new FastNER(ruleStr, false, false).getTypeDefinitions();
    }
}

