/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.rush.core;

import edu.utah.bmi.nlp.core.Span;

public class Marker
extends Span {
    public float fbegin;
    public float fend;
    public MARKERTYPE type;

    public Marker(int begin, int end, String text) {
        this.construct(begin, end, -1, (MARKERTYPE)null, text);
    }

    public Marker(float fbegin) {
        this.construct(fbegin, 0.0f, -1, null, "");
    }

    public Marker(float fbegin, float fend) {
        this.construct(fbegin, fend, this.width, null, "");
    }

    public Marker(float fbegin, float fend, int width) {
        this.construct(fbegin, fend, width, null, "");
    }

    public Marker(float fbegin, MARKERTYPE type) {
        this.construct(fbegin, fbegin + 1.0f, -1, type, "");
    }

    protected void construct(float fbegin, float fend, int width, MARKERTYPE type, String text) {
        this.fbegin = fbegin;
        this.fend = fend;
        this.begin = (int)fbegin;
        this.end = (int)fend;
        this.type = null;
        this.width = width == -1 ? (int)fend - (int)fbegin + 1 : width;
        this.type = type;
        this.text = text;
    }

    protected void construct(int begin, int end, int width, MARKERTYPE type, String text) {
        this.fbegin = begin;
        this.begin = begin;
        this.end = end;
        this.fend = (float)end - 0.3f;
        this.width = width == -1 ? end - begin + 1 : width;
        this.type = type;
        this.text = text;
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setBegin(int begin) {
        this.fbegin = begin;
    }

    @Override
    public void setEnd(int end) {
        this.fend = (float)end - 0.3f;
    }

    @Override
    public String toString() {
        return this.begin + "-" + this.end + "\t" + (Object)((Object)this.type) + "|" + this.text;
    }

    public static enum MARKERTYPE {
        BEGIN,
        END;

    }
}

