/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.rush.core;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.SimpleParser;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.core.WildCardChecker;
import edu.utah.bmi.nlp.fastcner.FastRuSHFactory;
import edu.utah.bmi.nlp.fastcner.FastRuSHRule_H;
import edu.utah.bmi.nlp.fastcner.FastRuSHRule_HCN;
import edu.utah.bmi.nlp.rush.core.Boundary;
import edu.utah.bmi.nlp.rush.core.Marker;
import edu.utah.bmi.nlp.rush.core.RuSHInf;
import edu.utah.bmi.nlp.rush.core.SmartChineseCharacterSplitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuSH
implements RuSHInf {
    protected static Logger logger = IOUtil.getLogger(RuSH.class);
    protected static FastRuSHRule_H fcrp;
    public static final String STBEGIN = "stbegin";
    public static final String STEND = "stend";
    public static final String TOKENBEGIN = "tobegin";
    public static final String TOKENEND = "toend";
    protected boolean autofixGap = true;
    public boolean fillTextInSpan = false;
    protected Map<String, ArrayList<Marker>> result;
    public boolean tokenRuleEnabled;
    public String mLanguage = "en";
    private int minSentChar = 5;
    public static LinkedHashSet<Boundary> logs;

    public RuSH(String ruleStr) {
        this.initiate(ruleStr, 5);
    }

    public RuSH(String ruleStr, int minSentChar) {
        this.initiate(ruleStr, 5);
    }

    public void initiate(String ruleStr, int minSentChar) {
        fcrp = FastRuSHFactory.createFastRuSHRule(ruleStr);
        if (fcrp instanceof FastRuSHRule_HCN) {
            this.mLanguage = "cn";
        }
        this.minSentChar = minSentChar;
        this.tokenRuleEnabled = RuSH.fcrp.tokenRuleEnabled;
    }

    protected void fixGap(String text, ArrayList<Span> sentences, int previousEnd, int thisBegin) {
        int counter = 0;
        int begin = 0;
        int end = 0;
        char[] gapChars = text.substring(previousEnd, thisBegin).toCharArray();
        for (int i = 0; i < thisBegin - previousEnd; ++i) {
            char thisChar = gapChars[i];
            if (!Character.isAlphabetic(thisChar) && !Character.isDigit(thisChar) && !WildCardChecker.isPunctuation(thisChar)) continue;
            end = i;
            ++counter;
            if (begin != 0) continue;
            begin = i;
        }
        if (counter > 5) {
            end = end + previousEnd + 1;
            sentences.add(new Span(begin += previousEnd, end));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayList<Span> segToSentenceSpans(String text) {
        void var6_8;
        ArrayList<Span> sentences = new ArrayList<Span>();
        this.result = fcrp.processText(text);
        if (logger.isLoggable(Level.FINE)) {
            text = text.replaceAll("\n", " ");
            for (Map.Entry<String, ArrayList<Marker>> ent : this.result.entrySet()) {
                logger.finer(ent.getKey());
                for (Span span : ent.getValue()) {
                    Rule rule = fcrp.getRule(span.ruleId);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    String rulestr = "Rule " + rule.id + ":\t" + rule.rule + "\t" + rule.ruleName + "\t" + rule.score + "\t" + (Object)((Object)rule.type);
                    logger.finer("\t" + span.begin + "-" + span.end + ":" + span.score + "\t" + text.substring(0, span.begin) + "<" + text.substring(span.begin, span.begin + 1) + ">\t[" + rulestr + "]");
                    logs.add(new Boundary(span.begin, span.end, rulestr, rule.ruleName, rule.type));
                }
            }
        }
        ArrayList<Marker> stbegins = this.result.getOrDefault(STBEGIN, new ArrayList());
        ArrayList<Marker> stends = this.result.getOrDefault(STEND, new ArrayList());
        if (stbegins.size() == 0 || ((Marker)stbegins.get((int)0)).fbegin > 0.0f) {
            stbegins.add(0, new Marker(0.0f, Marker.MARKERTYPE.BEGIN));
        }
        if (stends.size() == 0 || ((Marker)stends.get((int)(stends.size() - 1))).fend < (float)text.length()) {
            stends.add(stends.size(), new Marker((float)(text.length() - 1), Marker.MARKERTYPE.END));
        }
        ArrayList sortedMarkers = new ArrayList();
        boolean bl = false;
        int e = 0;
        while (var6_8 < stbegins.size() && e < stends.size()) {
            if (((Marker)stbegins.get((int)var6_8)).fbegin < ((Marker)stends.get((int)e)).fend) {
                sortedMarkers.add(stbegins.get((int)(++var6_8)));
                continue;
            }
            sortedMarkers.add(stends.get(e++));
        }
        if (var6_8 < stbegins.size()) {
            sortedMarkers.addAll(stbegins.subList((int)var6_8, stbegins.size()));
        }
        if (e < stends.size()) {
            sortedMarkers.addAll(stends.subList(e, stends.size()));
        }
        int begin = 0;
        int end = 0;
        boolean sentStarted = false;
        for (int m3 = 0; m3 < sortedMarkers.size(); ++m3) {
            Marker current = (Marker)sortedMarkers.get(m3);
            if (!sentStarted) {
                if (current.type == Marker.MARKERTYPE.BEGIN) {
                    begin = current.getBegin();
                    sentStarted = true;
                    continue;
                }
                if (sentences.size() <= 0) continue;
                end = current.getEnd();
                sentences.set(sentences.size() - 1, new Span(begin, end));
                continue;
            }
            if (current.type == Marker.MARKERTYPE.BEGIN || (end = current.getEnd()) - begin < this.minSentChar) continue;
            sentences.add(new Span(begin, end));
            sentStarted = false;
        }
        ArrayList<Span> gapFixed = new ArrayList<Span>();
        for (int i = 0; i < sentences.size() - 1; ++i) {
            gapFixed.add((Span)sentences.get(i));
            int preEnd = ((Span)sentences.get(i)).getEnd();
            int nextBegin = ((Span)sentences.get(i + 1)).getBegin();
            this.fixGap(text, gapFixed, preEnd, nextBegin);
        }
        gapFixed.add((Span)sentences.get(sentences.size() - 1));
        for (Span sent : gapFixed) {
            int stEnd;
            int stBegin = sent.getBegin();
            boolean rtrimmed = false;
            boolean ltrimmed = false;
            for (stEnd = sent.getEnd(); stEnd >= stBegin && (Character.isWhitespace(text.charAt(stEnd - 1)) || text.charAt(stEnd - 1) == '\u00a0'); --stEnd) {
                rtrimmed = true;
            }
            if (rtrimmed) {
                sent.setEnd(stEnd);
            }
            while (stBegin < stEnd && (Character.isWhitespace(text.charAt(stBegin)) || text.charAt(stBegin) == '\u00a0')) {
                ++stBegin;
                ltrimmed = true;
            }
            if (!ltrimmed) continue;
            sent.setBegin(stBegin);
        }
        if (logger.isLoggable(Level.FINE)) {
            for (Span sentence : sentences) {
                logger.fine("Sentence(" + sentence.begin + "-" + sentence.end + "):\t>" + text.substring(sentence.begin, sentence.end) + "<");
            }
        }
        return sentences;
    }

    private ArrayList<Marker> createMarkers(ArrayList<Marker> begins, ArrayList<Marker> ends, String text) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        if (begins == null || begins.size() == 0) {
            markers.add(new Marker(0.0f, Marker.MARKERTYPE.BEGIN));
        }
        if (ends == null || ends.size() == 0) {
            markers.add(new Marker((float)text.length() - 0.4f, Marker.MARKERTYPE.END));
        }
        for (int i = 0; i < begins.size(); ++i) {
        }
        if (begins == null) {
            markers.add(new Marker(0.0f, Marker.MARKERTYPE.BEGIN));
            if (ends != null) {
                this.addEndMarkers(ends, markers);
            } else {
                markers.add(new Marker((float)text.length() - 0.4f, Marker.MARKERTYPE.END));
            }
        } else if (ends == null) {
            this.addBeginMarkers(begins, markers);
            markers.add(new Marker((float)text.length() - 0.4f, Marker.MARKERTYPE.END));
        } else {
            Iterator<Marker> bIter = begins.iterator();
            Iterator<Marker> eIter = ends.iterator();
            while (bIter.hasNext() || eIter.hasNext()) {
                Span endSpan;
                Span beginSpan;
                if (bIter.hasNext()) {
                    beginSpan = bIter.next();
                    markers.add(new Marker((float)beginSpan.getBegin(), Marker.MARKERTYPE.BEGIN));
                } else {
                    while (eIter.hasNext()) {
                        endSpan = eIter.next();
                        markers.add(new Marker((float)endSpan.getEnd(), Marker.MARKERTYPE.END));
                    }
                }
                if (eIter.hasNext()) {
                    endSpan = eIter.next();
                    markers.add(new Marker((float)endSpan.getEnd(), Marker.MARKERTYPE.END));
                    continue;
                }
                while (bIter.hasNext()) {
                    beginSpan = bIter.next();
                    markers.add(new Marker((float)beginSpan.getBegin(), Marker.MARKERTYPE.BEGIN));
                }
            }
        }
        Collections.sort(markers);
        return markers;
    }

    private void addBeginMarkers(ArrayList<Marker> spans, ArrayList<Marker> markers) {
        for (Span span : spans) {
            if (RuSH.fcrp.getRule((int)span.ruleId).type != DeterminantValueSet.Determinants.ACTUAL) continue;
            markers.add(new Marker((float)span.begin, Marker.MARKERTYPE.BEGIN));
        }
    }

    private void addEndMarkers(ArrayList<Marker> spans, ArrayList<Marker> markers) {
        for (Span span : spans) {
            if (RuSH.fcrp.getRule((int)span.ruleId).type != DeterminantValueSet.Determinants.ACTUAL) continue;
            markers.add(new Marker((float)span.end - 0.4f, Marker.MARKERTYPE.END));
        }
    }

    public ArrayList<Span> tokenize(String text) {
        ArrayList<Span> sentence = new ArrayList<Span>();
        sentence.add(new Span(0, text.length()));
        ArrayList<ArrayList<Span>> tokenss = this.tokenize(sentence, text);
        return tokenss.get(0);
    }

    public ArrayList<ArrayList<Span>> tokenize(ArrayList<Span> sentences, String text) {
        int lastSentence;
        ArrayList<ArrayList<Span>> tokenss = new ArrayList<ArrayList<Span>>();
        ArrayList<Object> tokens = new ArrayList();
        if (!this.result.containsKey(TOKENBEGIN)) {
            for (Span sentence : sentences) {
                tokens = this.mLanguage.equals("en") ? SimpleParser.tokenizeDecimalSmart(text.substring(sentence.begin, sentence.end), true, 0, true) : SmartChineseCharacterSplitter.tokenizeDecimalSmart(text.substring(sentence.begin, sentence.end), true, 0);
                for (Span span : tokens) {
                    span.begin += sentence.begin;
                    span.end += sentence.begin;
                    if (!this.fillTextInSpan) continue;
                    span.text = text.substring(span.begin, span.end);
                }
                tokenss.add(tokens);
            }
        } else {
            ArrayList<Marker> tobegins = this.result.get(TOKENBEGIN);
            ArrayList<Marker> toends = this.result.get(TOKENEND);
            Collections.sort(tobegins);
            Collections.sort(toends);
            tokenss.add(new ArrayList());
            tokens = tokenss.get(tokenss.size() - 1);
            int toBegin = 0;
            boolean bl = false;
            int toEnd = 0;
            int toEndId = 0;
            int sentenceId = 0;
            Span currentSentence = sentences.get(sentenceId);
            block2: for (int toBeginId = 0; toBeginId < tobegins.size() && sentenceId != sentences.size(); ++toBeginId) {
                boolean bl2;
                if (!bl2) {
                    toBegin = tobegins.get((int)toBeginId).begin;
                    if (RuSH.fcrp.getRule((int)tobegins.get((int)toBeginId).ruleId).type == DeterminantValueSet.Determinants.PSEUDO || toBegin < toEnd) continue;
                    bl2 = true;
                } else if (tobegins.get((int)toBeginId).begin < toEnd) continue;
                for (int k = toEndId; k < toends.size(); ++k) {
                    if (RuSH.fcrp.getRule((int)toends.get((int)k).ruleId).type == DeterminantValueSet.Determinants.PSEUDO) continue;
                    if (toBeginId < tobegins.size() - 1 && k < toends.size() - 1 && tobegins.get(toBeginId + 1).getBegin() < toends.get((int)k).begin + 1) continue block2;
                    toEndId = k;
                    toEnd = toends.get((int)k).end;
                    if (toEnd < toBegin) continue;
                    if (toEnd == toBegin) {
                        if (tokens.size() > 0) {
                            Span lastToken = (Span)tokens.get(tokens.size() - 1);
                            lastToken.setEnd(toEnd);
                            lastToken.setText(text.substring(lastToken.begin, lastToken.end));
                            tokens.set(tokens.size() - 1, lastToken);
                            continue;
                        }
                        ArrayList<Span> previousSentence = tokenss.get(tokenss.size() - 2);
                        Span lastToken = previousSentence.get(previousSentence.size() - 1);
                        lastToken.setEnd(toEnd);
                        tokens.set(tokens.size() - 1, lastToken);
                        lastToken.setText(text.substring(lastToken.begin, lastToken.end));
                        previousSentence.set(previousSentence.size() - 1, lastToken);
                        continue;
                    }
                    if (bl2) {
                        if (toBegin > currentSentence.end) {
                            currentSentence = sentences.get(++sentenceId);
                            tokenss.add(new ArrayList());
                            tokens = tokenss.get(tokenss.size() - 1);
                        } else if (toEnd > currentSentence.end) {
                            if (this.fillTextInSpan) {
                                tokens.add(new Span(toBegin, currentSentence.end, text.substring(toBegin, currentSentence.end)));
                            } else {
                                tokens.add(new Span(toBegin, currentSentence.end));
                            }
                            currentSentence = sentences.get(++sentenceId);
                            tokenss.add(new ArrayList());
                            tokens = tokenss.get(tokenss.size() - 1);
                            toBegin = currentSentence.begin;
                        }
                        if (this.fillTextInSpan) {
                            tokens.add(new Span(toBegin, toEnd, text.substring(toBegin, toEnd)));
                        } else {
                            tokens.add(new Span(toBegin, toEnd));
                        }
                        bl2 = false;
                        if (toBeginId == tobegins.size() - 1 || k < toends.size() - 1 && tobegins.get(toBeginId + 1).getBegin() > toends.get(k + 1).getEnd()) continue;
                        ++toEndId;
                        continue block2;
                    }
                    Span tmp = this.fillTextInSpan ? new Span(toBegin, toEnd, text.substring(toBegin, toEnd)) : new Span(toBegin, toEnd);
                    if (tokens.size() > 0) {
                        tokens.set(tokens.size() - 1, tmp);
                    } else {
                        ArrayList<Span> previousSentence = tokenss.get(tokenss.size() - 2);
                        previousSentence.set(previousSentence.size() - 1, tmp);
                    }
                    bl2 = false;
                }
            }
        }
        if (((ArrayList)tokenss.get(lastSentence = tokenss.size() - 1)).size() == 0) {
            tokenss.remove(lastSentence);
        }
        return tokenss;
    }

    static {
        logs = new LinkedHashSet();
    }
}

