/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.rush.core;

import edu.utah.bmi.nlp.core.Span;
import java.io.Serializable;

public class RushSpan
extends Span
implements Comparable<Span>,
Serializable {
    public float fbegin;
    public float fend;
    public RUSHTYPE type;

    public RushSpan(float fbegin, float fend) {
        this.fbegin = fbegin;
        this.fend = fend;
        this.begin = Math.round(fbegin);
        this.end = Math.round(fend);
        this.width = this.end - this.begin;
    }

    public RushSpan(float fbegin, float fend, String text) {
        this.fbegin = fbegin;
        this.fend = fend;
        this.begin = Math.round(fbegin);
        this.end = Math.round(fend);
        this.width = this.end - this.begin;
        this.text = text;
    }

    public RushSpan(float fbegin, float fend, int ruleId) {
        this.fbegin = fbegin;
        this.fend = fend;
        this.ruleId = ruleId;
        this.begin = Math.round(fbegin);
        this.end = Math.round(fend);
        this.width = this.end - this.begin;
    }

    public RushSpan(float fbegin, float fend, int ruleId, double score) {
        this.fbegin = fbegin;
        this.fend = fend;
        this.ruleId = ruleId;
        this.score = score;
        this.begin = Math.round(fbegin);
        this.end = Math.round(fend);
        this.width = this.end - this.begin;
    }

    public RushSpan(float fbegin, float fend, int ruleId, int width, double score) {
        this.fbegin = fbegin;
        this.fend = fend;
        this.ruleId = ruleId;
        this.score = score;
        this.begin = Math.round(fbegin);
        this.end = Math.round(fend);
        this.width = this.end - this.begin;
    }

    public RushSpan(float fbegin, float fend, int ruleId, double score, String text) {
        this.fbegin = fbegin;
        this.fend = fend;
        this.ruleId = ruleId;
        this.score = score;
        this.text = text;
        this.begin = Math.round(fbegin);
        this.end = Math.round(fend);
        this.width = this.end - this.begin;
    }

    @Override
    public int compareTo(Span o) {
        if (o == null) {
            return -1;
        }
        int res = this.compareFloat(this.fbegin, ((RushSpan)o).fbegin);
        return res;
    }

    public int compareFloat(float a, float b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    public float getFloatBegin() {
        return this.fbegin;
    }

    public void setBegin(float fbegin) {
        this.fbegin = fbegin;
        this.begin = Math.round(fbegin);
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public float getFloatEnd() {
        return this.fend;
    }

    public void setEnd(float fend) {
        this.fend = fend;
        this.end = Math.round(fend);
        this.width = this.end - this.begin;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public String serialize() {
        return "(Rule" + this.ruleId + ": " + this.getBegin() + "-" + this.getEnd() + ":" + this.score + "):" + this.getText();
    }

    public int getPosition() {
        return Math.round(this.fbegin);
    }

    public static enum RUSHTYPE {
        BEGIN,
        END;

    }
}

