/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.rush.core;

import edu.utah.bmi.nlp.core.SimpleParser;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.fastcner.UnicodeChecker;
import java.util.ArrayList;

public class SmartChineseCharacterSplitter
extends SimpleParser {
    protected static final int chineseChar = 5;

    public static ArrayList<Span> tokenizeDecimalSmart(String text, boolean includePunctuation) {
        return SmartChineseCharacterSplitter.tokenizeDecimalSmart(text, includePunctuation, 0);
    }

    public static ArrayList<Span> tokenizeDecimalSmart(String text, boolean includePunctuation, int offset) {
        ArrayList<Span> tokens = new ArrayList<Span>();
        int type_2 = -1;
        int type_1 = -1;
        int type0 = -1;
        int tokenBegin = 0;
        boolean tokenEnd = false;
        boolean sentenceBegin = false;
        boolean sentenceEnd = false;
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char thisChar = text.charAt(i);
            type0 = thisChar == '.' ? 1 : (UnicodeChecker.isPunctuation(thisChar) ? 0 : (thisChar == '\n' || thisChar == '\r' ? 2 : (Character.isDigit(thisChar) ? 4 : (SmartChineseCharacterSplitter.isAlphbetic(thisChar) ? 3 : (UnicodeChecker.isChinese(thisChar) ? 5 : -1)))));
            switch (type0) {
                case 5: {
                    switch (type_1) {
                        case -1: {
                            tokenBegin = i;
                            break;
                        }
                        case 0: {
                            if (includePunctuation) {
                                tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                                tmp.setLength(0);
                            }
                            tokenBegin = i;
                            break;
                        }
                        case 1: {
                            if (type_2 == 4 || type_2 == -1) {
                                tmp.append('.');
                                break;
                            }
                            if (tmp.length() > 0) {
                                tokens.add(new Span(tokenBegin + offset, i - 1 + offset, tmp.toString()));
                                tmp.setLength(0);
                            }
                            if (includePunctuation) {
                                tokens.add(new Span(i - 1 + offset, i + offset, "."));
                            }
                            tokenBegin = i;
                            break;
                        }
                        default: {
                            tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                            tmp.setLength(0);
                            tokenBegin = i;
                        }
                    }
                    tmp.append(thisChar);
                    break;
                }
                case 1: {
                    if (type_1 == -1) {
                        tokenBegin = i;
                    }
                    if (i != text.length() - 1) break;
                    if (tmp.length() > 0) {
                        tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                        tmp.setLength(0);
                    }
                    if (!includePunctuation) break;
                    tokens.add(new Span(i + offset, i + 1 + offset, "."));
                    break;
                }
                case 0: {
                    if ((type_1 == 3 || type_1 == 4 || type_1 == 5) && tmp.length() > 0) {
                        tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                        tmp.setLength(0);
                        tokenBegin = i;
                    }
                    if (!includePunctuation) break;
                    tmp.append(thisChar);
                    switch (type_1) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (tmp.length() > 0) {
                                tokens.add(new Span(tokenBegin + offset, i - 1 + offset, tmp.toString()));
                            }
                            tokens.add(new Span(i - 1 + offset, i + offset, "."));
                            tmp.setLength(0);
                            tokenBegin = i;
                            break;
                        }
                        case -1: 
                        case 2: {
                            tokenBegin = i;
                        }
                    }
                    break;
                }
                case -1: 
                case 2: {
                    switch (type_1) {
                        case 3: 
                        case 4: 
                        case 5: {
                            tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                            tmp.setLength(0);
                            break;
                        }
                        case 0: {
                            if (!includePunctuation) break;
                            tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                            tmp.setLength(0);
                            break;
                        }
                        case 1: {
                            if (tmp.length() > 0) {
                                tokens.add(new Span(tokenBegin + offset, i - 1 + offset, tmp.toString()));
                                tmp.setLength(0);
                            }
                            if (!includePunctuation) break;
                            tokens.add(new Span(i - 1 + offset, i + offset, "."));
                        }
                    }
                    tokenBegin = i;
                    break;
                }
                case 4: {
                    switch (type_1) {
                        case -1: {
                            tokenBegin = i;
                            break;
                        }
                        case 0: {
                            if (includePunctuation) {
                                tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                                tmp.setLength(0);
                            }
                            tokenBegin = i;
                            break;
                        }
                        case 1: {
                            if (type_2 == 4 || type_2 == -1) {
                                tmp.append('.');
                                break;
                            }
                            if (tmp.length() > 0) {
                                tokens.add(new Span(tokenBegin + offset, i - 1 + offset, tmp.toString()));
                                tmp.setLength(0);
                            }
                            if (includePunctuation) {
                                tokens.add(new Span(i - 1 + offset, i + offset, "."));
                            }
                            tokenBegin = i;
                            break;
                        }
                        case 3: 
                        case 5: {
                            tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                            tmp.setLength(0);
                            tokenBegin = i;
                        }
                    }
                    tmp.append(thisChar);
                    break;
                }
                case 3: {
                    switch (type_1) {
                        case -1: 
                        case 2: {
                            tokenBegin = i;
                            break;
                        }
                        case 1: {
                            if (tmp.length() > 0) {
                                tokens.add(new Span(tokenBegin + offset, i - 1 + offset, tmp.toString()));
                                tmp.setLength(0);
                            }
                            if (includePunctuation) {
                                tokens.add(new Span(i - 1 + offset, i + offset, "."));
                            }
                            tokenBegin = i;
                            break;
                        }
                        case 0: {
                            if (includePunctuation) {
                                tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                                tmp.setLength(0);
                            }
                            tokenBegin = i;
                            break;
                        }
                        case 4: 
                        case 5: {
                            tokens.add(new Span(tokenBegin + offset, i + offset, tmp.toString()));
                            tmp.setLength(0);
                            tokenBegin = i;
                            break;
                        }
                    }
                    tmp.append(thisChar);
                }
            }
            type_2 = type_1;
            type_1 = type0;
        }
        if (tmp.length() > 0) {
            tokens.add(new Span(tokenBegin + offset, text.length() + offset, tmp.toString()));
        }
        return tokens;
    }

    private static boolean isAlphbetic(char ch) {
        return (6 >> Character.getType(ch) & 1) != 0;
    }
}

