/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.rush.uima;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.SimpleParser;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.rush.core.RuSH;
import edu.utah.bmi.nlp.rush.core.SmartChineseCharacterSplitter;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class RuSH_AE
extends JCasAnnotator_ImplBase {
    private static Logger logger = IOUtil.getLogger(RuSH_AE.class);
    private RuSH rush;
    private boolean autoFixGaps = true;
    public static final String PARAM_INSIDE_SECTIONS = "InsideSections";
    public static final String PARAM_FIX_GAPS = "AutoFixGaps";
    public static final String PARAM_RULE_STR = "RuleFileOrStr";
    public static final String PARAM_SENTENCE_TYPE_NAME = "SentenceTypeName";
    public static final String PARAM_ALTER_SENTENCE_TYPE_NAME = "AlterSentenceTypeName";
    public static final String PARAM_TOKEN_TYPE_NAME = "TokenTypeName";
    public static final String PARAM_INCLUDE_PUNCTUATION = "IncludePunctuation";
    public static final String PARAM_LANGUAGE = "Language";
    @Deprecated
    public static final String PARAM_DEBUG = "Debug";
    protected Class<? extends Annotation> SentenceType;
    protected Class<? extends Annotation> AlterSentenceType;
    protected Class<? extends Annotation> TokenType;
    protected boolean includePunctuation = false;
    protected boolean differentColoring = false;
    protected boolean colorIndicator = false;
    protected static Constructor<? extends Annotation> SentenceTypeConstructor;
    protected static Constructor<? extends Annotation> AlterSentenceTypeConstructor;
    protected static Constructor<? extends Annotation> TokenTypeConstructor;
    private String mLanguage;
    private LinkedHashSet<Class> sectionClasses = new LinkedHashSet();

    @Override
    public void initialize(UimaContext cont) {
        String tokenTypeName;
        String sentenceTypeName;
        String ruleFileName = (String)cont.getConfigParameterValue(PARAM_RULE_STR);
        this.rush = new RuSH(ruleFileName);
        Object autoFixGapsObj = cont.getConfigParameterValue(PARAM_FIX_GAPS);
        if (autoFixGapsObj != null) {
            this.autoFixGaps = (Boolean)autoFixGapsObj;
        }
        String alterSentenceTypeName = null;
        Object obj = cont.getConfigParameterValue(PARAM_SENTENCE_TYPE_NAME);
        if (obj != null && obj instanceof String) {
            sentenceTypeName = ((String)obj).trim();
            sentenceTypeName = RuSH_AE.checkTypeDomain(sentenceTypeName);
        } else {
            sentenceTypeName = DeterminantValueSet.defaultNameSpace + "Sentence";
        }
        obj = cont.getConfigParameterValue(PARAM_TOKEN_TYPE_NAME);
        if (obj != null && obj instanceof String) {
            tokenTypeName = ((String)obj).trim();
            tokenTypeName = RuSH_AE.checkTypeDomain(tokenTypeName);
        } else {
            tokenTypeName = DeterminantValueSet.defaultNameSpace + "Token";
        }
        obj = cont.getConfigParameterValue(PARAM_ALTER_SENTENCE_TYPE_NAME);
        if (obj != null && obj instanceof String) {
            alterSentenceTypeName = ((String)obj).trim();
            if ((alterSentenceTypeName = RuSH_AE.checkTypeDomain(alterSentenceTypeName)).length() > 0) {
                this.differentColoring = true;
            }
        }
        if ((obj = cont.getConfigParameterValue(PARAM_INCLUDE_PUNCTUATION)) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.includePunctuation = true;
        }
        this.mLanguage = (obj = cont.getConfigParameterValue(PARAM_LANGUAGE)) != null && obj instanceof String ? ((String)obj).trim().toLowerCase() : "en";
        obj = cont.getConfigParameterValue(PARAM_INSIDE_SECTIONS);
        if (obj == null || (obj + "").trim().length() == 0) {
            this.sectionClasses.add(SourceDocumentInformation.class);
        } else {
            for (String sectionName : ((String)obj).split("[\\|,;]")) {
                if ((sectionName = sectionName.trim()).length() <= 0) continue;
                this.sectionClasses.add(AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(sectionName)));
            }
        }
        try {
            this.SentenceType = Class.forName(sentenceTypeName).asSubclass(Annotation.class);
            this.TokenType = Class.forName(tokenTypeName).asSubclass(Annotation.class);
            SentenceTypeConstructor = this.SentenceType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            TokenTypeConstructor = this.TokenType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            if (this.differentColoring) {
                this.AlterSentenceType = Class.forName(alterSentenceTypeName).asSubclass(Annotation.class);
                AlterSentenceTypeConstructor = this.AlterSentenceType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Class sectionClass : this.sectionClasses) {
            AnnotationIndex annoIndex = jCas.getAnnotationIndex(sectionClass);
            for (Annotation section : annoIndex) {
                this.processOneSection(jCas, section);
            }
        }
    }

    private void processOneSection(JCas jCas, Annotation section) {
        String text = section.getCoveredText();
        int sectionBegin = section.getBegin();
        ArrayList<Span> sentences = this.rush.segToSentenceSpans(text);
        for (Span sentence : sentences) {
            if (!this.rush.tokenRuleEnabled) {
                ArrayList<Span> tokens;
                switch (this.mLanguage) {
                    case "en": {
                        tokens = SimpleParser.tokenizeDecimalSmart(text.substring(sentence.begin, sentence.end), this.includePunctuation);
                        this.saveTokens(jCas, sentence, tokens, sectionBegin);
                        break;
                    }
                    case "cn": {
                        tokens = SmartChineseCharacterSplitter.tokenizeDecimalSmart(text.substring(sentence.begin, sentence.end), this.includePunctuation);
                        this.saveTokens(jCas, sentence, tokens, sectionBegin);
                    }
                }
            }
            this.saveSentence(jCas, sentence, sectionBegin);
        }
        if (this.rush.tokenRuleEnabled) {
            ArrayList<ArrayList<Span>> tokenss = this.rush.tokenize(sentences, text);
            for (ArrayList<Span> tokens : tokenss) {
                for (Span token : tokens) {
                    this.saveToken(jCas, token.begin, token.end, sectionBegin);
                }
            }
        }
    }

    protected void saveTokens(JCas jcas, Span sentence, ArrayList<Span> tokens, int sectionBegin) {
        int sentBegin = sentence.begin;
        for (int i = 0; i < tokens.size(); ++i) {
            Span thisSpan = tokens.get(i);
            this.saveToken(jcas, thisSpan.begin + sentBegin, thisSpan.end + sentBegin, sectionBegin);
        }
    }

    protected void saveSentence(JCas jcas, Span sentence, int offset) {
        this.saveSentence(jcas, sentence.begin + offset, sentence.end + offset);
    }

    protected void saveToken(JCas jcas, int begin, int end, int offset) {
        this.saveAnnotation(jcas, TokenTypeConstructor, begin + offset, end + offset);
    }

    protected void saveSentence(JCas jcas, int begin, int end) {
        if (this.differentColoring) {
            boolean bl = this.colorIndicator = !this.colorIndicator;
            if (!this.colorIndicator) {
                this.saveAnnotation(jcas, AlterSentenceTypeConstructor, begin, end);
                return;
            }
        }
        this.saveAnnotation(jcas, SentenceTypeConstructor, begin, end);
    }

    protected void saveAnnotation(JCas jcas, Constructor<? extends Annotation> annoConstructor, int begin, int end) {
        TOP anno = null;
        try {
            anno = annoConstructor.newInstance(jcas, begin, end);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        anno.addToIndexes();
    }

    public static String checkTypeDomain(String typeName) {
        if (typeName.indexOf(".") == -1) {
            typeName = "edu.utah.bmi.nlp.type.system." + typeName;
        }
        return typeName;
    }
}

