/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ColumnInfo {
    private LinkedHashMap<String, String> columnInfo;
    private HashMap<String, Integer> columnName2Id;
    private HashMap<Integer, String> columnId2Name;
    private int currentColumnid = 1;

    public ColumnInfo() {
        this.columnInfo = new LinkedHashMap();
        this.columnName2Id = new HashMap();
        this.columnId2Name = new HashMap();
    }

    public ColumnInfo(LinkedHashMap<String, String> columnInfo) {
        this.columnInfo = columnInfo;
        int id = 1;
        for (Map.Entry<String, String> entry : columnInfo.entrySet()) {
            this.columnName2Id.put(entry.getKey(), id);
            this.columnId2Name.put(id, entry.getKey());
            ++id;
        }
    }

    public void addColumnInfo(String columnName, String dataType) {
        if (dataType == null || dataType.equals("null")) {
            dataType = "text";
        }
        this.columnInfo.put(columnName, dataType);
        this.columnName2Id.put(columnName, this.currentColumnid);
        this.columnId2Name.put(this.currentColumnid, columnName);
        ++this.currentColumnid;
    }

    public String getColumnType(String columnName) {
        return this.columnInfo.get(columnName);
    }

    public String getColumnType(int columnId) {
        return this.columnInfo.get(this.columnId2Name.get(columnId));
    }

    public Set<Map.Entry<String, String>> getColumnInfoSet() {
        return this.columnInfo.entrySet();
    }

    public int getColumnId(String columnName) {
        return this.columnName2Id.get(columnName);
    }

    public String getColumnName(int columnId) {
        return this.columnId2Name.get(columnId);
    }

    public LinkedHashMap<String, String> getColumnInfo() {
        return this.columnInfo;
    }
}

