/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import edu.utah.bmi.nlp.sql.ConfigReader;
import edu.utah.bmi.nlp.sql.JsonConfigReader;
import edu.utah.bmi.nlp.sql.XmlConfigReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;

public class ConfigReaderFactory {
    public static ConfigReader createConfigReader(File configFile) {
        if (FilenameUtils.getExtension(configFile.getName()).equals("xml")) {
            return new XmlConfigReader(configFile);
        }
        return new JsonConfigReader(configFile);
    }

    public static ConfigReader createConfigReader(Reader inputReader, String typeName) {
        if (typeName.toLowerCase().equals("xml")) {
            return new XmlConfigReader(inputReader);
        }
        return new JsonConfigReader(inputReader);
    }

    public static ConfigReader createConfigReader(InputStream inputStream, String typeName) {
        if (typeName.toLowerCase().equals("xml")) {
            return new XmlConfigReader(new InputStreamReader(inputStream));
        }
        return new JsonConfigReader(new InputStreamReader(inputStream));
    }
}

