/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.sql.ColumnInfo;
import edu.utah.bmi.nlp.sql.ConfigReader;
import edu.utah.bmi.nlp.sql.ConfigReaderFactory;
import edu.utah.bmi.nlp.sql.Decrypt;
import edu.utah.bmi.nlp.sql.RecordRow;
import edu.utah.bmi.nlp.sql.RecordRowIterator;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DAO {
    public static Logger logger = IOUtil.getLogger(DAO.class);
    @Deprecated
    public boolean debug = false;
    public Connection con = null;
    public Statement stmt = null;
    private LinkedHashMap<String, ArrayList<String>> createTableSQLs;
    private LinkedHashMap<String, ArrayList<String>> createTableTemplates;
    private LinkedHashMap<String, ArrayList<String>> dropTableSQLs;
    public HashMap<String, String> insertReturnEnabledTables;
    private HashMap<String, ColumnInfo> insertTableColumnInfo;
    private File configFile;
    public ConfigReader configReader;
    public HashMap<String, String> insertTemplates;
    public HashMap<String, String> queryTemplates;
    public HashMap<String, PreparedStatement> insertPreparedStatements = new HashMap();
    public HashMap<String, PreparedStatement> updatePreparedStatements = new HashMap();
    public HashMap<String, PreparedStatement> queryPreparedStatements = new HashMap();
    public HashMap<String, String> queries = new HashMap();
    public HashMap<String, String> inserts = new HashMap();
    public HashMap<String, String> updateTableSQLs = new HashMap();
    public int batchsize = 200;
    public int batchCounter = 0;
    public String databaseName = "";

    public DAO(File configFile) {
        this.initConnection(configFile, false, false, true);
    }

    public DAO(File configFile, boolean initiateTables, boolean overwriteExistingTables) {
        this.initConnection(configFile, initiateTables, overwriteExistingTables, true);
    }

    public DAO(File configFile, boolean initiateTables, boolean overwriteExistingTables, boolean concurUpdatable) {
        this.initConnection(configFile, initiateTables, overwriteExistingTables, concurUpdatable);
    }

    protected void initConnection(File configFile, boolean initiateTables, boolean overwriteExistingTables, boolean concurUpdatable) {
        String sql;
        int i;
        ArrayList sqls;
        String tableName;
        this.configFile = configFile;
        this.configReader = ConfigReaderFactory.createConfigReader(configFile);
        String server = (String)this.configReader.getValue("server");
        String username = (String)this.configReader.getValue("username");
        String password = (String)this.configReader.getValue("password");
        this.databaseName = (String)this.configReader.getValue("databaseName");
        String driver = (String)this.configReader.getValue("driver");
        if (password.startsWith("ENC(") && password.endsWith(")")) {
            password = Decrypt.decrypt(password.substring(4, password.length() - 1));
        }
        if (this.configReader.getValue("concurUpdatable") != null) {
            concurUpdatable = ((String)this.configReader.getValue("concurUpdatable")).startsWith("t");
        }
        this.createTableSQLs = new LinkedHashMap();
        this.createTableTemplates = new LinkedHashMap();
        this.dropTableSQLs = new LinkedHashMap();
        this.insertTableColumnInfo = new HashMap();
        this.updateTableSQLs = new HashMap();
        this.insertReturnEnabledTables = new HashMap();
        this.insertTemplates = new HashMap();
        this.queryTemplates = new HashMap();
        if (this.configReader.getValue("createTables") != null) {
            for (Map.Entry entry : ((HashMap)this.configReader.getValue("createTables")).entrySet()) {
                tableName = (String)entry.getKey();
                sqls = (ArrayList)((HashMap)entry.getValue()).get("sql");
                for (i = 0; i < sqls.size(); ++i) {
                    sql = (String)sqls.get(i);
                    sql = this.fillVariables(sql);
                    sqls.set(i, sql);
                }
                this.createTableSQLs.put(tableName, sqls);
            }
        }
        if (this.configReader.getValue("dropTables") != null) {
            for (Map.Entry entry : ((HashMap)this.configReader.getValue("dropTables")).entrySet()) {
                tableName = (String)entry.getKey();
                sqls = (ArrayList)((HashMap)entry.getValue()).get("sql");
                for (i = 0; i < sqls.size(); ++i) {
                    sql = (String)sqls.get(i);
                    sql = this.fillVariables(sql);
                    sqls.set(i, sql);
                }
                this.dropTableSQLs.put(tableName, sqls);
            }
        }
        if (this.configReader.getValue("templates") != null) {
            for (Map.Entry entry : ((LinkedHashMap)this.configReader.getValue("templates")).entrySet()) {
                String templateName = (String)entry.getKey();
                LinkedHashMap values2 = (LinkedHashMap)entry.getValue();
                ArrayList sqls2 = (ArrayList)((HashMap)values2).get("sql");
                for (int i2 = 0; i2 < sqls2.size(); ++i2) {
                    String sql2 = (String)sqls2.get(i2);
                    sql2 = this.fillVariables(sql2);
                    sqls2.set(i2, sql2);
                }
                this.createTableTemplates.put(templateName, sqls2);
                if (!values2.containsKey("insert")) {
                    System.err.println("Template " + templateName + " hasn't set up insert sql template.");
                    continue;
                }
                String insertTemplate = this.fillVariables((String)((HashMap)values2).get("insert"));
                Object returnKey = null;
                if (values2.containsKey("returnKey")) {
                    returnKey = ((HashMap)values2).get("returnKey");
                }
                this.insertTemplates.put(templateName, insertTemplate);
                if (returnKey != null) {
                    this.insertReturnEnabledTables.put(templateName, returnKey);
                }
                if (values2.containsKey("query")) {
                    String query = this.fillVariables((String)((HashMap)values2).get("query"));
                    this.queryTemplates.put(templateName, query);
                }
                if (!values2.containsKey("drop")) continue;
                if (!this.dropTableSQLs.containsValue(templateName)) {
                    this.dropTableSQLs.put(templateName, new ArrayList());
                }
                ArrayList<String> dropSqls = this.dropTableSQLs.get(templateName);
                for (Object dropSql : (ArrayList)((HashMap)values2).get("drop")) {
                    dropSqls.add(this.fillVariables((String)dropSql));
                }
            }
        }
        if (this.configReader.getValue("updateStatements") != null) {
            for (Map.Entry entry : ((HashMap)this.configReader.getValue("updateStatements")).entrySet()) {
                tableName = (String)entry.getKey();
                String sql3 = (String)((HashMap)entry.getValue()).get("sql");
                sql3 = this.fillVariables(sql3);
                this.updateTableSQLs.put(tableName, sql3);
            }
        }
        this.con = null;
        this.stmt = null;
        try {
            Class.forName(driver);
            this.con = DriverManager.getConnection(server, username, password);
            this.stmt = concurUpdatable ? this.con.createStatement(1005, 1008) : this.con.createStatement();
            this.con.setAutoCommit(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.initCheckTableStatment("queryStatements", this.queryPreparedStatements);
        if (initiateTables) {
            this.initiateTables(overwriteExistingTables);
        }
        if (this.configReader.getValue("queryStatements") != null) {
            this.initStatements(this.queries, "queryStatements", this.queryPreparedStatements);
        }
        if (this.configReader.getValue("insertStatements") != null) {
            this.initInsertStatements();
        }
        if (this.configReader.getValue("updateStatements") != null) {
            this.initStatements(this.inserts, "updateStatements", this.updatePreparedStatements);
        }
    }

    private void initCheckTableStatment(String queryStatements, HashMap<String, PreparedStatement> queryPreparedStatements) {
        if (this.configReader.getValue("queryStatements") != null) {
            HashMap queryConfigs = (HashMap)this.configReader.getValue("queryStatements");
            if (queryConfigs.containsKey("checkTableExists")) {
                String sql = (String)((HashMap)queryConfigs.get("checkTableExists")).get("sql");
                if ((sql = this.fillVariables(sql)).indexOf("{tableName}") == -1) {
                    try {
                        PreparedStatement pstms = this.con.prepareStatement(sql);
                        queryPreparedStatements.put("checkTableExists", pstms);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.queries.put("checkTableExists", sql);
                }
            } else {
                System.err.println("'checkTableExists' hasn't been set up yet. You need to add it into 'queryStatements'.");
            }
        }
    }

    protected void initStatements(HashMap<String, String> sqls, String statementSetName, HashMap<String, PreparedStatement> statementHashMap) {
        for (Map.Entry entry : ((HashMap)this.configReader.getValue(statementSetName)).entrySet()) {
            String name = (String)entry.getKey();
            String sql = (String)((HashMap)entry.getValue()).get("sql");
            if ((sql = this.fillVariables(sql)).indexOf("{tableName}") == -1) {
                try {
                    PreparedStatement pstms = this.con.prepareStatement(sql);
                    statementHashMap.put(name, pstms);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            sqls.put(name, sql);
        }
    }

    protected void initInsertStatements() {
        for (Map.Entry entry : ((HashMap)this.configReader.getValue("insertStatements")).entrySet()) {
            boolean tableExist;
            String tableName = (String)entry.getKey();
            HashMap values2 = (HashMap)entry.getValue();
            String sql = (String)((HashMap)entry.getValue()).get("sql");
            sql = this.fillVariables(sql);
            Object returnKey = null;
            if (values2.containsKey("returnKey")) {
                returnKey = values2.get("returnKey");
            }
            if (!(tableExist = this.checkTableExits(tableName))) continue;
            this.parseInsertColumnInfor(tableName, sql);
            this.addInsertPreparedStatement(tableName, sql, returnKey);
            if (returnKey == null) continue;
            this.insertReturnEnabledTables.put(tableName, returnKey);
        }
    }

    private ColumnInfo parseInsertColumnInfor(String tableName, String sql) {
        String columnNames = sql.substring(sql.indexOf("(") + 1);
        String parameters = sql.substring(sql.indexOf(")"));
        parameters = parameters.substring(parameters.indexOf("(") + 1);
        parameters = parameters.substring(0, parameters.indexOf(")"));
        columnNames = columnNames.substring(0, columnNames.indexOf(")"));
        columnNames = columnNames.trim();
        String[] columns = columnNames.split(",\\s*");
        String[] paras = parameters.split(",\\s*");
        ColumnInfo tableColumnInfor = this.getTableColumnInfo(tableName);
        ColumnInfo insertColumnInfo = new ColumnInfo();
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i].trim();
            String para = paras[i];
            if (!para.equals("?")) continue;
            if (column.startsWith("'") && column.endsWith("'")) {
                column.substring(1, column.length() - 1);
            } else if (column.startsWith("`") && column.endsWith("`")) {
                column.substring(1, column.length() - 1);
            } else if (column.startsWith("\"") && column.endsWith("\"")) {
                column.substring(1, column.length() - 1);
            }
            insertColumnInfo.addColumnInfo(column, tableColumnInfor.getColumnType(column));
        }
        this.insertTableColumnInfo.put(tableName, insertColumnInfo);
        return insertColumnInfo;
    }

    public void dropTable(String tableName) {
        if (this.checkTableExits(tableName)) {
            try {
                if (this.dropTableSQLs.containsKey(tableName)) {
                    for (String sql : this.dropTableSQLs.get(tableName)) {
                        logger.fine(sql);
                        if (this.insertPreparedStatements.containsKey(tableName)) {
                            this.insertPreparedStatements.get(tableName).clearBatch();
                            this.insertPreparedStatements.get(tableName).close();
                        }
                        if (this.queryPreparedStatements.containsKey(tableName)) {
                            System.out.println(this.queryPreparedStatements.get(tableName).isClosed());
                        }
                        this.stmt.execute(sql);
                        if (this.con.getAutoCommit()) continue;
                        this.con.commit();
                    }
                } else {
                    System.out.println("The sql to create table: " + tableName + " hasn't been set up.");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void initiateTable(String tableName, boolean overwrite) {
        if (overwrite) {
            this.dropTable(tableName);
            this.createTableNIndexes(tableName);
        } else if (!this.checkExists(tableName)) {
            this.createTableNIndexes(tableName);
        }
    }

    private void createTableNIndexes(String tableName) {
        try {
            if (this.createTableSQLs.containsKey(tableName)) {
                for (String sql : this.createTableSQLs.get(tableName)) {
                    logger.fine(sql);
                    this.stmt.execute(sql);
                    if (this.con.getAutoCommit()) continue;
                    this.con.commit();
                }
            } else {
                System.out.println("The sql to create table: " + tableName + " hasn't been set up.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void initiateTableFromTemplate(String templateName, String tableName, boolean overwrite) {
        if (this.dropTableSQLs.containsKey(templateName)) {
            this.dropTableSQLs.put(tableName, new ArrayList());
            for (String dropSql : this.dropTableSQLs.get(templateName)) {
                dropSql = dropSql.replaceAll("\\{tableName}", tableName);
                this.dropTableSQLs.get(tableName).add(dropSql);
            }
        }
        if (overwrite) {
            this.dropTable(tableName);
            this.createTableNIndexes(templateName, tableName);
        } else if (!this.checkTableExits(tableName)) {
            this.createTableNIndexes(templateName, tableName);
        }
        if (this.insertTemplates.containsKey(templateName)) {
            String insertSQL = this.insertTemplates.get(templateName);
            insertSQL = insertSQL.replaceAll("\\{tableName}", tableName);
            String returnKey = this.insertReturnEnabledTables.getOrDefault(templateName, null);
            if (returnKey != null) {
                this.insertReturnEnabledTables.put(tableName, returnKey);
            }
            this.parseInsertColumnInfor(tableName, insertSQL);
            this.addInsertPreparedStatement(tableName, insertSQL, returnKey);
        }
        if (this.queryTemplates.containsKey(templateName)) {
            String sql = this.queryTemplates.get(templateName);
            sql = sql.replaceAll("\\{tableName}", tableName);
            try {
                PreparedStatement pstms = this.con.prepareStatement(sql);
                this.queryPreparedStatements.put(tableName, pstms);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void createTableNIndexes(String templateName, String tableName) {
        try {
            if (this.createTableTemplates.containsKey(templateName)) {
                for (String sql : this.createTableTemplates.get(templateName)) {
                    sql = sql.replaceAll("\\{tableName}", tableName);
                    logger.fine(sql);
                    this.stmt.execute(sql);
                    if (this.con.getAutoCommit()) continue;
                    this.con.commit();
                }
            } else {
                System.out.println("The sql to create table: " + tableName + " hasn't been set up.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void initiateTables(boolean overwrite) {
        for (String tableName : this.createTableSQLs.keySet()) {
            this.initiateTable(tableName, overwrite);
        }
    }

    public ColumnInfo getResultSetMetaData(ResultSet results) {
        ColumnInfo columnInfo = new ColumnInfo();
        try {
            ResultSetMetaData metaData = results.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                columnInfo.addColumnInfo(metaData.getColumnLabel(i), metaData.getColumnTypeName(i).toLowerCase());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columnInfo;
    }

    public ColumnInfo getTableColumnInfo(String tableName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Pseudo get column info from table: \n" + tableName);
            return new ColumnInfo();
        }
        ColumnInfo columnInfor = new ColumnInfo();
        RecordRowIterator recordRowIterator = this.queryRecordsFromPstmt("getColumnsInfo", tableName);
        while (recordRowIterator.hasNext()) {
            String type;
            RecordRow recordRow = recordRowIterator.next();
            int offset = 0;
            if (recordRow.getValueByColumnId(1) instanceof Integer) {
                offset = 1;
            }
            if ((type = recordRow.getValueByColumnId(offset + 2) + "").indexOf("(") != -1) {
                type = type.substring(0, type.indexOf("("));
            }
            columnInfor.addColumnInfo((String)recordRow.getValueByColumnId(offset + 1), type.toLowerCase());
        }
        return columnInfor;
    }

    public RecordRowIterator queryRecords(String sql) {
        RecordRowIterator recordIterator = null;
        try {
            sql = this.fillVariables(sql);
            ResultSet rs = this.stmt.executeQuery(sql);
            ColumnInfo metaData = this.getResultSetMetaData(rs);
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
            recordIterator = new RecordRowIterator(rs, metaData);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return recordIterator;
    }

    public RecordRowIterator queryRecordsFromPstmt(String queryName, Object ... values2) {
        RecordRowIterator recordIterator = null;
        try {
            if (this.queryPreparedStatements.containsKey(queryName)) {
                PreparedStatement queryStmt = this.queryPreparedStatements.get(queryName);
                this.setPstmtValues(queryStmt, values2);
                ResultSet rs = queryStmt.executeQuery();
                ColumnInfo metaData = this.getResultSetMetaData(rs);
                if (!this.con.getAutoCommit()) {
                    this.con.commit();
                }
                recordIterator = new RecordRowIterator(rs, metaData);
            } else if (values2.length > 0 && this.queryPreparedStatements.containsKey(queryName + "_" + values2[0])) {
                PreparedStatement queryStmt = this.queryPreparedStatements.get(queryName + "_" + values2[0]);
                this.setPstmtValues(queryStmt, Arrays.copyOfRange(values2, 1, values2.length));
                ResultSet rs = queryStmt.executeQuery();
                ColumnInfo metaData = this.getResultSetMetaData(rs);
                if (!this.con.getAutoCommit()) {
                    this.con.commit();
                }
                recordIterator = new RecordRowIterator(rs, metaData);
            } else if (this.queries.containsKey(queryName) && values2.length > 0) {
                String sql = this.queries.get(queryName).replaceAll("\\{tableName}", values2[0].toString());
                try {
                    PreparedStatement pstms = this.con.prepareStatement(sql);
                    this.queryPreparedStatements.put(queryName + "_" + values2[0], pstms);
                    if (values2.length > 1) {
                        this.setPstmtValues(pstms, Arrays.copyOfRange(values2, 1, values2.length));
                    }
                    ResultSet rs = pstms.executeQuery();
                    ColumnInfo metaData = this.getResultSetMetaData(rs);
                    if (!this.con.getAutoCommit()) {
                        this.con.commit();
                    }
                    recordIterator = new RecordRowIterator(rs, metaData);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Query SQL: '" + queryName + "' has not been configured.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return recordIterator;
    }

    public RecordRow queryRecord(String sql) {
        RecordRowIterator recordIterator = null;
        recordIterator = this.queryRecords(sql);
        if (recordIterator.hasNext()) {
            return recordIterator.next();
        }
        return null;
    }

    protected void addInsertPreparedStatement(String tableName, String sql, Object returnKey) {
        try {
            PreparedStatement insertPstmt = returnKey != null ? this.con.prepareStatement(sql, new String[]{(String)returnKey}) : this.con.prepareStatement(sql);
            this.insertPreparedStatements.put(tableName, insertPstmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected PreparedStatement getInsertPstmt(String tableName) {
        return this.getPstmt(tableName, this.insertPreparedStatements);
    }

    protected PreparedStatement getUpdatePstmt(String tableName) {
        return this.getPstmt(tableName, this.updatePreparedStatements);
    }

    protected PreparedStatement getPstmt(String tableName, HashMap<String, PreparedStatement> preparedStatements) {
        if (!preparedStatements.containsKey(tableName)) {
            if (preparedStatements.containsKey(this.databaseName + "." + tableName)) {
                return preparedStatements.get(this.databaseName + "." + tableName);
            }
            System.err.println(preparedStatements.getClass().getSimpleName() + " for table: " + tableName + " hasn't been set up.");
        }
        return preparedStatements.get(tableName);
    }

    private void insertRecord(PreparedStatement insertPstmt, ColumnInfo columnInfo, RecordRow record) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Pseudo insert record: \n" + record.toString("\t"));
            return;
        }
        for (Map.Entry<String, String> columnNameType : columnInfo.getColumnInfoSet()) {
            String columnName = columnNameType.getKey();
            int columnId = columnInfo.getColumnId(columnName);
            Object value = null;
            if (record.getColumnNameValues().size() > 0) {
                value = record.getValueByColumnName(columnName);
            } else if (record.getColumnIdsValues().size() > 0) {
                value = record.getValueByColumnId(columnId);
            }
            this.setPstmtValue(insertPstmt, columnId, value);
        }
    }

    public Object insertRecord(String tableName, RecordRow record) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(record.toString());
            return null;
        }
        PreparedStatement insertPstmt = this.getInsertPstmt(tableName);
        ColumnInfo columnInfo = this.insertTableColumnInfo.get(tableName);
        try {
            ResultSet rs;
            this.insertRecord(insertPstmt, columnInfo, record);
            insertPstmt.executeUpdate();
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
            if (this.insertReturnEnabledTables.containsKey(tableName) && (rs = insertPstmt.getGeneratedKeys()).next()) {
                Object last_inserted_id = rs.getObject(1);
                return last_inserted_id;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void updateRecord(String tableName, RecordRow recordRow) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Pseudo update record to table: " + tableName + ":\n" + recordRow.toString("\t"));
            return;
        }
        HashMap<Integer, Object> idCells = recordRow.getId_cells();
        PreparedStatement updatePstmt = this.getUpdatePstmt(tableName);
        try {
            for (Map.Entry<Integer, Object> cell : idCells.entrySet()) {
                updatePstmt.setObject(cell.getKey(), cell.getValue());
            }
            updatePstmt.executeUpdate();
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertRecordToBatch(String tableName, RecordRow record) {
        PreparedStatement insertPstmt = this.getInsertPstmt(tableName);
        ColumnInfo columnInfo = this.insertTableColumnInfo.get(tableName);
        try {
            this.insertRecord(insertPstmt, columnInfo, record);
            if (!logger.isLoggable(Level.FINE)) {
                insertPstmt.addBatch();
                ++this.batchCounter;
                if (this.batchCounter % this.batchsize == 0) {
                    insertPstmt.executeBatch();
                    this.batchCounter = 0;
                    if (!this.con.getAutoCommit()) {
                        this.con.commit();
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertRecords(String tableName, Iterable<RecordRow> records) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Pseudo insert records....");
            for (RecordRow record : records) {
                System.out.println(record.toString("\t") + "\n");
            }
            return;
        }
        PreparedStatement insertPstmt = this.getInsertPstmt(tableName);
        ColumnInfo columnInfo = this.insertTableColumnInfo.get(tableName);
        try {
            for (RecordRow record : records) {
                this.insertRecord(insertPstmt, columnInfo, record);
                insertPstmt.addBatch();
                ++this.batchCounter;
                if (this.batchCounter % this.batchsize != 0) continue;
                insertPstmt.executeBatch();
                this.batchCounter = 0;
                if (this.con.getAutoCommit()) continue;
                this.con.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void endBatchInsert(String ... tableNames) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Pseudo execute endBatchInsert--finish whatever left in the batch.");
            return;
        }
        try {
            if (tableNames.length > 0) {
                for (String tableName : tableNames) {
                    this.insertPreparedStatements.get(tableName).executeBatch();
                }
            } else {
                for (PreparedStatement sts : this.insertPreparedStatements.values()) {
                    sts.executeBatch();
                }
            }
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setPstmtValue(PreparedStatement insertPstmt, Integer key, Object value) {
        try {
            if (value != null) {
                insertPstmt.setObject(key, value);
            } else {
                insertPstmt.setNull(key, 0);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setPstmtValues(PreparedStatement insertPstmt, Object ... values2) {
        try {
            for (int i = 0; i < values2.length; ++i) {
                Object value = values2[i];
                if (value != null) {
                    insertPstmt.setObject(i + 1, value);
                    continue;
                }
                insertPstmt.setNull(i + 1, 0);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String fillVariables(String query) {
        query = query.replaceAll("\\{databaseName\\}", this.databaseName);
        return query;
    }

    public int countRecords(String countSqlName, Object ... values2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(countSqlName);
            return 1;
        }
        int total = 0;
        RecordRowIterator rsIter = this.queryRecordsFromPstmt(countSqlName, values2);
        if (rsIter.hasNext()) {
            RecordRow recordRow = rsIter.next();
            Object value = recordRow.getValueByColumnId(1);
            total = value instanceof Long ? ((Long)value).intValue() : ((Integer)recordRow.getValueByColumnId(1)).intValue();
        }
        return total;
    }

    public void close() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pseudo close dao...");
            return;
        }
        try {
            for (PreparedStatement stat : this.insertPreparedStatements.values()) {
                stat.close();
            }
            this.stmt.close();
            this.con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean checkTableExits(String tableName) {
        try {
            if (this.con.getMetaData().getDriverName().toLowerCase().startsWith("sqlite")) {
                return this.checkExists(tableName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.checkExits("checkTableExists", tableName);
    }

    public boolean checkSequenceExists(String sequenceName) {
        return this.checkExits("checkSequenceExists", sequenceName);
    }

    public boolean checkTriggerExists(String triggerName) {
        return this.checkExits("checkTriggerExists", triggerName);
    }

    public boolean checkExits(String checkQueryName, String objectName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pseudo " + checkQueryName + " for: " + objectName);
            return true;
        }
        RecordRowIterator recordRowIterator = this.queryRecordsFromPstmt(checkQueryName, objectName);
        int count = 0;
        if (recordRowIterator.hasNext()) {
            RecordRow recordRow = recordRowIterator.next();
            Object value = recordRow.getValueByColumnId(1);
            count = value instanceof Long ? ((Long)value).intValue() : ((Integer)recordRow.getValueByColumnId(1)).intValue();
        }
        return count != 0;
    }

    public boolean checkExists(String tableName) {
        try {
            if (this.databaseName != null && this.databaseName.length() > 0) {
                this.stmt.execute("SELECT COUNT(*) FROM " + this.databaseName + "." + tableName);
            } else {
                this.stmt.execute("SELECT COUNT(*) FROM " + tableName);
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private String getSimpleTableName(String tableName) {
        int pointer = tableName.indexOf(".");
        if (pointer != -1) {
            tableName = tableName.substring(pointer + 1, tableName.length());
        }
        return tableName;
    }

    public int getLastId(String tableName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pseudo getLastId of table: " + tableName);
            return 1;
        }
        int id = 0;
        RecordRowIterator recordRowIterator = this.queryRecordsFromPstmt("lastIdof" + tableName, new Object[0]);
        if (recordRowIterator.hasNext()) {
            RecordRow recordRow = recordRowIterator.next();
            Object value = recordRow.getValueByColumnId(1);
            id = value instanceof Long ? ((Long)value).intValue() : ((Integer)recordRow.getValueByColumnId(1)).intValue();
        }
        return id;
    }

    public String formatTableName(String tableName) {
        if (tableName.indexOf(".") == -1) {
            tableName = this.databaseName + "." + tableName;
        }
        return tableName;
    }
}

