/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.jasypt.util.text.BasicTextEncryptor;

public class Encrypt {
    public static void main(String[] args2) throws UnknownHostException, SocketException {
        String password;
        InetAddress ip = InetAddress.getLocalHost();
        String sb = Encrypt.getMasterPassword();
        System.out.println(sb);
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword(sb);
        if (args2.length == 0) {
            System.out.print("Please enter your password (will be displayed in console): ");
            password = System.console().readLine();
        } else {
            password = args2[0];
        }
        password = textEncryptor.encrypt(password);
        System.out.println("This is your encrypted password: \n" + password);
        System.out.println("Use (without quotes): \"ENC(" + password + ")\" to fill the password setting in your configuration file");
        String configFile = "";
        if (args2.length > 1) {
            for (int i = 1; i < args2.length; ++i) {
                configFile = args2[i];
                Encrypt.updateConfigFile(password, configFile);
                System.out.println(new File(configFile).getAbsolutePath() + " has been updated");
            }
        }
    }

    private static void updateConfigFile(String password, String configFile) {
        File file = new File(configFile);
        if (file.exists()) {
            try {
                String content = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
                content = content.replaceAll(">ENC\\([^\\)]+\\)<", ">ENC(" + password + ")<");
                FileUtils.write(file, (CharSequence)content, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getMasterPassword() {
        StringBuilder output = new StringBuilder();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
            output.append(ip.getHostName());
            output.append("  ");
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface currentNetwork = networks.nextElement();
                byte[] mac = currentNetwork.getHardwareAddress();
                if (mac == null || currentNetwork.getName().startsWith("dock") || currentNetwork.getName().startsWith("veth")) continue;
                output.append(currentNetwork.getName());
                output.append(" ");
                for (int i = 0; i < mac.length; ++i) {
                    output.append(String.format("%02X", mac[i]));
                }
                output.append("  ");
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return output.toString().trim();
    }
}

