/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import edu.utah.bmi.nlp.sql.ConfigReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonConfigReader
implements ConfigReader {
    private JSONObject jsonObject;
    private LinkedHashMap<String, Object> configs;

    public JsonConfigReader(File jsonFile) {
        try {
            FileReader reader = new FileReader(jsonFile);
            this.init(reader);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    public JsonConfigReader(String str) {
        StringReader strReader = new StringReader(str);
        this.init(strReader);
    }

    public JsonConfigReader(Reader reader) {
        this.init(reader);
    }

    private void init(Reader reader) {
        JSONParser jsonParser = new JSONParser();
        try {
            this.jsonObject = (JSONObject)jsonParser.parse(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.configs = this.parse(this.jsonObject);
    }

    @Override
    public LinkedHashMap<String, Object> parse(Object configObject) {
        if (configObject instanceof JSONObject) {
            return this.parse((JSONObject)configObject);
        }
        System.err.println("Not a JSONObject to parse");
        return null;
    }

    private LinkedHashMap<String, Object> parse(JSONObject jsonObject) {
        LinkedHashMap<String, Object> configs = new LinkedHashMap<String, Object>();
        for (Map.Entry obj : jsonObject.entrySet()) {
            Map.Entry entry = obj;
            if (entry.getValue() instanceof JSONArray) {
                JSONArray values2 = (JSONArray)entry.getValue();
                Iterator i = values2.iterator();
                LinkedHashMap<String, LinkedHashMap<String, Object>> parsedValues = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                ArrayList<String> parseStrings = new ArrayList<String>();
                while (i.hasNext()) {
                    Object innerObj = i.next();
                    if (innerObj instanceof String) {
                        parseStrings.add((String)innerObj);
                        continue;
                    }
                    if (innerObj instanceof JSONObject) {
                        JSONObject innerJsonObj = (JSONObject)innerObj;
                        String key = "";
                        if (innerJsonObj.containsKey("id")) {
                            key = (String)innerJsonObj.get("id");
                        } else if (innerJsonObj.containsKey("name")) {
                            key = (String)innerJsonObj.get("name");
                        } else {
                            System.out.println("name or id is missing for Object: \n\t" + innerJsonObj.toJSONString());
                        }
                        parsedValues.put(key, this.parse(innerJsonObj));
                        continue;
                    }
                    System.out.println("unknown object: " + innerObj.getClass().getCanonicalName());
                }
                if (parsedValues.size() > 0) {
                    configs.put((String)entry.getKey(), parsedValues);
                    continue;
                }
                configs.put((String)entry.getKey(), parseStrings);
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            configs.put((String)entry.getKey(), entry.getValue());
        }
        return configs;
    }

    @Override
    public Object getValue(String keyString) {
        String[] keys2 = keyString.split("/");
        Object result = this.configs;
        for (String key : keys2) {
            if (result instanceof LinkedHashMap) {
                result = ((LinkedHashMap)result).get(key);
                continue;
            }
            System.out.println("no key of " + key + " found in keyString");
        }
        return result;
    }
}

