/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class RecordRow
implements Cloneable {
    private LinkedHashMap<String, Object> name_cells = new LinkedHashMap();
    private HashMap<String, Integer> ColumnNamePos = new HashMap();
    private HashMap<Integer, Object> id_cells = new HashMap();
    private int columnId = 1;

    public RecordRow() {
    }

    public RecordRow(Object ... values2) {
        this.addCellValues(values2);
    }

    public RecordRow(LinkedHashMap<String, Object> name_cells) {
        for (Map.Entry<String, Object> entry : name_cells.entrySet()) {
            this.name_cells.put(entry.getKey(), entry.getValue());
            this.id_cells.put(this.columnId, entry.getValue());
            ++this.columnId;
        }
    }

    public HashMap<Integer, Object> getId_cells() {
        return this.id_cells;
    }

    public RecordRow addCell(String columnName, Object value) {
        int columnId;
        this.name_cells.put(columnName, value);
        if (this.ColumnNamePos.containsKey(columnName)) {
            columnId = this.ColumnNamePos.get(columnName);
        } else {
            columnId = this.columnId++;
            this.ColumnNamePos.put(columnName, columnId);
        }
        this.id_cells.put(columnId, value);
        return this;
    }

    public RecordRow addCellValue(Object value) {
        this.id_cells.put(this.columnId, value);
        ++this.columnId;
        return this;
    }

    public RecordRow addCellValues(Object ... values2) {
        for (Object value : values2) {
            this.id_cells.put(this.columnId, value);
            ++this.columnId;
        }
        return this;
    }

    public RecordRow addCells(Object ... keyValuePairs) {
        boolean key = true;
        String columnName = "";
        Object value = null;
        for (Object keyValue : keyValuePairs) {
            if (key) {
                columnName = (String)keyValue;
            } else {
                value = keyValue;
                this.addCell(columnName, value);
            }
            key = !key;
        }
        return this;
    }

    public Object getValueByColumnName(String columnName) {
        if (this.name_cells.containsKey(columnName)) {
            return this.name_cells.get(columnName);
        }
        return null;
    }

    public String getStrByColumnName(String columnName) {
        if (this.name_cells.containsKey(columnName)) {
            return this.name_cells.get(columnName) + "";
        }
        return null;
    }

    public Object getValueByColumnId(int columnId) {
        if (this.id_cells.containsKey(columnId)) {
            return this.id_cells.get(columnId);
        }
        return null;
    }

    public HashMap<Integer, Object> getColumnIdsValues() {
        return this.id_cells;
    }

    public LinkedHashMap<String, Object> getColumnNameValues() {
        return this.name_cells;
    }

    public String serialize(String ... excludes) {
        StringBuilder ser = new StringBuilder();
        HashSet<Object> excludedColumns = new HashSet<Object>();
        if (excludes != null) {
            for (String exc : excludes) {
                excludedColumns.add(exc);
            }
        }
        for (Map.Entry entry : this.name_cells.entrySet()) {
            String columnName = (String)entry.getKey();
            if (excludedColumns.size() != 0 && excludedColumns.contains(columnName)) continue;
            Object value = entry.getValue();
            if (value == null) {
                value = "NULL";
            }
            ser.append("|");
            ser.append(columnName);
            ser.append(":");
            ser.append(Base64.getEncoder().encodeToString(value.toString().getBytes()));
        }
        if (ser.length() > 1) {
            ser.deleteCharAt(0);
        }
        return ser.toString();
    }

    public void deserialize(String input) {
        for (String entry : input.split("\\|")) {
            if (entry.indexOf(":") == -1) {
                System.out.println(input);
                throw new IllegalArgumentException("Illegal input string to be deserialized:\n" + input);
            }
            String[] pair = entry.split(":");
            String key = pair[0];
            String value = new String(Base64.getDecoder().decode(pair[1].getBytes()));
            this.name_cells.put(key, value);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder output;
        block4: {
            block3: {
                if (this == null) {
                    return "null record";
                }
                output = new StringBuilder();
                if (this.name_cells.size() <= 0) break block3;
                for (Map.Entry<String, Object> entry : this.name_cells.entrySet()) {
                    output.append(prefix);
                    output.append(entry.getKey() + "\t" + entry.getValue());
                    output.append("\n");
                }
                break block4;
            }
            if (this.id_cells.size() <= 0) break block4;
            for (Map.Entry<Integer, Object> entry : this.id_cells.entrySet()) {
                output.append(prefix);
                output.append(entry.getKey() + "\t" + entry.getValue());
                output.append("\n");
            }
        }
        return output.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }

    public RecordRow clone() {
        RecordRow newRecordRow = new RecordRow();
        newRecordRow.name_cells = (LinkedHashMap)this.name_cells.clone();
        newRecordRow.id_cells = (HashMap)this.id_cells.clone();
        newRecordRow.ColumnNamePos = (HashMap)this.ColumnNamePos.clone();
        newRecordRow.columnId = this.columnId;
        return newRecordRow;
    }
}

