/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import edu.utah.bmi.nlp.sql.ColumnInfo;
import edu.utah.bmi.nlp.sql.RecordRow;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class RecordRowIterator
implements Iterator<RecordRow> {
    private ResultSet resultSet;
    private ColumnInfo columninfo;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean nextRetrieved = false;

    public RecordRowIterator(ResultSet resultSet, ColumnInfo columninfo) {
        this.resultSet = resultSet;
        this.columninfo = columninfo;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRetrieved) {
            return true;
        }
        try {
            this.nextRetrieved = this.resultSet.next();
            return this.nextRetrieved;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public RecordRow next() {
        this.nextRetrieved = false;
        RecordRow record = new RecordRow();
        try {
            block66: for (Map.Entry<String, String> col : this.columninfo.getColumnInfoSet()) {
                switch (col.getValue()) {
                    case "char": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    case "bigint": {
                        record.addCell(col.getKey(), this.resultSet.getLong(col.getKey()));
                        break;
                    }
                    case "mediumint": {
                        record.addCell(col.getKey(), this.resultSet.getLong(col.getKey()));
                        break;
                    }
                    case "smallint": {
                        record.addCell(col.getKey(), this.resultSet.getInt(col.getKey()));
                        break;
                    }
                    case "tinyint": {
                        record.addCell(col.getKey(), this.resultSet.getShort(col.getKey()));
                        break;
                    }
                    case "int": {
                        record.addCell(col.getKey(), this.resultSet.getInt(col.getKey()));
                        break;
                    }
                    case "integer": {
                        record.addCell(col.getKey(), this.resultSet.getInt(col.getKey()));
                        break;
                    }
                    case "number": {
                        record.addCell(col.getKey(), this.resultSet.getLong(col.getKey()));
                        break;
                    }
                    case "varchar": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    case "varchar2": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    case "text": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    case "longtext": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    case "mediumtext": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    case "tinytext": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    case "boolean": {
                        record.addCell(col.getKey(), this.resultSet.getBoolean(col.getKey()));
                        break;
                    }
                    case "float": {
                        record.addCell(col.getKey(), Float.valueOf(this.resultSet.getFloat(col.getKey())));
                        break;
                    }
                    case "binary_float": {
                        record.addCell(col.getKey(), Float.valueOf(this.resultSet.getFloat(col.getKey())));
                        break;
                    }
                    case "double": {
                        record.addCell(col.getKey(), this.resultSet.getDouble(col.getKey()));
                        break;
                    }
                    case "binary_double": {
                        record.addCell(col.getKey(), this.resultSet.getDouble(col.getKey()));
                        break;
                    }
                    case "date": {
                        record.addCell(col.getKey(), this.resultSet.getDate(col.getKey()));
                        break;
                    }
                    case "time": {
                        record.addCell(col.getKey(), this.resultSet.getTime(col.getKey()));
                        break;
                    }
                    case "blob": {
                        Blob blob = this.resultSet.getBlob(col.getKey());
                        if (blob == null) {
                            record.addCell(col.getKey(), null);
                            break;
                        }
                        record.addCell(col.getKey(), blob.getBinaryStream());
                        break;
                    }
                    case "datetime": {
                        Date dateTime;
                        Object value;
                        try {
                            record.addCell(col.getKey(), this.resultSet.getTimestamp(col.getKey()));
                        }
                        catch (SQLException e) {
                            value = this.resultSet.getObject(col.getKey());
                            if (!(value instanceof String)) continue block66;
                            dateTime = null;
                            try {
                                dateTime = this.simpleDateFormat.parse((String)value);
                            }
                            catch (ParseException e1) {
                                e1.printStackTrace();
                            }
                            record.addCell(col.getKey(), new Timestamp(dateTime.getTime()));
                        }
                        break;
                    }
                    case "timestamp": {
                        Date dateTime;
                        Object value;
                        try {
                            record.addCell(col.getKey(), this.resultSet.getTimestamp(col.getKey()));
                        }
                        catch (SQLException e) {
                            value = this.resultSet.getObject(col.getKey());
                            if (!(value instanceof String)) continue block66;
                            dateTime = null;
                            try {
                                dateTime = this.simpleDateFormat.parse((String)value);
                            }
                            catch (ParseException e1) {
                                e1.printStackTrace();
                            }
                            record.addCell(col.getKey(), new Timestamp(dateTime.getTime()));
                        }
                        break;
                    }
                    case "clob": {
                        Clob clob = this.resultSet.getClob(col.getKey());
                        if (clob == null) {
                            record.addCell(col.getKey(), null);
                            break;
                        }
                        record.addCell(col.getKey(), clob.getSubString(1L, (int)clob.length()));
                        break;
                    }
                    case "numeric": {
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                        break;
                    }
                    default: {
                        System.err.println("Data type: '" + col.getValue() + "' for column '" + col.getValue() + "' has not been fully supported, read it as string instead.");
                        record.addCell(col.getKey(), this.resultSet.getString(col.getKey()));
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return record;
    }

    public void updateValueByName(String columnName, Object value) {
        try {
            this.resultSet.updateObject(columnName, value);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateValueById(int columnId, Object value) {
        try {
            this.resultSet.updateObject(columnId, value);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commitUpdates() {
        try {
            this.resultSet.updateRow();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public ColumnInfo getColumninfo() {
        return this.columninfo;
    }
}

