/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.sql;

import edu.utah.bmi.nlp.sql.ConfigReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.ReaderInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlConfigReader
implements ConfigReader {
    private LinkedHashMap<String, Object> configs;
    private Document doc;

    public XmlConfigReader(File jsonFile) {
        try {
            FileReader reader = new FileReader(jsonFile);
            this.init(reader);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    public XmlConfigReader(String str) {
        StringReader strReader = new StringReader(str);
        this.init(strReader);
    }

    public XmlConfigReader(Reader reader) {
        this.init(reader);
    }

    private void init(Reader reader) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
            this.doc = db.parse(new ReaderInputStream(reader));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.parse(this.doc);
    }

    @Override
    public LinkedHashMap<String, Object> parse(Object doc) {
        if (doc instanceof Document) {
            Node config = ((Document)doc).getElementsByTagName("config").item(0);
            this.configs = new LinkedHashMap();
            this.parse(config.getChildNodes(), "", this.configs);
        } else {
            System.err.println("Not a XML Document to parse");
        }
        return this.configs;
    }

    private void parse(NodeList children, String mapKey, Object configs) {
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("#text") && child.getNodeValue().trim().length() == 0) continue;
            this.parse(child, mapKey, configs);
        }
    }

    private Object parse(Node node, String mapKey, Object configs) {
        String name = node.getNodeName();
        String value = node.getNodeValue();
        if (value != null) {
            value = value.trim();
        }
        if (name.equals("#text") && value != null && value.length() > 0) {
            LinkedHashMap configMap = (LinkedHashMap)configs;
            configMap.put(mapKey, value);
        } else if (name.equals("item")) {
            Object child;
            LinkedHashMap configMap = (LinkedHashMap)configs;
            LinkedHashMap childConfig = new LinkedHashMap();
            this.parse(node.getChildNodes(), "", childConfig);
            String key = "";
            if (configMap.get(mapKey) == null) {
                if (childConfig.containsKey("name")) {
                    key = (String)childConfig.get("name");
                } else if (childConfig.containsKey("id")) {
                    key = (String)childConfig.get("id");
                }
                if (key.length() > 0) {
                    configMap.put(mapKey, new LinkedHashMap());
                } else {
                    configMap.put(mapKey, new ArrayList());
                }
            }
            if ((child = configMap.get(mapKey)) instanceof LinkedHashMap) {
                key = (String)childConfig.get("name");
                ((LinkedHashMap)child).put(key, childConfig);
            } else {
                ((ArrayList)child).add((String)childConfig.values().iterator().next());
            }
        } else if (!name.equals("#text") && value == null) {
            ((LinkedHashMap)configs).put(name, null);
            this.parse(node.getChildNodes(), name, configs);
        }
        return configs;
    }

    @Override
    public Object getValue(String keyString) {
        String[] keys2 = keyString.split("/");
        Object result = this.configs;
        for (String key : keys2) {
            if (result instanceof LinkedHashMap) {
                result = ((LinkedHashMap)result).get(key);
                continue;
            }
            System.out.println("no key of " + key + " found in keyString");
        }
        return result;
    }
}

