/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.NLPTask;
import edu.utah.bmi.nlp.core.NLPTasks;
import edu.utah.bmi.nlp.core.SettingAb;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.DynamicTypeGenerator;
import edu.utah.bmi.nlp.uima.ModifiedChecker;
import edu.utah.bmi.nlp.uima.SimpleStatusCallbackListenerImpl;
import edu.utah.bmi.nlp.uima.StatusSetable;
import edu.utah.bmi.nlp.uima.ae.RuleBasedAEInf;
import edu.utah.bmi.nlp.uima.loggers.UIMALogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.uima.CompositeResourceFactory;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.impl.PrimitiveAnalysisEngine_impl;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.impl.CollectionProcessingEngine_impl;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCasProcessors;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeInclude;
import org.apache.uima.collection.metadata.CpeIntegratedCasProcessor;
import org.apache.uima.collection.metadata.NameValuePair;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.impl.ChildUimaContext_impl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.UriUtils;
import org.apache.uima.util.XMLInputSource;
import org.xml.sax.SAXException;

public class AdaptableCPEDescriptorRunner
implements StatusSetable {
    public static Logger classLogger = IOUtil.getLogger(AdaptableCPEDescriptorRunner.class);
    public static AdaptableCPEDescriptorRunner lastRunner = null;
    protected static ModifiedChecker modifiedChecker = new ModifiedChecker();
    protected String annotator;
    protected String runnerName;
    protected CpeDescription currentCpeDesc;
    protected File rootFolder;
    protected LinkedHashMap<String, TypeDefinition> conceptTypeDefinitions = new LinkedHashMap();
    protected DynamicTypeGenerator dynamicTypeGenerator;
    protected String srcClassRootPath = null;
    protected String compiledClassPath = null;
    protected String genDescriptorPath;
    protected UIMALogger logger;
    protected final ResourceManager defaultResourceManager = UIMAFramework.newDefaultResourceManager();
    protected CollectionProcessingEngine mCPE = null;
    protected LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap;
    protected LinkedHashMap<String, LinkedHashMap<String, String>> aeConfigTypeMap;
    protected LinkedHashMap<String, Integer> writerIds = new LinkedHashMap();
    protected LinkedHashMap<String, Integer> cpeProcessorIds = new LinkedHashMap();
    protected LinkedHashMap<String, Class<? extends JCasAnnotator_ImplBase>> ruleBaseAeClassMap;
    protected ArrayList<Integer> versionedCpProcessorId = new ArrayList();
    protected File customTypeDescXmlDir = new File("target/generated-test-sources/uima-descripters");
    protected String runId = "-1";
    protected String previousRunId = "-1";
    protected File customTypeDescXmlLoc = null;
    protected String cpeDescripterFileName = "";
    protected String cpeDescriptorPath = "";
    protected boolean refreshed = false;
    protected int status = 0;
    private static final String ACTION_ON_MAX_ERROR = "terminate";
    private String typeXMLAbsolutPath = "";
    private SimpleStatusCallbackListenerImpl statCbL;

    public SimpleStatusCallbackListenerImpl getStatCbL() {
        return this.statCbL;
    }

    protected AdaptableCPEDescriptorRunner() {
    }

    public static AdaptableCPEDescriptorRunner getInstance(NLPTasks tasks) {
        NLPTask config = tasks.getTask("easycie");
        String cpeDescriptor = config.getValue("pipeLineSetting/CpeDescriptor");
        LinkedHashMap<String, String> componentsSettings = AdaptableCPEDescriptorRunner.readPipelineConfigurations(config.getChildSettings("pipeLineSetting"));
        String annotator = config.getValue("annotators/current");
        String pipelineName = new File(cpeDescriptor).getName();
        pipelineName = pipelineName.substring(0, pipelineName.length() - 4);
        return AdaptableCPEDescriptorRunner.getInstance(cpeDescriptor, annotator, componentsSettings, "classes", "desc/type/" + pipelineName + "_" + annotator + "_Type.xml");
    }

    public static AdaptableCPEDescriptorRunner getInstance(String cpeDescriptor, String annotator, String ... options) {
        return AdaptableCPEDescriptorRunner.getInstance(cpeDescriptor, annotator, null, new LinkedHashMap<String, String>(), options);
    }

    public static AdaptableCPEDescriptorRunner getInstance(String cpeDescriptor, String annotator, UIMALogger logger, String ... options) {
        return AdaptableCPEDescriptorRunner.getInstance(cpeDescriptor, annotator, logger, new LinkedHashMap<String, String>(), options);
    }

    public static AdaptableCPEDescriptorRunner getInstance(String cpeDescriptor, String annotator, LinkedHashMap<String, String> externalRuleConfigMap, String ... options) {
        return AdaptableCPEDescriptorRunner.getInstance(cpeDescriptor, annotator, null, externalRuleConfigMap, options);
    }

    public static AdaptableCPEDescriptorRunner getInstance(String cpeDescriptor, String annotator, UIMALogger logger, LinkedHashMap<String, String> externalSettingMap, String ... options) {
        LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap = AdaptableCPEDescriptorRunner.parseExternalConfigMap(externalSettingMap);
        ArrayList<String> modifiedAes = modifiedChecker.checkModifiedAEs(cpeDescriptor, externalConfigMap);
        return AdaptableCPEDescriptorRunner.getInstance(cpeDescriptor, annotator, logger, modifiedAes, externalConfigMap, options);
    }

    public static AdaptableCPEDescriptorRunner getInstance(String cpeDescriptor, String annotator, UIMALogger logger, ArrayList<String> modifiedAes, LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap, String ... options) {
        String cpeName = FilenameUtils.getBaseName(cpeDescriptor) + "_" + annotator;
        if (lastRunner != null && AdaptableCPEDescriptorRunner.lastRunner.runnerName.equals(cpeName) && modifiedAes != null) {
            if (modifiedAes.size() > 0) {
                for (String aeName : modifiedAes) {
                    classLogger.finest("The configuration of the AE: " + aeName + " has been modified. Re-initiate this AE.");
                    lastRunner.updateProcessorConfigurations(aeName, externalConfigMap.get(aeName));
                }
            }
        } else {
            if (classLogger.isLoggable(Level.FINEST)) {
                if (modifiedAes == null) {
                    classLogger.finest("Cpe descriptor modification detected.");
                } else {
                    classLogger.finest("Configuration modification detected: " + modifiedAes);
                }
            }
            lastRunner = new AdaptableCPEDescriptorRunner(cpeDescriptor, annotator, logger, externalConfigMap, options);
            AdaptableCPEDescriptorRunner.lastRunner.runnerName = cpeName;
        }
        lastRunner.setUIMALogger(logger);
        return lastRunner;
    }

    public AdaptableCPEDescriptorRunner(String cpeDescriptor, String annotator, UIMALogger logger, String ... options) {
        this.externalConfigMap = new LinkedHashMap();
        this.annotator = annotator;
        this.setUIMALogger(logger);
        this.initCpe(cpeDescriptor, annotator, options);
    }

    public AdaptableCPEDescriptorRunner(String cpeDescriptor, String annotator, UIMALogger logger, LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap, String ... options) {
        this.annotator = annotator;
        this.externalConfigMap = externalConfigMap;
        this.setUIMALogger(logger);
        this.initCpe(cpeDescriptor, annotator, options);
    }

    public CollectionProcessingEngine getmCPE() {
        return this.mCPE;
    }

    public static LinkedHashMap<String, LinkedHashMap<String, String>> parseExternalConfigMap(LinkedHashMap<String, String> externalSettingMap) {
        LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (Map.Entry<String, String> entry : externalSettingMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String[] keys2 = key.split("/");
            if (keys2.length == 1 && !key.equals(value) || keys2.length <= 1) continue;
            String cpName = keys2[0];
            String configName = keys2[1];
            if (!externalConfigMap.containsKey(cpName)) {
                externalConfigMap.put(cpName, new LinkedHashMap());
            }
            externalConfigMap.get(cpName).put(configName, value);
        }
        return externalConfigMap;
    }

    public void setExternalConfigMap(LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap) {
        this.externalConfigMap = externalConfigMap;
    }

    public void initCpe(String cpeDescriptor, String annotator, String ... options) {
        this.aeConfigTypeMap = new LinkedHashMap();
        this.conceptTypeDefinitions = new LinkedHashMap();
        this.ruleBaseAeClassMap = new LinkedHashMap();
        this.status = 0;
        if (options == null || options.length == 0) {
            this.initCpeDescriptor(cpeDescriptor, annotator);
        } else {
            switch (options.length) {
                case 3: {
                    this.srcClassRootPath = options[2];
                }
                case 2: {
                    this.compiledClassPath = options[1];
                }
                case 1: {
                    this.genDescriptorPath = options[0];
                    this.initCpeDescriptor(cpeDescriptor, annotator);
                    break;
                }
                default: {
                    this.genDescriptorPath = options[0];
                    this.compiledClassPath = options[1];
                    this.srcClassRootPath = options[2];
                    this.initCpeDescriptor(cpeDescriptor, annotator);
                }
            }
        }
    }

    public void initCpeDescriptor(String cpeDescriptor, String annotator) {
        this.refreshed = true;
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        this.ruleBaseAeClassMap = new LinkedHashMap();
        this.cpeDescripterFileName = FilenameUtils.getBaseName(cpeDescriptor) + "_" + annotator;
        this.customTypeDescXmlDir = new File(this.customTypeDescXmlDir, this.cpeDescripterFileName);
        try {
            CpeCollectionReader[] collRdrs;
            this.currentCpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(cpeDescriptor));
            this.rootFolder = new File(this.currentCpeDesc.getSourceUrl().getFile()).getParentFile();
            for (CpeCollectionReader collReader : collRdrs = this.currentCpeDesc.getAllCollectionCollectionReaders()) {
                File descFile = new File(this.rootFolder + System.getProperty("file.separator") + collReader.getDescriptor().getImport().getLocation());
                CollectionReaderDescription crd = UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(descFile));
                TypeSystemDescription typeSystem = crd.getCollectionReaderMetaData().getTypeSystem();
                typeSystem.resolveImports();
                typeSystems.add(typeSystem);
                this.configureReader(collReader, crd, this.externalConfigMap);
            }
            CpeCasProcessors cpeCasProcessors = this.currentCpeDesc.getCpeCasProcessors();
            this.updateProcessorsDescriptorConfigurations(cpeCasProcessors, annotator, typeSystems, this.externalConfigMap);
            this.removeFailedDescriptors(this.currentCpeDesc, new File(cpeDescriptor));
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        this.dynamicTypeGenerator = new DynamicTypeGenerator(typeSystems);
        if (this.compiledClassPath != null) {
            this.dynamicTypeGenerator.setCompiledRootPath(this.compiledClassPath);
        }
        if (this.conceptTypeDefinitions.size() > 0 || lastRunner != null && !annotator.equals(AdaptableCPEDescriptorRunner.lastRunner.annotator)) {
            this.reInitTypeSystem(this.genDescriptorPath);
            this.attachTypeDescriptorToReader();
        }
    }

    public void setCollectionReaderDescriptor(String readerDescriptor, Object ... configs) {
        try {
            CpeCollectionReader reader = CpeDescriptorFactory.produceCollectionReader(readerDescriptor);
            this.currentCpeDesc.setAllCollectionCollectionReaders(new CpeCollectionReader[]{reader});
            this.updateAllReaderDescriptorConfigs(configs);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void setCollectionReaderDescriptor(String readerDescriptor, LinkedHashMap<String, String> configs) {
        try {
            CpeCollectionReader reader = CpeDescriptorFactory.produceCollectionReader(readerDescriptor);
            this.currentCpeDesc.setAllCollectionCollectionReaders(new CpeCollectionReader[]{reader});
            this.updateAllReaderDescriptorConfigs(configs);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void updateAllReaderDescriptorConfigs(LinkedHashMap<String, String> configs) {
        try {
            CpeCollectionReader[] collRdrs;
            for (CpeCollectionReader collReader : collRdrs = this.currentCpeDesc.getAllCollectionCollectionReaders()) {
                for (String paraName : configs.keySet()) {
                    collReader.getConfigurationParameterSettings().setParameterValue(paraName, configs.get(paraName));
                }
            }
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void updateAllReaderDescriptorConfigs(String paraName, Object value) {
        try {
            CpeCollectionReader[] collRdrs;
            for (CpeCollectionReader collReader : collRdrs = this.currentCpeDesc.getAllCollectionCollectionReaders()) {
                collReader.getConfigurationParameterSettings().setParameterValue(paraName, value);
            }
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void updateAllReaderDescriptorConfigs(Object ... configs) {
        try {
            CpeCollectionReader[] collRdrs;
            for (CpeCollectionReader collReader : collRdrs = this.currentCpeDesc.getAllCollectionCollectionReaders()) {
                for (int i = 0; i < configs.length; i += 2) {
                    if (collReader.getConfigurationParameterSettings() == null) {
                        CasProcessorConfigurationParameterSettings aSe = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                        collReader.setConfigurationParameterSettings(aSe);
                    }
                    collReader.getCollectionIterator().getConfigurationParameterSettings().setParameterValue((String)configs[i], configs[i + 1]);
                }
            }
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void attachTypeDescriptorToReader() {
        try {
            CpeCollectionReader reader = this.currentCpeDesc.getAllCollectionCollectionReaders()[0];
            if (reader.getDescriptor().getImport() != null) {
                String readerxml = reader.getDescriptor().getImport().getLocation();
                if (!new File(readerxml).exists()) {
                    readerxml = new File(new File(this.currentCpeDesc.getSourceUrl().getPath()).getParentFile(), readerxml).getAbsolutePath();
                }
                String newReaderXml = this.updateTypeDescriptor(readerxml, this.customTypeDescXmlDir, this.customTypeDescXmlLoc);
                reader.getDescriptor().getImport().setLocation(new File(newReaderXml).toURI().toString());
            } else {
                String readerxml = reader.getDescriptor().getInclude().get();
                if (!new File(readerxml).exists()) {
                    readerxml = new File(new File(this.currentCpeDesc.getSourceUrl().getPath()).getParentFile(), readerxml).getAbsolutePath();
                }
                String newReaderXml = this.updateTypeDescriptor(readerxml, this.customTypeDescXmlDir, this.customTypeDescXmlLoc);
                reader.getDescriptor().getInclude().set(new File(newReaderXml).toURI().toString());
            }
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    protected void configureReader(CpeCollectionReader collReader, CollectionReaderDescription crd, LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap) {
        String readerName = crd.getMetaData().getName();
        if (readerName == null || readerName.equals("")) {
            readerName = crd.getImplementationName();
            readerName = readerName.substring(readerName.lastIndexOf(".") + 1);
        }
        if (!externalConfigMap.containsKey(readerName)) {
            return;
        }
        LinkedHashMap<String, String> paraTypes = new LinkedHashMap<String, String>();
        ConfigurationParameterDeclarations readerParas = crd.getMetaData().getConfigurationParameterDeclarations();
        for (ConfigurationParameter para : readerParas.getConfigurationParameters()) {
            String name = para.getName();
            String type = para.getType();
            paraTypes.put(name, type);
        }
        for (Map.Entry entry : externalConfigMap.get(readerName).entrySet()) {
            String configName = (String)entry.getKey();
            String valueStr = (String)entry.getValue();
            String valueType = (String)paraTypes.get(configName);
            collReader.getConfigurationParameterSettings().setParameterValue(configName, AdaptableCPEDescriptorRunner.convertValueType(valueStr, valueType));
        }
        try {
            collReader.setConfigurationParameterSettings(collReader.getConfigurationParameterSettings());
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    protected String updateTypeDescriptor(String readerxml, File customTypeDescXmlDir, File customTypeDescXmlLoc) {
        File inputFile = new File(readerxml);
        String fileName = this.cpeDescripterFileName + "_" + FilenameUtils.getBaseName(readerxml) + ".xml";
        File outputXmlFile = new File(customTypeDescXmlDir, fileName);
        this.typeXMLAbsolutPath = outputXmlFile.getAbsolutePath();
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        try {
            XMLEventReader eventReader = inFactory.createXMLEventReader(new FileInputStream(inputFile));
            XMLEventWriter writer = factory.createXMLEventWriter(new FileWriter(outputXmlFile));
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                writer.add(e);
                if (!e.isStartElement() || !((StartElement)e).getName().getLocalPart().equalsIgnoreCase("imports")) continue;
                writer.add(eventFactory.createStartElement("", null, "import"));
                writer.add(eventFactory.createAttribute("location", customTypeDescXmlLoc.getName()));
                writer.add(eventFactory.createEndElement("", null, "import"));
            }
            eventReader.close();
            writer.close();
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
        return outputXmlFile.getAbsolutePath();
    }

    protected void updateProcessorsDescriptorConfigurations(CpeCasProcessors cpeCasProcessors, String annotator, ArrayList<TypeSystemDescription> typeSystems, LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap) throws IOException, InvalidXMLException, CpeDescriptorException {
        CpeCasProcessor[] cpeCasProcessorsArray = cpeCasProcessors.getAllCpeCasProcessors();
        int numRemoved = 0;
        for (int i = 0; i < cpeCasProcessorsArray.length; ++i) {
            CpeCasProcessor cp = cpeCasProcessorsArray[i];
            String processorName = cp.getName();
            classLogger.finest("Update configurations for processor: " + processorName);
            File descFile = new File(this.rootFolder + File.separator + cp.getCpeComponentDescriptor().getImport().getLocation());
            AnalysisEngineDescription aed = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(descFile));
            ConfigurationParameterDeclarations aeparas = aed.getMetaData().getConfigurationParameterDeclarations();
            this.aeConfigTypeMap.put(processorName, new LinkedHashMap());
            for (ConfigurationParameter aepara : aeparas.getConfigurationParameters()) {
                String name = aepara.getName();
                String type = aepara.getType();
                this.aeConfigTypeMap.get(processorName).put(name, type);
            }
            String className = aed.getImplementationName();
            Class<? extends JCasAnnotator_ImplBase> aeClass = this.getJCasAnnotatorClassByName(className);
            boolean ruleBasedAE = false;
            Object cpeVersionValue = null;
            if (cp.getConfigurationParameterSettings() != null) {
                cpeVersionValue = cp.getConfigurationParameterSettings().getParameterValue("Version");
            } else {
                CasProcessorConfigurationParameterSettings aSe = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                cp.setConfigurationParameterSettings(aSe);
            }
            Object aeVersionValue = aed.getMetaData().getConfigurationParameterSettings().getParameterValue("Version");
            if (RuleBasedAEInf.class.isAssignableFrom(aeClass)) {
                classLogger.finest("Read the rules for rule processor: " + processorName);
                ruleBasedAE = true;
                if (externalConfigMap.containsKey(processorName) && externalConfigMap.get(processorName).containsKey("RuleFileOrStr") && externalConfigMap.get(processorName).get("RuleFileOrStr").trim().length() == 0) {
                    cpeCasProcessors.removeCpeCasProcessor(i - numRemoved);
                    classLogger.fine("The rule for the Rule-based AE: '" + processorName + "' has been configured to blank, skip this AE.");
                    ++numRemoved;
                    continue;
                }
                Object aeRuleValue = aed.getMetaData().getConfigurationParameterSettings().getParameterValue("RuleFileOrStr");
                Object cpeRuleValue = cp.getConfigurationParameterSettings() == null ? null : cp.getConfigurationParameterSettings().getParameterValue("RuleFileOrStr");
                String externalValue = null;
                if (externalConfigMap.containsKey(processorName) && externalConfigMap.get(processorName).containsKey("RuleFileOrStr")) {
                    externalValue = externalConfigMap.get(processorName).get("RuleFileOrStr");
                }
                if (!(cpeRuleValue != null && !cpeRuleValue.equals("") || aeRuleValue != null && !aeRuleValue.equals("") && (aeRuleValue.toString().indexOf("\t") != -1 || new File(aeRuleValue.toString()).exists()) || externalValue != null && externalValue.trim().length() != 0)) {
                    cpeCasProcessors.removeCpeCasProcessor(i - numRemoved);
                    classLogger.fine("The rule for the Rule-based AE: '" + processorName + "' has not been configured, skip this AE.");
                    ++numRemoved;
                    continue;
                }
                this.ruleBaseAeClassMap.put(processorName, aeClass);
            }
            if (processorName.toLowerCase().indexOf("writer") != -1) {
                this.writerIds.put(processorName, i - numRemoved);
            }
            this.updateProcessorsDescriptorConfigurations(processorName, cp, aed, externalConfigMap.get(processorName));
            if (aeVersionValue != null) {
                if (cpeVersionValue == null || cpeVersionValue.equals("")) {
                    this.versionedCpProcessorId.add(i - numRemoved);
                }
                cp.getConfigurationParameterSettings().setParameterValue("Annotator", annotator);
            }
            this.addAeTypes(aed, typeSystems);
            if (!ruleBasedAE) continue;
            CasProcessorConfigurationParameterSettings settings = cp.getConfigurationParameterSettings();
            if (settings.getParameterValue("RuleFileOrStr") == null) {
                for (NameValuePair namevalue : settings.getParameterSettings()) {
                    if (!namevalue.getName().equals("RuleFileOrStr")) continue;
                    classLogger.finest("Automatically generate types for rule processor: " + processorName);
                    this.addAutoGenTypesForAE(aeClass, namevalue.getValue().toString());
                }
                continue;
            }
            this.addAutoGenTypesForAE(aeClass, cp.getConfigurationParameterSettings().getParameterValue("RuleFileOrStr").toString());
        }
    }

    protected void updateProcessorDescriptorConfigurations(CpeCasProcessor cpeCasProcessor, ArrayList<TypeSystemDescription> typeSystems, LinkedHashMap<String, LinkedHashMap<String, String>> externalConfigMap) throws IOException, InvalidXMLException, CpeDescriptorException {
    }

    public void updateDescriptorConfiguration(int id, String paraName, Object value) {
        try {
            CpeCasProcessor cpeProcessor = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(id);
            if (cpeProcessor.getConfigurationParameterSettings() == null) {
                CasProcessorConfigurationParameterSettings aSe = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                cpeProcessor.setConfigurationParameterSettings(aSe);
            }
            cpeProcessor.getConfigurationParameterSettings().setParameterValue(paraName, value);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void updateReadDescriptorsConfiguration(String paraName, Object value) {
        CpeCollectionReader[] collRdrs = new CpeCollectionReader[]{};
        try {
            for (CpeCollectionReader collReader : collRdrs = this.currentCpeDesc.getAllCollectionCollectionReaders()) {
                collReader.getConfigurationParameterSettings().setParameterValue(paraName, value);
            }
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    protected void updateProcessorsDescriptorConfigurations(CpeCasProcessor cp, AnalysisEngineDescription aed, Object ... configs) {
        for (int i = 0; i < configs.length - 1; i += 2) {
            String paraName = (String)configs[i];
            Object value = configs[i + 1];
            if (cp.getConfigurationParameterSettings() == null) {
                CasProcessorConfigurationParameterSettings aSe = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                try {
                    cp.setConfigurationParameterSettings(aSe);
                }
                catch (CpeDescriptorException e) {
                    e.printStackTrace();
                }
            }
            cp.getConfigurationParameterSettings().setParameterValue(paraName, value);
        }
    }

    protected void updateProcessorsDescriptorConfigurations(String processorName, CpeCasProcessor cp, AnalysisEngineDescription aed, LinkedHashMap<String, String> externalConfigMap) {
        LinkedHashMap<String, String> aeparas = this.aeConfigTypeMap.get(processorName);
        if (externalConfigMap != null) {
            for (Map.Entry<String, String> externalConfigs : externalConfigMap.entrySet()) {
                String configName = externalConfigs.getKey();
                String valueStr = externalConfigs.getValue();
                String valueType = aeparas.get(configName);
                try {
                    cp.getConfigurationParameterSettings().setParameterValue(configName, AdaptableCPEDescriptorRunner.convertValueType(valueStr, valueType));
                }
                catch (Exception e) {
                    classLogger.warning("Incorrect format of configuration value for AE: " + processorName + " parameter: " + configName + " value: " + valueStr + ". Cannot be parsed to type: " + valueType);
                }
            }
        }
    }

    public static Object convertValueType(Object value, String valueType) {
        switch (valueType) {
            case "Integer": {
                try {
                    if (!(value instanceof String)) break;
                    String valueStr = (String)value;
                    value = Integer.parseInt(valueStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "Float": {
                try {
                    if (!(value instanceof String)) break;
                    String valueStr = (String)value;
                    value = Float.valueOf(Float.parseFloat(valueStr));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "Boolean": {
                try {
                    if (!(value instanceof String)) break;
                    String valueStr = (String)value;
                    char ch = valueStr.toLowerCase().charAt(0);
                    value = ch == 't' || ch == '1';
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "Double": {
                try {
                    if (!(value instanceof String)) break;
                    String valueStr = (String)value;
                    value = Double.parseDouble(valueStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "Long": {
                try {
                    if (!(value instanceof String)) break;
                    String valueStr = (String)value;
                    value = Long.parseLong(valueStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "Short": {
                try {
                    if (!(value instanceof String)) break;
                    String valueStr = (String)value;
                    value = Short.parseShort(valueStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "String": {
                if (value instanceof String) break;
                value = value + "";
            }
        }
        return value;
    }

    private void addAeTypes(AnalysisEngineDescription aed, ArrayList<TypeSystemDescription> typeSystems) {
        TypeSystemDescription typeSystem = aed.getAnalysisEngineMetaData().getTypeSystem();
        try {
            typeSystem.resolveImports();
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        typeSystems.add(typeSystem);
    }

    public Class<? extends JCasAnnotator_ImplBase> getJCasAnnotatorClassByName(String className) {
        Class<JCasAnnotator_ImplBase> processorClass = null;
        try {
            processorClass = Class.forName(className).asSubclass(JCasAnnotator_ImplBase.class);
        }
        catch (ClassNotFoundException e) {
            System.err.println("not class for name " + className);
            e.printStackTrace();
        }
        return processorClass;
    }

    public void addAutoGenTypes(LinkedHashMap<String, Class<? extends RuleBasedAEInf>> ruleBaseAeClassMap, LinkedHashMap<String, String> ruleBaseAedefaultConfigRuleMap) {
        for (String name : ruleBaseAeClassMap.keySet()) {
            this.addAutoGenTypesForAE(ruleBaseAeClassMap.get(name), ruleBaseAedefaultConfigRuleMap.get(name));
        }
    }

    public void addAutoGenTypesForAE(Class<? extends RuleBasedAEInf> processClass, String ruleStr) {
        try {
            Constructor<? extends RuleBasedAEInf> constructor = processClass.getConstructor(new Class[0]);
            RuleBasedAEInf instance = constructor.newInstance(new Object[0]);
            LinkedHashMap<String, TypeDefinition> typeDefs = instance.getTypeDefs(ruleStr);
            this.addConceptTypes(typeDefs.values());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void setUIMALogger(UIMALogger logger) {
        this.logger = logger;
        if (logger != null) {
            this.runId = logger.getRunid() + "";
        }
        if (this.writerIds.size() > 0 && this.mCPE != null && this.mCPE.getCasProcessors().length > 0) {
            for (int writerId : this.writerIds.values()) {
                this.updateCpeProcessorConfiguration(writerId, "Version", this.runId);
            }
        }
    }

    public void addConceptType(String conceptName, String superTypeName) {
        TypeDefinition typeDefinition = new TypeDefinition(conceptName, superTypeName);
        this.conceptTypeDefinitions.put(typeDefinition.fullTypeName, typeDefinition);
    }

    public void addConceptType(TypeDefinition typeDefinition) {
        if (this.conceptTypeDefinitions.containsKey(typeDefinition.fullTypeName)) {
            LinkedHashMap<String, String> thisFeatureValuePairs = typeDefinition.getFeatureValuePairs();
            LinkedHashMap<String, String> previousFeatureValuePairs = this.conceptTypeDefinitions.get(typeDefinition.fullTypeName).getFeatureValuePairs();
            for (String featureName : thisFeatureValuePairs.keySet()) {
                if (previousFeatureValuePairs.containsKey(featureName)) continue;
                previousFeatureValuePairs.put(featureName, thisFeatureValuePairs.get(featureName));
            }
        } else {
            this.conceptTypeDefinitions.put(typeDefinition.fullTypeName, typeDefinition);
        }
    }

    public void addConceptTypes(Collection<TypeDefinition> typeDefinitions) {
        for (TypeDefinition typeDefinition : typeDefinitions) {
            this.addConceptType(typeDefinition);
        }
    }

    public void addConceptType(String conceptName, Collection<String> featureNames, String superTypeName) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(featureNames);
        TypeDefinition typeDefinition = new TypeDefinition(conceptName, superTypeName, features);
        this.addConceptType(typeDefinition);
    }

    public void addConceptType(String conceptName) {
        this.addConceptType(conceptName, DeterminantValueSet.defaultSuperTypeName);
    }

    public void addConceptType(String conceptName, Collection<String> featureNames) {
        this.addConceptType(conceptName, featureNames, DeterminantValueSet.defaultSuperTypeName);
    }

    public void reInitTypeSystem(String customTypeDescXml, String srcPath) {
        if (this.customTypeDescXmlDir == null) {
            this.customTypeDescXmlDir = new File("target/generated-test-sources/uima-descripters");
        }
        if (customTypeDescXml == null || customTypeDescXml.trim().length() == 0) {
            if (this.customTypeDescXmlLoc == null) {
                this.customTypeDescXmlLoc = new File(this.customTypeDescXmlDir, this.cpeDescripterFileName + "_Types.xml");
                customTypeDescXml = this.customTypeDescXmlLoc.getAbsolutePath();
            }
        } else {
            this.customTypeDescXmlLoc = new File(customTypeDescXml);
            this.customTypeDescXmlDir = this.customTypeDescXmlLoc.getParentFile();
        }
        if (!this.customTypeDescXmlDir.exists()) {
            try {
                FileUtils.forceMkdir(this.customTypeDescXmlDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TreeSet<String> importedTypes = this.getImportedTypeNames();
        TreeSet<String> redundant = new TreeSet<String>();
        for (String typeFullName : this.conceptTypeDefinitions.keySet()) {
            if (!importedTypes.contains(typeFullName)) continue;
            redundant.add(typeFullName);
        }
        for (String removeTypeName : redundant) {
            this.conceptTypeDefinitions.remove(removeTypeName);
        }
        if (this.conceptTypeDefinitions.size() > 0) {
            this.dynamicTypeGenerator.addConceptTypes(this.conceptTypeDefinitions.values());
            this.dynamicTypeGenerator.reInitTypeSystem(customTypeDescXml, srcPath);
        }
    }

    public void reInitTypeSystem() {
        this.reInitTypeSystem(null, this.srcClassRootPath);
    }

    public void reInitTypeSystem(String customTypeDescXml) {
        this.reInitTypeSystem(customTypeDescXml, this.srcClassRootPath);
    }

    public TreeSet<String> getImportedTypeNames() {
        return this.dynamicTypeGenerator.getImportedTypeNames();
    }

    public void updateProcessorConfigurations(String cpeName, LinkedHashMap configurations) {
        if (this.cpeProcessorIds.containsKey(cpeName)) {
            int id = this.cpeProcessorIds.get(cpeName);
            this.updateProcessorConfigurations(id, configurations);
        } else {
            classLogger.warning(cpeName + " doesn't exist in this CPE descriptor.");
        }
    }

    public void updateProcessorConfigurations(int cpeId, LinkedHashMap configurations) {
        if (this.mCPE != null && cpeId < this.mCPE.getCasProcessors().length) {
            CasProcessor[] processors = this.mCPE.getCasProcessors();
            CasProcessor processor = processors[cpeId];
            try {
                CpeCasProcessor cpeProcessor = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(cpeId);
                String processorName = cpeProcessor.getName();
                if (processor instanceof PrimitiveAnalysisEngine_impl) {
                    PrimitiveAnalysisEngine_impl ae = (PrimitiveAnalysisEngine_impl)processor;
                    UimaContext uimaContext = ae.getUimaContext();
                    LinkedHashMap<String, String> configTypes = this.aeConfigTypeMap.get(processorName);
                    if (uimaContext instanceof ChildUimaContext_impl) {
                        ChildUimaContext_impl uimaContext_impl = (ChildUimaContext_impl)uimaContext;
                        for (Object configName : configurations.keySet()) {
                            Object value = configurations.get(configName);
                            if (!configTypes.containsKey(configName)) {
                                classLogger.info(String.format("Configure parameter %s is not available in processor %s", configName, processorName));
                                continue;
                            }
                            value = AdaptableCPEDescriptorRunner.convertValueType(value, configTypes.get(configName));
                            uimaContext_impl.setSharedParam("/" + processorName + "/" + configName, value);
                            AnalysisComponent aeEngine = ae.getAnalysisComponent();
                            if (configName.equals("RuleFileOrStr") && RuleBasedAEInf.class.isAssignableFrom(aeEngine.getClass())) {
                                RuleBasedAEInf ruleAeEngine = (RuleBasedAEInf)((Object)aeEngine);
                                this.dynamicTypeGenerator.addConceptTypes(ruleAeEngine.getTypeDefs(value.toString()).values());
                                this.dynamicTypeGenerator.reInitTypeSystem(this.customTypeDescXmlLoc.getAbsolutePath(), this.srcClassRootPath);
                                aeEngine.initialize(uimaContext);
                                continue;
                            }
                            if (!((String)configName).toLowerCase().endsWith("file")) continue;
                            aeEngine.initialize(uimaContext);
                        }
                    }
                    ae.setmInitialized(false);
                }
            }
            catch (ResourceInitializationException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            classLogger.warning(cpeId + " doesn't exist in this CPE descriptor.");
        }
    }

    public void updateCpeProcessorConfiguration(String cpeName, String parameter, Object value) {
        if (this.cpeProcessorIds.containsKey(cpeName)) {
            int id = this.cpeProcessorIds.get(cpeName);
            this.updateCpeProcessorConfiguration(id, parameter, value);
        } else {
            classLogger.warning(cpeName + " doesn't exist in this CPE descriptor.");
        }
    }

    public void updateCpeProcessorConfiguration(int cpeId, Object ... configs) {
        if (this.mCPE != null && cpeId < this.mCPE.getCasProcessors().length) {
            CasProcessor processor = this.mCPE.getCasProcessors()[cpeId];
            try {
                CPMEngine cpeEngine = ((CollectionProcessingEngine_impl)this.mCPE).getCPM().getCpEngine();
                CpeCasProcessor cpeProcessor = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(cpeId);
                String processorName = cpeProcessor.getName();
                LinkedHashMap<String, String> configTypes = this.aeConfigTypeMap.get(processorName);
                if (processor instanceof PrimitiveAnalysisEngine_impl) {
                    PrimitiveAnalysisEngine_impl ae = (PrimitiveAnalysisEngine_impl)processor;
                    UimaContext uimaContext = ae.getUimaContext();
                    AnalysisComponent aeEngine = ae.getAnalysisComponent();
                    ae.setmInitialized(false);
                    for (int i = 0; i < configs.length - 1; i += 2) {
                        Object obj = configs[i];
                        if (!(obj instanceof String)) {
                            classLogger.warning("parameter \"" + obj + "\" to set for cpeprocess " + cpeId + " is not a string");
                        }
                        String parameter = (String)configs[i];
                        Object value = configs[i + 1];
                        value = AdaptableCPEDescriptorRunner.convertValueType(value, configTypes.get(parameter));
                        if (uimaContext instanceof ChildUimaContext_impl) {
                            ChildUimaContext_impl uimaContext_impl = (ChildUimaContext_impl)uimaContext;
                            uimaContext_impl.setSharedParam("/" + processorName + "/" + parameter, value);
                        }
                        if (!parameter.equals("RuleFileOrStr") || !RuleBasedAEInf.class.isAssignableFrom(aeEngine.getClass())) continue;
                        RuleBasedAEInf ruleAeEngine = (RuleBasedAEInf)((Object)aeEngine);
                        this.dynamicTypeGenerator.addConceptTypes(ruleAeEngine.getTypeDefs(value.toString()).values());
                        this.dynamicTypeGenerator.reInitTypeSystem(this.customTypeDescXmlLoc.getAbsolutePath(), this.srcClassRootPath);
                    }
                    aeEngine.initialize(uimaContext);
                }
            }
            catch (ResourceInitializationException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            classLogger.warning(cpeId + " doesn't exist in this CPE descriptor.");
        }
    }

    protected void updateCasProcessor(CasProcessor processor, String param, Object value) {
        try {
            if (processor instanceof PrimitiveAnalysisEngine_impl) {
                PrimitiveAnalysisEngine_impl ae = (PrimitiveAnalysisEngine_impl)processor;
                UimaContext uimaContext = ae.getUimaContext();
                AnalysisComponent aeEngine = ae.getAnalysisComponent();
                ae.setmInitialized(false);
                ChildUimaContext_impl uimaContext_impl = (ChildUimaContext_impl)uimaContext;
                uimaContext_impl.setSharedParam("/" + ae.getMetaData().getName() + "/" + param, value);
                aeEngine.initialize(uimaContext_impl);
            }
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCpeProcessorDescriptor(Class aeClass, String name, Object ... configs) {
        try {
            this.addCpeProcessorDescriptor(aeClass, name, this.currentCpeDesc.getCpeCasProcessors().getAllCpeCasProcessors().length, configs);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void addCpeProcessorDescriptor(Class aeClass, String name, int pos, Object ... configs) {
        try {
            AnalysisEngineDescription aed = AnalysisEngineFactory.createEngineDescription((Class<? extends AnalysisComponent>)aeClass, configs);
            CpeIntegratedCasProcessor cp = AdaptableCPEDescriptorRunner.createProcessor(name, aed);
            this.currentCpeDesc.getCpeCasProcessors().addCpeCasProcessor(cp, pos);
            this.updateProcessorsDescriptorConfigurations(cp, aed, configs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
    }

    public void addCpeProcessorDescriptor(String descriptorPath, int pos, Object ... configs) {
        File descFile = new File(descriptorPath);
        try {
            AnalysisEngineDescription aed = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(descFile));
            String name = aed.getAnalysisEngineMetaData().getName();
            CpeIntegratedCasProcessor cp = AdaptableCPEDescriptorRunner.createProcessor(name, aed);
            this.currentCpeDesc.getCpeCasProcessors().addCpeCasProcessor(cp, pos);
            this.cpeProcessorIds.put(name, pos);
            this.updateCpeProcessorConfiguration(pos, configs);
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void addCpeProcessorDescriptor(String descriptorPath, String name, Object ... configs) {
        try {
            this.addCpeProcessorDescriptor(descriptorPath, name, this.currentCpeDesc.getCpeCasProcessors().getAllCpeCasProcessors().length, configs);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public void addCpeProcessorDescriptor(String descriptorPath, String name, int pos, Object ... configs) {
        File descFile = new File(descriptorPath);
        try {
            AnalysisEngineDescription aed = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(descFile));
            CpeIntegratedCasProcessor cp = AdaptableCPEDescriptorRunner.createProcessor(name, aed);
            this.currentCpeDesc.getCpeCasProcessors().addCpeCasProcessor(cp, pos);
            this.cpeProcessorIds.put(name, pos);
            this.updateProcessorsDescriptorConfigurations(cp, aed, configs);
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void addCpeProcessorDescriptor(String name, AnalysisEngineDescription aDesc, int pos, Object ... configs) {
        try {
            CpeCasProcessors cpeCasProcessors = this.currentCpeDesc.getCpeCasProcessors();
            CpeIntegratedCasProcessor processor = AdaptableCPEDescriptorRunner.createProcessor(name, aDesc);
            cpeCasProcessors.addCpeCasProcessor(processor, pos);
            this.cpeProcessorIds.put(name, pos);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeCpeProcessDescriptor(String cpeName) {
        this.removeCpeProcessDescriptor(this.cpeProcessorIds.get(cpeName));
    }

    public void removeCpeProcessDescriptor(int id) {
        try {
            this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(id);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    public Set<String> getCpeProcessorNames() {
        return this.cpeProcessorIds.keySet();
    }

    public void compileCPE() {
        try {
            if (this.runId.equals(this.previousRunId)) {
                this.runId = this.logger != null ? this.logger.getRunid() + "" : "999999";
            }
            this.mCPE = UIMAFramework.produceCollectionProcessingEngine(this.currentCpeDesc);
            Class<CompositeResourceFactory> e = CompositeResourceFactory.class;
            Iterator<Integer> iterator2 = this.writerIds.values().iterator();
            while (iterator2.hasNext()) {
                int writerId = (Integer)iterator2.next();
                this.updateCpeProcessorConfiguration(writerId, "Version", this.runId);
            }
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        this.refreshed = false;
        int i = 0;
        for (CasProcessor casProcessor : this.mCPE.getCasProcessors()) {
            String name = casProcessor.getProcessingResourceMetaData().getName();
            this.cpeProcessorIds.put(name, i);
            ++i;
        }
    }

    public void run() {
        try {
            if (this.status == 1) {
                classLogger.fine("Pipeline is running. Please wait till finish.");
                return;
            }
            this.status = 1;
            this.compileCPE();
            this.statCbL = new SimpleStatusCallbackListenerImpl(this.logger);
            this.mCPE.addStatusCallbackListener(this.statCbL);
            this.statCbL.setRunner(this);
            this.statCbL.setCollectionProcessingEngine(this.mCPE);
            this.mCPE.process();
            this.previousRunId = this.runId;
        }
        catch (UIMAException e) {
            e.printStackTrace();
        }
    }

    public TypeSystemDescription getTypeSystemDescription() {
        return this.dynamicTypeGenerator.getTypeSystemDescription();
    }

    public JCas initJCas() {
        JCas jCas = null;
        try {
            jCas = CasCreationUtils.createCas(this.dynamicTypeGenerator.getTypeSystemDescription(), null, null).getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        return jCas;
    }

    public void removeFailedDescriptors(CpeDescription currentCpeDesc, File aFile) {
        int numFailed = 0;
        try {
            CpeCasProcessor[] casProcs = currentCpeDesc.getCpeCasProcessors().getAllCpeCasProcessors();
            for (int i = 0; i < casProcs.length; ++i) {
                boolean success = true;
                try {
                    URL specifierUrl = casProcs[i].getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
                    ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(specifierUrl));
                    success = this.isCasConsumerSpecifier(specifier) ? this.tryLoadConsumer(casProcs[i]) : this.tryLoadAE(casProcs[i]);
                }
                catch (Exception e) {
                    this.displayError("Error loading CPE Descriptor " + aFile.getPath());
                    e.printStackTrace();
                    success = false;
                }
                if (success) continue;
                currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(i - numFailed);
                ++numFailed;
            }
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    protected boolean isCasConsumerSpecifier(ResourceSpecifier specifier) {
        if (specifier instanceof CasConsumerDescription) {
            return true;
        }
        if (specifier instanceof URISpecifier) {
            URISpecifier uriSpec = (URISpecifier)specifier;
            return "CasConsumer".equals(uriSpec.getResourceType());
        }
        return false;
    }

    protected boolean tryLoadConsumer(CpeCasProcessor cpeCasProc) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        String tabName;
        File f;
        URL consumerSpecifierUrl = cpeCasProc.getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
        if (!"file".equals(consumerSpecifierUrl.getProtocol())) {
            this.displayError("Could not load descriptor from URL " + consumerSpecifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
            return false;
        }
        try {
            f = this.urlToFile(consumerSpecifierUrl);
        }
        catch (URISyntaxException e) {
            this.displayError(e.toString());
            return false;
        }
        long fileModStamp = f.lastModified();
        XMLInputSource consumerInputSource = new XMLInputSource(consumerSpecifierUrl);
        ResourceSpecifier casConsumerSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(consumerInputSource);
        if (casConsumerSpecifier instanceof CasConsumerDescription) {
            ProcessingResourceMetaData md = ((CasConsumerDescription)casConsumerSpecifier).getCasConsumerMetaData();
            tabName = md.getName();
        } else {
            tabName = f.getName();
        }
        cpeCasProc.setName(tabName);
        return true;
    }

    protected boolean tryLoadAE(CpeCasProcessor cpeCasProc) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        File f;
        URL aeSpecifierUrl = cpeCasProc.getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
        String name = cpeCasProc.getName();
        if (!"file".equals(aeSpecifierUrl.getProtocol())) {
            this.displayError("Could not load descriptor from URL " + aeSpecifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
            return false;
        }
        try {
            f = this.urlToFile(aeSpecifierUrl);
        }
        catch (URISyntaxException e) {
            this.displayError(e.toString());
            return false;
        }
        long fileModStamp = f.lastModified();
        XMLInputSource aeInputSource = new XMLInputSource(aeSpecifierUrl);
        ResourceSpecifier aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(aeInputSource);
        cpeCasProc.setName(name);
        return true;
    }

    protected File urlToFile(URL url) throws URISyntaxException {
        return new File(UriUtils.quote(url));
    }

    protected void displayError(String msg) {
        System.err.println(msg);
    }

    public LinkedHashMap<String, Integer> getWriterIds() {
        return this.writerIds;
    }

    public UIMALogger getLogger() {
        return this.logger;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    protected static LinkedHashMap<String, String> readPipelineConfigurations(LinkedHashMap<String, SettingAb> pipelineSettings) {
        LinkedHashMap<String, String> componentsSettings = new LinkedHashMap<String, String>();
        for (SettingAb setting : pipelineSettings.values()) {
            String[] componentConfigure = setting.getSettingName().split("/");
            if (componentConfigure.length < 3) continue;
            String key = componentConfigure[1] + "/" + componentConfigure[2];
            String value = setting.getSettingValue();
            componentsSettings.put(key, value);
        }
        return componentsSettings;
    }

    public LinkedHashMap<String, Integer> getCpeProcessorIds() {
        return this.cpeProcessorIds;
    }

    private static CpeIntegratedCasProcessor createProcessor(String key, AnalysisEngineDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
        URL descUrl = AdaptableCPEDescriptorRunner.materializeDescriptor(aDesc).toURI().toURL();
        CpeInclude cpeInclude = UIMAFramework.getResourceSpecifierFactory().createInclude();
        cpeInclude.set(descUrl.toString());
        CpeComponentDescriptor ccd = UIMAFramework.getResourceSpecifierFactory().createDescriptor();
        ccd.setInclude(cpeInclude);
        CpeIntegratedCasProcessor proc = CpeDescriptorFactory.produceCasProcessor(key);
        proc.setCpeComponentDescriptor(ccd);
        proc.setAttributeValue("1", 1);
        proc.setActionOnMaxError(ACTION_ON_MAX_ERROR);
        proc.setMaxErrorCount(0);
        return proc;
    }

    private static File materializeDescriptor(ResourceSpecifier resource) throws IOException, SAXException {
        File tempDesc = File.createTempFile("desc", ".xml");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempDesc), "UTF-8"));
        resource.toXML(out);
        out.close();
        return tempDesc;
    }
}

