/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import edu.utah.bmi.nlp.uima.DynamicTypeGenerator;
import edu.utah.bmi.nlp.uima.SimpleStatusCallbackListenerImpl;
import edu.utah.bmi.nlp.uima.StatusSetable;
import edu.utah.bmi.nlp.uima.loggers.UIMALogger;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.UriUtils;
import org.apache.uima.util.XMLInputSource;

public class AdaptableUIMACPEDescriptorRunner
implements StatusSetable {
    protected CollectionReaderDescription reader;
    protected CpeDescription currentCpeDesc;
    protected File rootFolder;
    protected ArrayList<AnalysisEngineDescription> analysisEngines = new ArrayList();
    protected DynamicTypeGenerator dynamicTypeGenerator;
    protected String srcClassRootPath = null;
    protected UIMALogger logger;
    protected final ResourceManager defaultResourceManager = UIMAFramework.newDefaultResourceManager();
    protected CollectionProcessingEngine mCPE;
    protected long mInitCompleteTime;
    protected int totaldocs = -1;
    public int maxCommentLength = 500;
    protected int status = 0;

    protected AdaptableUIMACPEDescriptorRunner() {
    }

    public AdaptableUIMACPEDescriptorRunner(String cpeDescriptor) {
        this.init(cpeDescriptor);
    }

    public AdaptableUIMACPEDescriptorRunner(String cpeDescriptor, String compileRootPath) {
        this.init(cpeDescriptor, compileRootPath);
    }

    public AdaptableUIMACPEDescriptorRunner(String cpeDescriptor, String compileRootPath, String srcClassRootPath) {
        this.init(cpeDescriptor, compileRootPath, srcClassRootPath);
    }

    public void init(String ... settings) {
        switch (settings.length) {
            case 0: {
                new Throwable("Not CPE descriptor is specified");
                break;
            }
            case 1: {
                this.initTypeDescriptor(settings[0]);
                break;
            }
            case 2: {
                this.dynamicTypeGenerator.setCompiledRootPath(new File(settings[1]));
                this.initTypeDescriptor(settings[0]);
                break;
            }
            default: {
                this.dynamicTypeGenerator.setCompiledRootPath(new File(settings[1]));
                this.srcClassRootPath = settings[2];
                this.initTypeDescriptor(settings[0]);
            }
        }
    }

    public void initTypeDescriptor(String cpeDescriptor) {
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        try {
            CpeCasProcessor[] cpeCasProcessors;
            CpeCollectionReader[] collRdrs;
            this.currentCpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(cpeDescriptor));
            this.removeFailedDescriptors(new File(cpeDescriptor));
            File rootFolder = new File(this.currentCpeDesc.getSourceUrl().getFile()).getParentFile();
            for (CpeCollectionReader collReader : collRdrs = this.currentCpeDesc.getAllCollectionCollectionReaders()) {
                File descFile = new File(rootFolder + System.getProperty("file.separator") + collReader.getDescriptor().getImport().getLocation());
                CollectionReaderDescription crd = UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(descFile));
                TypeSystemDescription typeSystem = crd.getCollectionReaderMetaData().getTypeSystem();
                typeSystem.resolveImports();
                typeSystems.add(typeSystem);
            }
            for (CpeCasProcessor casProcessor : cpeCasProcessors = this.currentCpeDesc.getCpeCasProcessors().getAllCpeCasProcessors()) {
                File descFile = new File(rootFolder + System.getProperty("file.separator") + casProcessor.getCpeComponentDescriptor().getImport().getLocation());
                AnalysisEngineDescription aed = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(descFile));
                TypeSystemDescription typeSystem = aed.getAnalysisEngineMetaData().getTypeSystem();
                typeSystem.resolveImports();
                typeSystems.add(typeSystem);
            }
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        this.dynamicTypeGenerator = new DynamicTypeGenerator(typeSystems);
    }

    public void setLogger(UIMALogger logger) {
        this.logger = logger;
    }

    public void addConceptType(String conceptName) {
        this.dynamicTypeGenerator.addConceptType(conceptName);
    }

    public void addConceptType(String conceptName, Collection<String> featureNames) {
        this.dynamicTypeGenerator.addConceptType(conceptName, featureNames);
    }

    public void addConceptType(String conceptName, String superTypeName) {
        this.dynamicTypeGenerator.addConceptType(conceptName, superTypeName);
    }

    public void addConceptType(String conceptName, Collection<String> featureNames, String superTypeName) {
        this.dynamicTypeGenerator.addConceptType(conceptName, featureNames, superTypeName);
    }

    public void reInitTypeSystem(String customTypeDescXml, String srcPath) {
        this.dynamicTypeGenerator.reInitTypeSystem(customTypeDescXml, srcPath);
    }

    public void reInitTypeSystem(String customTypeDescXml) {
        this.dynamicTypeGenerator.reInitTypeSystem(customTypeDescXml, this.srcClassRootPath);
    }

    public TreeSet<String> getImportedTypeNames() {
        return this.dynamicTypeGenerator.getImportedTypeNames();
    }

    public void run() {
        try {
            this.mCPE = null;
            this.mCPE = UIMAFramework.produceCollectionProcessingEngine(this.currentCpeDesc);
            SimpleStatusCallbackListenerImpl statCbL = new SimpleStatusCallbackListenerImpl(this.logger);
            this.mCPE.addStatusCallbackListener(statCbL);
            statCbL.setCollectionProcessingEngine(this.mCPE);
            this.mCPE.process();
        }
        catch (UIMAException e) {
            e.printStackTrace();
        }
    }

    public TypeSystemDescription getTypeSystemDescription() {
        return this.dynamicTypeGenerator.getTypeSystemDescription();
    }

    public JCas initJCas() {
        JCas jCas = null;
        try {
            jCas = CasCreationUtils.createCas(this.dynamicTypeGenerator.getTypeSystemDescription(), null, null).getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        return jCas;
    }

    public void removeFailedDescriptors(File aFile) {
        int numFailed = 0;
        try {
            CpeCasProcessor[] casProcs = this.currentCpeDesc.getCpeCasProcessors().getAllCpeCasProcessors();
            for (int i = 0; i < casProcs.length; ++i) {
                boolean success = true;
                try {
                    URL specifierUrl = casProcs[i].getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
                    ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(specifierUrl));
                    success = this.isCasConsumerSpecifier(specifier) ? this.addConsumer(casProcs[i]) : this.addAE(casProcs[i]);
                }
                catch (Exception e) {
                    this.displayError("Error loading CPE Descriptor " + aFile.getPath());
                    e.printStackTrace();
                    success = false;
                }
                if (success) continue;
                this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(i - numFailed);
                ++numFailed;
            }
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
    }

    private boolean isCasConsumerSpecifier(ResourceSpecifier specifier) {
        if (specifier instanceof CasConsumerDescription) {
            return true;
        }
        if (specifier instanceof URISpecifier) {
            URISpecifier uriSpec = (URISpecifier)specifier;
            return "CasConsumer".equals(uriSpec.getResourceType());
        }
        return false;
    }

    private boolean addConsumer(CpeCasProcessor cpeCasProc) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        String tabName;
        File f;
        URL consumerSpecifierUrl = cpeCasProc.getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
        if (!"file".equals(consumerSpecifierUrl.getProtocol())) {
            this.displayError("Could not load descriptor from URL " + consumerSpecifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
            return false;
        }
        try {
            f = this.urlToFile(consumerSpecifierUrl);
        }
        catch (URISyntaxException e) {
            this.displayError(e.toString());
            return false;
        }
        long fileModStamp = f.lastModified();
        XMLInputSource consumerInputSource = new XMLInputSource(consumerSpecifierUrl);
        ResourceSpecifier casConsumerSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(consumerInputSource);
        if (casConsumerSpecifier instanceof CasConsumerDescription) {
            ProcessingResourceMetaData md = ((CasConsumerDescription)casConsumerSpecifier).getCasConsumerMetaData();
            tabName = md.getName();
        } else {
            tabName = f.getName();
        }
        cpeCasProc.setName(tabName);
        return true;
    }

    private boolean addAE(CpeCasProcessor cpeCasProc) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        String tabName;
        File f;
        URL aeSpecifierUrl = cpeCasProc.getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
        if (!"file".equals(aeSpecifierUrl.getProtocol())) {
            this.displayError("Could not load descriptor from URL " + aeSpecifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
            return false;
        }
        try {
            f = this.urlToFile(aeSpecifierUrl);
        }
        catch (URISyntaxException e) {
            this.displayError(e.toString());
            return false;
        }
        long fileModStamp = f.lastModified();
        XMLInputSource aeInputSource = new XMLInputSource(aeSpecifierUrl);
        ResourceSpecifier aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(aeInputSource);
        if (aeSpecifier instanceof AnalysisEngineDescription) {
            AnalysisEngineDescription aeDescription = (AnalysisEngineDescription)aeSpecifier;
            ResourceMetaData md = aeDescription.getMetaData();
            tabName = md.getName();
        } else {
            tabName = f.getName();
        }
        cpeCasProc.setName(tabName);
        return true;
    }

    private File urlToFile(URL url) throws URISyntaxException {
        return new File(UriUtils.quote(url));
    }

    protected void displayError(String msg) {
        System.err.println(msg);
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return 0;
    }
}

