/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.DynamicTypeGenerator;
import edu.utah.bmi.nlp.uima.SimpleStatusCallbackListenerImpl;
import edu.utah.bmi.nlp.uima.loggers.UIMALogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.fit.cpe.CpeBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.xml.sax.SAXException;

public class AdaptableUIMACPERunner {
    protected CollectionReaderDescription reader;
    protected ArrayList<AnalysisEngineDescription> analysisEngineDescriptors = new ArrayList();
    protected DynamicTypeGenerator dynamicTypeGenerator;
    protected LinkedHashMap<String, TypeDefinition> conceptTypeDefinitions = new LinkedHashMap();
    protected CollectionProcessingEngine engine;
    protected String srcClassRootPath = null;
    protected UIMALogger logger;

    public AdaptableUIMACPERunner() {
    }

    public AdaptableUIMACPERunner(String typeDescriptorURI) {
        this.dynamicTypeGenerator = new DynamicTypeGenerator(typeDescriptorURI);
    }

    public AdaptableUIMACPERunner(String typeDescriptorURI, String compileRootPath) {
        this.dynamicTypeGenerator = new DynamicTypeGenerator(typeDescriptorURI);
        this.dynamicTypeGenerator.setCompiledRootPath(compileRootPath);
    }

    public AdaptableUIMACPERunner(String typeDescriptorURI, String compileRootPath, String srcClassRootPath) {
        this.dynamicTypeGenerator = new DynamicTypeGenerator(typeDescriptorURI);
        this.dynamicTypeGenerator.setCompiledRootPath(compileRootPath);
        this.srcClassRootPath = srcClassRootPath;
    }

    public void setLogger(UIMALogger logger) {
        this.logger = logger;
    }

    public void addConceptType(String conceptName, String superTypeName) {
        TypeDefinition typeDefinition = new TypeDefinition(conceptName, superTypeName);
        this.conceptTypeDefinitions.put(typeDefinition.fullTypeName, typeDefinition);
    }

    public void addConceptType(TypeDefinition typeDefinition) {
        if (this.conceptTypeDefinitions.containsKey(typeDefinition.fullTypeName)) {
            LinkedHashMap<String, String> thisFeatureValuePairs = typeDefinition.getFeatureValuePairs();
            LinkedHashMap<String, String> previousFeatureValuePairs = this.conceptTypeDefinitions.get(typeDefinition.fullTypeName).getFeatureValuePairs();
            for (String featureName : thisFeatureValuePairs.keySet()) {
                if (previousFeatureValuePairs.containsKey(featureName)) continue;
                previousFeatureValuePairs.put(featureName, thisFeatureValuePairs.get(featureName));
            }
        } else {
            this.conceptTypeDefinitions.put(typeDefinition.fullTypeName, typeDefinition);
        }
    }

    public void addConceptTypes(Collection<TypeDefinition> typeDefinitions) {
        for (TypeDefinition typeDefinition : typeDefinitions) {
            this.addConceptType(typeDefinition);
        }
    }

    public void addConceptType(String conceptName, Collection<String> featureNames, String superTypeName) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(featureNames);
        TypeDefinition typeDefinition = new TypeDefinition(conceptName, superTypeName, features);
        this.addConceptType(typeDefinition);
    }

    public void addConceptType(String conceptName) {
        this.addConceptType(conceptName, DeterminantValueSet.defaultSuperTypeName);
    }

    public void addConceptType(String conceptName, Collection<String> featureNames) {
        this.addConceptType(conceptName, featureNames, DeterminantValueSet.defaultSuperTypeName);
    }

    public void reInitTypeSystem(String customTypeDescXml, String srcPath) {
        TreeSet<String> importedTypes = this.getImportedTypeNames();
        TreeSet<String> redundant = new TreeSet<String>();
        for (String typeFullName : this.conceptTypeDefinitions.keySet()) {
            if (!importedTypes.contains(typeFullName)) continue;
            redundant.add(typeFullName);
        }
        for (String removeTypeName : redundant) {
            this.conceptTypeDefinitions.remove(removeTypeName);
        }
        if (this.conceptTypeDefinitions.size() > 0) {
            this.dynamicTypeGenerator.addConceptTypes(this.conceptTypeDefinitions.values());
            this.dynamicTypeGenerator.reInitTypeSystem(customTypeDescXml, srcPath);
        }
    }

    public void reInitTypeSystem(String customTypeDescXml) {
        this.reInitTypeSystem(customTypeDescXml, this.srcClassRootPath);
    }

    public TreeSet<String> getImportedTypeNames() {
        return this.dynamicTypeGenerator.getImportedTypeNames();
    }

    public void setCollectionReader(Class readerClass, Object[] configurations) {
        try {
            this.reader = CollectionReaderFactory.createReaderDescription((Class<? extends CollectionReader>)readerClass, this.dynamicTypeGenerator.getTypeSystemDescription(), configurations);
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
    }

    public void addAnalysisEngine(Class analysisEngineClass, Object[] configurations) {
        try {
            this.analysisEngineDescriptors.add(AnalysisEngineFactory.createEngineDescription((Class<? extends AnalysisComponent>)analysisEngineClass, configurations));
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
    }

    public void removeAnalysisEngine(int index) {
        this.analysisEngineDescriptors.remove(index);
    }

    public void addAnalysisEngine(AnalysisEngineDescription analysisEngineDescription) {
        this.analysisEngineDescriptors.add(analysisEngineDescription);
    }

    public TypeSystemDescription getTypeSystemDescription() {
        return this.dynamicTypeGenerator.getTypeSystemDescription();
    }

    public JCas initJCas() {
        JCas jCas = null;
        try {
            jCas = CasCreationUtils.createCas(this.dynamicTypeGenerator.getTypeSystemDescription(), null, null).getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        return jCas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            AnalysisEngineDescription aaeDesc = this.createEngineDescription(this.analysisEngineDescriptors);
            CpeBuilder builder = new CpeBuilder();
            builder.setReader(this.reader);
            builder.setAnalysisEngine(aaeDesc);
            builder.setMaxProcessingUnitThreadCount(Runtime.getRuntime().availableProcessors() - 1);
            SimpleStatusCallbackListenerImpl status = new SimpleStatusCallbackListenerImpl(this.logger);
            builder.setMaxProcessingUnitThreadCount(0);
            this.engine = builder.createCpe(status);
            status.setCollectionProcessingEngine(this.engine);
            this.engine.process();
            try {
                SimpleStatusCallbackListenerImpl simpleStatusCallbackListenerImpl = status;
                synchronized (simpleStatusCallbackListenerImpl) {
                    while (status.isProcessing) {
                        status.wait();
                    }
                    System.out.println("Pipeline complete");
                }
            }
            catch (InterruptedException var9) {
                var9.printStackTrace();
            }
            if (status.exceptions.size() > 0) {
                throw new AnalysisEngineProcessException(status.exceptions.get(0));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        catch (AnalysisEngineProcessException e) {
            e.printStackTrace();
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
    }

    public AnalysisEngineDescription createEngineDescription(List<AnalysisEngineDescription> analysisEngineDescriptions) throws ResourceInitializationException {
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(false);
        boolean allowMultipleDeploy = true;
        for (AnalysisEngineDescription d : analysisEngineDescriptions) {
            allowMultipleDeploy &= d.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
        }
        desc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(allowMultipleDeploy);
        ArrayList<String> flowNames = new ArrayList<String>();
        for (int i = 0; i < analysisEngineDescriptions.size(); ++i) {
            AnalysisEngineDescription aed = analysisEngineDescriptions.get(i);
            String componentName = aed.getImplementationName() + "-" + i;
            desc.getDelegateAnalysisEngineSpecifiersWithImports().put(componentName, aed);
            flowNames.add(componentName);
        }
        FixedFlow_impl fixedFlow = new FixedFlow_impl();
        fixedFlow.setFixedFlow(flowNames.toArray(new String[flowNames.size()]));
        desc.getAnalysisEngineMetaData().setFlowConstraints(fixedFlow);
        return desc;
    }
}

