/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import edu.utah.bmi.nlp.uima.SimpleStatusCallbackListenerImpl;
import edu.utah.bmi.nlp.uima.loggers.UIMALogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.fit.cpe.CpeBuilder;
import org.apache.uima.resource.ResourceInitializationException;
import org.xml.sax.SAXException;

public final class CpePipeline {
    private UIMALogger logger;
    private long mInitCompleteTime;
    private CollectionProcessingEngine engine;
    public int maxCommentLength = 500;

    public CpePipeline(UIMALogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPipeline(CollectionReaderDescription readerDesc, List<AnalysisEngineDescription> descs) throws UIMAException, SAXException, CpeDescriptorException, IOException {
        AnalysisEngineDescription aaeDesc = this.createEngineDescription(descs);
        this.logger = this.logger;
        CpeBuilder builder = new CpeBuilder();
        builder.setReader(readerDesc);
        builder.setAnalysisEngine(aaeDesc);
        builder.setMaxProcessingUnitThreadCount(Runtime.getRuntime().availableProcessors() - 1);
        SimpleStatusCallbackListenerImpl status = new SimpleStatusCallbackListenerImpl(this.logger);
        builder.setMaxProcessingUnitThreadCount(0);
        this.engine = builder.createCpe(status);
        status.setCollectionProcessingEngine(this.engine);
        this.engine.process();
        try {
            SimpleStatusCallbackListenerImpl simpleStatusCallbackListenerImpl = status;
            synchronized (simpleStatusCallbackListenerImpl) {
                while (status.isProcessing) {
                    status.wait();
                }
                System.out.println("Pipeline complete");
            }
        }
        catch (InterruptedException var9) {
            var9.printStackTrace();
        }
        if (status.exceptions.size() > 0) {
            throw new AnalysisEngineProcessException(status.exceptions.get(0));
        }
    }

    public AnalysisEngineDescription createEngineDescription(List<AnalysisEngineDescription> analysisEngineDescriptions) throws ResourceInitializationException {
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(false);
        boolean allowMultipleDeploy = true;
        for (AnalysisEngineDescription d : analysisEngineDescriptions) {
            allowMultipleDeploy &= d.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
        }
        desc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(allowMultipleDeploy);
        ArrayList<String> flowNames = new ArrayList<String>();
        for (int i = 0; i < analysisEngineDescriptions.size(); ++i) {
            AnalysisEngineDescription aed = analysisEngineDescriptions.get(i);
            String componentName = aed.getImplementationName() + "-" + i;
            desc.getDelegateAnalysisEngineSpecifiersWithImports().put(componentName, aed);
            flowNames.add(componentName);
        }
        FixedFlow_impl fixedFlow = new FixedFlow_impl();
        fixedFlow.setFixedFlow(flowNames.toArray(new String[flowNames.size()]));
        desc.getAnalysisEngineMetaData().setFlowConstraints(fixedFlow);
        return desc;
    }
}

