/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import edu.utah.bmi.nlp.compiler.MemoryJavaCompiler;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.jcas.JcasGen;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.FeatureDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.xml.sax.SAXException;

public class DynamicTypeGenerator {
    private static Logger logger = IOUtil.getLogger(DynamicTypeGenerator.class);
    protected TypeSystemDescription typeSystemDescription;
    protected HashSet<String> compiledTypes = new HashSet();
    protected HashSet<String> toBeCompiledTypes;
    public File compiledRootPath = new File("classes");
    private MemoryJavaCompiler compiler = new MemoryJavaCompiler(this.compiledRootPath);
    private HashMap<String, HashSet<String>> superTypefeatureNamesCache = new HashMap();
    @Deprecated
    public boolean debug = false;

    public DynamicTypeGenerator(String ... descriptorNames) {
        this.initTypeSystem(descriptorNames);
    }

    public void setCompiledRootPath(File compiledRootPath) {
        this.compiledRootPath = compiledRootPath;
        if (!compiledRootPath.exists()) {
            try {
                FileUtils.forceMkdir(compiledRootPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.compiler = new MemoryJavaCompiler(compiledRootPath);
    }

    public void setCompiledRootPath(String path) {
        this.setCompiledRootPath(new File(path));
    }

    public DynamicTypeGenerator(TypeSystemDescription typeSystemDescription) {
        try {
            JCas jCas = CasCreationUtils.createCas(typeSystemDescription, null, null).getJCas();
            this.typeSystemDescription = typeSystemDescription;
            this.toBeCompiledTypes = new HashSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public DynamicTypeGenerator(ArrayList<TypeSystemDescription> typeSystemDescriptions) {
        try {
            TypeSystemDescription mergedTypeSystem;
            this.typeSystemDescription = mergedTypeSystem = CasCreationUtils.mergeTypeSystems(typeSystemDescriptions);
            JCas jCas = CasCreationUtils.createCas(mergedTypeSystem, null, null).getJCas();
            this.toBeCompiledTypes = new HashSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void initTypeSystem(String ... descriptorNames) {
        try {
            this.compiler.addClassPath();
            boolean nameIsPath = false;
            for (int i = 0; i < descriptorNames.length; ++i) {
                if (!descriptorNames[i].endsWith(".xml")) continue;
                nameIsPath = true;
                descriptorNames[i] = new File(descriptorNames[i]).getAbsolutePath();
            }
            this.typeSystemDescription = nameIsPath ? TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath(descriptorNames) : TypeSystemDescriptionFactory.createTypeSystemDescription(descriptorNames);
            JCas jCas = CasCreationUtils.createCas(this.typeSystemDescription, null, null).getJCas();
            this.toBeCompiledTypes = new HashSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public TypeSystemDescription getTypeSystemDescription() {
        return this.typeSystemDescription;
    }

    public TreeSet<String> getImportedTypeNames() {
        TreeSet<String> typeNames = new TreeSet<String>();
        for (TypeDescription typeDescription : this.typeSystemDescription.getTypes()) {
            typeNames.add(typeDescription.getName());
        }
        return typeNames;
    }

    public void addConceptTypes(Collection<TypeDefinition> typeDefinitions) {
        for (TypeDefinition typeDefinition : typeDefinitions) {
            this.addConceptType(typeDefinition);
        }
    }

    public void addConceptType(TypeDefinition typeDefinition) {
        this.addConceptType(typeDefinition.getFullTypeName(), typeDefinition.getNewFeatureNames(), typeDefinition.getFullSuperTypeName(), typeDefinition.featureTypes);
    }

    public void addConceptType(String conceptName, String superTypeName) {
        conceptName = DeterminantValueSet.checkNameSpace(conceptName);
        this.addConceptType(conceptName, new ArrayList<String>(), superTypeName, new HashMap<String, String>());
    }

    public void addConceptType(String conceptName) {
        this.addConceptType(conceptName, DeterminantValueSet.defaultSuperTypeName);
    }

    public void addConceptType(String conceptName, Collection<String> featureNames) {
        this.addConceptType(conceptName, featureNames, DeterminantValueSet.defaultSuperTypeName, new HashMap<String, String>());
    }

    public void addConceptType(String conceptName, Collection<String> featureNames, String superTypeName) {
        this.addConceptType(conceptName, featureNames, superTypeName, new HashMap<String, String>());
    }

    public void addConceptType(String conceptName, Collection<String> featureNames, String superTypeName, HashMap<String, String> featureTypes) {
        conceptName = DeterminantValueSet.checkNameSpace(conceptName);
        superTypeName = DeterminantValueSet.checkNameSpace(superTypeName);
        if (this.compiledTypes.contains(conceptName)) {
            return;
        }
        boolean loaded = AnnotationOper.classLoaded(conceptName);
        if (!this.toBeCompiledTypes.contains(conceptName)) {
            this.typeSystemDescription.addType(conceptName, "an automatic generated concept type", superTypeName);
            if (featureNames != null && featureNames.size() > 0) {
                featureNames = this.filterFeatureNames(superTypeName, featureNames);
                TypeDescription type = this.typeSystemDescription.getType(conceptName);
                FeatureDescription[] aFeatures = new FeatureDescription[featureNames.size()];
                int i = 0;
                for (String featureName : featureNames) {
                    if (featureTypes.containsKey(featureName) && featureTypes.get(featureName) != null && featureTypes.get(featureName).trim().length() > 0) {
                        String featureType = featureTypes.get(featureName);
                        if (featureType.indexOf(":") == -1) {
                            aFeatures[i] = new FeatureDescription_impl(featureName, "Automatic generated Type", featureType);
                        } else {
                            String[] typeElementType = featureType.split(":");
                            featureType = typeElementType[0].trim();
                            String elementType = typeElementType[1].trim();
                            aFeatures[i] = new FeatureDescription_impl(featureName, "Automatic generated Type", featureType, elementType, true);
                        }
                    } else {
                        aFeatures[i] = new FeatureDescription_impl(featureName, "Automatic generated Type", "uima.cas.String");
                    }
                    ++i;
                }
                type.setFeatures(aFeatures);
            }
            if (loaded) {
                this.compiledTypes.add(conceptName);
            } else {
                this.toBeCompiledTypes.add(conceptName);
            }
        }
    }

    private Collection<String> filterFeatureNames(String superTypeName, Collection<String> featureNames) {
        ArrayList<String> filteredFeatureNames = new ArrayList<String>();
        if (!this.superTypefeatureNamesCache.containsKey(superTypeName)) {
            this.superTypefeatureNamesCache.put(superTypeName, new HashSet());
            Class<? extends Annotation> superTypeClass = AnnotationOper.getTypeClass(superTypeName);
            if (superTypeClass != null) {
                for (String featureName : featureNames) {
                    if (AnnotationOper.getDefaultGetMethod(superTypeClass, featureName) == null) continue;
                    if (featureName.startsWith("get")) {
                        featureName = featureName.substring(3);
                    }
                    this.superTypefeatureNamesCache.get(superTypeName).add(featureName);
                }
            } else {
                logger.warning(superTypeName + " has not been initiated or loaded into memory.");
            }
        }
        for (String featureName : featureNames) {
            if (this.superTypefeatureNamesCache.get(superTypeName).contains(featureName)) continue;
            filteredFeatureNames.add(featureName);
        }
        return filteredFeatureNames;
    }

    public void reInitTypeSystem(String customTypeDescXml, String srcPath) {
        File srcDir;
        this.superTypefeatureNamesCache.clear();
        if (srcPath != null && !(srcDir = new File(srcPath)).exists()) {
            try {
                FileUtils.forceMkdir(srcDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setCompiledRootPath(this.compiledRootPath);
        if (this.toBeCompiledTypes.size() > 0) {
            HashMap<String, String> classSrcs = this.genTypeDescriptorNClasses(customTypeDescXml, srcPath, false);
            for (Map.Entry<String, String> entry : classSrcs.entrySet()) {
                if (this.compiledTypes.contains(DeterminantValueSet.checkNameSpace(entry.getKey()))) continue;
                this.compiler.addClassSrc(entry.getKey(), entry.getValue());
                this.compiledTypes.add(DeterminantValueSet.checkNameSpace(entry.getKey()));
            }
            try {
                Map<String, Class> classes = this.compiler.compileBatchToSystem();
                if (logger.isLoggable(Level.FINE)) {
                    for (String type : classes.keySet()) {
                        logger.fine(type + " loaded " + AnnotationOper.classLoaded(type));
                    }
                }
            }
            catch (Exception e) {
                logger.warning("Fail to compile new types.");
            }
            this.toBeCompiledTypes.clear();
        } else {
            this.writeTypeDescriptorXML(customTypeDescXml);
        }
    }

    public void writeTypeDescriptorXML(String customTypeDescXml) {
        try {
            this.typeSystemDescription.toXML(new FileWriter(customTypeDescXml));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, String> genTypeDescriptorNClasses(String customTypeDescXml, String srcPath, boolean classOnly) {
        if (!customTypeDescXml.toLowerCase().endsWith(".xml")) {
            customTypeDescXml = customTypeDescXml + ".xml";
        }
        if (!classOnly) {
            this.writeTypeDescriptorXML(customTypeDescXml);
        }
        HashMap<String, String> classes = srcPath == null ? new JcasGen().main(customTypeDescXml, this.toBeCompiledTypes, new String[0]) : new JcasGen().main(customTypeDescXml, this.toBeCompiledTypes, srcPath);
        return classes;
    }
}

