/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import edu.utah.bmi.nlp.uima.MyCasAnnotationViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.internal.util.BrowserUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.tools.docanalyzer.PrefsMediator;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.stylemap.ColorParser;
import org.apache.uima.tools.stylemap.StyleMapEditor;
import org.apache.uima.tools.stylemap.StyleMapEntry;
import org.apache.uima.tools.util.gui.Caption;
import org.apache.uima.tools.util.gui.SpringUtilities;
import org.apache.uima.tools.util.htmlview.AnnotationViewGenerator;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasToInlineXml;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XmlCasDeserializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class MyAnnotationViewerDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -7259891069111863433L;
    private File tempDir = this.createTempDir();
    protected AnnotationViewGenerator annotationViewGenerator;
    private StyleMapEditor styleMapEditor;
    private PrefsMediator med1;
    private File styleMapFile;
    JList analyzedResultsList;
    String inputDirPath = null;
    TypeSystem typeSystem = null;
    String[] typesToDisplay = null;
    JRadioButton javaViewerRB = null;
    JRadioButton javaViewerUCRB = null;
    JRadioButton htmlRB = null;
    JRadioButton xmlRB = null;
    private CAS cas;
    private boolean processedStyleMap = false;
    private String defaultCasViewName = "_InitialView";
    private MyCasAnnotationViewer viewerPanel;

    public MyAnnotationViewerDialog(JFrame aParentFrame, String aDialogTitle, PrefsMediator med, File aStyleMapFile, String aPerformanceStats, TypeSystem aTypeSystem, String[] aTypesToDisplay, String interactiveTempFN, boolean javaViewerRBisSelected, boolean javaViewerUCRBisSelected, boolean xmlRBisSelected, CAS cas) {
        super((Frame)aParentFrame, aDialogTitle);
        this.med1 = med;
        this.cas = cas;
        this.annotationViewGenerator = new AnnotationViewGenerator(this.tempDir);
        this.launchThatViewer(med.getOutputDir(), interactiveTempFN, aTypeSystem, aTypesToDisplay, javaViewerRBisSelected, javaViewerUCRBisSelected, xmlRBisSelected, aStyleMapFile, this.tempDir);
    }

    public MyAnnotationViewerDialog(JFrame aParentFrame, String aDialogTitle, PrefsMediator med, File aStyleMapFile, String aPerformanceStats, TypeSystem aTypeSystem, String[] aTypesToDisplay, boolean generatedStyleMap, CAS cas) {
        super((Frame)aParentFrame, aDialogTitle);
        this.med1 = med;
        this.cas = cas;
        this.styleMapFile = aStyleMapFile;
        final String performanceStats = aPerformanceStats;
        this.typeSystem = aTypeSystem;
        this.typesToDisplay = aTypesToDisplay;
        this.annotationViewGenerator = new AnnotationViewGenerator(this.tempDir);
        this.styleMapEditor = new StyleMapEditor(aParentFrame, cas);
        JPanel resultsTitlePanel = new JPanel();
        resultsTitlePanel.setLayout(new BoxLayout(resultsTitlePanel, 1));
        resultsTitlePanel.add(new JLabel("These are the Analyzed Documents."));
        resultsTitlePanel.add(new JLabel("Select viewer type and double-click file to open."));
        this.inputDirPath = med.getOutputDir();
        File dir = new File(this.inputDirPath);
        InteractiveFilter iFilter = new InteractiveFilter();
        Object[] documents = dir.list(iFilter);
        Arrays.sort(documents);
        if (documents == null) {
            documents = new String[]{};
        }
        this.analyzedResultsList = new JList<Object>(documents);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.analyzedResultsList);
        JPanel southernPanel = new JPanel();
        southernPanel.setLayout(new BoxLayout(southernPanel, 1));
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new SpringLayout());
        Caption displayFormatLabel = new Caption("Results Display Format:");
        controlsPanel.add(displayFormatLabel);
        JPanel displayFormatPanel = new JPanel();
        displayFormatPanel.setLayout(new FlowLayout(0));
        displayFormatPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.javaViewerRB = new JRadioButton("Java Viewer");
        this.javaViewerUCRB = new JRadioButton("JV user colors");
        this.htmlRB = new JRadioButton("HTML");
        this.xmlRB = new JRadioButton("XML");
        ButtonGroup displayFormatButtonGroup = new ButtonGroup();
        displayFormatButtonGroup.add(this.javaViewerRB);
        displayFormatButtonGroup.add(this.javaViewerUCRB);
        displayFormatButtonGroup.add(this.htmlRB);
        displayFormatButtonGroup.add(this.xmlRB);
        this.javaViewerRB.setSelected(true);
        if ("Java Viewer".equals(med.getViewType())) {
            this.javaViewerRB.setSelected(true);
        } else if ("JV User Colors".equals(med.getViewType())) {
            this.javaViewerUCRB.setSelected(true);
        } else if ("HTML".equals(med.getViewType())) {
            this.htmlRB.setSelected(true);
        } else if ("XML".equals(med.getViewType())) {
            this.xmlRB.setSelected(true);
        }
        displayFormatPanel.add(this.javaViewerRB);
        displayFormatPanel.add(this.javaViewerUCRB);
        displayFormatPanel.add(this.htmlRB);
        displayFormatPanel.add(this.xmlRB);
        controlsPanel.add(displayFormatPanel);
        SpringUtilities.makeCompactGrid(controlsPanel, 1, 2, 4, 4, 0, 0);
        JButton editStyleMapButton = new JButton("Edit Style Map");
        editStyleMapButton.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add(editStyleMapButton);
        if (performanceStats != null) {
            JButton perfStatsButton = new JButton("Performance Stats");
            perfStatsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JOptionPane.showMessageDialog((Component)ae.getSource(), performanceStats, null, -1);
                }
            });
            buttonsPanel.add(perfStatsButton);
        }
        JButton closeButton = new JButton("Close");
        buttonsPanel.add(closeButton);
        southernPanel.add(buttonsPanel);
        JPanel listPanel = new JPanel();
        this.getContentPane().add((Component)listPanel, "West");
        listPanel.setLayout(new BorderLayout(0, 0));
        this.analyzedResultsList = new JList<Object>(documents);
        listPanel.add((Component)scrollPane, "Center");
        scrollPane.setViewportView(this.analyzedResultsList);
        this.analyzedResultsList.setCellRenderer(new MyListCellRenderer());
        listPanel.add((Component)southernPanel, "South");
        this.viewerPanel = new MyCasAnnotationViewer();
        this.getContentPane().add((Component)this.viewerPanel, "Center");
        JSplitPane splitPane = new JSplitPane(1, listPanel, this.viewerPanel);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)controlsPanel, "North");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MyAnnotationViewerDialog.this.setVisible(false);
            }
        });
        this.setDefaultCloseOperation(2);
        MyAnnotationViewerDialog.setLF();
        this.analyzedResultsList.setCellRenderer(new MyListCellRenderer());
        ListMouseAdapter mouseListener = new ListMouseAdapter();
        this.analyzedResultsList.addMouseListener(mouseListener);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String styleMapXml = null;
        AnalysisEngineDescription selectedAE = null;
        try {
            if (this.styleMapFile.exists()) {
                styleMapXml = FileUtils.file2String(this.styleMapFile);
            }
            if (selectedAE == null) {
                selectedAE = this.promptForAE();
            }
            if (selectedAE != null) {
                this.styleMapEditor.setAnalysisEngine(selectedAE);
                String newStyleMap = this.styleMapEditor.launchEditor(selectedAE.getAnalysisEngineMetaData(), styleMapXml, this.cas);
                if (newStyleMap != null) {
                    this.styleMapFile = this.med1.getStylemapFile();
                    FileWriter writer = new FileWriter(this.styleMapFile);
                    writer.write(newStyleMap);
                    writer.close();
                    this.annotationViewGenerator.processStyleMap(this.styleMapFile);
                }
            }
        }
        catch (Exception e) {
            this.displayError(e);
        }
    }

    public String getDefaultCasViewName() {
        return this.defaultCasViewName;
    }

    public void setDefaultCasViewName(String defaultCasViewName) {
        this.defaultCasViewName = defaultCasViewName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchThatViewer(String inputDirPath, String fileName, TypeSystem typeSystem, String[] aTypesToDisplay, boolean javaViewerRBisSelected, boolean javaViewerUCRBisSelected, boolean xmlRBisSelected, File styleMapFile, File viewerDirectory) {
        try {
            File xcasFile = new File(inputDirPath, fileName);
            CAS cas = CasCreationUtils.createCas((Collection<? extends MetaDataObject>)Collections.EMPTY_LIST, typeSystem, UIMAFramework.getDefaultPerformanceTuningProperties());
            try (FileInputStream xcasInStream = null;){
                xcasInStream = new FileInputStream(xcasFile);
                XmlCasDeserializer.deserialize(xcasInStream, cas, true);
            }
            cas = cas.getView(this.defaultCasViewName);
            if (javaViewerRBisSelected || javaViewerUCRBisSelected) {
                this.med1.setViewType(javaViewerRBisSelected ? "Java Viewer" : "JV User Colors");
                this.viewerPanel.setDisplayedTypes(aTypesToDisplay);
                if (javaViewerUCRBisSelected) {
                    this.getColorsForTypesFromFile(this.viewerPanel, styleMapFile);
                } else {
                    this.viewerPanel.setHiddenTypes(new String[]{"uima.cpm.FileLocation"});
                }
                this.viewerPanel.setCAS(cas);
            } else {
                CAS defaultView = cas.getView("_InitialView");
                if (defaultView.getDocumentText() == null) {
                    this.displayError("The HTML and XML Viewers can only view the default text document, which was not found in this CAS.");
                    return;
                }
                File inlineXmlFile = new File(viewerDirectory, "inline.xml");
                CasToInlineXml casToInlineXml = new CasToInlineXml();
                casToInlineXml.setFormattedOutput(false);
                String xmlAnnotations = casToInlineXml.generateXML(defaultView);
                FileOutputStream outStream = new FileOutputStream(inlineXmlFile);
                outStream.write(xmlAnnotations.getBytes("UTF-8"));
                outStream.close();
                if (xmlRBisSelected) {
                    this.med1.setViewType("XML");
                    BrowserUtil.openUrlInDefaultBrowser(inlineXmlFile.getAbsolutePath());
                } else {
                    this.med1.setViewType("HTML");
                    if (!this.processedStyleMap) {
                        if (!styleMapFile.exists()) {
                            this.annotationViewGenerator.autoGenerateStyleMapFile(this.promptForAE().getAnalysisEngineMetaData(), styleMapFile);
                        }
                        this.annotationViewGenerator.processStyleMap(styleMapFile);
                        this.processedStyleMap = true;
                    }
                    this.annotationViewGenerator.processDocument(inlineXmlFile);
                    File genFile = new File(viewerDirectory, "index.html");
                    BrowserUtil.openUrlInDefaultBrowser(genFile.getAbsolutePath());
                }
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public static String getTextValue(Node node) {
        Node first = node.getFirstChild();
        if (first != null) {
            Text text = (Text)node.getFirstChild();
            return text.getNodeValue().trim();
        }
        return null;
    }

    public static Node getFirstChildByName(Node node, String name) {
        NodeList children = node.getChildNodes();
        for (int c = 0; c < children.getLength(); ++c) {
            Node n = children.item(c);
            if (!n.getNodeName().equals(name)) continue;
            return n;
        }
        return null;
    }

    public void getColorsForTypesFromFile(MyCasAnnotationViewer viewer, File aStyleMapFile) {
        ArrayList<Color> colorList = new ArrayList<Color>();
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> notCheckedList = new ArrayList<String>();
        ArrayList<String> hiddenList = new ArrayList<String>();
        hiddenList.add("uima.cpm.FileLocation");
        if (aStyleMapFile.exists()) {
            FileInputStream stream = null;
            Document parse = null;
            try {
                stream = new FileInputStream(aStyleMapFile);
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parse = db.parse(stream);
            }
            catch (FileNotFoundException e) {
                throw new UIMARuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new UIMARuntimeException(e);
            }
            catch (FactoryConfigurationError e) {
                throw new UIMARuntimeException(e);
            }
            catch (SAXException e) {
                throw new UIMARuntimeException(e);
            }
            catch (IOException e) {
                throw new UIMARuntimeException(e);
            }
            Element node0 = parse.getDocumentElement();
            NodeList nodeList = node0.getChildNodes();
            ColorParser cParser = new ColorParser();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String nodeName = node.getNodeName();
                if (!nodeName.equals("rule")) continue;
                NodeList childrenList = node.getChildNodes();
                String type = "";
                String label = "";
                StyleMapEntry sme = null;
                String colorText = "";
                for (int j = 0; j < childrenList.getLength(); ++j) {
                    Node child = childrenList.item(j);
                    String childName = child.getNodeName();
                    if (childName.equals("pattern")) {
                        type = MyAnnotationViewerDialog.getTextValue(child);
                    }
                    if (childName.equals("label")) {
                        label = MyAnnotationViewerDialog.getTextValue(child);
                    }
                    if (!childName.equals("style")) continue;
                    colorText = MyAnnotationViewerDialog.getTextValue(child);
                }
                sme = cParser.parseAndAssignColors(type, label, label, colorText);
                if (!sme.getChecked()) {
                    notCheckedList.add(sme.getAnnotationTypeName());
                }
                if (!sme.getHidden()) {
                    colorList.add(sme.getBackground());
                    typeList.add(sme.getAnnotationTypeName());
                    continue;
                }
                hiddenList.add(sme.getAnnotationTypeName());
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            viewer.assignColorsFromList(colorList, typeList);
            viewer.assignCheckedFromList(notCheckedList);
            String[] hiddenArr = new String[hiddenList.size()];
            hiddenList.toArray(hiddenArr);
            viewer.setHiddenTypes(hiddenArr);
        }
    }

    public void displayError(String aErrorString) {
        StringBuffer buf = new StringBuffer(aErrorString.length());
        int CHARS_PER_LINE = 80;
        int charCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(aErrorString, " \n", true);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("\n")) {
                buf.append("\n");
                charCount = 0;
                continue;
            }
            if (charCount > 0 && charCount + tok.length() > 80) {
                buf.append("\n").append(tok);
                charCount = tok.length();
                continue;
            }
            buf.append(tok);
            charCount += tok.length();
        }
        JOptionPane.showMessageDialog(this, buf.toString(), "Error", 0);
    }

    public void displayError(Throwable aThrowable) {
        aThrowable.printStackTrace();
        String message = aThrowable.toString();
        while (aThrowable instanceof UIMAException || aThrowable instanceof UIMARuntimeException) {
            if (aThrowable instanceof UIMAException) {
                aThrowable = aThrowable.getCause();
            } else if (aThrowable instanceof UIMARuntimeException) {
                aThrowable = aThrowable.getCause();
            }
            if (aThrowable == null) continue;
            message = message + "\nCausedBy: " + aThrowable.toString();
        }
        this.displayError(message);
    }

    protected AnalysisEngineDescription promptForAE() throws IOException, InvalidXMLException, ResourceInitializationException {
        if (this.med1.getTAEfile() != null) {
            File taeFile = new File(this.med1.getTAEfile());
            XMLInputSource in = new XMLInputSource(taeFile);
            AnalysisEngineDescription aed = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(in);
            return aed;
        }
        String taeDir = this.med1.getTAEfile();
        JFileChooser chooser = new JFileChooser(taeDir);
        chooser.setDialogTitle("Select the Analysis Engine that Generated this Output");
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            XMLInputSource in = new XMLInputSource(chooser.getSelectedFile());
            return UIMAFramework.getXMLParser().parseAnalysisEngineDescription(in);
        }
        return null;
    }

    private static void setLF() {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
        }
        catch (Exception exc) {
            System.err.println("Error loading " + laf + ": " + exc);
        }
    }

    private File createTempDir() {
        File temp = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
        temp.mkdir();
        return temp;
    }

    class ListMouseAdapter
    extends MouseAdapter {
        ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                String fileName;
                if (e.getClickCount() == 1 && (fileName = (String)MyAnnotationViewerDialog.this.analyzedResultsList.getSelectedValue()) != null) {
                    MyAnnotationViewerDialog.this.analyzedResultsList.setCursor(Cursor.getPredefinedCursor(3));
                    MyAnnotationViewerDialog.this.launchThatViewer(MyAnnotationViewerDialog.this.inputDirPath, fileName, MyAnnotationViewerDialog.this.typeSystem, MyAnnotationViewerDialog.this.typesToDisplay, MyAnnotationViewerDialog.this.javaViewerRB.isSelected(), MyAnnotationViewerDialog.this.javaViewerUCRB.isSelected(), MyAnnotationViewerDialog.this.xmlRB.isSelected(), MyAnnotationViewerDialog.this.styleMapFile, MyAnnotationViewerDialog.this.tempDir);
                    MyAnnotationViewerDialog.this.analyzedResultsList.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Exception ex) {
                MyAnnotationViewerDialog.this.displayError(ex);
            }
        }
    }

    static class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 7231915634689270693L;

        public MyListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList analyzedResultsList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon xmlIcon = Images.getImageIcon("/org/apache/uima/tools/images/xml_16.gif");
            this.setIcon(xmlIcon);
            this.setText(value.toString());
            this.setBackground(isSelected ? Color.orange : Color.white);
            this.setForeground(isSelected ? Color.black : Color.black);
            return this;
        }
    }

    static class InteractiveFilter
    implements FilenameFilter {
        InteractiveFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.equals("interactive_temp")) {
                return false;
            }
            return !name.equals("interactive_out");
        }
    }
}

