/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.viewer.EntityResolver;

public class MyCasAnnotationViewer
extends JPanel {
    private static final long serialVersionUID = 3559118488371946999L;
    private static final short MODE_ANNOTATIONS = 0;
    private static final short MODE_ENTITIES = 1;
    private static final short MODE_FEATURES = 2;
    private static String[] DEFAULT_HIDDEN_FEATURES = new String[]{"sofa"};
    private static final float BRIGHT = 0.95f;
    private static final Color[] COLORS = new Color[]{Color.getHSBColor(0.15277778f, 0.25f, 0.95f), Color.getHSBColor(0.0f, 0.25f, 0.95f), Color.getHSBColor(0.5833333f, 0.25f, 0.95f), Color.getHSBColor(0.33333334f, 0.25f, 0.95f), Color.getHSBColor(0.8055556f, 0.25f, 0.95f), Color.getHSBColor(0.083333336f, 0.25f, 0.95f), Color.getHSBColor(0.22222222f, 0.25f, 0.95f), Color.getHSBColor(0.9166667f, 0.25f, 0.95f), Color.getHSBColor(0.44444445f, 0.25f, 0.95f), Color.getHSBColor(0.6944444f, 0.25f, 0.95f), Color.getHSBColor(0.15277778f, 0.5f, 0.95f), Color.getHSBColor(0.0f, 0.5f, 0.95f), Color.getHSBColor(0.5833333f, 0.5f, 0.95f), Color.getHSBColor(0.33333334f, 0.5f, 0.95f), Color.getHSBColor(0.8055556f, 0.5f, 0.95f), Color.getHSBColor(0.083333336f, 0.5f, 0.95f), Color.getHSBColor(0.22222222f, 0.5f, 0.95f), Color.getHSBColor(0.9166667f, 0.5f, 0.95f), Color.getHSBColor(0.44444445f, 0.5f, 0.95f), Color.getHSBColor(0.6944444f, 0.5f, 0.95f), Color.getHSBColor(0.15277778f, 0.75f, 0.95f), Color.getHSBColor(0.0f, 0.75f, 0.95f), Color.getHSBColor(0.5833333f, 0.75f, 0.95f), Color.getHSBColor(0.33333334f, 0.75f, 0.95f), Color.getHSBColor(0.8055556f, 0.75f, 0.95f), Color.getHSBColor(0.083333336f, 0.75f, 0.95f), Color.getHSBColor(0.22222222f, 0.75f, 0.95f), Color.getHSBColor(0.9166667f, 0.75f, 0.95f), Color.getHSBColor(0.44444445f, 0.75f, 0.95f), Color.getHSBColor(0.6944444f, 0.75f, 0.95f)};
    private CAS cas;
    private TypeSystem typeSystem;
    private Type stringType;
    private Type fsArrayType;
    private boolean useConsistentColors = true;
    private List<String> highFrequencyTypes = new ArrayList<String>();
    private String[] boldFaceKeyWords = new String[0];
    private int[] boldFaceSpans = new int[0];
    private Set<String> hiddenFeatureNames = new HashSet<String>();
    private Set<String> hiddenTypeNames = new HashSet<String>();
    private Set<String> displayedTypeNames;
    private Set<String> initiallySelectedTypeNames;
    private boolean hideUnselectedCheckBoxes;
    private List<String> userTypes = new ArrayList<String>();
    private Set<String> typesNotChecked = new HashSet<String>();
    private Map<String, Color> typeColorMap = new HashMap<String, Color>();
    private Map<String, Color> featureColorMap = new HashMap<String, Color>();
    private EntityResolver entityResolver = new DefaultEntityResolver();
    private short viewMode = 0;
    private Map<Type, JCheckBox> typeToCheckBoxMap = new HashMap<Type, JCheckBox>();
    private Map<EntityResolver.Entity, JCheckBox> entityToCheckBoxMap = new HashMap<EntityResolver.Entity, JCheckBox>();
    private JSplitPane horizontalSplitPane;
    private JSplitPane verticalSplitPane;
    private JTextPane textPane;
    private JScrollPane textScrollPane;
    private Map<Type, JRadioButton> typeRadioButtonMap = new HashMap<Type, JRadioButton>();
    private Map<String, JRadioButton> featureRadioButtonMap = new HashMap<String, JRadioButton>();
    private Map<String, JCheckBox> featureValueCheckBoxMap = new HashMap<String, JCheckBox>();
    private Map<String, Color> featureValueColorMap = new HashMap<String, Color>();
    private JButton showHideUnselectedButton;
    private JTree selectedAnnotationTree;
    private DefaultTreeModel selectedAnnotationTreeModel;
    private JRadioButton annotationModeButton;
    private JRadioButton entityModeButton;
    private JRadioButton featureModeButton;
    private JPanel sofaSelectionPanel;
    private JComboBox sofaSelectionComboBox;
    private JTabbedPane tabbedChoicePane;
    private JScrollPane typeCheckBoxScrollPane;
    private VerticallyScrollablePanel typeCheckBoxVerticalScrollPanel;
    private JScrollPane entityCheckBoxScrollPane;
    private VerticallyScrollablePanel entityCheckBoxVerticalScrollPanel;
    private JScrollPane typeRadioButtonScrollPane;
    private VerticallyScrollablePanel typeRadioButtonVerticalScrollPanel;
    private JScrollPane featureRadioButtonScrollPane;
    private VerticallyScrollablePanel featureRadioButtonVerticalScrollPanel;
    private JScrollPane featureValueCheckBoxScrollPane;
    private VerticallyScrollablePanel featureValueCheckBoxVerticalScrollPanel;

    public MyCasAnnotationViewer() {
        this.setLayout(new BorderLayout());
        this.createHorizontalSplitPane();
        this.add((Component)this.horizontalSplitPane, "Center");
        this.add((Component)this.createControlPanel(), "South");
        this.hiddenFeatureNames.addAll(Arrays.asList(DEFAULT_HIDDEN_FEATURES));
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        controlPanel.add((Component)this.createViewPanel(), "Center");
        controlPanel.add((Component)this.createSelectButtonPanel(), "South");
        return controlPanel;
    }

    private JPanel createSelectButtonPanel() {
        JPanel selectButtonPanel = new JPanel();
        selectButtonPanel.add(this.createSelectAllButton());
        selectButtonPanel.add(this.createDeselectAllButton());
        this.createShowHideUnselectedButton();
        selectButtonPanel.add(this.showHideUnselectedButton);
        return selectButtonPanel;
    }

    private JPanel createViewPanel() {
        JPanel viewPanel = new JPanel();
        viewPanel.setLayout(new BorderLayout());
        this.createSofaSelectionPanel();
        viewPanel.add((Component)this.sofaSelectionPanel, "North");
        viewPanel.add((Component)this.createViewModePanel(), "Center");
        return viewPanel;
    }

    private JPanel createViewModePanel() {
        JPanel viewModePanel = new JPanel();
        viewModePanel.add(new JLabel("Mode: "));
        this.createAnnotationModeButton();
        viewModePanel.add(this.annotationModeButton);
        this.createFeatureModeButton();
        viewModePanel.add(this.featureModeButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.annotationModeButton);
        group.add(this.featureModeButton);
        return viewModePanel;
    }

    private void createFeatureModeButton() {
        this.featureModeButton = new JRadioButton("Features", this.viewMode == 2);
        this.featureModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton radioButton = (JRadioButton)e.getSource();
                if (!radioButton.isSelected() || MyCasAnnotationViewer.this.viewMode == 2) {
                    return;
                }
                MyCasAnnotationViewer.this.viewMode = (short)2;
                MyCasAnnotationViewer.this.resetTabbedPane();
                MyCasAnnotationViewer.this.display();
            }
        });
    }

    private void createEntityModeButton() {
        this.entityModeButton = new JRadioButton("Entities", this.viewMode == 1);
        this.entityModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton radioButton = (JRadioButton)e.getSource();
                if (!radioButton.isSelected() || MyCasAnnotationViewer.this.viewMode == 1) {
                    return;
                }
                MyCasAnnotationViewer.this.viewMode = (short)1;
                MyCasAnnotationViewer.this.resetTabbedPane();
                MyCasAnnotationViewer.this.display();
            }
        });
    }

    private void createAnnotationModeButton() {
        this.annotationModeButton = new JRadioButton("Annotations", this.viewMode == 0);
        this.annotationModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton radioButton = (JRadioButton)e.getSource();
                if (!radioButton.isSelected() || MyCasAnnotationViewer.this.viewMode == 0) {
                    return;
                }
                MyCasAnnotationViewer.this.viewMode = (short)0;
                MyCasAnnotationViewer.this.resetTabbedPane();
                MyCasAnnotationViewer.this.display();
            }
        });
    }

    private void createSofaSelectionPanel() {
        this.sofaSelectionPanel = new JPanel();
        this.sofaSelectionPanel.add(new JLabel("Sofa:"));
        this.createSofaSelectionComboBox();
        this.sofaSelectionPanel.add(this.sofaSelectionComboBox);
    }

    private void createSofaSelectionComboBox() {
        this.sofaSelectionComboBox = new JComboBox();
        this.sofaSelectionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CAS newCas;
                if (e.getSource() != MyCasAnnotationViewer.this.sofaSelectionComboBox || MyCasAnnotationViewer.this.cas == null) {
                    return;
                }
                String sofaId = (String)e.getItem();
                CAS cAS = newCas = "DEFAULT".equalsIgnoreCase(sofaId) ? MyCasAnnotationViewer.this.cas.getView("_InitialView") : MyCasAnnotationViewer.this.cas.getView(sofaId);
                if (newCas != MyCasAnnotationViewer.this.cas) {
                    MyCasAnnotationViewer.this.setCAS(newCas);
                }
            }
        });
    }

    private void createShowHideUnselectedButton() {
        this.showHideUnselectedButton = new JButton("Hide Unselected");
        this.showHideUnselectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyCasAnnotationViewer.this.hideUnselectedCheckBoxes = !MyCasAnnotationViewer.this.hideUnselectedCheckBoxes;
                switch (MyCasAnnotationViewer.this.viewMode) {
                    case 0: {
                        if (MyCasAnnotationViewer.this.typeToCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox typeCheckBox : MyCasAnnotationViewer.this.typeToCheckBoxMap.values()) {
                            if (typeCheckBox.isSelected()) continue;
                            needRefresh = true;
                            break;
                        }
                        if (!needRefresh) break;
                        if (MyCasAnnotationViewer.this.typeCheckBoxVerticalScrollPanel != null) {
                            MyCasAnnotationViewer.this.typeCheckBoxVerticalScrollPanel.removeAll();
                        }
                        MyCasAnnotationViewer.this.display();
                        break;
                    }
                    case 1: {
                        if (MyCasAnnotationViewer.this.entityToCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox entityCheckBox : MyCasAnnotationViewer.this.entityToCheckBoxMap.values()) {
                            if (entityCheckBox.isSelected()) continue;
                            needRefresh = true;
                            break;
                        }
                        if (!needRefresh) break;
                        if (MyCasAnnotationViewer.this.entityCheckBoxVerticalScrollPanel != null) {
                            MyCasAnnotationViewer.this.entityCheckBoxVerticalScrollPanel.removeAll();
                        }
                        MyCasAnnotationViewer.this.display();
                        break;
                    }
                    case 2: {
                        if (MyCasAnnotationViewer.this.featureValueCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox featureValueCheckBox : MyCasAnnotationViewer.this.featureValueCheckBoxMap.values()) {
                            if (featureValueCheckBox.isSelected()) continue;
                            needRefresh = true;
                            break;
                        }
                        if (!needRefresh) break;
                        if (MyCasAnnotationViewer.this.featureValueCheckBoxVerticalScrollPanel != null) {
                            MyCasAnnotationViewer.this.featureValueCheckBoxVerticalScrollPanel.removeAll();
                        }
                        MyCasAnnotationViewer.this.display();
                        MyCasAnnotationViewer.this.tabbedChoicePane.setSelectedIndex(2);
                        break;
                    }
                }
            }
        });
    }

    private JButton createDeselectAllButton() {
        JButton deselectAllButton = new JButton("Deselect All");
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MyCasAnnotationViewer.this.viewMode) {
                    case 0: {
                        if (MyCasAnnotationViewer.this.typeToCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox typeCheckBox : MyCasAnnotationViewer.this.typeToCheckBoxMap.values()) {
                            if (!typeCheckBox.isSelected()) continue;
                            typeCheckBox.setSelected(false);
                            needRefresh = true;
                        }
                        if (!needRefresh) break;
                        MyCasAnnotationViewer.this.display();
                        break;
                    }
                    case 1: {
                        if (MyCasAnnotationViewer.this.entityToCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox entityCheckBox : MyCasAnnotationViewer.this.entityToCheckBoxMap.values()) {
                            if (!entityCheckBox.isSelected()) continue;
                            entityCheckBox.setSelected(false);
                            needRefresh = true;
                        }
                        if (!needRefresh) break;
                        MyCasAnnotationViewer.this.display();
                        break;
                    }
                    case 2: {
                        if (MyCasAnnotationViewer.this.featureValueCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox featureValueCheckBox : MyCasAnnotationViewer.this.featureValueCheckBoxMap.values()) {
                            if (!featureValueCheckBox.isSelected()) continue;
                            featureValueCheckBox.setSelected(false);
                            needRefresh = true;
                        }
                        if (!needRefresh) break;
                        MyCasAnnotationViewer.this.display();
                        MyCasAnnotationViewer.this.tabbedChoicePane.setSelectedIndex(2);
                        break;
                    }
                }
            }
        });
        return deselectAllButton;
    }

    private JButton createSelectAllButton() {
        JButton selectAllButton = new JButton("Select All");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MyCasAnnotationViewer.this.viewMode) {
                    case 0: {
                        if (MyCasAnnotationViewer.this.typeToCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox typeCheckBox : MyCasAnnotationViewer.this.typeToCheckBoxMap.values()) {
                            if (typeCheckBox.isSelected()) continue;
                            typeCheckBox.setSelected(true);
                            needRefresh = true;
                        }
                        if (!needRefresh) break;
                        MyCasAnnotationViewer.this.display();
                        break;
                    }
                    case 1: {
                        if (MyCasAnnotationViewer.this.entityToCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox entityCheckBox : MyCasAnnotationViewer.this.entityToCheckBoxMap.values()) {
                            if (entityCheckBox.isSelected()) continue;
                            entityCheckBox.setSelected(true);
                            needRefresh = true;
                        }
                        if (!needRefresh) break;
                        MyCasAnnotationViewer.this.display();
                        break;
                    }
                    case 2: {
                        if (MyCasAnnotationViewer.this.featureValueCheckBoxMap.size() <= 0) break;
                        boolean needRefresh = false;
                        for (JCheckBox featureValueCheckBox : MyCasAnnotationViewer.this.featureValueCheckBoxMap.values()) {
                            if (featureValueCheckBox.isSelected()) continue;
                            featureValueCheckBox.setSelected(true);
                            needRefresh = true;
                        }
                        if (!needRefresh) break;
                        MyCasAnnotationViewer.this.display();
                        MyCasAnnotationViewer.this.tabbedChoicePane.setSelectedIndex(2);
                        break;
                    }
                }
            }
        });
        return selectAllButton;
    }

    private void resetTabbedPane() {
        if (this.tabbedChoicePane == null) {
            return;
        }
        this.tabbedChoicePane.removeAll();
        switch (this.viewMode) {
            case 0: {
                if (this.typeCheckBoxScrollPane == null) break;
                this.tabbedChoicePane.addTab("Annotation Types", this.typeCheckBoxScrollPane);
                break;
            }
            case 1: {
                if (this.entityCheckBoxScrollPane == null) break;
                this.tabbedChoicePane.addTab("Entities", this.entityCheckBoxScrollPane);
                break;
            }
            case 2: {
                if (this.typeRadioButtonScrollPane != null) {
                    this.tabbedChoicePane.addTab("Annotation Types", this.typeRadioButtonScrollPane);
                    this.tabbedChoicePane.setMnemonicAt(0, 49);
                }
                if (this.featureRadioButtonScrollPane != null) {
                    this.tabbedChoicePane.addTab("Features", this.featureRadioButtonScrollPane);
                    this.tabbedChoicePane.setMnemonicAt(1, 50);
                }
                if (this.featureValueCheckBoxScrollPane == null) break;
                this.tabbedChoicePane.addTab("Feature Values", this.featureValueCheckBoxScrollPane);
                this.tabbedChoicePane.setMnemonicAt(2, 51);
                break;
            }
        }
    }

    private void createHorizontalSplitPane() {
        this.horizontalSplitPane = new JSplitPane(1);
        this.horizontalSplitPane.setResizeWeight(0.6);
        this.createVerticalSplitPane();
        this.horizontalSplitPane.setLeftComponent(this.verticalSplitPane);
        this.horizontalSplitPane.setRightComponent(this.createTreePanel());
    }

    private JPanel createTreePanel() {
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)new JLabel("Click In Text to See Annotation Detail"), "North");
        this.createSelectedAnnotationTree();
        treePanel.add((Component)new JScrollPane(this.selectedAnnotationTree), "Center");
        return treePanel;
    }

    private void createSelectedAnnotationTree() {
        this.selectedAnnotationTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("Annotations"));
        this.selectedAnnotationTree = new JTree(this.selectedAnnotationTreeModel){
            private static final long serialVersionUID = -7882967150283952907L;

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(230, 500);
            }
        };
        this.selectedAnnotationTree.setMinimumSize(new Dimension(50, 100));
        this.selectedAnnotationTree.setScrollsOnExpand(true);
        this.selectedAnnotationTree.setRootVisible(true);
        this.selectedAnnotationTree.setCellRenderer(new AnnotationTreeCellRenderer());
        this.selectedAnnotationTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreeNode firstChild;
                DefaultMutableTreeNode expandedNode;
                Object userObject;
                Object lastPathComponent = event.getPath().getLastPathComponent();
                if (lastPathComponent instanceof DefaultMutableTreeNode && (userObject = (expandedNode = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof FsTreeNodeObject && (firstChild = expandedNode.getFirstChild()) instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)firstChild).getUserObject() == null) {
                    expandedNode.removeAllChildren();
                    FeatureStructure fs = ((FsTreeNodeObject)userObject).getFeatureStructure();
                    MyCasAnnotationViewer.this.addFeatureTreeNodes(expandedNode, fs);
                    ((JTree)event.getSource()).treeDidChange();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
            }
        });
        this.selectedAnnotationTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode expandedNode;
                Object userObject;
                Object lastPathComponent = event.getPath().getLastPathComponent();
                if (lastPathComponent instanceof DefaultMutableTreeNode && (userObject = (expandedNode = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof TypeTreeNodeObject && expandedNode.getChildCount() == 1) {
                    TreePath childPath = event.getPath().pathByAddingChild(expandedNode.getFirstChild());
                    ((JTree)event.getSource()).expandPath(childPath);
                    ((JTree)event.getSource()).treeDidChange();
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
    }

    private void createVerticalSplitPane() {
        this.verticalSplitPane = new JSplitPane(0);
        this.verticalSplitPane.setResizeWeight(0.8);
        this.verticalSplitPane.setPreferredSize(new Dimension(620, 600));
        this.verticalSplitPane.setMinimumSize(new Dimension(200, 200));
        this.createTextScrollPane();
        this.verticalSplitPane.setTopComponent(this.textScrollPane);
        this.verticalSplitPane.setBottomComponent(this.createTabbedChoicePane());
    }

    private JTabbedPane createTabbedChoicePane() {
        this.tabbedChoicePane = new JTabbedPane();
        this.createTypeCheckBoxPane();
        this.createEntityCheckBoxPane();
        this.createTypeRadioButtonPane();
        this.createFeatureRadioButtonPane();
        this.createFeatureValueCheckBoxPane();
        switch (this.viewMode) {
            case 0: {
                this.tabbedChoicePane.addTab("Annotation Types", this.typeCheckBoxScrollPane);
                this.tabbedChoicePane.setMnemonicAt(0, 49);
                break;
            }
            case 1: {
                this.tabbedChoicePane.addTab("Entities", this.entityCheckBoxScrollPane);
                this.tabbedChoicePane.setMnemonicAt(0, 49);
                break;
            }
            case 2: {
                this.tabbedChoicePane.addTab("Annotation Types", this.typeRadioButtonScrollPane);
                this.tabbedChoicePane.setMnemonicAt(0, 49);
                this.tabbedChoicePane.addTab("Features", this.featureRadioButtonScrollPane);
                this.tabbedChoicePane.setMnemonicAt(1, 50);
                this.tabbedChoicePane.addTab("Feature Values", this.featureValueCheckBoxScrollPane);
                this.tabbedChoicePane.setMnemonicAt(2, 51);
                break;
            }
        }
        return this.tabbedChoicePane;
    }

    private void createFeatureValueCheckBoxPane() {
        this.featureValueCheckBoxVerticalScrollPanel = new VerticallyScrollablePanel();
        this.featureValueCheckBoxVerticalScrollPanel.setLayout(new GridLayout(0, 5));
        this.featureValueCheckBoxScrollPane = new JScrollPane();
        this.featureValueCheckBoxScrollPane.setHorizontalScrollBarPolicy(31);
        this.featureValueCheckBoxScrollPane.setViewportView(this.featureValueCheckBoxVerticalScrollPanel);
    }

    private void createFeatureRadioButtonPane() {
        this.featureRadioButtonVerticalScrollPanel = new VerticallyScrollablePanel();
        this.featureRadioButtonVerticalScrollPanel.setLayout(new GridLayout(0, 5));
        this.featureRadioButtonScrollPane = new JScrollPane();
        this.featureRadioButtonScrollPane.setHorizontalScrollBarPolicy(31);
        this.featureRadioButtonScrollPane.setViewportView(this.featureRadioButtonVerticalScrollPanel);
    }

    private void createTypeRadioButtonPane() {
        this.typeRadioButtonVerticalScrollPanel = new VerticallyScrollablePanel();
        this.typeRadioButtonVerticalScrollPanel.setLayout(new GridLayout(0, 5));
        this.typeRadioButtonScrollPane = new JScrollPane();
        this.typeRadioButtonScrollPane.setHorizontalScrollBarPolicy(31);
        this.typeRadioButtonScrollPane.setViewportView(this.typeRadioButtonVerticalScrollPanel);
    }

    private void createEntityCheckBoxPane() {
        this.entityCheckBoxVerticalScrollPanel = new VerticallyScrollablePanel();
        this.entityCheckBoxVerticalScrollPanel.setLayout(new GridLayout(0, 5));
        this.entityCheckBoxScrollPane = new JScrollPane();
        this.entityCheckBoxScrollPane.setHorizontalScrollBarPolicy(31);
        this.entityCheckBoxScrollPane.setViewportView(this.entityCheckBoxVerticalScrollPanel);
    }

    private void createTypeCheckBoxPane() {
        this.typeCheckBoxVerticalScrollPanel = new VerticallyScrollablePanel();
        this.typeCheckBoxVerticalScrollPanel.setLayout(new GridLayout(0, 5));
        this.typeCheckBoxScrollPane = new JScrollPane();
        this.typeCheckBoxScrollPane.setHorizontalScrollBarPolicy(31);
        this.typeCheckBoxScrollPane.setViewportView(this.typeCheckBoxVerticalScrollPanel);
    }

    private void createTextScrollPane() {
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(620, 400));
        this.textPane.setMinimumSize(new Dimension(200, 100));
        this.textPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int pos = MyCasAnnotationViewer.this.textPane.viewToModel(e.getPoint());
                MyCasAnnotationViewer.this.updateSelectedAnnotationTree(pos);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.textPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                Clipboard clipboard;
                String selection;
                if (ke != null && ke.getKeyCode() == 67 && (ke.getModifiers() & 2) != 0 && (selection = MyCasAnnotationViewer.this.textPane.getSelectedText()) != null && selection.length() > 0 && (clipboard = MyCasAnnotationViewer.this.getToolkit().getSystemClipboard()) != null) {
                    StringSelection data = new StringSelection(selection);
                    clipboard.setContents(data, data);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.textScrollPane = new JScrollPane(this.textPane);
    }

    public List<String> getUserTypes() {
        return this.userTypes;
    }

    public void setUserTypes(List<String> userTypes) {
        this.userTypes = userTypes;
    }

    public void setHighFrequencyTypes(String[] aTypeNames) {
        if (this.highFrequencyTypes.size() > 0) {
            this.highFrequencyTypes.clear();
        }
        this.highFrequencyTypes.addAll(Arrays.asList(aTypeNames));
        if (this.typeColorMap.size() > 0) {
            this.typeColorMap.clear();
        }
        this.assignTypeColors(this.highFrequencyTypes);
    }

    public void setDisplayedTypes(String[] aDisplayedTypeNames) {
        if (aDisplayedTypeNames == null) {
            this.displayedTypeNames = null;
        } else {
            if (this.displayedTypeNames == null) {
                this.displayedTypeNames = new HashSet<String>();
            }
            if (this.displayedTypeNames.size() > 0) {
                this.displayedTypeNames.clear();
            }
            this.displayedTypeNames.addAll(Arrays.asList(aDisplayedTypeNames));
        }
    }

    public void setHiddenTypes(String[] aTypeNames) {
        if (this.hiddenTypeNames.size() > 0) {
            this.hiddenTypeNames.clear();
        }
        this.hiddenTypeNames.addAll(Arrays.asList(aTypeNames));
    }

    public void setInitiallySelectedTypes(String[] aTypeNames) {
        this.initiallySelectedTypeNames = new HashSet<String>();
        for (int i = 0; i < aTypeNames.length; ++i) {
            this.initiallySelectedTypeNames.add(aTypeNames[i]);
        }
        for (Map.Entry<Type, JCheckBox> entry : this.typeToCheckBoxMap.entrySet()) {
            String type = entry.getKey().getName();
            JCheckBox checkbox = entry.getValue();
            checkbox.setSelected(MyCasAnnotationViewer.typeNamesContains(this.initiallySelectedTypeNames, type));
        }
        if (this.cas != null) {
            this.display();
        }
    }

    public void setHiddenFeatures(String[] aFeatureNames) {
        if (this.hiddenFeatureNames.size() > 0) {
            this.hiddenFeatureNames.clear();
        }
        this.hiddenFeatureNames.addAll(Arrays.asList(DEFAULT_HIDDEN_FEATURES));
        this.hiddenFeatureNames.addAll(Arrays.asList(aFeatureNames));
    }

    public void setEntityResolver(EntityResolver aEntityResolver) {
        this.entityResolver = aEntityResolver;
    }

    public void setConsistentColors(boolean aConsistent) {
        this.useConsistentColors = aConsistent;
    }

    public void setRightToLeftTextOrientation(boolean aRightToLeft) {
        if (this.textPane != null) {
            this.textPane.applyComponentOrientation(aRightToLeft ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
        }
    }

    public void setHideUnselectedCheckboxes(boolean aHideUnselected) {
        this.hideUnselectedCheckBoxes = aHideUnselected;
        this.display();
    }

    public void setCAS(CAS aCAS) {
        this.reset();
        this.cas = aCAS;
        this.typeSystem = this.cas.getTypeSystem();
        this.stringType = this.typeSystem.getType("uima.cas.String");
        this.fsArrayType = this.typeSystem.getType("uima.cas.FSArray");
        this.initializeSofaSelectionPanel();
        this.display();
    }

    private void initializeSofaSelectionPanel() {
        if (this.sofaSelectionComboBox == null) {
            return;
        }
        this.sofaSelectionComboBox.removeAllItems();
        boolean hasNonDefaultSofa = false;
        Feature sofaIdFeature = this.typeSystem.getFeatureByFullName("uima.cas.Sofa:sofaID");
        FSIterator<SofaFS> sofaIterator = this.cas.getSofaIterator();
        while (sofaIterator != null && sofaIterator.hasNext()) {
            SofaFS sofa = (SofaFS)sofaIterator.next();
            if (sofa.getLocalStringData() == null) continue;
            String sofaId = sofa.getStringValue(sofaIdFeature);
            if ("_InitialView".equals(sofaId)) {
                sofaId = "DEFAULT";
            } else {
                hasNonDefaultSofa = true;
            }
            this.sofaSelectionComboBox.addItem(sofaId);
            if (this.cas.getView(sofa) != this.cas) continue;
            this.sofaSelectionComboBox.setSelectedIndex(this.sofaSelectionComboBox.getItemCount() - 1);
        }
        if (this.sofaSelectionComboBox.getItemCount() == 0) {
            throw new RuntimeException("This CAS contains no document to view.");
        }
        if (this.sofaSelectionPanel != null) {
            this.sofaSelectionPanel.setVisible(hasNonDefaultSofa);
        }
    }

    private void reset() {
        this.resetTypeColorMap();
        this.resetTypeRadioButtonPanel();
        this.resetFeaturePanel();
        this.resetFeatureValuePanel();
        this.resetTypeCheckBoxPanel();
        this.resetEntityCheckBoxPanel();
        this.resetSelectedAnnotationTree();
        this.boldFaceKeyWords = new String[0];
        this.boldFaceSpans = new int[0];
    }

    private void resetSelectedAnnotationTree() {
        DefaultMutableTreeNode root;
        if (this.selectedAnnotationTreeModel != null && (root = (DefaultMutableTreeNode)this.selectedAnnotationTreeModel.getRoot()) != null) {
            root.removeAllChildren();
        }
    }

    private void resetEntityCheckBoxPanel() {
        if (this.entityToCheckBoxMap.size() > 0) {
            this.entityToCheckBoxMap.clear();
        }
        if (this.entityCheckBoxVerticalScrollPanel != null) {
            this.entityCheckBoxVerticalScrollPanel.removeAll();
        }
    }

    private void resetTypeCheckBoxPanel() {
        if (this.typeToCheckBoxMap.size() > 0) {
            this.typeToCheckBoxMap.clear();
        }
        if (this.typeCheckBoxVerticalScrollPanel != null) {
            this.typeCheckBoxVerticalScrollPanel.removeAll();
        }
    }

    private void resetFeatureValuePanel() {
        if (this.featureValueColorMap.size() > 0) {
            this.featureValueColorMap.clear();
        }
        if (this.featureValueCheckBoxMap.size() > 0) {
            this.featureValueCheckBoxMap.clear();
        }
        if (this.featureValueCheckBoxVerticalScrollPanel != null) {
            this.featureValueCheckBoxVerticalScrollPanel.removeAll();
        }
    }

    private void resetFeaturePanel() {
        if (this.featureColorMap.size() > 0) {
            this.featureColorMap.clear();
        }
        if (this.featureRadioButtonMap.size() > 0) {
            this.featureRadioButtonMap.clear();
        }
        if (this.featureRadioButtonVerticalScrollPanel != null) {
            this.featureRadioButtonVerticalScrollPanel.removeAll();
        }
    }

    private void resetTypeRadioButtonPanel() {
        if (this.typeRadioButtonMap.size() > 0) {
            this.typeRadioButtonMap.clear();
        }
        if (this.typeRadioButtonVerticalScrollPanel != null) {
            this.typeRadioButtonVerticalScrollPanel.removeAll();
        }
    }

    private void resetTypeColorMap() {
        if (!this.useConsistentColors) {
            if (this.typeColorMap.size() > 0) {
                this.typeColorMap.clear();
            }
            if (this.highFrequencyTypes.size() > 0) {
                this.assignTypeColors(this.highFrequencyTypes);
            }
        }
    }

    public void applyBoldfaceToKeywords(String[] aWords) {
        this.boldFaceKeyWords = aWords;
        this.doBoldFace();
    }

    public void applyBoldfaceToSpans(int[] aSpans) {
        this.boldFaceSpans = aSpans;
        this.doBoldFace();
    }

    public void configureViewForXmlFragmentsQuery(String aQuery, String aTypeNamespace) {
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> keywordList = new ArrayList<String>();
        String delims = "<>+-*\" \t\n";
        StringTokenizer tokenizer = new StringTokenizer(aQuery, delims, true);
        boolean inTag = false;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if ("<".equals(tok)) {
                inTag = true;
                continue;
            }
            if (">".equals(tok) && inTag) {
                inTag = false;
                continue;
            }
            if (delims.indexOf(tok) != -1) continue;
            if (inTag) {
                if (tok.startsWith("/")) continue;
                if (tok.endsWith("/")) {
                    tok = tok.substring(0, tok.length() - 1);
                }
                typeList.add(aTypeNamespace + '.' + tok);
                continue;
            }
            keywordList.add(tok);
        }
        this.setInitiallySelectedTypes(typeList.toArray(new String[0]));
        this.display();
        this.applyBoldfaceToKeywords(keywordList.toArray(new String[0]));
    }

    public void configureViewForXmlFragmentsQuery(String aQuery) {
        this.configureViewForXmlFragmentsQuery(aQuery, "*");
    }

    public void assignCheckedFromList(List<String> aNotChecked) {
        if (aNotChecked == null || aNotChecked.size() == 0) {
            return;
        }
        this.typesNotChecked.addAll(aNotChecked);
    }

    public void assignColorsFromList(List<Color> aColors, List<String> aTypeNames) {
        if (aColors == null || aColors.size() == 0 || aTypeNames == null || aTypeNames.size() == 0) {
            return;
        }
        if (this.userTypes.size() > 0) {
            this.userTypes.clear();
        }
        if (this.typeColorMap.size() > 0) {
            this.typeColorMap.clear();
        }
        int colorCount = aColors.size();
        for (int i = 0; i < aTypeNames.size(); ++i) {
            Color color = aColors.get(i % colorCount);
            String inTypeName = aTypeNames.get(i);
            this.typeColorMap.put(inTypeName, color);
            this.userTypes.add(inTypeName);
        }
        if (this.typeRadioButtonVerticalScrollPanel != null) {
            this.typeRadioButtonVerticalScrollPanel.removeAll();
        }
        if (this.typeCheckBoxVerticalScrollPanel != null) {
            this.typeCheckBoxVerticalScrollPanel.removeAll();
        }
        if (this.featureRadioButtonVerticalScrollPanel != null) {
            this.featureRadioButtonVerticalScrollPanel.removeAll();
        }
        if (this.featureValueCheckBoxVerticalScrollPanel != null) {
            this.featureValueCheckBoxVerticalScrollPanel.removeAll();
        }
        this.typeToCheckBoxMap.clear();
        this.typeRadioButtonMap.clear();
    }

    private void assignTypeColors(List<String> aTypeNames) {
        if (aTypeNames == null || aTypeNames.size() == 0) {
            return;
        }
        for (String typeName : aTypeNames) {
            if (this.typeColorMap.containsKey(typeName)) continue;
            this.typeColorMap.put(typeName, COLORS[this.typeColorMap.size() % COLORS.length]);
        }
        if (this.typeRadioButtonVerticalScrollPanel != null) {
            this.typeRadioButtonVerticalScrollPanel.removeAll();
        }
        if (this.typeCheckBoxVerticalScrollPanel != null) {
            this.typeCheckBoxVerticalScrollPanel.removeAll();
        }
        this.typeRadioButtonMap.clear();
        this.typeToCheckBoxMap.clear();
    }

    private void display() {
        int dividerLocation = this.verticalSplitPane.getDividerLocation();
        int caretPosition = this.textPane.getCaretPosition();
        int verticalScrollPos = this.textScrollPane.getVerticalScrollBar().getValue();
        switch (this.viewMode) {
            case 0: {
                this.displayAnnotationView();
                break;
            }
            case 1: {
                this.displayEntityView();
                break;
            }
            case 2: {
                this.displayFeatureView();
                break;
            }
        }
        this.doBoldFace();
        if (this.hideUnselectedCheckBoxes) {
            this.showHideUnselectedButton.setText("Show Unselected");
        } else {
            this.showHideUnselectedButton.setText("Hide Unselected");
        }
        this.textPane.setCaretPosition(caretPosition);
        this.textScrollPane.getVerticalScrollBar().setValue(verticalScrollPos);
        this.textScrollPane.revalidate();
        this.verticalSplitPane.setDividerLocation(dividerLocation);
    }

    private void displayFeatureView() {
        boolean firstType;
        StyledDocument doc = (StyledDocument)this.textPane.getDocument();
        DefaultStyledDocument blank = new DefaultStyledDocument();
        this.textPane.setDocument(blank);
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, this.cas.getDocumentText(), new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        JCas jcas = null;
        try {
            jcas = this.cas.getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        AnnotationIndex<Annotation> annotationIndex = jcas.getAnnotationIndex();
        if (annotationIndex == null) {
            return;
        }
        FSIterator annotationIterator = annotationIndex.iterator();
        if (annotationIterator == null || !annotationIterator.hasNext()) {
            return;
        }
        boolean bl = firstType = this.typeRadioButtonMap.size() == 0;
        while (annotationIterator.hasNext()) {
            if (!this.processOneAnnotationInFeatureView(doc, (Annotation)annotationIterator.next(), firstType) || !firstType) continue;
            firstType = false;
        }
        this.addTypeRadioButtons();
        this.addFeatureRadioButtons();
        this.addFeatureValueCheckBoxes();
        this.textPane.setDocument(doc);
    }

    private void addFeatureValueCheckBoxes() {
        if (this.featureValueCheckBoxMap.size() == 0) {
            return;
        }
        ArrayList<JCheckBox> checkBoxes = new ArrayList<JCheckBox>(this.featureValueCheckBoxMap.values());
        Collections.sort(checkBoxes, new Comparator<JCheckBox>(){

            @Override
            public int compare(JCheckBox arg0, JCheckBox arg1) {
                return arg0.getText().toLowerCase().compareTo(arg1.getText().toLowerCase());
            }
        });
        for (JCheckBox checkBox : checkBoxes) {
            if (checkBox.getParent() == this.featureValueCheckBoxVerticalScrollPanel || !checkBox.isSelected() && this.hideUnselectedCheckBoxes) continue;
            this.featureValueCheckBoxVerticalScrollPanel.add(checkBox);
        }
    }

    private void addFeatureRadioButtons() {
        if (this.featureRadioButtonMap.size() == 0) {
            return;
        }
        ArrayList<JRadioButton> radioButtons = new ArrayList<JRadioButton>(this.featureRadioButtonMap.values());
        Collections.sort(radioButtons, new Comparator<JRadioButton>(){

            @Override
            public int compare(JRadioButton arg0, JRadioButton arg1) {
                return arg0.getText().toLowerCase().compareTo(arg1.getText().toLowerCase());
            }
        });
        ButtonGroup featureRadioButtonGroup = new ButtonGroup();
        for (JRadioButton radioButton : radioButtons) {
            if (radioButton.getParent() != this.featureRadioButtonVerticalScrollPanel) {
                this.featureRadioButtonVerticalScrollPanel.add(radioButton);
            }
            featureRadioButtonGroup.add(radioButton);
        }
    }

    private void addTypeRadioButtons() {
        if (this.typeRadioButtonMap.size() == 0) {
            return;
        }
        HashMap<String, JRadioButton> radioButtonMap = new HashMap<String, JRadioButton>();
        HashSet<JRadioButton> radioButtonSet = new HashSet<JRadioButton>();
        for (Type type : this.typeRadioButtonMap.keySet()) {
            JRadioButton typeRadioButton = this.typeRadioButtonMap.get(type);
            radioButtonMap.put(type.getName(), typeRadioButton);
            radioButtonSet.add(typeRadioButton);
        }
        ButtonGroup typeRadioButtonGroup = new ButtonGroup();
        if (this.userTypes.size() > 0) {
            for (String typeName : this.userTypes) {
                JRadioButton typeRadioButton = (JRadioButton)radioButtonMap.get(typeName);
                if (typeRadioButton == null) continue;
                this.typeRadioButtonVerticalScrollPanel.add(typeRadioButton);
                typeRadioButtonGroup.add(typeRadioButton);
                radioButtonSet.remove(typeRadioButton);
            }
        }
        if (radioButtonSet != null && radioButtonSet.size() > 0) {
            ArrayList arrayList = new ArrayList(radioButtonSet);
            Collections.sort(arrayList, new Comparator<JRadioButton>(){

                @Override
                public int compare(JRadioButton arg0, JRadioButton arg1) {
                    return arg0.getText().toLowerCase().compareTo(arg1.getText().toLowerCase());
                }
            });
            for (JRadioButton radioButton : arrayList) {
                if (radioButton.getParent() != this.typeRadioButtonVerticalScrollPanel) {
                    this.typeRadioButtonVerticalScrollPanel.add(radioButton);
                }
                typeRadioButtonGroup.add(radioButton);
            }
        }
    }

    private boolean processOneAnnotationInFeatureView(StyledDocument doc, Annotation annotation, boolean firstType) {
        Type type = annotation.getType();
        String typeName = type.getName();
        if (this.displayedTypeNames != null && !MyCasAnnotationViewer.typeNamesContains(this.displayedTypeNames, typeName) || MyCasAnnotationViewer.typeNamesContains(this.hiddenTypeNames, typeName)) {
            return false;
        }
        JRadioButton typeRadioButton = this.typeRadioButtonMap.get(type);
        if (typeRadioButton == null) {
            Color typeColor = this.typeColorMap.get(typeName);
            if (typeColor == null) {
                typeColor = COLORS[this.typeColorMap.size() % COLORS.length];
                this.typeColorMap.put(typeName, typeColor);
            }
            typeRadioButton = new JRadioButton(type.getShortName(), firstType);
            typeRadioButton.setToolTipText(typeName);
            typeRadioButton.setBackground(typeColor);
            typeRadioButton.setOpaque(true);
            typeRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JRadioButton typeRadioButton = (JRadioButton)ae.getSource();
                    if (typeRadioButton == null || !typeRadioButton.isSelected()) {
                        return;
                    }
                    MyCasAnnotationViewer.this.resetFeaturePanel();
                    MyCasAnnotationViewer.this.resetFeatureValuePanel();
                    MyCasAnnotationViewer.this.resetSelectedAnnotationTree();
                    MyCasAnnotationViewer.this.display();
                    MyCasAnnotationViewer.this.tabbedChoicePane.setSelectedIndex(1);
                }
            });
            this.typeRadioButtonMap.put(type, typeRadioButton);
        }
        if (!typeRadioButton.isSelected()) {
            return true;
        }
        List<Feature> features = type.getFeatures();
        if (features == null || features.size() == 0) {
            return false;
        }
        boolean firstFeature = this.featureRadioButtonMap.size() == 0;
        for (Feature feature : features) {
            if (!this.processOneFeature(doc, annotation, feature, firstFeature) || !firstFeature) continue;
            firstFeature = false;
        }
        return this.featureValueCheckBoxMap.size() > 0;
    }

    private boolean processOneFeature(StyledDocument doc, Annotation annotation, Feature feature, boolean firstFeature) {
        String featureName = feature.getShortName();
        if (this.hiddenFeatureNames.contains(featureName)) {
            return false;
        }
        Type rangeType = feature.getRange();
        if (this.typeSystem != null && (this.typeSystem.subsumes(this.fsArrayType, rangeType) || rangeType.isArray())) {
            return false;
        }
        String featureValue = this.getFeatureValueInString(annotation, feature);
        if (featureValue == null || featureValue.equalsIgnoreCase("*FS*")) {
            return false;
        }
        JRadioButton featureRadioButton = this.featureRadioButtonMap.get(featureName);
        if (featureRadioButton == null) {
            Color featureColor = this.featureColorMap.get(featureName);
            if (featureColor == null) {
                featureColor = COLORS[this.featureColorMap.size() % COLORS.length];
                this.featureColorMap.put(featureName, featureColor);
            }
            featureRadioButton = new JRadioButton(featureName, firstFeature);
            featureRadioButton.setToolTipText(feature.getName());
            featureRadioButton.setBackground(featureColor);
            featureRadioButton.setOpaque(true);
            featureRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JRadioButton featureRadioButton = (JRadioButton)ae.getSource();
                    if (featureRadioButton == null || !featureRadioButton.isSelected()) {
                        return;
                    }
                    MyCasAnnotationViewer.this.resetFeatureValuePanel();
                    MyCasAnnotationViewer.this.resetSelectedAnnotationTree();
                    MyCasAnnotationViewer.this.display();
                    MyCasAnnotationViewer.this.tabbedChoicePane.setSelectedIndex(2);
                }
            });
            this.featureRadioButtonMap.put(featureName, featureRadioButton);
        }
        if (!featureRadioButton.isSelected()) {
            return true;
        }
        return this.processOneFeatureValue(doc, annotation, feature);
    }

    private boolean processOneFeatureValue(StyledDocument doc, Annotation annotation, Feature feature) {
        String featureValue = this.getFeatureValueInString(annotation, feature);
        if (featureValue == null || featureValue.length() == 0) {
            return false;
        }
        JCheckBox featureValueCheckBox = this.featureValueCheckBoxMap.get(featureValue);
        if (featureValueCheckBox == null) {
            Color featureValueColor = this.featureValueColorMap.get(featureValue);
            if (featureValueColor == null) {
                featureValueColor = COLORS[this.featureValueColorMap.size() % COLORS.length];
                this.featureValueColorMap.put(featureValue, featureValueColor);
            }
            featureValueCheckBox = new JCheckBox(MyCasAnnotationViewer.checkString(featureValue, "null", 16), true);
            featureValueCheckBox.setToolTipText(featureValue);
            featureValueCheckBox.setBackground(featureValueColor);
            featureValueCheckBox.setOpaque(true);
            featureValueCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyCasAnnotationViewer.this.resetSelectedAnnotationTree();
                    MyCasAnnotationViewer.this.display();
                    MyCasAnnotationViewer.this.tabbedChoicePane.setSelectedIndex(2);
                }
            });
            this.featureValueCheckBoxMap.put(featureValue, featureValueCheckBox);
        }
        if (featureValueCheckBox.isSelected()) {
            int begin = annotation.getBegin();
            int end = annotation.getEnd();
            if (begin == 0 && end == this.cas.getDocumentText().length()) {
                --end;
            }
            if (begin < end) {
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                StyleConstants.setBackground(attrs, featureValueCheckBox.getBackground());
                doc.setCharacterAttributes(begin, end - begin, attrs, false);
            }
        }
        return true;
    }

    private void displayAnnotationView() {
        StyledDocument doc = (StyledDocument)this.textPane.getDocument();
        DefaultStyledDocument blank = new DefaultStyledDocument();
        this.textPane.setDocument(blank);
        this.typeCheckBoxVerticalScrollPanel.removeAll();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, this.cas.getDocumentText(), new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        AnnotationIndex annotationIndex = this.cas.getAnnotationIndex();
        if (annotationIndex == null) {
            return;
        }
        FSIterator annotationIterator = annotationIndex.iterator();
        if (annotationIterator == null || !annotationIterator.hasNext()) {
            return;
        }
        while (annotationIterator.hasNext()) {
            this.processOneAnnotationInAnnotationView(doc, (AnnotationFS)annotationIterator.next());
        }
        this.addTypeCheckBoxes();
        this.textPane.setDocument(doc);
    }

    private void addTypeCheckBoxes() {
        JCheckBox typeCheckBox;
        if (this.typeToCheckBoxMap.size() == 0) {
            return;
        }
        HashMap<String, JCheckBox> checkBoxMap = new HashMap<String, JCheckBox>();
        HashSet<JCheckBox> checkBoxSet = new HashSet<JCheckBox>();
        for (Type type : this.typeToCheckBoxMap.keySet()) {
            typeCheckBox = this.typeToCheckBoxMap.get(type);
            if (typeCheckBox.getParent() == this.typeCheckBoxVerticalScrollPanel || !typeCheckBox.isSelected() && this.hideUnselectedCheckBoxes) continue;
            checkBoxMap.put(type.getName(), typeCheckBox);
            checkBoxSet.add(typeCheckBox);
        }
        if (this.userTypes.size() > 0) {
            for (String userType : this.userTypes) {
                typeCheckBox = (JCheckBox)checkBoxMap.get(userType);
                if (typeCheckBox == null) continue;
                this.typeCheckBoxVerticalScrollPanel.add(typeCheckBox);
                checkBoxSet.remove(typeCheckBox);
            }
        }
        if (checkBoxSet != null && checkBoxSet.size() > 0) {
            ArrayList remainingCheckBoxes = new ArrayList(checkBoxSet);
            Collections.sort(remainingCheckBoxes, new Comparator<JCheckBox>(){

                @Override
                public int compare(JCheckBox o1, JCheckBox o2) {
                    return o1.getText().toLowerCase().compareTo(o2.getText().toLowerCase());
                }
            });
            for (JCheckBox checkBox : remainingCheckBoxes) {
                this.typeCheckBoxVerticalScrollPanel.add(checkBox);
            }
        }
    }

    private void processOneAnnotationInAnnotationView(StyledDocument doc, AnnotationFS annotation) {
        Type type = annotation.getType();
        String typeName = type.getName();
        if (this.displayedTypeNames != null && !MyCasAnnotationViewer.typeNamesContains(this.displayedTypeNames, typeName) || MyCasAnnotationViewer.typeNamesContains(this.hiddenTypeNames, typeName)) {
            return;
        }
        JCheckBox typeCheckBox = this.typeToCheckBoxMap.get(type);
        if (typeCheckBox == null) {
            Color typeColor = this.typeColorMap.get(typeName);
            if (typeColor == null) {
                typeColor = COLORS[this.typeColorMap.size() % COLORS.length];
                this.typeColorMap.put(typeName, typeColor);
            }
            boolean selected = this.initiallySelectedTypeNames == null && !"uima.tcas.DocumentAnnotation".equals(typeName) && !this.typesNotChecked.contains(typeName) || this.initiallySelectedTypeNames != null && MyCasAnnotationViewer.typeNamesContains(this.initiallySelectedTypeNames, typeName);
            typeCheckBox = new JCheckBox(type.getShortName(), selected);
            typeCheckBox.setToolTipText(typeName);
            typeCheckBox.setBackground(typeColor);
            typeCheckBox.setOpaque(true);
            typeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyCasAnnotationViewer.this.resetSelectedAnnotationTree();
                    MyCasAnnotationViewer.this.display();
                }
            });
            this.typeToCheckBoxMap.put(type, typeCheckBox);
        }
        if (typeCheckBox.isSelected()) {
            int begin = annotation.getBegin();
            int end = annotation.getEnd();
            if (begin == 0 && end == this.cas.getDocumentText().length()) {
                --end;
            }
            if (begin < end) {
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                StyleConstants.setBackground(attrs, typeCheckBox.getBackground());
                doc.setCharacterAttributes(begin, end - begin, attrs, false);
            }
        }
    }

    private void displayEntityView() {
        JCas jcas;
        StyledDocument doc = (StyledDocument)this.textPane.getDocument();
        DefaultStyledDocument blank = new DefaultStyledDocument();
        this.textPane.setDocument(blank);
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, this.cas.getDocumentText(), new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        try {
            jcas = this.cas.getJCas();
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
        AnnotationIndex<Annotation> annotationIndex = jcas.getAnnotationIndex();
        if (annotationIndex == null) {
            return;
        }
        FSIterator annotationIterator = annotationIndex.iterator();
        if (annotationIterator == null || !annotationIterator.hasNext()) {
            return;
        }
        while (annotationIterator.hasNext()) {
            this.processOneAnnotationInEntityView(doc, (Annotation)annotationIterator.next());
        }
        for (JCheckBox entityCheckBox : this.entityToCheckBoxMap.values()) {
            if (entityCheckBox.getParent() == this.entityCheckBoxVerticalScrollPanel || !entityCheckBox.isSelected() && this.hideUnselectedCheckBoxes) continue;
            this.entityCheckBoxVerticalScrollPanel.add(entityCheckBox);
        }
        this.textPane.setDocument(doc);
    }

    private void processOneAnnotationInEntityView(StyledDocument doc, Annotation annotation) {
        EntityResolver.Entity entity = this.entityResolver.getEntity(annotation);
        if (entity == null) {
            return;
        }
        JCheckBox entityCheckBox = this.entityToCheckBoxMap.get(entity);
        if (entityCheckBox == null) {
            Color entityColor = COLORS[this.entityToCheckBoxMap.size() % COLORS.length];
            entityCheckBox = new JCheckBox(entity.getCanonicalForm(), true);
            entityCheckBox.setToolTipText(entity.getCanonicalForm());
            entityCheckBox.setBackground(entityColor);
            entityCheckBox.setOpaque(true);
            entityCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyCasAnnotationViewer.this.resetSelectedAnnotationTree();
                    MyCasAnnotationViewer.this.display();
                }
            });
            this.entityCheckBoxVerticalScrollPanel.add(entityCheckBox);
            this.entityToCheckBoxMap.put(entity, entityCheckBox);
        }
        if (entityCheckBox.isSelected()) {
            int begin = annotation.getBegin();
            int end = annotation.getEnd();
            if (begin == 0 && end == this.cas.getDocumentText().length()) {
                --end;
            }
            if (begin < end) {
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                StyleConstants.setBackground(attrs, entityCheckBox.getBackground());
                doc.setCharacterAttributes(begin, end - begin, attrs, false);
            }
        }
    }

    private void updateSelectedAnnotationTree(int aPosition) {
        Annotation annotation;
        int begin;
        if (this.cas == null || this.selectedAnnotationTreeModel == null) {
            return;
        }
        JCas jcas = null;
        try {
            jcas = this.cas.getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectedAnnotationTreeModel.getRoot();
        root.removeAllChildren();
        AnnotationIndex<Annotation> annotationIndex = jcas.getAnnotationIndex();
        if (annotationIndex == null) {
            return;
        }
        FSIterator annotationIterator = annotationIndex.iterator();
        if (annotationIterator == null || !annotationIterator.hasNext()) {
            return;
        }
        while (annotationIterator.hasNext() && (begin = (annotation = (Annotation)annotationIterator.next()).getBegin()) <= aPosition) {
            if (annotation.getEnd() <= aPosition || !this.isMatch(annotation)) continue;
            this.addAnnotationToTree(annotation);
        }
        this.selectedAnnotationTreeModel.nodeStructureChanged(root);
        this.selectedAnnotationTree.treeDidChange();
        this.selectedAnnotationTree.revalidate();
        this.horizontalSplitPane.revalidate();
        this.expandAll(this.selectedAnnotationTree);
    }

    protected void expandAll(JTree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    private boolean isMatch(Annotation annotation) {
        Type type = annotation.getType();
        switch (this.viewMode) {
            case 0: {
                if (this.typeToCheckBoxMap.size() == 0) {
                    return false;
                }
                JCheckBox typeCheckBox = this.typeToCheckBoxMap.get(type);
                return typeCheckBox != null && typeCheckBox.isSelected();
            }
            case 1: {
                if (this.entityToCheckBoxMap.size() == 0) {
                    return false;
                }
                EntityResolver.Entity entity = this.entityResolver.getEntity(annotation);
                if (entity == null) {
                    return false;
                }
                JCheckBox entityCheckBox = this.entityToCheckBoxMap.get(entity);
                return entityCheckBox != null && entityCheckBox.isSelected();
            }
            case 2: {
                JRadioButton typeRadioButton = this.typeRadioButtonMap.get(type);
                if (typeRadioButton == null || !typeRadioButton.isSelected()) {
                    return false;
                }
                List<Feature> features = type.getFeatures();
                if (features == null || features.size() == 0) {
                    return false;
                }
                for (Feature feature : features) {
                    String featureValue;
                    JRadioButton featureRadioButton;
                    String featureName = feature.getShortName();
                    if (featureName == null || featureName.length() == 0 || (featureRadioButton = this.featureRadioButtonMap.get(featureName)) == null || !featureRadioButton.isSelected() || (featureValue = this.getFeatureValueInString(annotation, feature)) == null || featureValue.length() == 0) continue;
                    JCheckBox featureValueCheckBox = this.featureValueCheckBoxMap.get(featureValue);
                    return featureValueCheckBox != null && featureValueCheckBox.isSelected();
                }
                break;
            }
        }
        return false;
    }

    protected void addAnnotationToTree(AnnotationFS aAnnotation) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectedAnnotationTreeModel.getRoot();
        DefaultMutableTreeNode typeNode = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            if (!aAnnotation.getType().equals(((TypeTreeNodeObject)child.getUserObject()).getType())) continue;
            typeNode = child;
            break;
        }
        if (typeNode == null) {
            typeNode = new DefaultMutableTreeNode(new TypeTreeNodeObject(aAnnotation.getType()));
            root.insert(typeNode, 0);
        }
        DefaultMutableTreeNode annotationNode = new DefaultMutableTreeNode(new FsTreeNodeObject(aAnnotation, null));
        typeNode.insert(annotationNode, 0);
        this.addFeatureTreeNodes(annotationNode, aAnnotation);
    }

    private void addFeatureTreeNodes(DefaultMutableTreeNode aParentNode, FeatureStructure aFS) {
        List<Feature> features = aFS.getType().getFeatures();
        if (features == null || features.size() == 0) {
            return;
        }
        for (Feature feature : features) {
            String featureValue;
            String featureName = feature.getShortName();
            if (this.hiddenFeatureNames.contains(featureName) || (featureValue = this.getFeatureValueInString(aFS, feature)) == null) continue;
            if (featureValue.equalsIgnoreCase("*FSArray*")) {
                ArrayFS arrayFS = (ArrayFS)aFS.getFeatureValue(feature);
                if (arrayFS == null) continue;
                DefaultMutableTreeNode arrayNode = new DefaultMutableTreeNode(featureName + " = FSArray");
                for (int i = 0; i < arrayFS.size(); ++i) {
                    FeatureStructure featureStructure = arrayFS.get(i);
                    if (featureStructure != null) {
                        DefaultMutableTreeNode fsValueNode = new DefaultMutableTreeNode(new FsTreeNodeObject(featureStructure, featureName));
                        if (!featureStructure.getType().getFeatures().isEmpty()) {
                            fsValueNode.add(new DefaultMutableTreeNode(null));
                        }
                        arrayNode.add(fsValueNode);
                        continue;
                    }
                    arrayNode.add(new DefaultMutableTreeNode("null"));
                }
                aParentNode.add(arrayNode);
                continue;
            }
            if (featureValue.equalsIgnoreCase("*FS*")) {
                FeatureStructure featureStructure = aFS.getFeatureValue(feature);
                if (featureStructure == null) continue;
                DefaultMutableTreeNode fsValueNode = new DefaultMutableTreeNode(new FsTreeNodeObject(featureStructure, featureName));
                if (!featureStructure.getType().getFeatures().isEmpty()) {
                    fsValueNode.add(new DefaultMutableTreeNode(null));
                }
                aParentNode.add(fsValueNode);
                continue;
            }
            aParentNode.add(new DefaultMutableTreeNode(featureName + " = " + featureValue));
        }
    }

    private String getFeatureValueInString(FeatureStructure aFS, Feature feature) {
        if (this.cas == null || this.typeSystem == null || this.stringType == null || this.fsArrayType == null) {
            return "null";
        }
        Type rangeType = feature.getRange();
        if (this.typeSystem.subsumes(this.fsArrayType, rangeType)) {
            return "*FSArray*";
        }
        if (this.typeSystem.subsumes(this.stringType, rangeType)) {
            return MyCasAnnotationViewer.checkString(aFS.getStringValue(feature), "null", 64);
        }
        if (rangeType.isPrimitive()) {
            return MyCasAnnotationViewer.checkString(aFS.getFeatureValueAsString(feature), "null", 64);
        }
        if (rangeType.isArray()) {
            String[] values2;
            CommonArrayFS arrayFS = (CommonArrayFS)aFS.getFeatureValue(feature);
            String[] stringArray = values2 = arrayFS == null ? null : arrayFS.toStringArray();
            if (values2 == null || values2.length == 0) {
                return "null";
            }
            StringBuffer displayValue = new StringBuffer();
            displayValue.append("[");
            for (int i = 0; i < values2.length - 1; ++i) {
                displayValue.append(values2[i]);
                displayValue.append(",");
            }
            displayValue.append(values2[values2.length - 1]);
            displayValue.append("]");
            return displayValue.toString();
        }
        return "*FS*";
    }

    private static String checkString(String stringValue, String defaultIfNull, int maxLength) {
        if (stringValue == null) {
            return defaultIfNull;
        }
        if (maxLength > 0 && stringValue.length() > maxLength) {
            return stringValue.substring(0, maxLength) + "...";
        }
        return stringValue;
    }

    private static boolean typeNamesContains(Set<String> names, String name) {
        if (names.contains(name)) {
            return true;
        }
        for (String pattern : names) {
            if (!(pattern.indexOf(42) != -1 ? MyCasAnnotationViewer.wildCardMatch(name, pattern) : pattern.equalsIgnoreCase(name))) continue;
            return true;
        }
        return false;
    }

    private static boolean wildCardMatch(String name, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return false;
        }
        StringBuffer regex = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                regex.append('.');
            }
            if (c == '.') {
                regex.append('\\');
            }
            if (Character.isLetter(c)) {
                regex.append('(').append(Character.toLowerCase(c)).append('|').append(Character.toUpperCase(c)).append(')');
                continue;
            }
            regex.append(c);
        }
        return name != null && name.length() > 0 && name.matches(new String(regex));
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        Insets insets = this.getInsets();
        Dimension paneSize = new Dimension(d.width - insets.left - insets.right, d.height - insets.top - insets.bottom);
        this.horizontalSplitPane.setPreferredSize(paneSize);
        this.horizontalSplitPane.setSize(paneSize);
    }

    private void doBoldFace() {
        this.doBoldFaceByKeyWords();
        this.doBoldFaceBySpans();
    }

    private void doBoldFaceBySpans() {
        if (this.boldFaceSpans == null || this.boldFaceSpans.length == 0) {
            return;
        }
        int docLength = this.cas.getDocumentText().length();
        int spanLength = this.boldFaceSpans.length - this.boldFaceSpans.length % 2;
        for (int i = 0; i < spanLength; i += 2) {
            int begin = this.boldFaceSpans[i];
            int end = this.boldFaceSpans[i + 1];
            if (begin < 0 || begin > docLength || end < 0 || end > docLength || begin >= end) continue;
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBold(attrs, true);
            StyledDocument doc = (StyledDocument)this.textPane.getDocument();
            doc.setCharacterAttributes(begin, end - begin, attrs, false);
        }
    }

    private void doBoldFaceByKeyWords() {
        if (this.boldFaceKeyWords == null || this.boldFaceKeyWords.length == 0) {
            return;
        }
        StringBuffer regex = new StringBuffer();
        for (int i = 0; i < this.boldFaceKeyWords.length; ++i) {
            if (i > 0) {
                regex.append('|');
            }
            regex.append("\\b");
            String keyWord = this.boldFaceKeyWords[i];
            for (int j = 0; j < keyWord.length(); ++j) {
                char c = keyWord.charAt(j);
                if (Character.isLetter(c)) {
                    regex.append('[').append(Character.toLowerCase(c)).append(Character.toUpperCase(c)).append(']');
                    continue;
                }
                if (c == '.' || c == '^' || c == '&' || c == '\\' || c == '(' || c == ')') {
                    regex.append('\\').append(c);
                    continue;
                }
                regex.append(c);
            }
            regex.append("\\b");
        }
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(this.cas.getDocumentText());
        int pos = 0;
        while (matcher.find(pos)) {
            int begin = matcher.start();
            int end = matcher.end();
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBold(attrs, true);
            StyledDocument doc = (StyledDocument)this.textPane.getDocument();
            doc.setCharacterAttributes(begin, end - begin, attrs, false);
            if (pos == end) break;
            pos = end;
        }
    }

    protected JTree getSelectedAnnotationTree() {
        return this.selectedAnnotationTree;
    }

    private static class VerticallyScrollablePanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1009744410018634511L;

        private VerticallyScrollablePanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }
    }

    private class AnnotationTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -8661556785397184756L;

        private AnnotationTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, final Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color background = null;
            if (value instanceof DefaultMutableTreeNode) {
                Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
                Type type = null;
                if (userObj instanceof FsTreeNodeObject) {
                    FeatureStructure fs = ((FsTreeNodeObject)userObj).getFeatureStructure();
                    type = fs.getType();
                } else if (userObj instanceof TypeTreeNodeObject) {
                    type = ((TypeTreeNodeObject)userObj).getType();
                }
                if (type != null) {
                    background = (Color)MyCasAnnotationViewer.this.typeColorMap.get(type.getName());
                }
            }
            if (background != null) {
                this.setBackgroundNonSelectionColor(background);
                this.setBackgroundSelectionColor(background);
            }
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke == null || ke.getKeyCode() != 67 || (ke.getModifiers() & 2) == 0) {
                        return;
                    }
                    String selection = ((DefaultMutableTreeNode)value).getUserObject().toString();
                    Clipboard clipboard = AnnotationTreeCellRenderer.this.getToolkit().getSystemClipboard();
                    if (clipboard != null) {
                        StringSelection data = new StringSelection(selection);
                        clipboard.setContents(data, data);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            return component;
        }
    }

    private static class FsTreeNodeObject {
        private FeatureStructure featureStructure;
        private String featureName;
        private String caption;

        public FsTreeNodeObject(FeatureStructure inFeatureStructure, String inFeatureName) {
            this.featureStructure = inFeatureStructure;
            this.featureName = inFeatureName;
            this.caption = this.featureStructure.getType().getShortName();
            if (this.featureStructure instanceof AnnotationFS) {
                String coveredText = ((AnnotationFS)this.featureStructure).getCoveredText();
                if (coveredText.length() > 64) {
                    coveredText = coveredText.substring(0, 64) + "...";
                }
                this.caption = this.caption + " (\"" + coveredText + "\")";
            }
            if (this.featureName != null) {
                this.caption = this.featureName + " = " + this.caption;
            }
        }

        public FeatureStructure getFeatureStructure() {
            return this.featureStructure;
        }

        public String toString() {
            return this.caption;
        }
    }

    private static class TypeTreeNodeObject {
        private Type type;

        public TypeTreeNodeObject(Type inType) {
            this.type = inType;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.type.getShortName();
        }
    }

    public class DefaultEntityResolver
    implements EntityResolver {
        @Override
        public EntityResolver.Entity getEntity(final Annotation inAnnotation) {
            return new EntityResolver.Entity(){

                @Override
                public String getCanonicalForm() {
                    return inAnnotation.getCoveredText();
                }

                public boolean equals(Object inObject) {
                    if (inObject instanceof EntityResolver.Entity) {
                        String canon = ((EntityResolver.Entity)inObject).getCanonicalForm();
                        return canon != null && canon.equals(this.getCanonicalForm());
                    }
                    return false;
                }

                public int hashCode() {
                    return this.getCanonicalForm().hashCode();
                }
            };
        }
    }
}

