/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.XMLInputSource;

public class SimpleRunCPEReporter
extends Thread {
    private CollectionProcessingEngine mCPE;
    private long mStartTime = System.currentTimeMillis();
    private long mInitCompleteTime;
    private String logFile;

    public SimpleRunCPEReporter(String[] args2) throws Exception {
        String line;
        if (args2.length < 2) {
            SimpleRunCPEReporter.printUsageMessage();
            System.exit(1);
        }
        this.logFile = args2[1];
        System.out.println("Parsing CPE Descriptor");
        CpeDescription cpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(args2[0]));
        System.out.println("Instantiating CPE");
        this.mCPE = UIMAFramework.produceCollectionProcessingEngine(cpeDesc);
        this.mCPE.addStatusCallbackListener(new StatusCallbackListenerImpl());
        System.out.println("Running CPE");
        this.mCPE.process();
        System.out.println("To abort processing, type \"abort\" and press enter.");
        while (!"abort".equals(line = new BufferedReader(new InputStreamReader(System.in)).readLine()) || !this.mCPE.isProcessing()) {
        }
        System.out.println("Aborting...");
        this.mCPE.stop();
    }

    private static void printUsageMessage() {
        System.out.println(" Arguments to the program are as follows : \nargs[0] : path to CPE descriptor file");
    }

    public static void main(String[] args2) throws Exception {
        new SimpleRunCPEReporter(args2);
    }

    class StatusCallbackListenerImpl
    implements StatusCallbackListener {
        int entityCount = 0;
        long size = 0L;

        StatusCallbackListenerImpl() {
        }

        @Override
        public void initializationComplete() {
            System.out.println("CPM Initialization Complete");
            SimpleRunCPEReporter.this.mInitCompleteTime = System.currentTimeMillis();
        }

        @Override
        public void batchProcessComplete() {
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long elapsedTime = System.currentTimeMillis() - SimpleRunCPEReporter.this.mStartTime;
            System.out.println("Time Elapsed : " + elapsedTime + " ms ");
        }

        @Override
        public void collectionProcessComplete() {
            long time = System.currentTimeMillis();
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long initTime = SimpleRunCPEReporter.this.mInitCompleteTime - SimpleRunCPEReporter.this.mStartTime;
            long processingTime = time - SimpleRunCPEReporter.this.mInitCompleteTime;
            long elapsedTime = initTime + processingTime;
            System.out.println("Total Time Elapsed: " + elapsedTime + " ms ");
            System.out.println("Initialization Time: " + initTime + " ms");
            System.out.println("Processing Time: " + processingTime + " ms");
            String reportContent = "";
            reportContent = reportContent + "Total Time\t" + elapsedTime + "\t";
            reportContent = reportContent + "Initialization Time\t" + initTime + "\t";
            reportContent = reportContent + "Processing Time\t" + processingTime + "\t";
            for (ProcessTraceEvent event : SimpleRunCPEReporter.this.mCPE.getPerformanceReport().getEvents()) {
                reportContent = reportContent + event.getComponentName() + "-" + event.getType() + "\t" + event.getDuration() + "\t";
            }
            try {
                IOUtils.write(reportContent, (Writer)new FileWriter(SimpleRunCPEReporter.this.logFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("\n\n ------------------ PERFORMANCE REPORT ------------------\n");
            System.out.println(SimpleRunCPEReporter.this.mCPE.getPerformanceReport().toString());
            System.exit(1);
        }

        @Override
        public void paused() {
            System.out.println("Paused");
        }

        @Override
        public void resumed() {
            System.out.println("Resumed");
        }

        @Override
        public void aborted() {
            System.out.println("Aborted");
            System.exit(1);
        }

        @Override
        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
            if (aStatus.isException()) {
                List<Exception> exceptions = aStatus.getExceptions();
                for (int i = 0; i < exceptions.size(); ++i) {
                    ((Throwable)exceptions.get(i)).printStackTrace();
                }
                return;
            }
            ++this.entityCount;
            String docText = aCas.getDocumentText();
            if (docText != null) {
                this.size += (long)docText.length();
            }
        }
    }
}

