/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima;

import edu.utah.bmi.nlp.uima.StatusSetable;
import edu.utah.bmi.nlp.uima.loggers.UIMALogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.BaseCollectionReader;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.Progress;

public class SimpleStatusCallbackListenerImpl
implements StatusCallbackListener {
    public static Logger syslogger = Logger.getLogger(SimpleStatusCallbackListenerImpl.class.getCanonicalName());
    protected final List<Exception> exceptions = new ArrayList<Exception>();
    protected boolean isProcessing;
    protected UIMALogger logger;
    public CollectionProcessingEngine mCPE;
    protected StatusSetable runner;

    public boolean isProcessing() {
        return this.isProcessing;
    }

    protected SimpleStatusCallbackListenerImpl() {
    }

    public SimpleStatusCallbackListenerImpl(UIMALogger logger) {
        this.isProcessing = true;
        this.logger = logger;
        if (logger != null) {
            logger.logStartTime();
        }
    }

    public void setCollectionProcessingEngine(CollectionProcessingEngine engine) {
        this.mCPE = engine;
    }

    @Override
    public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        if (this.logger != null) {
            this.logger.entityProcessComplete(aCas, aStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aborted() {
        SimpleStatusCallbackListenerImpl simpleStatusCallbackListenerImpl = this;
        synchronized (simpleStatusCallbackListenerImpl) {
            if (this.logger != null) {
                this.logger.aborted();
            }
            if (this.isProcessing) {
                this.isProcessing = false;
                this.notify();
            }
        }
    }

    @Override
    public void initializationComplete() {
        if (this.logger == null) {
            return;
        }
        int totalDocs = 0;
        BaseCollectionReader reader = this.mCPE.getCollectionReader();
        Progress[] progress = reader.getProgress();
        if (progress != null) {
            for (int i = 0; i < progress.length; ++i) {
                if (!progress[i].getUnit().equals(this.logger.getUnit())) continue;
                totalDocs = (int)progress[i].getTotal();
                break;
            }
        }
        this.logger.initializationComplete(totalDocs);
    }

    @Override
    public void batchProcessComplete() {
    }

    @Override
    public void paused() {
        if (this.logger != null) {
            this.logger.paused();
        }
    }

    @Override
    public void resumed() {
        if (this.logger != null) {
            this.logger.resumed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectionProcessComplete() {
        SimpleStatusCallbackListenerImpl simpleStatusCallbackListenerImpl = this;
        synchronized (simpleStatusCallbackListenerImpl) {
            if (this.isProcessing) {
                this.notify();
                if (this.logger != null) {
                    if (this.runner != null) {
                        this.runner.setStatus(2);
                    }
                    StringBuilder reportContent = new StringBuilder();
                    for (ProcessTraceEvent event : this.mCPE.getPerformanceReport().getEvents()) {
                        String componentName = event.getComponentName();
                        componentName = componentName.substring(componentName.lastIndexOf(".") + 1);
                        String eventType = event.getType();
                        if (eventType.startsWith("End")) {
                            reportContent.append("\t\t" + event.getType() + "\t" + event.getDuration() + " ms\n");
                            continue;
                        }
                        reportContent.append(componentName + "\t" + event.getType() + "\t" + event.getDuration() + " ms\n");
                    }
                    if (this.logger != null) {
                        this.logger.collectionProcessComplete(reportContent.toString());
                    }
                }
            }
            this.isProcessing = false;
        }
    }

    public void setRunner(StatusSetable runner) {
        this.runner = runner;
    }
}

