/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.JCas;

public class AnnotationCountEvaluator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_TYPE_NAME = "TypeName";
    public static final String PARAM_TYPE_COUNT = "TypeCount";
    public static final String PARAM_FEATURE_VALUES = "FeatureValues";
    private String typeName;
    public static boolean pass = true;
    private int count;
    private LinkedHashMap<String, String> featureValues = new LinkedHashMap();

    @Override
    public void initialize(UimaContext cont) {
        this.typeName = "";
        Object obj = cont.getConfigParameterValue(PARAM_TYPE_NAME);
        if (obj != null && obj instanceof String) {
            this.typeName = DeterminantValueSet.checkNameSpace((String)obj);
        }
        if ((obj = cont.getConfigParameterValue(PARAM_TYPE_COUNT)) != null && obj instanceof Integer) {
            this.count = (Integer)obj;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_FEATURE_VALUES)) != null && obj instanceof String) {
            String[] fvs = ((String)obj).split(",\\s*");
            for (int i = 0; i < fvs.length / 2; i += 2) {
                this.featureValues.put(fvs[i], fvs[i + 1].trim());
            }
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        CAS cas = jCas.getCas();
        Type type = CasUtil.getAnnotationType(cas, this.typeName);
        Collection<AnnotationFS> annos = CasUtil.select(cas, type);
        int counter = 0;
        for (AnnotationFS anno : annos) {
            if (!this.checkFeatureValues(type, anno)) continue;
            ++counter;
        }
        pass = counter == this.count;
    }

    private boolean checkFeatureValues(Type type, AnnotationFS anno) {
        Iterator<String> iterator2 = this.featureValues.keySet().iterator();
        block11: while (iterator2.hasNext()) {
            String featureName;
            switch (featureName = iterator2.next()) {
                case "Text": 
                case "CoveredText": {
                    if (anno.getCoveredText().equals(this.featureValues.get(featureName))) continue block11;
                    return false;
                }
                case "Begin": {
                    if ((anno.getBegin() + "").equals(this.featureValues.get(featureName))) continue block11;
                    return false;
                }
                case "End": {
                    if ((anno.getEnd() + "").equals(this.featureValues.get(featureName))) continue block11;
                    return false;
                }
            }
            Feature fObj = type.getFeatureByBaseName(featureName);
            if (fObj == null) {
                return false;
            }
            String value = anno.getFeatureValueAsString(fObj);
            if (value.equals(this.featureValues.get(featureName))) continue;
            return false;
        }
        return true;
    }
}

