/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.JCas;

public class AnnotationEvaluator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_TYPE_NAME = "TypeName";
    public static final String PARAM_ANNO_IND = "AnnotationIndex";
    public static final String PARAM_FEATURE_NAME = "FeatureName";
    public static final String PARAM_FEATURE_VALUE = "FeatureValue";
    public static final String PARAM_BEGIN = "Begin";
    public static final String PARAM_END = "End";
    private String typeName;
    private String featureName;
    private String featureValue;
    private int begin;
    private int end;
    public static boolean pass = true;
    private int ind;

    @Override
    public void initialize(UimaContext cont) {
        this.typeName = "";
        Object obj = cont.getConfigParameterValue(PARAM_TYPE_NAME);
        if (obj != null && obj instanceof String) {
            this.typeName = DeterminantValueSet.checkNameSpace((String)obj);
        }
        if ((obj = cont.getConfigParameterValue(PARAM_ANNO_IND)) != null && obj instanceof Integer) {
            this.ind = (Integer)obj;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_FEATURE_NAME)) != null && obj instanceof String) {
            this.featureName = (String)obj;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_FEATURE_VALUE)) != null && obj instanceof String) {
            this.featureValue = (String)obj;
        }
        this.begin = (obj = cont.getConfigParameterValue(PARAM_BEGIN)) != null && obj instanceof Integer ? (Integer)obj : -1;
        obj = cont.getConfigParameterValue(PARAM_END);
        this.end = obj != null && obj instanceof Integer ? (Integer)obj : -1;
    }

    @Override
    public void process(JCas jCas) {
        Feature fObj;
        CAS cas = jCas.getCas();
        Type type = CasUtil.getAnnotationType(cas, this.typeName);
        Iterator iter = CasUtil.iterator(cas, type);
        AnnotationFS anno = null;
        int i = 0;
        while (iter.hasNext() && i <= this.ind) {
            anno = (AnnotationFS)iter.next();
        }
        pass = true;
        if (anno == null) {
            pass = false;
        }
        if ((fObj = type.getFeatureByBaseName(this.featureName)) == null) {
            pass = false;
        } else {
            String value = anno.getFeatureValueAsString(fObj);
            if (!value.equals(this.featureValue)) {
                pass = false;
            }
        }
        if (this.begin > -1 && this.end > -1 && (anno.getBegin() != this.begin || anno.getEnd() != this.end)) {
            pass = false;
        }
    }
}

