/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.ae.AnnotationFeatureMergerAnnotator;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;

public class AnnotationFeatureMerger {
    public static Logger logger = IOUtil.getLogger(AnnotationFeatureMergerAnnotator.class);
    private LinkedHashMap<String, ArrayList<String>> conceptFeaturesRuleMap = new LinkedHashMap();
    private LinkedHashMap<Type, ArrayList<Feature>> conceptFeaturesMap = new LinkedHashMap();
    private LinkedHashMap<String, HashMap<String, Integer>> featureValuesRulePriorities = new LinkedHashMap();
    private LinkedHashMap<Feature, HashMap<String, Integer>> featureValuesPriorities = new LinkedHashMap();
    private HashMap<String, Class> conceptMergedConceptMap = new HashMap();
    @Deprecated
    private boolean debug = false;
    private boolean insitu = false;

    @Deprecated
    public AnnotationFeatureMerger(String ruleStr, boolean debug, boolean insitu) {
        this.init(ruleStr, insitu);
    }

    public AnnotationFeatureMerger(String ruleStr, boolean insitu) {
        this.init(ruleStr, insitu);
    }

    @Deprecated
    public void init(String ruleStr, boolean debug, boolean insitu) {
        this.init(ruleStr, insitu);
    }

    public void init(String ruleStr, boolean insitu) {
        this.insitu = insitu;
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        block10: for (ArrayList<String> initRow : ioUtil.getInitiations()) {
            String header;
            switch (header = initRow.get(1).trim()) {
                case "@FEATURE_VALUES": 
                case "&FEATURE_VALUES": {
                    String featureName = initRow.get(2);
                    this.featureValuesRulePriorities.put(featureName, new HashMap());
                    for (int i = 3; i < initRow.size(); ++i) {
                        this.featureValuesRulePriorities.get(featureName).put(initRow.get(i), i - 2);
                    }
                    continue block10;
                }
                case "@CONCEPT_FEATURES": 
                case "&CONCEPT_FEATURES": {
                    String sourceTypeName = initRow.get(3);
                    String mergedTypeName = initRow.get(2);
                    this.conceptMergedConceptMap.put(sourceTypeName, AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(mergedTypeName)));
                    this.conceptFeaturesRuleMap.put(sourceTypeName, new ArrayList());
                    for (int i = 4; i < initRow.size(); ++i) {
                        this.conceptFeaturesRuleMap.get(sourceTypeName).add(initRow.get(i));
                    }
                    break;
                }
            }
        }
    }

    public void mergeAnnotations(JCas jCas) {
        CAS cas = jCas.getCas();
        int i = 0;
        for (String conceptName : this.conceptFeaturesRuleMap.keySet()) {
            Type type = CasUtil.getAnnotationType(cas, DeterminantValueSet.checkNameSpace(conceptName));
            TOP mergedAnno = null;
            if (!this.conceptFeaturesMap.containsKey(type)) {
                this.conceptFeaturesMap.put(type, new ArrayList());
                for (String featureName : this.conceptFeaturesRuleMap.get(conceptName)) {
                    Feature fObj = type.getFeatureByBaseName(featureName);
                    this.conceptFeaturesMap.get(type).add(fObj);
                    if (this.featureValuesPriorities.containsKey(fObj)) continue;
                    this.featureValuesPriorities.put(fObj, this.featureValuesRulePriorities.get(featureName));
                }
            }
            Iterator iter = CasUtil.iterator(cas, type);
            while (iter.hasNext()) {
                AnnotationFS anno = (AnnotationFS)iter.next();
                if (mergedAnno == null) {
                    if (this.insitu) {
                        mergedAnno = AnnotationFactory.createAnnotation(jCas, anno.getBegin(), anno.getEnd(), this.conceptMergedConceptMap.get(conceptName));
                    } else {
                        mergedAnno = AnnotationFactory.createAnnotation(jCas, i, i + 3, this.conceptMergedConceptMap.get(conceptName));
                        i += 3;
                    }
                }
                for (Feature feature : this.conceptFeaturesMap.get(type)) {
                    String currentValue = anno.getFeatureValueAsString(feature);
                    if (currentValue == null) continue;
                    String mergedValue = mergedAnno.getFeatureValueAsString(feature);
                    if (!this.featureValuesPriorities.containsKey(feature)) {
                        logger.info("featureValuesPriorities doesn't have feature: " + feature);
                    } else if (!this.featureValuesPriorities.get(feature).containsKey(currentValue)) {
                        logger.info("Feature " + feature + " doesn't have value: " + currentValue);
                    }
                    if (mergedValue != null && this.featureValuesPriorities.get(feature).getOrDefault(currentValue, -1) <= this.featureValuesPriorities.get(feature).getOrDefault(mergedValue, -1)) continue;
                    mergedAnno.setFeatureValueFromString(feature, currentValue);
                }
            }
            if (mergedAnno == null) continue;
            mergedAnno.addToIndexes();
        }
    }

    public static LinkedHashMap<String, TypeDefinition> getTypeDefinitions(String ruleStr) {
        LinkedHashMap<String, TypeDefinition> typeDefinitionLinkedHashMap = new LinkedHashMap<String, TypeDefinition>();
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        for (ArrayList<String> initRow : ioUtil.getInitiations()) {
            String header;
            switch (header = initRow.get(1).trim()) {
                case "@CONCEPT_FEATURES": 
                case "&CONCEPT_FEATURES": {
                    String typeName = initRow.get(2);
                    String sourceTypeName = initRow.get(3);
                    typeDefinitionLinkedHashMap.put(typeName, new TypeDefinition(typeName, sourceTypeName));
                }
            }
        }
        return typeDefinitionLinkedHashMap;
    }
}

