/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class AnnotationPrinter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_TYPE_NAME = "TypeName";
    @ConfigurationParameter(name="TypeName", mandatory=false, defaultValue={"Annotation"}, description="The type name to be printed.")
    private String printTypeName;
    public static final String PARAM_INDICATION = "Indication";
    @ConfigurationParameter(name="Indication", mandatory=false, defaultValue={""}, description="Hint to the printed annotations.")
    private String indication;

    @Override
    public void initialize(UimaContext cont) throws ResourceInitializationException {
        super.initialize(cont);
        this.printTypeName = DeterminantValueSet.checkNameSpace(this.printTypeName);
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        CAS cas = jCas.getCas();
        Type type = CasUtil.getAnnotationType(cas, this.printTypeName);
        Collection<? extends Annotation> annotations = JCasUtil.select(jCas, AnnotationOper.getTypeClass(this.printTypeName));
        for (AnnotationFS annotationFS : annotations) {
            System.out.println(this.indication + "\n Here is a list of annotation '" + this.printTypeName + "':");
            System.out.println(annotationFS.getClass());
            System.out.println(annotationFS.toString() + "   Covered Text: \"" + annotationFS.getCoveredText() + "\"".replaceAll("\n", ""));
        }
    }
}

