/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.AnnotationDefinition;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.type.system.Doc_Base;
import edu.utah.bmi.nlp.type.system.Sentence;
import edu.utah.bmi.nlp.type.system.Token;
import edu.utah.bmi.nlp.uima.ae.DocInferenceFeatureReader;
import edu.utah.bmi.nlp.uima.ae.RuleBasedAEInf;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.common.UIMATypeFunctions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;

public class DocInferenceAnnotator
extends JCasAnnotator_ImplBase
implements RuleBasedAEInf {
    public static Logger logger = IOUtil.getLogger(DocInferenceAnnotator.class);
    public static final String PARAM_RULE_STR = "RuleFileOrStr";
    @ConfigurationParameter(name="RuleFileOrStr", mandatory=true)
    protected String inferenceStr;
    public static final String FIRSTWORD = "FIRSTWORD";
    public static final String LASTWORD = "LASTWORD";
    public static final String FIRSTSENTENCE = "FIRSTSENTENCE";
    public static final String LASTSENTENCE = "LASTSENTENCE";
    public static final String FIRSTEVIDENCE = "FIRSTEVIDENCE";
    public static final String LASTEVIDENCE = "LASTEVIDENCE";
    public static final String PARAM_ANNO_POSITION = "AnnotatePosition";
    @ConfigurationParameter(name="AnnotatePosition", mandatory=false, defaultValue={"FIRSTWORD"}, description="where to place the conclusion annotation.")
    protected String annotatePosition;
    public static final String PARAM_OVERWRITE_NOTE = "OverWriteNote";
    @ConfigurationParameter(name="OverWriteNote", mandatory=false, defaultValue={"true"}, description="whether Use concatenated evidence type names as Note values")
    protected boolean overWriteNote;
    public static final String PARAM_REPLACING = "Replacing";
    @ConfigurationParameter(name="Replacing", mandatory=false, defaultValue={"false"}, description="whether replace the specified (by PARAM_ANNO_POSITION ) evidence annotation")
    protected boolean replacing;
    protected boolean aggregateFeatures = true;
    public LinkedHashMap<String, ArrayList<ArrayList<Object>>> inferenceMap = new LinkedHashMap();
    protected HashMap<String, HashMap<String, Method>> evidenceConceptGetFeatures = new LinkedHashMap<String, HashMap<String, Method>>();
    protected HashMap<String, Class<? extends Annotation>> conceptClassMap = new HashMap();
    protected HashMap<Class, HashMap<String, Method>> conclusionConceptSetFeatures = new HashMap();
    protected HashMap<String, String> defaultDocTypes = new HashMap();
    protected HashMap<String, String> valueFeatureMap = new HashMap();
    protected HashMap<String, String> uniqueFeatureClassMap = new HashMap();
    protected ArrayList<ArrayList<String>> ruleCells = new ArrayList();
    protected HashMap<String, Constructor<? extends Annotation>> docTypeConstructorMap = new HashMap();
    protected HashMap<Class<? extends Annotation>, IntervalST<Annotation>> evidenceAnnotationTree = new HashMap();
    protected HashMap<Class<? extends Annotation>, IntervalST<Integer>> scopeAnnotationTree = new HashMap();
    protected HashMap<Class<? extends Annotation>, ArrayList<Annotation>> scopeAnnotations = new HashMap();
    protected HashMap<Integer, String> currentDocTypes = new HashMap();
    protected LinkedHashMap<String, TypeDefinition> typeDefinitions = new LinkedHashMap();
    protected Pattern pattern = Pattern.compile("^\\s*(\\w+)");

    @Override
    public void initialize(UimaContext cont) throws ResourceInitializationException {
        super.initialize(cont);
        this.parseRuleStr(this.inferenceStr);
    }

    protected void parseRuleStr(String ruleStr) {
        this.inferenceMap.clear();
        this.conceptClassMap.clear();
        this.docTypeConstructorMap.clear();
        this.evidenceConceptGetFeatures.clear();
        this.conclusionConceptSetFeatures.clear();
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        this.getTypeDefs(ioUtil);
        for (ArrayList<String> row : ioUtil.getRuleCells()) {
            try {
                String topic = row.get(1).trim();
                if (!this.inferenceMap.containsKey(topic)) {
                    this.inferenceMap.put(topic, new ArrayList());
                }
                ArrayList<Object> inference = new ArrayList<Object>();
                String docTypeName = row.get(2).trim();
                inference.add(docTypeName);
                this.buildConstructor(docTypeName);
                ArrayList<Class> evidences = new ArrayList<Class>();
                for (String evidenceTypeName : row.get(4).split(",")) {
                    Class<? extends Annotation> evidenceType;
                    if (!this.conceptClassMap.containsKey(evidenceTypeName)) {
                        evidenceType = AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(evidenceTypeName));
                        if (evidenceType == null) {
                            logger.warning("Type: " + evidenceTypeName + " has not been defined before using as an evidence.");
                            logger.warning("Rule: " + row + " skipped.");
                            continue;
                        }
                        this.conceptClassMap.put(evidenceTypeName, evidenceType);
                    } else {
                        evidenceType = this.conceptClassMap.get(evidenceTypeName);
                    }
                    evidences.add(evidenceType);
                }
                String featureSetting = row.get(3).trim();
                inference.add(new DocInferenceFeatureReader(featureSetting, this.conceptClassMap, this.evidenceConceptGetFeatures, evidences));
                AnnotationOper.initSetReflections(this.typeDefinitions, this.conceptClassMap, this.docTypeConstructorMap, this.conclusionConceptSetFeatures);
                inference.add(evidences);
                Class<? extends Annotation> scopeType = null;
                if (row.size() > 5) {
                    scopeType = AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(row.get(5)));
                    if (scopeType == SourceDocumentInformation.class || scopeType == DocumentAnnotation.class) {
                        scopeType = null;
                    } else {
                        for (Class evidenceType : evidences) {
                            if (this.evidenceAnnotationTree.containsKey(evidenceType)) continue;
                            this.evidenceAnnotationTree.put(evidenceType, new IntervalST());
                        }
                        this.scopeAnnotationTree.put(scopeType, new IntervalST());
                    }
                }
                inference.add(scopeType);
                inference.add(row.get(4));
                int windowSize = 0;
                if (row.size() > 6) {
                    String windowSizeStr = row.get(6);
                    try {
                        windowSize = NumberUtils.toInt(windowSizeStr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                inference.add(windowSize);
                this.inferenceMap.get(topic).add(inference);
            }
            catch (Exception e) {
                logger.warning("Error parse rule: " + row);
            }
        }
    }

    protected void buildConstructor(String docTypeName) {
        try {
            if (!this.docTypeConstructorMap.containsKey(docTypeName)) {
                Class<? extends Annotation> docType = AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(docTypeName));
                if (docType == null) {
                    logger.warning(docTypeName + " has not been initiated. Please check the definition in rule files.");
                    return;
                }
                Constructor<? extends Annotation> cc = docType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
                this.docTypeConstructorMap.put(docTypeName, cc);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.clearCaches(this.scopeAnnotations, this.scopeAnnotationTree, this.evidenceAnnotationTree);
        this.indexAnnotations(jCas);
        if (logger.isLoggable(Level.FINE)) {
            SourceDocumentInformation so = JCasUtil.selectByIndex(jCas, SourceDocumentInformation.class, 0);
            logger.fine("Write Doc inference for: " + so.getUri());
        }
        ArrayList<Annotation> evidenceAnnotations = null;
        for (String topic : this.inferenceMap.keySet()) {
            ArrayList<ArrayList<Object>> inferences = this.inferenceMap.get(topic);
            boolean matched = false;
            for (ArrayList<Object> inference : inferences) {
                logger.finest("\tTrying " + inference.get(4) + "\t" + inference.get(3));
                DocInferenceFeatureReader featureReader = (DocInferenceFeatureReader)inference.get(1);
                ArrayList evidences = (ArrayList)inference.get(2);
                Object scope = inference.get(3);
                int windowSize = (Integer)inference.get(5);
                if (scope == null) {
                    evidenceAnnotations = this.checkMatchInDoc(jCas, evidences);
                    if (evidenceAnnotations == null || evidenceAnnotations.size() != evidences.size()) continue;
                    this.addConclusion(jCas, topic, (String)inference.get(0), evidenceAnnotations, featureReader, (String)inference.get(4), "");
                    matched = true;
                    break;
                }
                evidenceAnnotations = this.checkMatchInScope(jCas, evidences, (Class)scope, windowSize);
                if (evidenceAnnotations == null || evidenceAnnotations.size() != evidences.size()) continue;
                this.addConclusion(jCas, topic, (String)inference.get(0), evidenceAnnotations, featureReader, (String)inference.get(4), ((Class)scope).getSimpleName());
                matched = true;
                break;
            }
            if (matched || !this.defaultDocTypes.containsKey(topic)) continue;
            this.addDefaultConclusion(jCas, topic);
        }
    }

    protected void clearCaches(HashMap<Class<? extends Annotation>, ArrayList<Annotation>> scopeAnnotations, HashMap<Class<? extends Annotation>, IntervalST<Integer>> scopeAnnotationTree, HashMap<Class<? extends Annotation>, IntervalST<Annotation>> evidenceAnnotationTree) {
        for (Class<? extends Annotation> annoClass : scopeAnnotations.keySet()) {
            scopeAnnotations.get(annoClass).clear();
            scopeAnnotationTree.put(annoClass, new IntervalST());
        }
        for (Class<? extends Annotation> annoClass : evidenceAnnotationTree.keySet()) {
            evidenceAnnotationTree.put(annoClass, new IntervalST());
        }
    }

    protected void addDefaultConclusion(JCas jCas, String topic) {
        Span span = this.getAnnotationPosition(jCas);
        if (this.aggregateFeatures) {
            this.addFeatureAggregatedDocAnnotation(jCas, span, topic, this.defaultDocTypes.get(topic), this.aggregateDefaultFeatureValues(this.defaultDocTypes.get(topic)), "default value");
        } else {
            String resultTypeShortName = this.defaultDocTypes.get(topic);
            AnnotationDefinition conclusionDef = AnnotationOper.createConclusionAnnotationDefinition(new AnnotationDefinition(this.typeDefinitions.get(resultTypeShortName)), this.evidenceConceptGetFeatures, this.uniqueFeatureClassMap, Arrays.asList(new Annotation[0]), this.typeDefinitions);
            if (this.overWriteNote) {
                conclusionDef.setFeatureValue("Note", "default conclusion");
            }
            this.addFeatureSeparatedDocAnnotation(jCas, span, conclusionDef, this.conceptClassMap.get(resultTypeShortName));
        }
    }

    protected void addConclusion(JCas jCas, String topic, String resultTypeShortName, ArrayList<Annotation> evidenceAnnotations, DocInferenceFeatureReader featureReader, String evidencesString, String scope) {
        if (evidenceAnnotations.size() > 0) {
            if (!scope.equals("SourceDocumentInformation") && !scope.equals("DocumentAnnotation")) {
                evidencesString = evidencesString + "(" + scope + ")";
            }
            ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
            Span span = this.getAnnotationPosition(jCas, evidenceAnnotations, toRemove);
            if (this.aggregateFeatures) {
                this.addFeatureAggregatedDocAnnotation(jCas, span, topic, resultTypeShortName, featureReader.getFeaturesString(evidenceAnnotations, this.evidenceConceptGetFeatures), evidencesString);
            } else {
                AnnotationDefinition conclusionDef = featureReader.getAnnotationDef(this.typeDefinitions.get(resultTypeShortName), evidenceAnnotations, this.evidenceConceptGetFeatures);
                if (this.overWriteNote) {
                    conclusionDef.setFeatureValue("Note", evidencesString);
                }
                this.addFeatureSeparatedDocAnnotation(jCas, span, conclusionDef, this.conceptClassMap.get(resultTypeShortName));
            }
            if (toRemove.size() > 0) {
                for (Annotation anno : toRemove) {
                    anno.removeFromIndexes();
                }
            }
        }
    }

    protected void addFeatureSeparatedDocAnnotation(JCas jCas, Span span, AnnotationDefinition conclusionDef, Class<? extends Annotation> docTypeClass) {
        Annotation docAnnotation = AnnotationOper.createAnnotation(jCas, conclusionDef, docTypeClass, span.getBegin(), span.getEnd());
        docAnnotation.addToIndexes();
    }

    @Deprecated
    protected void addFeatureSeparatedDocAnnotation(JCas jCas, Span span, String resultTypeShortName, AnnotationDefinition conclusionDef, Constructor<? extends Annotation> docTypeConstructor, HashMap<String, Method> conclusionSetFeatures) {
        Annotation docAnnotation = AnnotationOper.createAnnotation(jCas, conclusionDef, docTypeConstructor, span.getBegin(), span.getEnd(), conclusionSetFeatures);
        docAnnotation.addToIndexes();
    }

    protected String aggregateDefaultFeatureValues(String docType) {
        if (this.typeDefinitions.containsKey(docType)) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.typeDefinitions.get(docType).getFeatureValuePairs().entrySet()) {
                String featureName = entry.getKey();
                if (featureName.equals("Features")) {
                    return entry.getValue();
                }
                String value = entry.getValue();
                sb.append("\t\t");
                sb.append(featureName);
                sb.append(":\t");
                sb.append(value);
                sb.append("\n");
            }
            return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : "";
        }
        return null;
    }

    protected ArrayList<Annotation> checkMatchInScope(JCas jCas, ArrayList<Class> evidences, Class scopeType, int windowSize) {
        if (!this.scopeAnnotationTree.containsKey(scopeType)) {
            return new ArrayList<Annotation>();
        }
        for (Annotation firstEvidenceAnnotation : JCasUtil.select(jCas, evidences.get(0))) {
            ArrayList<Annotation> evidenceAnnotations = new ArrayList<Annotation>();
            evidenceAnnotations.add(firstEvidenceAnnotation);
            Integer scopeAnnotationId = this.scopeAnnotationTree.get(scopeType).get(new Interval1D(firstEvidenceAnnotation.getBegin(), firstEvidenceAnnotation.getEnd()));
            if (scopeAnnotationId != null) {
                Class evidenceType;
                Annotation evidence;
                ArrayList<Annotation> scopeAnnotationList = this.scopeAnnotations.get(scopeType);
                int begin = scopeAnnotationList.get(scopeAnnotationId).getBegin();
                int end = scopeAnnotationList.get(scopeAnnotationId).getEnd();
                if (windowSize > 0) {
                    int endId;
                    int beginId = scopeAnnotationId - windowSize;
                    if (beginId < 0) {
                        beginId = 0;
                    }
                    if ((endId = scopeAnnotationId + windowSize) >= scopeAnnotationList.size()) {
                        endId = scopeAnnotationList.size() - 1;
                    }
                    begin = scopeAnnotationList.get(beginId).getBegin();
                    end = scopeAnnotationList.get(endId).getEnd();
                }
                if (evidences.size() == 1) {
                    evidenceAnnotations.add(firstEvidenceAnnotation);
                    return evidenceAnnotations;
                }
                for (int i = 1; i < evidences.size() && (evidence = this.evidenceAnnotationTree.get(evidenceType = evidences.get(i)).get(new Interval1D(begin, end))) != null; ++i) {
                    evidenceAnnotations.add(evidence);
                }
                if (evidenceAnnotations.size() != evidences.size()) continue;
                return evidenceAnnotations;
            }
            return new ArrayList<Annotation>();
        }
        return null;
    }

    protected ArrayList<Annotation> checkMatchInDoc(JCas jCas, ArrayList<Class> evidences) {
        ArrayList<Annotation> evidenceAnnotations = new ArrayList<Annotation>();
        for (Class evidenceType : evidences) {
            Annotation evidenceAnnotation = this.hasAnnotation(jCas, evidenceType);
            if (evidenceAnnotation == null) {
                return null;
            }
            evidenceAnnotations.add(evidenceAnnotation);
        }
        return evidenceAnnotations;
    }

    protected void addFeatureAggregatedDocAnnotation(JCas jCas, Span span, String topic, String docTypeName, String featuresString, String evidencesString) {
        if (docTypeName != null) {
            logger.finest("Try add doc annotation: " + docTypeName);
            Constructor<? extends Annotation> cs = this.docTypeConstructorMap.get(docTypeName);
            try {
                Annotation anno = cs.newInstance(jCas, span.getBegin(), span.getEnd());
                if (anno instanceof Doc_Base) {
                    Doc_Base docAnno = (Doc_Base)anno;
                    docAnno.setTopic(topic);
                    docAnno.setNote(evidencesString);
                    docAnno.setFeatures(featuresString);
                    docAnno.addToIndexes();
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected Span getAnnotationPosition(JCas jCas, ArrayList<Annotation> evidenceAnnotations, ArrayList<Annotation> toRemove) {
        Span span = null;
        Annotation anno = null;
        switch (this.annotatePosition) {
            case "FIRSTEVIDENCE": {
                anno = evidenceAnnotations.get(0);
                span = new Span(anno.getBegin(), anno.getEnd());
                if (!this.replacing) break;
                toRemove.add(anno);
                break;
            }
            case "LASTEVIDENCE": {
                anno = evidenceAnnotations.get(evidenceAnnotations.size() - 1);
                span = new Span(anno.getBegin(), anno.getEnd());
                if (!this.replacing) break;
                toRemove.add(anno);
                break;
            }
            default: {
                span = this.getAnnotationPosition(jCas);
            }
        }
        return span;
    }

    protected Span getAnnotationPosition(JCas jCas) {
        Annotation anno = null;
        Span span = null;
        switch (this.annotatePosition) {
            case "FIRSTWORD": {
                anno = JCasUtil.selectByIndex(jCas, Token.class, 0);
                break;
            }
            case "FIRSTSENTENCE": {
                anno = JCasUtil.selectByIndex(jCas, Sentence.class, 0);
                break;
            }
            case "LASTWORD": {
                anno = JCasUtil.selectByIndex(jCas, Token.class, -1);
                break;
            }
            case "LASTSENTENCE": {
                anno = JCasUtil.selectByIndex(jCas, Sentence.class, -1);
                break;
            }
            default: {
                if (this.annotatePosition.startsWith("edu.") || this.annotatePosition.startsWith("org.") || this.annotatePosition.startsWith("com.") || this.annotatePosition.startsWith("net.")) {
                    anno = JCasUtil.selectByIndex(jCas, AnnotationOper.getTypeClass(this.annotatePosition), 0);
                    break;
                }
                String docText = jCas.getDocumentText();
                int begin = docText.indexOf(this.annotatePosition);
                int end = begin + this.annotatePosition.length();
                span = new Span(begin, end);
            }
        }
        if (anno != null) {
            return new Span(anno.getBegin(), anno.getEnd());
        }
        String txt = jCas.getDocumentText();
        Matcher matched = this.pattern.matcher(jCas.getDocumentText());
        if (matched.find()) {
            span = new Span(matched.start(1), matched.end(1));
        }
        return span;
    }

    protected Annotation hasAnnotation(JCas jcas, Class evidenceType) {
        Iterator annoIter = JCasUtil.iterator(jcas, evidenceType);
        if (annoIter.hasNext()) {
            return (Annotation)annoIter.next();
        }
        return null;
    }

    protected Annotation hasAnnotation(JCas jCas, Class evidenceType, Annotation scopeAnnotation) {
        if (this.evidenceAnnotationTree.get(evidenceType) == null) {
            return null;
        }
        Annotation res = this.evidenceAnnotationTree.get(evidenceType).get(new Interval1D(scopeAnnotation.getBegin(), scopeAnnotation.getEnd()));
        return res;
    }

    protected void indexAnnotations(JCas jCas) {
        IntervalST<Object> intervalST;
        for (Class<? extends Annotation> conceptType : this.evidenceAnnotationTree.keySet()) {
            intervalST = new IntervalST<Object>();
            for (Annotation annotation : JCasUtil.select(jCas, conceptType)) {
                intervalST.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), annotation);
            }
            this.evidenceAnnotationTree.put(conceptType, intervalST);
        }
        for (Class<? extends Annotation> scopeType : this.scopeAnnotationTree.keySet()) {
            intervalST = new IntervalST();
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Annotation annotation : JCasUtil.select(jCas, scopeType)) {
                intervalST.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), annotationList.size());
                annotationList.add(annotation);
            }
            this.scopeAnnotationTree.put(scopeType, intervalST);
            this.scopeAnnotations.put(scopeType, annotationList);
        }
    }

    protected static String getDefaultRuleStr() {
        return "@splitter:\t\n@Doc\tNeg_Doc\nDoc\tPos_Doc\tConcept";
    }

    @Deprecated
    public static LinkedHashMap<String, TypeDefinition> getTypeDefinitions(String ruleStr) {
        return new DocInferenceAnnotator().getTypeDefs(ruleStr);
    }

    public LinkedHashMap<String, TypeDefinition> getTypeDefs(IOUtil ioUtil) {
        if (ioUtil.getInitiations().size() > 0) {
            UIMATypeFunctions.getTypeDefinitions(ioUtil, this.ruleCells, this.valueFeatureMap, new HashMap<String, Integer>(), this.defaultDocTypes, this.typeDefinitions);
        }
        if (ioUtil.settings.containsKey("aggregate") && ioUtil.settings.get("aggregate").toLowerCase().startsWith("f")) {
            this.aggregateFeatures = false;
        }
        if (this.aggregateFeatures) {
            String shortName;
            String docTypeName;
            this.ruleCells = ioUtil.getRuleCells();
            for (ArrayList<String> initRow : ioUtil.getInitiations()) {
                logger.finest("Parse initiation rule:" + initRow);
                docTypeName = DeterminantValueSet.checkNameSpace(initRow.get(2).trim());
                shortName = DeterminantValueSet.getShortName(docTypeName);
                this.typeDefinitions.put(shortName, new TypeDefinition(docTypeName, Doc_Base.class.getCanonicalName()));
                if (initRow.size() <= 4) continue;
                String defaultFeatureStr = "\t\t" + String.join((CharSequence)"\n\t\t", initRow.subList(4, initRow.size()));
                defaultFeatureStr = defaultFeatureStr.replaceAll(":\\s*", ":\t");
                this.typeDefinitions.get(shortName).addFeatureDefaultValue("Features", defaultFeatureStr);
            }
            for (ArrayList<String> row : this.ruleCells) {
                logger.finest("Parse rule:" + row);
                docTypeName = DeterminantValueSet.checkNameSpace(row.get(2).trim());
                shortName = DeterminantValueSet.getShortName(docTypeName);
                if (this.typeDefinitions.containsKey(shortName)) continue;
                this.typeDefinitions.put(shortName, new TypeDefinition(docTypeName, Doc_Base.class.getCanonicalName()));
            }
        }
        return this.typeDefinitions;
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefs(String ruleStr) {
        if (ruleStr.trim().length() == 0 || ruleStr.equals("default")) {
            ruleStr = DocInferenceAnnotator.getDefaultRuleStr();
        } else if (ruleStr.indexOf("|") != -1) {
            ruleStr = ruleStr.replaceAll("\\|", "\n");
        }
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        this.typeDefinitions = this.getTypeDefs(ioUtil);
        return this.typeDefinitions;
    }
}

