/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.AnnotationDefinition;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.type.system.Concept;
import edu.utah.bmi.nlp.uima.ae.FeatureInferenceAnnotator;
import edu.utah.bmi.nlp.uima.ae.FeatureInferencerInf;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.common.UIMATypeFunctions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;

public class FeatureAnnotationInferencer
implements FeatureInferencerInf {
    public static Logger logger = IOUtil.getLogger(FeatureInferenceAnnotator.class);
    private LinkedHashMap<Class<? extends Annotation>, Object> ruleMap = new LinkedHashMap();
    private HashMap<String, HashMap<String, Method>> evidenceConceptGetFeatures = new HashMap();
    private HashMap<Class, HashMap<String, Method>> conclusionConceptSetFeatures = new HashMap();
    private HashMap<String, Class<? extends Annotation>> conceptClassMap = new HashMap();
    private HashMap<String, Constructor<? extends Annotation>> conceptTypeConstructors = new HashMap();
    private LinkedHashMap<String, TypeDefinition> typeDefinitions = new LinkedHashMap();
    private HashMap<String, AnnotationDefinition> conclusionAnnotationDefinitions = new HashMap();
    private HashMap<String, String> uniqueFeatureClassMap = new HashMap();
    private HashMap<String, String> valueFeatureMap = new HashMap();
    private HashMap<String, Class<? extends Annotation>> scopeIndex = new HashMap();
    private HashMap<Class, IntervalST<Annotation>> scopes = new HashMap();
    private boolean removeEvidenceConcept = true;
    private boolean noteRuleId = false;
    private ArrayList<ArrayList<String>> ruleCells = new ArrayList();
    @Deprecated
    public boolean debug = false;
    private boolean strictNameMatch = false;
    private static String END = "<END>";

    public FeatureAnnotationInferencer() {
    }

    public FeatureAnnotationInferencer(String ruleStr, boolean removeEvidenceConcept, boolean strictNameMatch, boolean noteRuleId) {
        this.typeDefinitions = this.getTypeDefinitions(ruleStr);
        this.removeEvidenceConcept = removeEvidenceConcept;
        this.strictNameMatch = strictNameMatch;
        this.noteRuleId = noteRuleId;
    }

    public FeatureAnnotationInferencer(IOUtil ioUtil, boolean removeEvidenceConcept, boolean strictNameMatch, boolean noteRuleId) {
        this.typeDefinitions = this.getTypeDefinitions(ioUtil);
        this.removeEvidenceConcept = removeEvidenceConcept;
        this.strictNameMatch = strictNameMatch;
        this.noteRuleId = noteRuleId;
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public LinkedHashMap<String, TypeDefinition> getTypeDefinitions(String ruleStr) {
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        return this.getTypeDefinitions(ioUtil);
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefinitions(IOUtil ioUtil) {
        UIMATypeFunctions.getTypeDefinitions(ioUtil, this.ruleCells, this.valueFeatureMap, new HashMap<String, Integer>(), new HashMap<String, String>(), this.typeDefinitions);
        for (ArrayList<String> row : this.ruleCells) {
            String conclusionTypeName = row.get(1).trim();
            String evidenceTypeName = row.get(3);
            HashMap<String, String> evidenceTypeMethodTypes = this.getMethodTypes(evidenceTypeName);
            TypeDefinition typeDefinition = !this.typeDefinitions.containsKey(conclusionTypeName) ? new TypeDefinition(conclusionTypeName, Concept.class.getCanonicalName(), new ArrayList<String>()) : this.typeDefinitions.get(conclusionTypeName);
            for (String featureValuePairString : row.get(2).split(",")) {
                String[] featureValuePair = featureValuePairString.split(":");
                String featureName = featureValuePair[0];
                if (featureValuePair[0].startsWith("COPYALL")) {
                    if (!this.typeDefinitions.containsKey(conclusionTypeName)) {
                        logger.info("You need to define the Concept '" + conclusionTypeName + "' first before using 'COPYALL' or 'COPYALLEXCEPT' syntax.");
                        logger.info("For instance: @CONCEPT_FEATURES\tNegated_PE\tConcept\tSection:DocumentAnnotation\nThis rule define a 'Negated_PE' concept derived from 'Concept' type, and has one feature 'Section', with default value 'DocumentAnnotation'");
                        continue;
                    }
                    ArrayList<String> newFeatureNames = new ArrayList<String>(typeDefinition.getNewFeatureNames());
                    for (String name : newFeatureNames) {
                        if (!evidenceTypeMethodTypes.containsKey(name)) continue;
                        typeDefinition.setFeatureType(name, evidenceTypeMethodTypes.get(name));
                        if (typeDefinition.getFeatureValuePairs().containsKey(name)) continue;
                        typeDefinition.addFeatureDefaultValue(name, null);
                    }
                    Class<? extends Annotation> superClass = AnnotationOper.getTypeClass(typeDefinition.fullSuperTypeName);
                    if (superClass == null) continue;
                    LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
                    AnnotationOper.getMethods(superClass, methods);
                    for (Method m3 : methods) {
                        featureName = m3.getName().substring(3);
                        if (!evidenceTypeMethodTypes.containsKey(featureName)) continue;
                        typeDefinition.setFeatureType(featureName, evidenceTypeMethodTypes.get(featureName));
                        if (typeDefinition.getFeatureValuePairs().containsKey(featureName)) continue;
                        typeDefinition.addFeatureDefaultValue(featureName, null);
                    }
                    continue;
                }
                if (typeDefinition.featureDefaultValues.containsKey(featureName)) continue;
                typeDefinition.addFeatureDefaultValue(featureName, "");
            }
            this.typeDefinitions.put(typeDefinition.shortTypeName, typeDefinition);
        }
        return this.typeDefinitions;
    }

    public HashMap<String, String> getMethodTypes(String evidenceTypeName) {
        if (this.typeDefinitions.containsKey(evidenceTypeName)) {
            return this.typeDefinitions.get((Object)evidenceTypeName).featureTypes;
        }
        HashMap<String, String> methodTypes = UIMATypeFunctions.getMethodUIMATypesFromLoadedClass(evidenceTypeName);
        return methodTypes;
    }

    @Override
    public void init() {
        this.ruleMap.clear();
        this.conceptClassMap.clear();
        this.conceptTypeConstructors.clear();
        this.evidenceConceptGetFeatures.clear();
        this.conclusionConceptSetFeatures.clear();
        AnnotationOper.initSetReflections(this.typeDefinitions, this.conceptClassMap, this.conceptTypeConstructors, this.conclusionConceptSetFeatures);
        this.initRuleMap();
    }

    private void initRuleMap() {
        for (ArrayList<String> row : this.ruleCells) {
            Class<? extends Annotation> scopeClass;
            String scopeShortName;
            String conclusionTypeName = row.get(1);
            AnnotationDefinition annotationDefinition = new AnnotationDefinition(this.typeDefinitions.get(conclusionTypeName));
            ArrayList<String> needEvidenceFeatures = new ArrayList<String>();
            String evidenceTypeName = row.get(3);
            Class<? extends Annotation> evidenceTypeClass = AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(evidenceTypeName));
            String evidenceTypeShortName = DeterminantValueSet.getShortName(evidenceTypeName);
            this.augmentRule(row.get(1), row.get(2), evidenceTypeClass, evidenceTypeShortName, annotationDefinition, needEvidenceFeatures);
            this.conceptClassMap.put(evidenceTypeShortName, evidenceTypeClass);
            if (row.get(4).trim().length() > 0) {
                if (!this.ruleMap.containsKey(evidenceTypeClass)) {
                    this.ruleMap.put(evidenceTypeClass, new LinkedHashMap());
                }
                LinkedHashMap tmp = (LinkedHashMap)this.ruleMap.get(evidenceTypeClass);
                String[] featureValueMatchRule = this.augmentConditionRule(row.get(4));
                AnnotationOper.initGetReflections(this.evidenceConceptGetFeatures, evidenceTypeShortName, evidenceTypeClass, featureValueMatchRule, needEvidenceFeatures);
                if (featureValueMatchRule.length % 2 == 0) {
                    for (int i = 0; i < featureValueMatchRule.length; ++i) {
                        String key = featureValueMatchRule[i].trim();
                        if (key.indexOf(":") != -1) {
                            key = key.split(":")[0].trim();
                        }
                        if (!tmp.containsKey(key)) {
                            tmp.put(key, new LinkedHashMap());
                        }
                        tmp = (LinkedHashMap)tmp.get(key);
                    }
                    if (!tmp.containsKey(END)) {
                        tmp.put(END, new ArrayList());
                    }
                    ((ArrayList)tmp.get(END)).add(row.get(0));
                    this.conclusionAnnotationDefinitions.put(row.get(0), annotationDefinition);
                } else {
                    logger.info("Rule error: " + row.get(4) + "\n\tin rule: " + row);
                    logger.info("Feature and value need to be paired.");
                }
            } else {
                if (!this.ruleMap.containsKey(evidenceTypeClass)) {
                    this.ruleMap.put(evidenceTypeClass, new LinkedHashMap());
                    ((LinkedHashMap)this.ruleMap.get(evidenceTypeClass)).put(END, new ArrayList());
                }
                ((ArrayList)((LinkedHashMap)this.ruleMap.get(evidenceTypeClass)).get(END)).add(row.get(0));
                this.conclusionAnnotationDefinitions.put(row.get(0), annotationDefinition);
                AnnotationOper.initGetReflections(this.evidenceConceptGetFeatures, evidenceTypeShortName, evidenceTypeClass, new String[0], needEvidenceFeatures);
            }
            if (row.size() <= 5 || row.get(5).trim().length() <= 0 || (scopeShortName = row.get(5).trim()).equals("DocumentAnnotation") || scopeShortName.equals("SourceDocumentInformation") || (scopeClass = AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(scopeShortName))) == DocumentAnnotation.class || scopeClass == SourceDocumentInformation.class) continue;
            this.scopeIndex.put(row.get(0), scopeClass);
        }
    }

    private String[] augmentConditionRule(String conditionString) {
        String[] baseRules = conditionString.split(",");
        String[] featureValueMatchRule = new String[baseRules.length * 2];
        for (int i = 0; i < baseRules.length; ++i) {
            String value;
            String ele = baseRules[i];
            String featureName = null;
            String[] valueFeatureName = ele.split(":");
            if (valueFeatureName.length == 1) {
                value = valueFeatureName[0];
                if (this.valueFeatureMap.containsKey(value)) {
                    featureName = this.valueFeatureMap.get(value);
                } else {
                    logger.info("You cannot use short form to define conditions, when the value: '" + value + "' hasn't been paired up with its feature name. \n Set it up using '@FEATURE_VALUES\tfeaturename\tvalue1\tvalue2...'");
                }
            } else {
                featureName = valueFeatureName[0];
                value = valueFeatureName[1];
            }
            featureValueMatchRule[i * 2] = featureName;
            featureValueMatchRule[i * 2 + 1] = value;
        }
        return featureValueMatchRule;
    }

    private void augmentRule(String conclusionType, String featureValues, Class<? extends Annotation> evidenceTypeClass, String evidenceTypeShortName, AnnotationDefinition annotationDefinition, ArrayList<String> needEvidenceFeatures) {
        if (featureValues.trim().length() == 0) {
            return;
        }
        String[] featureValuePairs = featureValues.split(",");
        switch (featureValuePairs[0]) {
            case "COPYALL": {
                for (String featureName : this.conclusionConceptSetFeatures.get(this.conceptClassMap.get(conclusionType)).keySet()) {
                    if (!this.evidenceConceptGetFeatures.containsKey(evidenceTypeShortName)) {
                        this.evidenceConceptGetFeatures.put(evidenceTypeShortName, new HashMap());
                    }
                    if (this.evidenceConceptGetFeatures.get(evidenceTypeShortName).containsKey(featureName) && this.evidenceConceptGetFeatures.get(evidenceTypeShortName).get(featureName) != null) {
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    Method m3 = AnnotationOper.getDefaultGetMethod(evidenceTypeClass, featureName);
                    if (m3 != null) {
                        this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m3);
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m3);
                }
                break;
            }
            case "COPYALLEXCEPT": {
                HashSet<String> skipFeatures = new HashSet<String>();
                for (int i = 1; i < featureValuePairs.length; ++i) {
                    String featureValue = featureValuePairs[i];
                    String[] fvpair = featureValue.split(":");
                    skipFeatures.add(fvpair[0].trim());
                    if (fvpair.length <= 1) continue;
                    annotationDefinition.addFeatureDefaultValue(fvpair[0], fvpair[1]);
                    if (!Character.isUpperCase(fvpair[1].charAt(0))) continue;
                    needEvidenceFeatures.add(fvpair[1].trim());
                }
                for (String featureName : this.conclusionConceptSetFeatures.get(this.conceptClassMap.get(conclusionType)).keySet()) {
                    if (skipFeatures.contains(featureName)) continue;
                    if (!this.evidenceConceptGetFeatures.containsKey(evidenceTypeShortName)) {
                        this.evidenceConceptGetFeatures.put(evidenceTypeShortName, new HashMap());
                    }
                    if (this.evidenceConceptGetFeatures.get(evidenceTypeShortName).containsKey(featureName) && this.evidenceConceptGetFeatures.get(evidenceTypeShortName).get(featureName) != null) {
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    Method m4 = AnnotationOper.getMethod(evidenceTypeClass, AnnotationOper.inferGetMethodName(featureName), new Class[0]);
                    if (m4 != null) {
                        this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m4);
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m4);
                }
                break;
            }
            default: {
                for (String featureValue : featureValuePairs) {
                    String[] fvpair = this.augmentRules(featureValue);
                    annotationDefinition.addFeatureDefaultValue(fvpair[0], fvpair[1]);
                    if (fvpair.length != 1 && fvpair[1] != null && !Character.isUpperCase(fvpair[1].charAt(0))) continue;
                    needEvidenceFeatures.add(fvpair[0].trim());
                }
            }
        }
    }

    private String[] augmentRules(String ruleString) {
        String featureValue;
        String featureName;
        if (ruleString.indexOf(":") != -1) {
            String[] pairArray = ruleString.split(":");
            featureName = pairArray[0].trim();
            featureValue = pairArray[1].trim();
        } else {
            featureName = ruleString.trim();
            featureValue = null;
        }
        return new String[]{featureName, featureValue};
    }

    @Override
    public void processInferences(JCas jcas) {
        this.indexScopes(jcas);
        for (Class<? extends Annotation> evidenceTypeClass : this.ruleMap.keySet()) {
            this.findNAddMatches(jcas, evidenceTypeClass, evidenceTypeClass.getSimpleName());
        }
    }

    private void indexScopes(JCas jCas) {
        this.scopes.clear();
        for (Class<? extends Annotation> scopeClass : this.scopeIndex.values()) {
            IntervalST<Annotation> scopeTree = new IntervalST<Annotation>();
            for (Annotation annotation : JCasUtil.select(jCas, scopeClass)) {
                scopeTree.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), annotation);
            }
            this.scopes.put(scopeClass, scopeTree);
        }
    }

    public void findNAddMatches(JCas jcas, Class<? extends Annotation> evidenceTypeClass, String evidenceTypeShortName) {
        ArrayList<Annotation> scheduledRemoval = new ArrayList<Annotation>();
        ArrayList<Annotation> scheduledSaving = new ArrayList<Annotation>();
        for (Annotation annotation : JCasUtil.select(jcas, evidenceTypeClass)) {
            HashMap<String, AnnotationDefinition> conclusions;
            if (this.strictNameMatch && !annotation.getClass().getSimpleName().equals(evidenceTypeShortName) || (conclusions = this.findMatches(annotation, evidenceTypeClass, this.evidenceConceptGetFeatures.get(evidenceTypeShortName), this.ruleMap.get(evidenceTypeClass), new HashMap<String, AnnotationDefinition>())).size() <= 0) continue;
            if (this.removeEvidenceConcept) {
                scheduledRemoval.add(annotation);
            }
            this.addToScheduledSaving(jcas, evidenceTypeShortName, conclusions, annotation, scheduledSaving);
        }
        for (Annotation annotation : scheduledRemoval) {
            annotation.removeFromIndexes();
        }
        for (Annotation annotation : scheduledSaving) {
            annotation.addToIndexes();
        }
    }

    private void addToScheduledSaving(JCas jcas, String evidenceTypeShortName, HashMap<String, AnnotationDefinition> conclusions, Annotation evidenceAnnotation, ArrayList<Annotation> scheduledSaving) {
        Annotation anno = null;
        for (AnnotationDefinition conclusionAnnotationDefinition : conclusions.values()) {
            Class<? extends Annotation> conceptCls;
            AnnotationDefinition conclusionDef = AnnotationOper.createConclusionAnnotationDefinition(conclusionAnnotationDefinition, this.evidenceConceptGetFeatures, this.uniqueFeatureClassMap, Arrays.asList(evidenceAnnotation), this.typeDefinitions);
            anno = AnnotationOper.createAnnotation(jcas, conclusionDef, conceptCls = AnnotationOper.getTypeClass(conclusionAnnotationDefinition.getFullTypeName()), evidenceAnnotation.getBegin(), evidenceAnnotation.getEnd());
            if (anno == null) continue;
            scheduledSaving.add(anno);
        }
    }

    private HashMap<String, AnnotationDefinition> findMatches(Annotation annotation, Class typeClass, HashMap<String, Method> methodHashMap, Object value, HashMap<String, AnnotationDefinition> conclusions) {
        if (value instanceof AnnotationDefinition) {
            AnnotationDefinition conclusionType = (AnnotationDefinition)value;
            conclusions.put(conclusionType.getShortTypeName(), conclusionType);
            return conclusions;
        }
        LinkedHashMap ruleMaps = (LinkedHashMap)value;
        for (String featureName : ruleMaps.keySet()) {
            if (featureName.equals(END)) {
                for (String ruleId : (ArrayList)ruleMaps.get(END)) {
                    this.addConclusion(ruleId, annotation, conclusions);
                }
                break;
            }
            try {
                if (!methodHashMap.containsKey(featureName)) {
                    logger.warning("Feature Name: " + featureName + " hasn't been initiated.");
                }
                String annotationFeatureValue = (String)methodHashMap.get(featureName).invoke((Object)annotation, new Object[0]);
                Object nextStep = ruleMaps.get(featureName);
                if (!((LinkedHashMap)nextStep).containsKey(annotationFeatureValue)) continue;
                if (((LinkedHashMap)(nextStep = ((LinkedHashMap)nextStep).get(annotationFeatureValue))).containsKey(END)) {
                    for (String ruleId : (ArrayList)((LinkedHashMap)nextStep).get(END)) {
                        this.addConclusion(ruleId, annotation, conclusions);
                    }
                }
                this.findMatches(annotation, typeClass, methodHashMap, nextStep, conclusions);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return conclusions;
    }

    private void addConclusion(String ruleId, Annotation annotation, HashMap<String, AnnotationDefinition> conclusions) {
        if (this.scopeIndex.containsKey(ruleId)) {
            if (this.scopes.get(this.scopeIndex.get(ruleId)).search(new Interval1D(annotation.getBegin(), annotation.getEnd())) != null) {
                AnnotationDefinition conclusionType = this.conclusionAnnotationDefinitions.get(ruleId);
                conclusions.put(conclusionType.getShortTypeName(), conclusionType);
            }
        } else {
            AnnotationDefinition conclusionType = this.conclusionAnnotationDefinitions.get(ruleId);
            conclusions.put(conclusionType.getShortTypeName(), conclusionType);
        }
    }
}

