/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.AnnotationDefinition;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.type.system.Concept;
import edu.utah.bmi.nlp.uima.ae.FeatureInferenceAnnotator;
import edu.utah.bmi.nlp.uima.ae.FeatureInferencerInf;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.common.UIMATypeFunctions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;

public class FeatureAnnotationInferencerEx
implements FeatureInferencerInf {
    public static Logger logger = IOUtil.getLogger(FeatureInferenceAnnotator.class);
    private LinkedHashMap<Class, Object> ruleMap = new LinkedHashMap();
    private HashMap<String, HashMap<String, Method>> evidenceConceptGetFeatures = new HashMap();
    private HashMap<Class, HashMap<String, Method>> conclusionConceptSetFeatures = new HashMap();
    private HashMap<String, Class<? extends Annotation>> conceptClassMap = new HashMap();
    private HashMap<String, Constructor<? extends Annotation>> conceptTypeConstructors = new HashMap();
    private LinkedHashMap<String, TypeDefinition> typeDefinitions = new LinkedHashMap();
    private HashMap<Integer, AnnotationDefinition> conclusionAnnotationDefinitions = new HashMap();
    private HashMap<String, String> uniqueFeatureClassMap = new HashMap();
    private HashMap<String, String> valueFeatureMap = new HashMap();
    private HashMap<String, Class<? extends Annotation>> scopeIndex = new HashMap();
    private HashMap<Class, IntervalST<Annotation>> scopes = new HashMap();
    private boolean removeEvidenceConcept = true;
    private boolean noteRuleId = true;
    private ArrayList<ArrayList<String>> ruleCells = new ArrayList();
    @Deprecated
    public boolean debug = false;
    private boolean strictNameMatch = false;
    private static String END = "<END>";
    public HashMap<Integer, ArrayList<String>> ruleStore = new HashMap();

    public FeatureAnnotationInferencerEx() {
    }

    public FeatureAnnotationInferencerEx(String ruleStr, boolean removeEvidenceConcept, boolean strictNameMatch, boolean noteRuleId) {
        this.typeDefinitions = this.getTypeDefinitions(ruleStr);
        this.removeEvidenceConcept = removeEvidenceConcept;
        this.strictNameMatch = strictNameMatch;
        this.noteRuleId = noteRuleId;
    }

    public FeatureAnnotationInferencerEx(IOUtil ioUtil, boolean removeEvidenceConcept, boolean strictNameMatch, boolean noteRuleId) {
        this.typeDefinitions = this.getTypeDefinitions(ioUtil);
        this.removeEvidenceConcept = removeEvidenceConcept;
        this.strictNameMatch = strictNameMatch;
        this.noteRuleId = noteRuleId;
    }

    @Override
    @Deprecated
    public LinkedHashMap<String, TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public LinkedHashMap<String, TypeDefinition> getTypeDefinitions(String ruleStr) {
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        return this.getTypeDefinitions(ioUtil);
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefinitions(IOUtil ioUtil) {
        UIMATypeFunctions.getTypeDefinitions(ioUtil, this.ruleCells, this.valueFeatureMap, new HashMap<String, Integer>(), new HashMap<String, String>(), this.typeDefinitions);
        for (ArrayList<String> row : this.ruleCells) {
            try {
                String conclusionTypeName = row.get(2).trim();
                String evidenceTypeName = row.get(4);
                HashMap<String, String> evidenceTypeMethodTypes = this.getMethodTypes(evidenceTypeName);
                TypeDefinition typeDefinition = !this.typeDefinitions.containsKey(conclusionTypeName) ? new TypeDefinition(conclusionTypeName, Concept.class.getCanonicalName(), new ArrayList<String>()) : this.typeDefinitions.get(conclusionTypeName);
                for (String featureValuePairString : row.get(3).split(",")) {
                    String[] featureValuePair = featureValuePairString.split(":");
                    String featureName = featureValuePair[0];
                    if (featureValuePair[0].startsWith("COPYALL")) {
                        if (!this.typeDefinitions.containsKey(conclusionTypeName)) {
                            logger.info("You need to define the Concept '" + conclusionTypeName + "' first before using 'COPYALL' or 'COPYALLEXCEPT' syntax.");
                            logger.info("For instance: @CONCEPT_FEATURES\tNegated_PE\tConcept\tSection:DocumentAnnotation\nThis rule define a 'Negated_PE' concept derived from 'Concept' type, and has one feature 'Section', with default value 'DocumentAnnotation'");
                            continue;
                        }
                        ArrayList<String> newFeatureNames = new ArrayList<String>(typeDefinition.getNewFeatureNames());
                        for (String name : newFeatureNames) {
                            if (!evidenceTypeMethodTypes.containsKey(name)) continue;
                            typeDefinition.setFeatureType(name, evidenceTypeMethodTypes.get(name));
                            if (typeDefinition.getFeatureValuePairs().containsKey(name)) continue;
                            typeDefinition.addFeatureDefaultValue(name, null);
                        }
                        Class<? extends Annotation> superClass = AnnotationOper.getTypeClass(typeDefinition.fullSuperTypeName);
                        if (superClass == null) continue;
                        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
                        AnnotationOper.getMethods(superClass, methods);
                        for (Method m3 : methods) {
                            featureName = m3.getName().substring(3);
                            if (!evidenceTypeMethodTypes.containsKey(featureName)) continue;
                            typeDefinition.setFeatureType(featureName, evidenceTypeMethodTypes.get(featureName));
                            if (typeDefinition.getFeatureValuePairs().containsKey(featureName)) continue;
                            typeDefinition.addFeatureDefaultValue(featureName, null);
                        }
                        continue;
                    }
                    if (typeDefinition.featureDefaultValues.containsKey(featureName)) continue;
                    typeDefinition.addFeatureDefaultValue(featureName, "");
                }
                this.typeDefinitions.put(typeDefinition.shortTypeName, typeDefinition);
            }
            catch (Exception e) {
                logger.warning("Error to parse row: " + row);
            }
        }
        return this.typeDefinitions;
    }

    public HashMap<String, String> getMethodTypes(String evidenceTypeName) {
        if (this.typeDefinitions.containsKey(evidenceTypeName)) {
            return this.typeDefinitions.get((Object)evidenceTypeName).featureTypes;
        }
        HashMap<String, String> methodTypes = UIMATypeFunctions.getMethodUIMATypesFromLoadedClass(evidenceTypeName);
        return methodTypes;
    }

    @Override
    public void init() {
        this.ruleMap.clear();
        this.conceptClassMap.clear();
        this.conceptTypeConstructors.clear();
        this.evidenceConceptGetFeatures.clear();
        this.conclusionConceptSetFeatures.clear();
        AnnotationOper.initSetReflections(this.typeDefinitions, this.conceptClassMap, this.conceptTypeConstructors, this.conclusionConceptSetFeatures);
        this.initRuleMap();
    }

    private void initRuleMap() {
        for (ArrayList<String> row : this.ruleCells) {
            try {
                this.ruleStore.put(Integer.parseInt(row.get(0)), row);
                String conclusionTypeName = row.get(2);
                ArrayList<String> needEvidenceFeatures = new ArrayList<String>();
                AnnotationDefinition annotationDefinition = new AnnotationDefinition(this.typeDefinitions.get(conclusionTypeName));
                String evidenceTypeName = row.get(4);
                Class<? extends Annotation> evidenceTypeClass = AnnotationOper.getTypeClass(evidenceTypeName);
                if (evidenceTypeClass == null) {
                    System.out.println(row);
                    logger.warning("Class " + evidenceTypeName + " has not been loaded to memory, check the Class definition for rule: " + row);
                    continue;
                }
                String evidenceTypeShortName = DeterminantValueSet.getShortName(evidenceTypeName);
                this.augmentRule(row.get(2), row.get(3), evidenceTypeClass, evidenceTypeShortName, annotationDefinition, needEvidenceFeatures);
                this.conceptClassMap.put(evidenceTypeShortName, evidenceTypeClass);
                int ruleId = Integer.parseInt(row.get(0));
                if (row.size() > 5 && row.get(5).trim().length() > 0) {
                    if (!this.ruleMap.containsKey(evidenceTypeClass)) {
                        this.ruleMap.put(evidenceTypeClass, new LinkedHashMap());
                    }
                    LinkedHashMap tmp = (LinkedHashMap)this.ruleMap.get(evidenceTypeClass);
                    String[] featureValueMatchRule = this.augmentConditionRule(row.get(5));
                    AnnotationOper.initGetReflections(this.evidenceConceptGetFeatures, evidenceTypeShortName, evidenceTypeClass, featureValueMatchRule, needEvidenceFeatures);
                    if (featureValueMatchRule.length % 2 == 0) {
                        for (int i = 0; i < featureValueMatchRule.length; ++i) {
                            String key = featureValueMatchRule[i].trim();
                            if (key.indexOf(":") != -1) {
                                key = key.split(":")[0].trim();
                            }
                            if (!tmp.containsKey(key)) {
                                tmp.put(key, new LinkedHashMap());
                            }
                            tmp = (LinkedHashMap)tmp.get(key);
                        }
                        if (!tmp.containsKey(END)) {
                            tmp.put(END, new ArrayList());
                        }
                        ((ArrayList)tmp.get(END)).add(ruleId);
                        this.conclusionAnnotationDefinitions.put(ruleId, annotationDefinition);
                    } else {
                        logger.info("Rule error: " + row.get(4) + "\n\tin rule: " + row);
                        logger.info("Feature and value need to be paired.");
                    }
                } else {
                    if (row.size() == 5) {
                        this.ruleStore.get(Integer.parseInt(row.get(0))).add("");
                    }
                    if (!this.ruleMap.containsKey(evidenceTypeClass)) {
                        this.ruleMap.put(evidenceTypeClass, new LinkedHashMap());
                        ((LinkedHashMap)this.ruleMap.get(evidenceTypeClass)).put(END, new ArrayList());
                    } else if (!((LinkedHashMap)this.ruleMap.get(evidenceTypeClass)).containsKey(END)) {
                        ((LinkedHashMap)this.ruleMap.get(evidenceTypeClass)).put(END, new ArrayList());
                    }
                    ((ArrayList)((LinkedHashMap)this.ruleMap.get(evidenceTypeClass)).get(END)).add(ruleId);
                    this.conclusionAnnotationDefinitions.put(ruleId, annotationDefinition);
                    AnnotationOper.initGetReflections(this.evidenceConceptGetFeatures, evidenceTypeShortName, evidenceTypeClass, new String[0], needEvidenceFeatures);
                }
                if (row.size() > 6 && row.get(6).trim().length() > 0) {
                    String scopeShortName = row.get(6).trim();
                    if (scopeShortName.equals("DocumentAnnotation") || scopeShortName.equals("SourceDocumentInformation") || scopeShortName.equals(SourceDocumentInformation.class.getCanonicalName()) || scopeShortName.equals(DocumentAnnotation.class.getCanonicalName())) continue;
                    Class<? extends Annotation> scopeClass = AnnotationOper.getTypeClass(scopeShortName);
                    if (scopeClass == null) {
                        logger.warning("Class " + scopeShortName + "' has not been loaded to memory. Check section rules see if this section has been defined.");
                    }
                    this.scopeIndex.put(scopeClass.getSimpleName(), scopeClass);
                    continue;
                }
                if (row.size() != 6) continue;
                this.ruleStore.get(Integer.parseInt(row.get(0))).add("");
            }
            catch (Exception e) {
                logger.warning("Rule error: " + row.get(4) + "\n\tin rule: " + row);
                logger.warning("Feature and value need to be paired.");
            }
        }
    }

    private String[] augmentConditionRule(String conditionString) {
        String[] baseRules = conditionString.split(",");
        String[] featureValueMatchRule = new String[baseRules.length * 2];
        for (int i = 0; i < baseRules.length; ++i) {
            String value;
            String ele = baseRules[i];
            String featureName = null;
            String[] valueFeatureName = ele.split(":");
            if (valueFeatureName.length == 1) {
                value = valueFeatureName[0];
                if (this.valueFeatureMap.containsKey(value)) {
                    featureName = this.valueFeatureMap.get(value);
                } else {
                    logger.info("You cannot use short form to define conditions, when the value: '" + value + "' hasn't been paired up with its feature name. \n Set it up using '@FEATURE_VALUES\tfeaturename\tvalue1\tvalue2...'");
                }
            } else {
                featureName = valueFeatureName[0];
                value = valueFeatureName[1];
            }
            featureValueMatchRule[i * 2] = featureName;
            featureValueMatchRule[i * 2 + 1] = value;
        }
        return featureValueMatchRule;
    }

    private void augmentRule(String conclusionType, String featureValues, Class<? extends Annotation> evidenceTypeClass, String evidenceTypeShortName, AnnotationDefinition annotationDefinition, ArrayList<String> needEvidenceFeatures) {
        if (featureValues.trim().length() == 0) {
            return;
        }
        String[] featureValuePairs = featureValues.split(",");
        switch (featureValuePairs[0]) {
            case "COPYALL": {
                for (String featureName : this.conclusionConceptSetFeatures.get(this.conceptClassMap.get(conclusionType)).keySet()) {
                    if (!this.evidenceConceptGetFeatures.containsKey(evidenceTypeShortName)) {
                        this.evidenceConceptGetFeatures.put(evidenceTypeShortName, new HashMap());
                    }
                    if (this.evidenceConceptGetFeatures.get(evidenceTypeShortName).containsKey(featureName) && this.evidenceConceptGetFeatures.get(evidenceTypeShortName).get(featureName) != null) {
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    Method m3 = AnnotationOper.getDefaultGetMethod(evidenceTypeClass, featureName);
                    if (m3 != null) {
                        this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m3);
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m3);
                }
                break;
            }
            case "COPYALLEXCEPT": {
                HashSet<String> skipFeatures = new HashSet<String>();
                for (int i = 1; i < featureValuePairs.length; ++i) {
                    String featureValue = featureValuePairs[i];
                    String[] fvpair = featureValue.split(":");
                    skipFeatures.add(fvpair[0].trim());
                    if (fvpair.length <= 1) continue;
                    annotationDefinition.addFeatureDefaultValue(fvpair[0], fvpair[1]);
                    if (!Character.isUpperCase(fvpair[1].charAt(0))) continue;
                    needEvidenceFeatures.add(fvpair[1].trim());
                }
                for (String featureName : this.conclusionConceptSetFeatures.get(this.conceptClassMap.get(conclusionType)).keySet()) {
                    if (skipFeatures.contains(featureName)) continue;
                    if (!this.evidenceConceptGetFeatures.containsKey(evidenceTypeShortName)) {
                        this.evidenceConceptGetFeatures.put(evidenceTypeShortName, new HashMap());
                    }
                    if (this.evidenceConceptGetFeatures.get(evidenceTypeShortName).containsKey(featureName) && this.evidenceConceptGetFeatures.get(evidenceTypeShortName).get(featureName) != null) {
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    Method m4 = AnnotationOper.getMethod(evidenceTypeClass, AnnotationOper.inferGetMethodName(featureName), new Class[0]);
                    if (m4 != null) {
                        this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m4);
                        annotationDefinition.addFeatureDefaultValue(featureName, evidenceTypeShortName);
                        needEvidenceFeatures.add(featureName);
                        continue;
                    }
                    this.evidenceConceptGetFeatures.get(evidenceTypeShortName).put(featureName, m4);
                }
                break;
            }
            default: {
                for (String featureValue : featureValuePairs) {
                    String[] fvpair = this.augmentRules(featureValue);
                    annotationDefinition.addFeatureDefaultValue(fvpair[0], fvpair[1]);
                    if (fvpair.length != 1 && fvpair[1] != null && !Character.isUpperCase(fvpair[1].charAt(0))) continue;
                    needEvidenceFeatures.add(fvpair[0].trim());
                }
            }
        }
    }

    private String[] augmentRules(String ruleString) {
        String featureValue;
        String featureName;
        if (ruleString.indexOf(":") != -1) {
            String[] pairArray = ruleString.split(":");
            featureName = pairArray[0].trim();
            featureValue = pairArray[1].trim();
        } else {
            featureName = ruleString.trim();
            featureValue = null;
        }
        return new String[]{featureName, featureValue};
    }

    @Override
    public void processInferences(JCas jcas) {
        this.scopes.clear();
        LinkedHashMap<String, LinkedHashMap<Double, Object[]>> allMatches = new LinkedHashMap<String, LinkedHashMap<Double, Object[]>>();
        ArrayList<Annotation> scheduledRemoval = new ArrayList<Annotation>();
        for (Class evidenceTypeClass : this.ruleMap.keySet()) {
            this.findNAddMatches(jcas, evidenceTypeClass, evidenceTypeClass.getSimpleName(), allMatches, scheduledRemoval);
        }
        LinkedHashMap<String, LinkedHashMap<Double, Annotation>> scheduledSaving = new LinkedHashMap<String, LinkedHashMap<Double, Annotation>>();
        for (String topic : allMatches.keySet()) {
            LinkedHashMap<Double, Object[]> matches = allMatches.get(topic);
            for (double offset : matches.keySet()) {
                Object[] matched = matches.get(offset);
                this.addToScheduledSaving(jcas, matched[0], this.conclusionAnnotationDefinitions.get(matched[0]), (Annotation)matched[1], scheduledSaving);
            }
        }
        for (Annotation annotation : scheduledRemoval) {
            annotation.removeFromIndexes();
        }
        for (LinkedHashMap entries : scheduledSaving.values()) {
            for (Annotation annotation : entries.values()) {
                logger.finest("Add annotation: " + annotation);
                annotation.addToIndexes();
            }
        }
    }

    private void indexScopes(JCas jCas, Class<? extends Annotation> scopeClass) {
        IntervalST<Annotation> scopeTree = new IntervalST<Annotation>();
        for (Annotation annotation : JCasUtil.select(jCas, scopeClass)) {
            scopeTree.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), annotation);
        }
        this.scopes.put(scopeClass, scopeTree);
    }

    public void findNAddMatches(JCas jcas, Class<? extends Annotation> evidenceTypeClass, String evidenceTypeShortName, LinkedHashMap<String, LinkedHashMap<Double, Object[]>> allMatches, ArrayList<Annotation> scheduledRemoval) {
        logger.finest("\n\nIterate evidence type: " + evidenceTypeClass.getSimpleName());
        ArrayList scheduledSaving = new ArrayList();
        for (Annotation annotation : JCasUtil.select(jcas, evidenceTypeClass)) {
            boolean matched;
            if (this.strictNameMatch && !annotation.getClass().getSimpleName().equals(evidenceTypeShortName) || !(matched = this.findMatches(jcas, annotation, this.evidenceConceptGetFeatures.get(evidenceTypeShortName), this.ruleMap.get(evidenceTypeClass), allMatches)) || !this.removeEvidenceConcept) continue;
            scheduledRemoval.add(annotation);
        }
    }

    private void addToScheduledSaving(JCas jcas, Object matchedRuleId, AnnotationDefinition conclusionAnnotationDefinition, Annotation evidenceAnnotation, LinkedHashMap<String, LinkedHashMap<Double, Annotation>> scheduledSaving) {
        AnnotationDefinition conclusionDef = AnnotationOper.createConclusionAnnotationDefinition(conclusionAnnotationDefinition, this.evidenceConceptGetFeatures, this.uniqueFeatureClassMap, Arrays.asList(evidenceAnnotation), this.typeDefinitions);
        String resultTypeShortName = conclusionAnnotationDefinition.getShortTypeName();
        if (!scheduledSaving.containsKey(resultTypeShortName)) {
            scheduledSaving.put(resultTypeShortName, new LinkedHashMap());
        }
        double offsets = FeatureAnnotationInferencerEx.concatenateIntegerToDouble(evidenceAnnotation.getBegin(), evidenceAnnotation.getEnd());
        if (!scheduledSaving.get(resultTypeShortName).containsKey(offsets)) {
            Class<? extends Annotation> conceptCls = AnnotationOper.getTypeClass(conclusionAnnotationDefinition.getFullTypeName());
            Annotation anno = AnnotationOper.createAnnotation(jcas, conclusionDef, conceptCls, evidenceAnnotation.getBegin(), evidenceAnnotation.getEnd());
            if (this.noteRuleId && anno instanceof Concept) {
                Concept con = (Concept)anno;
                String note = con.getNote();
                if (note == null || note.length() == 0) {
                    con.setNote("\tMachedId:\t" + matchedRuleId);
                } else {
                    con.setNote(con.getNote() + "\n\tMachedId:\t" + matchedRuleId);
                }
            }
            scheduledSaving.get(resultTypeShortName).put(offsets, anno);
        }
    }

    private boolean findMatches(JCas jCas, Annotation annotation, HashMap<String, Method> methodHashMap, Object value, LinkedHashMap<String, LinkedHashMap<Double, Object[]>> allMatches) {
        logger.finest("\nAnalyze evidence annotation: " + annotation.getClass().getSimpleName() + " [" + annotation.getBegin() + "-" + annotation.getEnd() + "]");
        double offsets = FeatureAnnotationInferencerEx.concatenateIntegerToDouble(annotation.getBegin(), annotation.getEnd());
        return this.findMatchedRuleIds(jCas, annotation, offsets, methodHashMap, value, allMatches);
    }

    private boolean findMatchedRuleIds(JCas jCas, Annotation annotation, double offsets, HashMap<String, Method> methodHashMap, Object value, LinkedHashMap<String, LinkedHashMap<Double, Object[]>> allMatches) {
        boolean found = false;
        LinkedHashMap ruleMaps = (LinkedHashMap)value;
        for (String featureName : ruleMaps.keySet()) {
            if (featureName.equals(END)) {
                for (Integer ruleId : (ArrayList)ruleMaps.get(END)) {
                    if (!this.checkScope(jCas, ruleId, annotation)) continue;
                    String topic = this.ruleStore.get(ruleId).get(1);
                    if (logger.isLoggable(Level.FINEST)) {
                        if (!allMatches.containsKey(topic) || !allMatches.get(topic).containsKey(offsets)) {
                            logger.finest("Add matched rule: " + topic + " -- " + ruleId);
                        } else if ((Integer)allMatches.get(topic).get(offsets)[0] > ruleId) {
                            logger.finest("Update matched rule: " + topic + " --- from " + this.toString(allMatches.get(topic)) + " to [ruleId: " + ruleId + ", " + annotation.getClass().getSimpleName() + "]");
                        } else {
                            logger.finest("Keep existing matched rule: " + topic + " --- " + this.toString(allMatches.get(topic)) + " rather than updating to [ruleId: " + ruleId + ", " + annotation.getClass().getSimpleName() + "]");
                        }
                    }
                    if (!allMatches.containsKey(topic)) {
                        allMatches.put(topic, new LinkedHashMap());
                    }
                    if (!allMatches.get(topic).containsKey(offsets) || (Integer)allMatches.get(topic).get(offsets)[0] > ruleId) {
                        allMatches.get(topic).put(offsets, new Object[]{ruleId, annotation});
                    }
                    found = true;
                }
                continue;
            }
            try {
                Method m3 = methodHashMap.getOrDefault(featureName, null);
                if (m3 == null) {
                    logger.finest("" + annotation.getClass().getSimpleName());
                    String className = annotation.getClass().getSimpleName();
                    if (this.evidenceConceptGetFeatures.containsKey(className)) {
                        if (this.evidenceConceptGetFeatures.get(className).containsKey(featureName)) {
                            m3 = this.evidenceConceptGetFeatures.get(className).get(featureName);
                        } else {
                            m3 = AnnotationOper.getDefaultGetMethod(annotation.getClass(), featureName);
                            this.evidenceConceptGetFeatures.get(className).put(featureName, m3);
                        }
                    }
                    if (m3 == null) {
                        logger.info("Class: " + annotation.getClass() + " doesn't have a feature: " + featureName);
                        continue;
                    }
                }
                String annotationFeatureValue = (String)m3.invoke((Object)annotation, new Object[0]);
                Object nextStep = ruleMaps.get(featureName);
                if (!((LinkedHashMap)nextStep).containsKey(annotationFeatureValue)) continue;
                logger.finest("Matched rule: " + featureName + ":" + annotationFeatureValue);
                if (!this.findMatchedRuleIds(jCas, annotation, offsets, methodHashMap, nextStep = ((LinkedHashMap)nextStep).get(annotationFeatureValue), allMatches)) continue;
                found = true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return found;
    }

    private boolean checkScope(JCas jCas, Integer ruleId, Annotation annotation) {
        ArrayList<String> rule = this.ruleStore.get(ruleId);
        String scopeType = rule.get(6);
        if (scopeType.length() == 0 || scopeType.equals("DocumentAnnotation") || scopeType.equals("SourceDocumentInformation") || scopeType.equals(SourceDocumentInformation.class.getCanonicalName()) || scopeType.equals(DocumentAnnotation.class.getCanonicalName())) {
            return true;
        }
        if (!this.scopeIndex.containsKey(scopeType) || !this.scopes.containsKey(this.scopeIndex.get(scopeType))) {
            this.indexScopes(jCas, this.scopeIndex.get(scopeType));
        }
        return this.scopeIndex.containsKey(scopeType) && this.scopes.get(this.scopeIndex.get(scopeType)).search(new Interval1D(annotation.getBegin(), annotation.getEnd())) != null;
    }

    private void addConclusion(Integer ruleId, Annotation annotation, HashMap<String, AnnotationDefinition> conclusions) {
        if (this.scopeIndex.containsKey(ruleId)) {
            if (this.scopes.get(this.scopeIndex.get(ruleId)).search(new Interval1D(annotation.getBegin(), annotation.getEnd())) != null) {
                AnnotationDefinition conclusionType = this.conclusionAnnotationDefinitions.get(ruleId);
                conclusions.put(conclusionType.getShortTypeName(), conclusionType);
            }
        } else {
            AnnotationDefinition conclusionType = this.conclusionAnnotationDefinitions.get(ruleId);
            conclusions.put(conclusionType.getShortTypeName(), conclusionType);
        }
    }

    public static double concatenateIntegerToDouble(int begin, int end) {
        int count = FeatureAnnotationInferencerEx.countNumberOfDigits(end);
        double denominator = Math.pow(10.0, count);
        double res = (double)begin + 1.0 * (double)end / denominator;
        return res;
    }

    public static int countNumberOfDigits(int digit) {
        if (digit > 100) {
            if (digit < 1000) {
                return 3;
            }
            if (digit > 10000) {
                return 5;
            }
            return 4;
        }
        if (digit > 10) {
            return 2;
        }
        return 1;
    }

    public String toString(LinkedHashMap<Double, Object[]> match) {
        StringBuilder sb = new StringBuilder();
        for (double key : match.keySet()) {
            sb.append("{");
            sb.append(key);
            sb.append("=[ruleId: ");
            sb.append(match.get(key)[0]);
            sb.append(", ");
            sb.append(((Annotation)match.get(key)[1]).getClass().getSimpleName());
            sb.append("]}");
        }
        return sb.toString();
    }
}

