/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.ae.FeatureInferencerFactory;
import edu.utah.bmi.nlp.uima.ae.FeatureInferencerInf;
import edu.utah.bmi.nlp.uima.ae.RuleBasedAEInf;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class FeatureInferenceAnnotator
extends JCasAnnotator_ImplBase
implements RuleBasedAEInf {
    public static final String PARAM_RULE_STR = "RuleFileOrStr";
    @ConfigurationParameter(name="RuleFileOrStr", mandatory=true)
    private String ruleStr;
    public static final String PARAM_REMOVE_EVIDENCE_CONCEPT = "RemoveEvidenceConcept";
    @ConfigurationParameter(name="RemoveEvidenceConcept", mandatory=false, defaultValue={"true"}, description="whether remove the evidence concept annotation.")
    private boolean removeEvidenceConcept;
    public static final String PARAM_REMOVE_OVERLAP = "RemoveOverlap";
    @ConfigurationParameter(name="RemoveOverlap", mandatory=false, defaultValue={"true"}, description="whether remove overlapped results.")
    private boolean removeOverlap;
    public static final String PARAM_STRICT_NAME_MATCH = "StrictNameMatch";
    @ConfigurationParameter(name="StrictNameMatch", mandatory=false, defaultValue={"false"}, description="whether use strict name match.")
    private boolean strictNameMatch;
    public static final String PARAM_NOTE_RULE_ID = "NoteRuleId";
    @ConfigurationParameter(name="NoteRuleId", mandatory=false, defaultValue={"false"}, description="whether add matched rule id into Note feature.")
    private boolean noteRuleId;
    @Deprecated
    public static final String PARAM_DEBUG = "EnableDebug";
    @Deprecated
    private boolean debug = false;
    private FeatureInferencerInf featureAnnotationInferencer;

    @Override
    public void initialize(UimaContext cont) throws ResourceInitializationException {
        super.initialize(cont);
        this.featureAnnotationInferencer = FeatureInferencerFactory.getFeatureInferencer(this.ruleStr, this.removeEvidenceConcept, this.strictNameMatch, this.noteRuleId);
        this.featureAnnotationInferencer.init();
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.featureAnnotationInferencer.processInferences(jCas);
        if (this.removeOverlap) {
            this.removeOverlap(jCas);
        }
    }

    private void removeOverlap(JCas jCas) {
        HashMap typeSpanMap = new HashMap();
        String typeName = "";
        for (Annotation anno : JCasUtil.select(jCas, Annotation.class)) {
            typeName = anno.getType().getName();
            IntervalST thisSpanTree = typeSpanMap.getOrDefault(typeName, new IntervalST());
            this.checkOverlap(thisSpanTree, anno);
        }
    }

    private void checkOverlap(IntervalST intervalTree, Annotation concept) {
        Interval1D interval = new Interval1D(concept.getBegin(), concept.getEnd());
        Annotation overlapped = (Annotation)intervalTree.get(interval);
        if (overlapped != null && overlapped.getEnd() != concept.getBegin() && concept.getEnd() != overlapped.getBegin()) {
            if (overlapped.getEnd() - overlapped.getBegin() < concept.getEnd() - concept.getBegin()) {
                overlapped.removeFromIndexes();
                intervalTree.remove(new Interval1D(overlapped.getBegin(), overlapped.getEnd()));
                intervalTree.put(interval, concept);
            } else {
                concept.removeFromIndexes();
            }
        } else {
            intervalTree.put(interval, concept);
        }
    }

    @Deprecated
    public static LinkedHashMap<String, TypeDefinition> getTypeDefinitions(String ruleStr) {
        return new FeatureInferenceAnnotator().getTypeDefs(ruleStr);
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefs(String ruleStr) {
        return FeatureInferencerFactory.getFeatureInferencer(ruleStr).getTypeDefinitions();
    }
}

