/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.type.system.Paragraph;
import edu.utah.bmi.nlp.type.system.Sentence;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;

public class ParagraphDetector
extends JCasAnnotator_ImplBase {
    private Pattern pat;
    public static String PARAM_SPLIT_PATTERN = "SplitPattern";
    public static String PARAM_MIN_LENGTH = "MinLength";
    public static String PARAM_SENTENCE_COORDINATED = "SentenceCoordinated";
    private int minLength = 0;
    private boolean sentenceCoordinated = true;

    @Override
    public void initialize(UimaContext cont) {
        Object value = cont.getConfigParameterValue(PARAM_SPLIT_PATTERN);
        this.pat = value != null && value instanceof String && ((String)value).trim().length() > 0 ? Pattern.compile((String)value) : Pattern.compile("\\s*((\r\n|\n\r){2,}|\n{2,}|\r{2,})\\s*");
        value = cont.getConfigParameterValue(PARAM_MIN_LENGTH);
        if (value instanceof Integer) {
            this.minLength = (Integer)value;
        }
        if ((value = cont.getConfigParameterValue(PARAM_SENTENCE_COORDINATED)) != null && value instanceof Boolean) {
            this.sentenceCoordinated = (Boolean)value;
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String text = aJCas.getDocumentText();
        int index = 0;
        int length = text.length();
        Matcher m3 = this.pat.matcher(text);
        ArrayList<int[]> matchList = new ArrayList<int[]>();
        while (m3.find()) {
            if (index == 0 && index == m3.start() && m3.start() == m3.end()) continue;
            matchList.add(new int[]{index, m3.start()});
            index = m3.end();
        }
        matchList.add(new int[]{index, length});
        IntervalST<Object> sentenceIndex = new IntervalST();
        if (this.sentenceCoordinated) {
            sentenceIndex = AnnotationOper.indexAnnotation(aJCas, Sentence.class);
        }
        ArrayList<int[]> mergedList = new ArrayList<int[]>();
        int begin = -1;
        for (int i = 0; i < matchList.size(); ++i) {
            Interval1D overlapped;
            int[] pos = (int[])matchList.get(i);
            if (begin == -1) {
                begin = pos[0];
            }
            if (this.notEnoughAlphaCharlength(text, begin, pos[1], this.minLength) || this.sentenceCoordinated && (overlapped = sentenceIndex.search(new Interval1D(pos[1] - 1, pos[1]))) != null && overlapped.min < pos[1] && pos[1] < overlapped.max) continue;
            mergedList.add(new int[]{begin, pos[1]});
            begin = -1;
        }
        for (int[] pos : mergedList) {
            if (text.substring(pos[0], pos[1]).trim().length() <= 0) continue;
            Paragraph paragraph = new Paragraph(aJCas, pos[0], pos[1]);
            paragraph.addToIndexes();
        }
    }

    private boolean notEnoughAlphaCharlength(String text, int begin, int end, int minLength) {
        text = text.substring(begin, end);
        int measure = 0;
        for (char c : text.toCharArray()) {
            if (!Character.isAlphabetic(c) && !Character.isDigit(c)) continue;
            ++measure;
        }
        return measure < minLength;
    }
}

