/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.ae.FeatureAnnotationInferencer;
import edu.utah.bmi.nlp.uima.ae.RuleBasedAEInf;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.common.BratOperator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RESTCommunicator
extends JCasAnnotator_ImplBase
implements RuleBasedAEInf {
    public static final String PARAM_RULE_STR = "RuleFileOrStr";
    protected static final String PARAM_OUTPUT_TYPES_DEF_URL = "OutputTypesURL";
    protected static final String PARAM_INPUT_TYPES_NAMES_URL = "InputTypesURL";
    protected static final String PARAM_PROCESSOR_URL = "ProcessorURL";
    protected String processorURL;
    protected ArrayList<Class<? extends Annotation>> inputTypeClasses = new ArrayList();
    protected HashMap<String, Class<? extends Annotation>> outputTypeClassesMap = new HashMap();
    protected LinkedHashMap<Class, LinkedHashSet<Method>> inputConceptGetFeatures = new LinkedHashMap();
    protected HashMap<Class, HashMap<String, Method>> outputConceptSetFeatures = new HashMap();
    private HashMap<String, HashSet<String>> attributeToConcepts;
    private HashMap<String, HashSet<String>> attributeToValues;
    protected HashMap<String, Constructor<? extends Annotation>> outputConceptConstructors = new HashMap();

    @Override
    public void initialize(UimaContext cont) {
        this.attributeToConcepts = new HashMap();
        this.attributeToValues = new HashMap();
        Object obj = cont.getConfigParameterValue(PARAM_RULE_STR);
        if (obj != null) {
            String settings = (String)obj;
            IOUtil ioUtil = new IOUtil(settings);
            for (ArrayList<String> row : ioUtil.getRuleCells()) {
                switch (row.get(1).trim()) {
                    case "InputTypesURL": {
                        String inputTypeString = this.post(row.get(2).trim(), new String[0]);
                        LinkedHashMap<String, ArrayList<String>> includeTypes = new LinkedHashMap<String, ArrayList<String>>();
                        for (ArrayList<String> inputDefRow : new IOUtil(inputTypeString).getRuleCells()) {
                            includeTypes.put(inputDefRow.get(1), new ArrayList());
                            if (inputDefRow.size() <= 2 || inputDefRow.get(2) == null || inputDefRow.get(2).trim().length() <= 1) continue;
                            if (inputDefRow.get(2).toLowerCase().equals("null")) {
                                includeTypes.put(inputDefRow.get(1), null);
                                continue;
                            }
                            includeTypes.get(inputDefRow.get(1)).addAll(Arrays.asList(inputDefRow.get(2).trim().split("\\s*[,;\\|]\\s*")));
                        }
                        this.initGetMethods(includeTypes, this.inputTypeClasses, this.inputConceptGetFeatures);
                        break;
                    }
                    case "OutputTypesURL": {
                        LinkedHashMap<String, TypeDefinition> typeDefinitions = this.parseTypeDefinitions(this.post(row.get(2).trim(), new String[0]));
                        AnnotationOper.initSetReflections(typeDefinitions, this.outputTypeClassesMap, this.outputConceptConstructors, this.outputConceptSetFeatures);
                        break;
                    }
                    case "ProcessorURL": {
                        this.processorURL = row.get(2).trim();
                    }
                }
            }
        }
    }

    private void initGetMethods(LinkedHashMap<String, ArrayList<String>> includeTypes, ArrayList<Class<? extends Annotation>> inputTypeClasses, LinkedHashMap<Class, LinkedHashSet<Method>> inputConceptGetFeatures) {
        for (Map.Entry<String, ArrayList<String>> typeFeaturePairs : includeTypes.entrySet()) {
            String typeName = DeterminantValueSet.checkNameSpace(typeFeaturePairs.getKey());
            ArrayList<String> featureNames = typeFeaturePairs.getValue();
            Class<? extends Annotation> cls = AnnotationOper.getTypeClass(typeName);
            inputTypeClasses.add(cls);
            if (featureNames == null) {
                inputConceptGetFeatures.put(cls, new LinkedHashSet());
                continue;
            }
            if (featureNames.size() == 0) {
                if (!inputConceptGetFeatures.containsKey(cls)) {
                    inputConceptGetFeatures.put(cls, new LinkedHashSet());
                }
                AnnotationOper.getMethods(cls, inputConceptGetFeatures.get(cls));
                continue;
            }
            for (String featureName : featureNames) {
                if (!inputConceptGetFeatures.containsKey(cls)) {
                    inputConceptGetFeatures.put(cls, new LinkedHashSet());
                }
                inputConceptGetFeatures.get(cls).add(AnnotationOper.getDefaultGetMethod(cls, AnnotationOper.inferGetMethodName(featureName)));
            }
        }
    }

    private void initGetMethods(Iterable<String> includeTypes) {
        for (String typeName : includeTypes) {
            typeName = DeterminantValueSet.checkNameSpace(typeName);
            Class<? extends Annotation> cls = AnnotationOper.getTypeClass(typeName);
            this.inputTypeClasses.add(cls);
            if (!this.inputConceptGetFeatures.containsKey(cls)) {
                this.inputConceptGetFeatures.put(cls, new LinkedHashSet());
            }
            AnnotationOper.getMethods(cls, this.inputConceptGetFeatures.get(cls));
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String request = BratOperator.exportBrat(aJCas, this.inputTypeClasses, this.inputConceptGetFeatures, this.attributeToConcepts, this.attributeToValues);
        String returnedString = this.post(this.processorURL, aJCas.getDocumentText(), request);
        if (returnedString.trim().length() > 0) {
            List<String> returns = Arrays.asList(returnedString.split("\n"));
            BratOperator.importBrat(aJCas, returns, this.outputConceptConstructors, this.outputTypeClassesMap, this.outputConceptSetFeatures);
        }
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefs(String ruleStr) {
        IOUtil ioUtil = new IOUtil(ruleStr);
        for (ArrayList<String> row : ioUtil.getRuleCells()) {
            if (!row.get(1).trim().equals(PARAM_OUTPUT_TYPES_DEF_URL)) continue;
            String typeString = this.post(row.get(2).trim(), new String[0]);
            return this.parseTypeDefinitions(typeString);
        }
        return null;
    }

    private String post(String URL2, String ... data) {
        HttpResponse<String> jsonResponse = null;
        try {
            jsonResponse = data.length > 1 ? Unirest.post(URL2).field("txt", data[0]).field("brat", data[1]).asString() : Unirest.post(URL2).asString();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        String output = RESTCommunicator.toJsonObj(jsonResponse.getRawBody()).toString();
        return output;
    }

    public static Object toJsonObj(InputStream inputStream) {
        String theString = null;
        try {
            theString = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONParser jsonParser = new JSONParser();
        Object jsonObject = new JSONObject();
        try {
            jsonObject = jsonParser.parse(theString);
        }
        catch (ParseException e) {
            return theString;
        }
        return jsonObject;
    }

    private LinkedHashMap<String, TypeDefinition> parseTypeDefinitions(String ruleString) {
        return new FeatureAnnotationInferencer().getTypeDefinitions(ruleString);
    }
}

